/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.model;

import ai.tock.nlp.core.CallContext;
import ai.tock.nlp.core.NlpEngineType;
import ai.tock.nlp.model.ClassifierContext;
import ai.tock.nlp.model.ClassifierContextKey;
import ai.tock.nlp.model.EntityContext;
import ai.tock.nlp.model.IntentContext;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\t\u0010\u0010B\u0011\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\t\u0010\u0013J\b\u0010\u001a\u001a\u00020\u0000H\u0016J\b\u0010\u001b\u001a\u00020\bH\u0016J\t\u0010\u001c\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\bH\u00c6\u0003J'\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020\bH\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lai/tock/nlp/model/TokenizerContext;", "Lai/tock/nlp/model/ClassifierContext;", "Lai/tock/nlp/model/ClassifierContextKey;", "language", "Ljava/util/Locale;", "engineType", "Lai/tock/nlp/core/NlpEngineType;", "applicationName", "", "<init>", "(Ljava/util/Locale;Lai/tock/nlp/core/NlpEngineType;Ljava/lang/String;)V", "callContext", "Lai/tock/nlp/core/CallContext;", "(Lai/tock/nlp/core/CallContext;)V", "intentContext", "Lai/tock/nlp/model/IntentContext;", "(Lai/tock/nlp/model/IntentContext;)V", "entityContext", "Lai/tock/nlp/model/EntityContext;", "(Lai/tock/nlp/model/EntityContext;)V", "getLanguage", "()Ljava/util/Locale;", "getEngineType", "()Lai/tock/nlp/core/NlpEngineType;", "getApplicationName", "()Ljava/lang/String;", "key", "id", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "tock-nlp-model-shared"})
public final class TokenizerContext
implements ClassifierContext<TokenizerContext>,
ClassifierContextKey {
    @NotNull
    private final Locale language;
    @NotNull
    private final NlpEngineType engineType;
    @NotNull
    private final String applicationName;

    public TokenizerContext(@NotNull Locale language, @NotNull NlpEngineType engineType, @NotNull String applicationName) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)engineType, (String)"engineType");
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        this.language = language;
        this.engineType = engineType;
        this.applicationName = applicationName;
    }

    @Override
    @NotNull
    public Locale getLanguage() {
        return this.language;
    }

    @Override
    @NotNull
    public NlpEngineType getEngineType() {
        return this.engineType;
    }

    @Override
    @NotNull
    public String getApplicationName() {
        return this.applicationName;
    }

    public TokenizerContext(@NotNull CallContext callContext) {
        Intrinsics.checkNotNullParameter((Object)callContext, (String)"callContext");
        this(callContext.getLanguage(), callContext.getEngineType(), callContext.getApplication().getName());
    }

    public TokenizerContext(@NotNull IntentContext intentContext) {
        Intrinsics.checkNotNullParameter((Object)intentContext, (String)"intentContext");
        this(intentContext.getLanguage(), intentContext.getEngineType(), intentContext.getApplication().getName());
    }

    public TokenizerContext(@NotNull EntityContext entityContext) {
        Intrinsics.checkNotNullParameter((Object)entityContext, (String)"entityContext");
        this(entityContext.getLanguage(), entityContext.getEngineType(), entityContext.getApplicationName());
    }

    @Override
    @NotNull
    public TokenizerContext key() {
        return this;
    }

    @Override
    @NotNull
    public String id() {
        return this.getLanguage() + "-" + this.getEngineType().getName();
    }

    @NotNull
    public final Locale component1() {
        return this.language;
    }

    @NotNull
    public final NlpEngineType component2() {
        return this.engineType;
    }

    @NotNull
    public final String component3() {
        return this.applicationName;
    }

    @NotNull
    public final TokenizerContext copy(@NotNull Locale language, @NotNull NlpEngineType engineType, @NotNull String applicationName) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)engineType, (String)"engineType");
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        return new TokenizerContext(language, engineType, applicationName);
    }

    public static /* synthetic */ TokenizerContext copy$default(TokenizerContext tokenizerContext, Locale locale, NlpEngineType nlpEngineType, String string, int n, Object object) {
        if ((n & 1) != 0) {
            locale = tokenizerContext.language;
        }
        if ((n & 2) != 0) {
            nlpEngineType = tokenizerContext.engineType;
        }
        if ((n & 4) != 0) {
            string = tokenizerContext.applicationName;
        }
        return tokenizerContext.copy(locale, nlpEngineType, string);
    }

    @NotNull
    public String toString() {
        return "TokenizerContext(language=" + this.language + ", engineType=" + this.engineType + ", applicationName=" + this.applicationName + ")";
    }

    public int hashCode() {
        int result = this.language.hashCode();
        result = result * 31 + this.engineType.hashCode();
        result = result * 31 + this.applicationName.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TokenizerContext)) {
            return false;
        }
        TokenizerContext tokenizerContext = (TokenizerContext)other;
        if (!Intrinsics.areEqual((Object)this.language, (Object)tokenizerContext.language)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.engineType, (Object)tokenizerContext.engineType)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.applicationName, (Object)tokenizerContext.applicationName);
    }
}

