/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.stanford;

import ai.tock.nlp.core.Entity;
import ai.tock.nlp.core.EntityRecognition;
import ai.tock.nlp.core.EntityValue;
import ai.tock.nlp.core.IntOpenRange;
import ai.tock.nlp.model.EntityCallContext;
import ai.tock.nlp.model.EntityCallContextForEntity;
import ai.tock.nlp.model.EntityCallContextForIntent;
import ai.tock.nlp.model.EntityCallContextForSubEntities;
import ai.tock.nlp.model.service.engine.EntityModelHolder;
import ai.tock.nlp.model.service.engine.NlpEntityClassifier;
import ai.tock.nlp.stanford.StanfordEntityClassifier;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.ie.crf.CRFCliqueTree;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.objectbank.ObjectBank;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J1\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ1\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002\u00a2\u0006\u0002\u0010\u0010J1\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002\u00a2\u0006\u0002\u0010\u0012J?\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0002\u00a2\u0006\u0002\u0010\u0016J$\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0006H\u0002J\u001b\u0010\u001d\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0002\u00a2\u0006\u0002\u0010\u001e\u00a8\u0006!"}, d2={"Lai/tock/nlp/stanford/StanfordEntityClassifier;", "Lai/tock/nlp/model/service/engine/NlpEntityClassifier;", "model", "Lai/tock/nlp/model/service/engine/EntityModelHolder;", "(Lai/tock/nlp/model/service/engine/EntityModelHolder;)V", "classifyEntities", "", "Lai/tock/nlp/core/EntityRecognition;", "context", "Lai/tock/nlp/model/EntityCallContext;", "text", "", "tokens", "", "(Lai/tock/nlp/model/EntityCallContext;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "Lai/tock/nlp/model/EntityCallContextForIntent;", "(Lai/tock/nlp/model/EntityCallContextForIntent;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "Lai/tock/nlp/model/EntityCallContextForSubEntities;", "(Lai/tock/nlp/model/EntityCallContextForSubEntities;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "entityFinder", "Lkotlin/Function1;", "Lai/tock/nlp/core/Entity;", "(Ljava/lang/String;[Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "getConfidence", "", "classifier", "Ledu/stanford/nlp/ie/crf/CRFClassifier;", "Ledu/stanford/nlp/ling/CoreLabel;", "classifiedLabels", "getEvaluationData", "([Ljava/lang/String;)Ljava/lang/String;", "Companion", "Token", "tock-nlp-model-stanford"})
public final class StanfordEntityClassifier
extends NlpEntityClassifier {
    private static final KLogger logger;
    private static final Regex adjacentMarkerRegep;
    public static final Companion Companion;

    @NotNull
    public List<EntityRecognition> classifyEntities(@NotNull EntityCallContext context, @NotNull String text, @NotNull String[] tokens) {
        List<EntityRecognition> list;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)tokens, (String)"tokens");
        EntityCallContext entityCallContext = context;
        if (entityCallContext instanceof EntityCallContextForIntent) {
            list = this.classifyEntities((EntityCallContextForIntent)context, text, tokens);
        } else {
            if (entityCallContext instanceof EntityCallContextForEntity) {
                boolean bl = false;
                throw (Throwable)new NotImplementedError(null, 1, null);
            }
            if (entityCallContext instanceof EntityCallContextForSubEntities) {
                list = this.classifyEntities((EntityCallContextForSubEntities)context, text, tokens);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    private final List<EntityRecognition> classifyEntities(EntityCallContextForSubEntities context, String text, String[] tokens) {
        return this.classifyEntities(text, tokens, (Function1<? super String, Entity>)((Function1)new Function1<String, Entity>(context){
            final /* synthetic */ EntityCallContextForSubEntities $context;

            @Nullable
            public final Entity invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$context.getEntityType().findSubEntity(it);
            }
            {
                this.$context = entityCallContextForSubEntities;
                super(1);
            }
        }));
    }

    private final List<EntityRecognition> classifyEntities(EntityCallContextForIntent context, String text, String[] tokens) {
        return this.classifyEntities(text, tokens, (Function1<? super String, Entity>)((Function1)new Function1<String, Entity>(context){
            final /* synthetic */ EntityCallContextForIntent $context;

            @NotNull
            public final Entity invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.$context.getIntent().getEntity(it);
            }
            {
                this.$context = entityCallContextForIntent;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final List<EntityRecognition> classifyEntities(String text, String[] tokens, Function1<? super String, Entity> entityFinder) {
        Object object;
        try {
            void $this$mapNotNullTo$iv$iv;
            int n;
            Object object2;
            List classifiedLabels;
            ObjectBank documents;
            object = this.getModel();
            boolean bl = false;
            boolean bl2 = false;
            EntityModelHolder $this$with = object;
            boolean bl3 = false;
            Object object3 = $this$with.getNativeModel();
            if (object3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type edu.stanford.nlp.ie.crf.CRFClassifier<edu.stanford.nlp.ling.CoreLabel>");
            }
            CRFClassifier classifier = (CRFClassifier)object3;
            String evaluationData = this.getEvaluationData(tokens);
            ObjectBank objectBank = documents = classifier.makeObjectBankFromString(evaluationData, classifier.defaultReaderAndWriter());
            Intrinsics.checkExpressionValueIsNotNull((Object)objectBank, (String)"documents");
            List document = CollectionsKt.flatten((Iterable)((Iterable)objectBank));
            List list = classifiedLabels = classifier.classify(document);
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"classifiedLabels");
            double confidence = this.getConfidence((CRFClassifier<CoreLabel>)classifier, list);
            boolean bl4 = false;
            List coreTokens = new ArrayList();
            Token previousToken = null;
            Iterable $this$forEachIndexed$iv = document;
            boolean $i$f$forEachIndexed = false;
            int index$iv22 = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void word;
                int n2 = index$iv22++;
                boolean bl5 = false;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n3 = n2;
                CoreLabel coreLabel = (CoreLabel)item$iv;
                int index = n3;
                boolean bl6 = false;
                String t = text;
                int start = 0;
                int n4 = 0;
                int n5 = index;
                while (n4 < n5) {
                    void i;
                    int n6 = ((CoreLabel)document.get((int)i)).word().length();
                    CharSequence charSequence = t;
                    String string = ((CoreLabel)document.get((int)i)).word();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"document[i].word()");
                    int nextTokenIndex = n6 + StringsKt.indexOf$default((CharSequence)charSequence, (String)string, (int)0, (boolean)false, (int)6, null);
                    start += nextTokenIndex;
                    object2 = t;
                    n = 0;
                    Object object4 = object2;
                    if (object4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)((String)object4).substring(nextTokenIndex), (String)"(this as java.lang.String).substring(startIndex)");
                    ++i;
                }
                CharSequence charSequence = t;
                String string = ((CoreLabel)document.get(index)).word();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"document[index].word()");
                int end = (start += StringsKt.indexOf$default((CharSequence)charSequence, (String)string, (int)0, (boolean)false, (int)6, null)) + ((CoreLabel)document.get(index)).word().length();
                String entityRole = (String)word.get(CoreAnnotations.AnswerAnnotation.class);
                if (Intrinsics.areEqual((Object)entityRole, (Object)"O") ^ true) {
                    Token token = previousToken;
                    if (Intrinsics.areEqual((Object)(token != null ? token.getType() : null), (Object)entityRole) ^ true) {
                        String string2 = word.word();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"word.word()");
                        String string3 = entityRole;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"entityRole");
                        previousToken = new Token(start, end, string2, string3);
                    } else {
                        String w;
                        coreTokens.remove(CollectionsKt.getLastIndex((List)coreTokens));
                        object2 = text;
                        Token token2 = previousToken;
                        if (token2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type ai.tock.nlp.stanford.StanfordEntityClassifier.Token");
                        }
                        n = token2.getStart();
                        boolean bl7 = false;
                        Object object5 = object2;
                        if (object5 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)((String)object5).substring(n, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        Token token3 = previousToken;
                        if (token3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type ai.tock.nlp.stanford.StanfordEntityClassifier.Token");
                        }
                        int n7 = token3.getStart();
                        String string4 = entityRole;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"entityRole");
                        previousToken = new Token(n7, end, w, string4);
                    }
                    Token tok = previousToken;
                    coreTokens.add(new Token(tok.getStart(), tok.getEnd(), tok.getText(), tok.getType()));
                    continue;
                }
                previousToken = null;
            }
            Iterable $this$mapNotNull$iv = coreTokens;
            boolean $i$f$mapNotNull = false;
            Iterable index$iv22 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                EntityRecognition entityRecognition;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl8 = false;
                Token it = (Token)element$iv$iv;
                boolean bl9 = false;
                CharSequence charSequence = it.getType();
                Regex regex = adjacentMarkerRegep;
                String string = "";
                object2 = entityFinder;
                n = 0;
                String string5 = regex.replaceFirst(charSequence, string);
                Entity entity = (Entity)object2.invoke((Object)string5);
                if (entity == null) {
                    logger.warn((Function0)new Function0<String>(it){
                        final /* synthetic */ Token $it;

                        @NotNull
                        public final String invoke() {
                            return "unknown entity role " + this.$it.getType();
                        }
                        {
                            this.$it = token;
                            super(0);
                        }
                    });
                    entityRecognition = null;
                } else {
                    entityRecognition = new EntityRecognition(new EntityValue(it.getStart(), it.getEnd(), entity, null, null, false, 56, null), confidence);
                }
                if (entityRecognition == null) continue;
                EntityRecognition entityRecognition2 = entityRecognition;
                boolean bl10 = false;
                boolean bl11 = false;
                EntityRecognition it$iv$iv = entityRecognition2;
                boolean bl12 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            object = (List)destination$iv$iv;
        }
        catch (Exception e) {
            logger.error("error with " + text + " and " + Arrays.toString(tokens), (Throwable)e);
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final String getEvaluationData(String[] tokens) {
        return ArraysKt.joinToString$default((Object[])tokens, (CharSequence)"", null, null, (int)0, null, (Function1)getEvaluationData.1.INSTANCE, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    private final double getConfidence(CRFClassifier<CoreLabel> classifier, List<? extends CoreLabel> classifiedLabels) {
        try {
            int counter = 0;
            double probSum = 0.0;
            CRFCliqueTree cliqueTree = classifier.getCliqueTree(classifiedLabels);
            int n = 0;
            int n2 = cliqueTree.length();
            while (n < n2) {
                void i;
                CoreLabel wi = classifiedLabels.get((int)i);
                int index = classifier.classIndex.indexOf(wi.get(CoreAnnotations.AnswerAnnotation.class));
                probSum = cliqueTree.prob((int)i, index);
                ++counter;
                ++i;
            }
            double prob = 1.0 - probSum / (double)counter;
            return (double)Math.round(prob * (double)1000) / 1000.0;
        }
        catch (Exception e) {
            logger.error((Throwable)e, (Function0)getConfidence.1.INSTANCE);
            return 0.1;
        }
    }

    public StanfordEntityClassifier(@NotNull EntityModelHolder model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        super(model);
    }

    static {
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
        String string = "__near__";
        boolean bl = false;
        adjacentMarkerRegep = new Regex(string);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001a"}, d2={"Lai/tock/nlp/stanford/StanfordEntityClassifier$Token;", "Lai/tock/nlp/core/IntOpenRange;", "start", "", "end", "text", "", "type", "(IILjava/lang/String;Ljava/lang/String;)V", "getEnd", "()I", "getStart", "getText", "()Ljava/lang/String;", "getType", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "tock-nlp-model-stanford"})
    private static final class Token
    implements IntOpenRange {
        private final int start;
        private final int end;
        @NotNull
        private final String text;
        @NotNull
        private final String type;

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public Token(int start, int end, @NotNull String text, @NotNull String type) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            this.start = start;
            this.end = end;
            this.text = text;
            this.type = type;
        }

        public int compareTo(@NotNull IntOpenRange other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return IntOpenRange.DefaultImpls.compareTo((IntOpenRange)this, (IntOpenRange)other);
        }

        public boolean isSameRange(@NotNull IntOpenRange range) {
            Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
            return IntOpenRange.DefaultImpls.isSameRange((IntOpenRange)this, (IntOpenRange)range);
        }

        public boolean overlap(@NotNull IntOpenRange range) {
            Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
            return IntOpenRange.DefaultImpls.overlap((IntOpenRange)this, (IntOpenRange)range);
        }

        public boolean overlap(int start, int end) {
            return IntOpenRange.DefaultImpls.overlap((IntOpenRange)this, (int)start, (int)end);
        }

        public int size() {
            return IntOpenRange.DefaultImpls.size((IntOpenRange)this);
        }

        @NotNull
        public String textValue(@NotNull String originalText) {
            Intrinsics.checkParameterIsNotNull((Object)originalText, (String)"originalText");
            return IntOpenRange.DefaultImpls.textValue((IntOpenRange)this, (String)originalText);
        }

        public final int component1() {
            return this.getStart();
        }

        public final int component2() {
            return this.getEnd();
        }

        @NotNull
        public final String component3() {
            return this.text;
        }

        @NotNull
        public final String component4() {
            return this.type;
        }

        @NotNull
        public final Token copy(int start, int end, @NotNull String text, @NotNull String type) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            return new Token(start, end, text, type);
        }

        public static /* synthetic */ Token copy$default(Token token, int n, int n2, String string, String string2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = token.getStart();
            }
            if ((n3 & 2) != 0) {
                n2 = token.getEnd();
            }
            if ((n3 & 4) != 0) {
                string = token.text;
            }
            if ((n3 & 8) != 0) {
                string2 = token.type;
            }
            return token.copy(n, n2, string, string2);
        }

        @NotNull
        public String toString() {
            return "Token(start=" + this.getStart() + ", end=" + this.getEnd() + ", text=" + this.text + ", type=" + this.type + ")";
        }

        public int hashCode() {
            String string = this.text;
            String string2 = this.type;
            return ((Integer.hashCode(this.getStart()) * 31 + Integer.hashCode(this.getEnd())) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Token)) break block3;
                    Token token = (Token)object;
                    if (this.getStart() != token.getStart() || this.getEnd() != token.getEnd() || !Intrinsics.areEqual((Object)this.text, (Object)token.text) || !Intrinsics.areEqual((Object)this.type, (Object)token.type)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lai/tock/nlp/stanford/StanfordEntityClassifier$Companion;", "", "()V", "adjacentMarkerRegep", "Lkotlin/text/Regex;", "logger", "Lmu/KLogger;", "tock-nlp-model-stanford"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

