/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.stanford;

import ai.tock.nlp.core.Application;
import ai.tock.nlp.core.Intent;
import ai.tock.nlp.core.IntentClassification;
import ai.tock.nlp.model.IntentContext;
import ai.tock.nlp.model.service.engine.IntentModelHolder;
import ai.tock.nlp.model.service.engine.NlpIntentClassifier;
import ai.tock.nlp.stanford.StanfordIntentModel;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J+\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000f"}, d2={"Lai/tock/nlp/stanford/StanfordIntentClassifier;", "Lai/tock/nlp/model/service/engine/NlpIntentClassifier;", "model", "Lai/tock/nlp/model/service/engine/IntentModelHolder;", "(Lai/tock/nlp/model/service/engine/IntentModelHolder;)V", "classifyIntent", "Lai/tock/nlp/core/IntentClassification;", "context", "Lai/tock/nlp/model/IntentContext;", "text", "", "tokens", "", "(Lai/tock/nlp/model/IntentContext;Ljava/lang/String;[Ljava/lang/String;)Lai/tock/nlp/core/IntentClassification;", "Companion", "tock-nlp-model-stanford"})
public final class StanfordIntentClassifier
extends NlpIntentClassifier {
    @NotNull
    private static final IntentClassification emptyClassification;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public IntentClassification classifyIntent(@NotNull IntentContext context, @NotNull String text, @NotNull String[] tokens) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        IntentModelHolder intentModelHolder = this.getModel();
        boolean bl = false;
        boolean bl2 = false;
        IntentModelHolder $this$with = intentModelHolder;
        boolean bl3 = false;
        if (!this.getModel().getApplication().getIntents().isEmpty()) {
            Object object = $this$with.getNativeModel();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type ai.tock.nlp.stanford.StanfordIntentModel");
            }
            StanfordIntentModel stanfordIntentModel = (StanfordIntentModel)object;
            boolean bl4 = false;
            boolean bl5 = false;
            StanfordIntentModel $this$with2 = stanfordIntentModel;
            boolean bl6 = false;
            Datum d = $this$with2.getCdc().makeDatumFromLine('\t' + text);
            Counter scores = $this$with2.getClassifier().scoresOf(d);
            double logSum = Counters.logSum((Counter)scores);
            Set set = scores.entrySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"scores.entrySet()");
            Iterable $this$sortedByDescending$iv = set;
            boolean $i$f$sortedByDescending = false;
            boolean bl7 = false;
            Iterator iterator = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Map.Entry it = (Map.Entry)b;
                    boolean bl2 = false;
                    Comparable comparable = (Double)it.getValue();
                    it = (Map.Entry)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Double d = (Double)it.getValue();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
                }
            }).iterator();
            return new IntentClassification(iterator, logSum, $this$with, this, text){
                private double probability;
                final /* synthetic */ Iterator $iterator;
                final /* synthetic */ double $logSum;
                final /* synthetic */ IntentModelHolder $this_with$inlined;
                final /* synthetic */ StanfordIntentClassifier this$0;
                final /* synthetic */ String $text$inlined;
                {
                    this.$iterator = $captured_local_variable$1;
                    this.$logSum = $captured_local_variable$2;
                    this.$this_with$inlined = intentModelHolder;
                    this.this$0 = stanfordIntentClassifier;
                    this.$text$inlined = string;
                }

                public final double getProbability() {
                    return this.probability;
                }

                public final void setProbability(double d) {
                    this.probability = d;
                }

                public double probability() {
                    return this.probability;
                }

                public boolean hasNext() {
                    return this.$iterator.hasNext();
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public Intent next() {
                    void key;
                    E e = this.$iterator.next();
                    boolean bl = false;
                    boolean bl2 = false;
                    Map.Entry $dstr$key$proba = (Map.Entry)e;
                    boolean bl3 = false;
                    Map.Entry entry = $dstr$key$proba;
                    boolean bl4 = false;
                    String string = (String)entry.getKey();
                    entry = $dstr$key$proba;
                    bl4 = false;
                    Double proba = (Double)entry.getValue();
                    this.probability = Math.exp(proba - this.$logSum);
                    Application application = this.$this_with$inlined.getApplication();
                    void v1 = key;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"key");
                    Intent intent = application.getIntent((String)v1);
                    if (intent == null) {
                        intent = Intent.Companion.getUNKNOWN_INTENT();
                    }
                    return intent;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }
        return emptyClassification;
    }

    public StanfordIntentClassifier(@NotNull IntentModelHolder model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(model);
    }

    static {
        Companion = new Companion(null);
        emptyClassification = new IntentClassification(){

            public double probability() {
                return 0.0;
            }

            public boolean hasNext() {
                return false;
            }

            @NotNull
            public Intent next() {
                throw (Throwable)new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/tock/nlp/stanford/StanfordIntentClassifier$Companion;", "", "()V", "emptyClassification", "Lai/tock/nlp/core/IntentClassification;", "getEmptyClassification", "()Lai/tock/nlp/core/IntentClassification;", "tock-nlp-model-stanford"})
    public static final class Companion {
        @NotNull
        public final IntentClassification getEmptyClassification() {
            return emptyClassification;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

