/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.stanford;

import ai.tock.nlp.core.Application;
import ai.tock.nlp.core.configuration.NlpApplicationConfiguration;
import ai.tock.nlp.core.configuration.NlpModelConfiguration;
import ai.tock.nlp.core.sample.SampleEntity;
import ai.tock.nlp.core.sample.SampleExpression;
import ai.tock.nlp.model.EntityBuildContext;
import ai.tock.nlp.model.EntityContext;
import ai.tock.nlp.model.IntentContext;
import ai.tock.nlp.model.TokenizerContext;
import ai.tock.nlp.model.service.engine.EntityModelHolder;
import ai.tock.nlp.model.service.engine.IntentModelHolder;
import ai.tock.nlp.model.service.engine.NlpEngineModelBuilder;
import ai.tock.nlp.model.service.engine.Tokenizer;
import ai.tock.nlp.model.service.engine.TokenizerModelHolder;
import ai.tock.nlp.stanford.StanfordEngineProvider;
import ai.tock.nlp.stanford.StanfordIntentModel;
import ai.tock.nlp.stanford.StanfordModelBuilder;
import ai.tock.shared.PropertiesKt;
import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.ColumnDataClassifier;
import edu.stanford.nlp.classify.Dataset;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.objectbank.ObjectBank;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J&\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J&\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J+\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0000\u00a2\u0006\u0002\b R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lai/tock/nlp/stanford/StanfordModelBuilder;", "Lai/tock/nlp/model/service/engine/NlpEngineModelBuilder;", "()V", "ADJACENT_ENTITY_MARKER", "", "TAB", "defaultEntityClassifierConfiguration", "Lai/tock/nlp/core/configuration/NlpModelConfiguration;", "getDefaultEntityClassifierConfiguration", "()Lai/tock/nlp/core/configuration/NlpModelConfiguration;", "defaultIntentClassifierConfiguration", "getDefaultIntentClassifierConfiguration", "defaultTokenizerConfiguration", "getDefaultTokenizerConfiguration", "logger", "Lmu/KLogger;", "buildEntityModel", "Lai/tock/nlp/model/service/engine/EntityModelHolder;", "context", "Lai/tock/nlp/model/EntityBuildContext;", "configuration", "Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;", "expressions", "", "Lai/tock/nlp/core/sample/SampleExpression;", "buildIntentModel", "Lai/tock/nlp/model/service/engine/IntentModelHolder;", "Lai/tock/nlp/model/IntentContext;", "buildTokenizerModel", "Lai/tock/nlp/model/service/engine/TokenizerModelHolder;", "Lai/tock/nlp/model/TokenizerContext;", "getEntityTrainData", "getEntityTrainData$tock_nlp_model_stanford", "tock-nlp-model-stanford"})
public final class StanfordModelBuilder
implements NlpEngineModelBuilder {
    private static final KLogger logger;
    @NotNull
    public static final String TAB = "\t";
    @NotNull
    public static final String ADJACENT_ENTITY_MARKER = "__near__";
    @NotNull
    private static final NlpModelConfiguration defaultEntityClassifierConfiguration;
    @NotNull
    private static final NlpModelConfiguration defaultIntentClassifierConfiguration;
    @NotNull
    private static final NlpModelConfiguration defaultTokenizerConfiguration;
    @NotNull
    public static final StanfordModelBuilder INSTANCE;

    @NotNull
    public TokenizerModelHolder buildTokenizerModel(@NotNull TokenizerContext context, @NotNull NlpApplicationConfiguration configuration, @NotNull List<SampleExpression> expressions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        return new TokenizerModelHolder(context.getLanguage(), configuration);
    }

    @NotNull
    public NlpModelConfiguration getDefaultEntityClassifierConfiguration() {
        return defaultEntityClassifierConfiguration;
    }

    @NotNull
    public NlpModelConfiguration getDefaultIntentClassifierConfiguration() {
        return defaultIntentClassifierConfiguration;
    }

    @NotNull
    public NlpModelConfiguration getDefaultTokenizerConfiguration() {
        return defaultTokenizerConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IntentModelHolder buildIntentModel(@NotNull IntentContext context, @NotNull NlpApplicationConfiguration configuration, @NotNull List<SampleExpression> expressions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        ColumnDataClassifier cdc = new ColumnDataClassifier(configuration.getIntentConfiguration().getProperties());
        Dataset dataset = new Dataset();
        Iterable $this$map$iv = expressions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SampleExpression sampleExpression = (SampleExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            dataset.add(cdc.makeDatumFromLine(it.getIntent().getName() + "\t$" + it.getText()));
            Unit unit = Unit.INSTANCE;
            collection.add(unit);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        Classifier classifier = cdc.makeClassifier((GeneralDataset)dataset);
        Application application = context.getApplication();
        Classifier classifier2 = classifier;
        Intrinsics.checkNotNullExpressionValue((Object)classifier2, (String)"classifier");
        return new IntentModelHolder(application, (Object)new StanfordIntentModel(cdc, (Classifier<String, String>)classifier2), configuration, null, 8, null);
    }

    @NotNull
    public EntityModelHolder buildEntityModel(@NotNull EntityBuildContext context, @NotNull NlpApplicationConfiguration configuration, @NotNull List<SampleExpression> expressions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        CRFClassifier crfClassifier = new CRFClassifier(configuration.getEntityConfiguration().getProperties());
        String trainingData = this.getEntityTrainData$tock_nlp_model_stanford(context, configuration, expressions);
        try {
            ObjectBank objectBank = crfClassifier.makeObjectBankFromString(trainingData, crfClassifier.defaultReaderAndWriter());
            Intrinsics.checkNotNullExpressionValue((Object)objectBank, (String)"crfClassifier.makeObject\u2026AndWriter()\n            )");
            ObjectBank transformedData = objectBank;
            crfClassifier.train((Collection)transformedData);
            return new EntityModelHolder((Object)crfClassifier, configuration, null, 4, null);
        }
        catch (Exception e) {
            logger.error((Function0)new Function0<Object>(trainingData){
                final /* synthetic */ String $trainingData;

                @Nullable
                public final Object invoke() {
                    return "error with train data: \n " + this.$trainingData;
                }
                {
                    this.$trainingData = string;
                    super(0);
                }
            });
            throw (Throwable)e;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getEntityTrainData$tock_nlp_model_stanford(@NotNull EntityBuildContext context, @NotNull NlpApplicationConfiguration configuration, @NotNull List<SampleExpression> expressions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        Tokenizer tokenizer = StanfordEngineProvider.Companion.getStanfordTokenizer(new TokenizerModelHolder(context.getLanguage(), configuration));
        TokenizerContext tokenizerContext = new TokenizerContext((EntityContext)context);
        StringBuilder sb = new StringBuilder();
        Map tokensIndexes = new HashMap();
        Map entityRoleMap = new HashMap();
        Iterable $this$forEach$iv = expressions;
        boolean $i$f$forEach = false;
        block2: for (Object element$iv : $this$forEach$iv) {
            SampleExpression expression = (SampleExpression)element$iv;
            boolean bl = false;
            try {
                String text = expression.getText();
                if (StringsKt.contains$default((CharSequence)text, (CharSequence)"\n", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)text, (CharSequence)TAB, (boolean)false, (int)2, null)) {
                    logger.warn((Function0)new Function0<Object>(text){
                        final /* synthetic */ String $text;

                        @Nullable
                        public final Object invoke() {
                            return "expression " + this.$text + " contains \\n or \\t!!! - skipped";
                        }
                        {
                            this.$text = string;
                            super(0);
                        }
                    });
                    continue;
                }
                tokensIndexes.clear();
                entityRoleMap.clear();
                String[] tokens = tokenizer.tokenize(tokenizerContext, text);
                Iterable $this$forEach$iv2 = expression.getEntities();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    int n;
                    int n2;
                    int n3;
                    SampleEntity e = (SampleEntity)element$iv2;
                    boolean bl2 = false;
                    if (e.getStart() == 0) {
                        n3 = 0;
                    } else {
                        String string = text;
                        int n4 = 0;
                        n2 = e.getStart();
                        n = 0;
                        String string2 = string;
                        if (string2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.substring(n4, n2);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        n3 = tokenizer.tokenize(tokenizerContext, string3).length;
                    }
                    int start = n3;
                    String string = text;
                    n2 = e.getStart();
                    n = e.getEnd();
                    boolean bl3 = false;
                    String string4 = string;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n2, n);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    int end = start + tokenizer.tokenize(tokenizerContext, string5).length;
                    if (start < tokens.length && end <= tokens.length) {
                        int n5 = start;
                        n2 = end;
                        while (n5 < n2) {
                            void i;
                            tokensIndexes.put((int)i, e);
                            ++i;
                        }
                        continue;
                    }
                    logger.warn((Function0)new Function0<Object>(text, tokens, tokensIndexes, entityRoleMap, tokenizer, tokenizerContext, sb){
                        final /* synthetic */ String $text$inlined;
                        final /* synthetic */ String[] $tokens$inlined;
                        final /* synthetic */ Map $tokensIndexes$inlined;
                        final /* synthetic */ Map $entityRoleMap$inlined;
                        final /* synthetic */ Tokenizer $tokenizer$inlined;
                        final /* synthetic */ TokenizerContext $tokenizerContext$inlined;
                        final /* synthetic */ StringBuilder $sb$inlined;
                        {
                            this.$text$inlined = string;
                            this.$tokens$inlined = stringArray;
                            this.$tokensIndexes$inlined = map;
                            this.$entityRoleMap$inlined = map2;
                            this.$tokenizer$inlined = tokenizer;
                            this.$tokenizerContext$inlined = tokenizerContext;
                            this.$sb$inlined = stringBuilder;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "entity mismatch for " + this.$text$inlined;
                        }
                    });
                    continue block2;
                }
                String[] $this$forEachIndexed$iv = tokens;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (String item$iv : $this$forEachIndexed$iv) {
                    void token;
                    String string;
                    block17: {
                        Object object;
                        SampleEntity entity;
                        block21: {
                            block20: {
                                int index;
                                block19: {
                                    block18: {
                                        block16: {
                                            int n = index$iv++;
                                            String i = item$iv;
                                            index = n;
                                            boolean bl4 = false;
                                            entity = (SampleEntity)tokensIndexes.get(index);
                                            if (entity != null) break block16;
                                            string = "O";
                                            break block17;
                                        }
                                        if (index != 0) break block18;
                                        string = entity.getDefinition().getRole();
                                        break block17;
                                    }
                                    String alreadyKnown = (String)entityRoleMap.get(entity);
                                    if (alreadyKnown == null) break block19;
                                    string = alreadyKnown;
                                    break block17;
                                }
                                object = (SampleEntity)tokensIndexes.get(index - 1);
                                if (object == null) break block20;
                                SampleEntity sampleEntity = object;
                                boolean bl5 = false;
                                boolean bl6 = false;
                                SampleEntity it = sampleEntity;
                                boolean bl7 = false;
                                object = Intrinsics.areEqual((Object)((String)entityRoleMap.get(it)), (Object)entity.getDefinition().getRole()) ? sampleEntity : null;
                                if (object == null) break block20;
                                sampleEntity = object;
                                bl5 = false;
                                bl6 = false;
                                it = sampleEntity;
                                boolean bl8 = false;
                                object = ADJACENT_ENTITY_MARKER + it.getDefinition().getRole();
                                if (object != null) break block21;
                            }
                            object = entity.getDefinition().getRole();
                        }
                        Object r = object;
                        entityRoleMap.put(entity, r);
                        string = r;
                    }
                    String role = string;
                    sb.append((String)token);
                    sb.append(TAB);
                    StringBuilder stringBuilder = sb;
                    boolean bl9 = false;
                    StringBuilder stringBuilder2 = stringBuilder.append(role);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder2);
                }
                StringsKt.appendln((StringBuilder)sb);
                logger.trace((Function0)new Function0<Object>(text, tokensIndexes, entityRoleMap, tokenizer, tokenizerContext, sb){
                    final /* synthetic */ String $text;
                    final /* synthetic */ Map $tokensIndexes$inlined;
                    final /* synthetic */ Map $entityRoleMap$inlined;
                    final /* synthetic */ Tokenizer $tokenizer$inlined;
                    final /* synthetic */ TokenizerContext $tokenizerContext$inlined;
                    final /* synthetic */ StringBuilder $sb$inlined;
                    {
                        this.$text = string;
                        this.$tokensIndexes$inlined = map;
                        this.$entityRoleMap$inlined = map2;
                        this.$tokenizer$inlined = tokenizer;
                        this.$tokenizerContext$inlined = tokenizerContext;
                        this.$sb$inlined = stringBuilder;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return this.$text + " ->\n" + this.$sb$inlined;
                    }
                });
            }
            catch (Exception e) {
                logger.error("error with " + expression, (Throwable)e);
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private StanfordModelBuilder() {
    }

    static {
        StanfordModelBuilder stanfordModelBuilder;
        INSTANCE = stanfordModelBuilder = new StanfordModelBuilder();
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        defaultEntityClassifierConfiguration = new NlpModelConfiguration(PropertiesKt.loadProperties((String)"/stanford/crfclassifier.properties"), null, false, false, 14, null);
        defaultIntentClassifierConfiguration = new NlpModelConfiguration(PropertiesKt.loadProperties((String)"/stanford/intentClassifier.properties"), null, false, false, 14, null);
        defaultTokenizerConfiguration = new NlpModelConfiguration(PropertiesKt.loadProperties((String)"/stanford/tokenizer.properties"), null, false, false, 14, null);
    }

    @NotNull
    public NlpApplicationConfiguration defaultNlpApplicationConfiguration() {
        return NlpEngineModelBuilder.DefaultImpls.defaultNlpApplicationConfiguration((NlpEngineModelBuilder)this);
    }
}

