/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.stanford;

import ai.tock.nlp.core.Application;
import ai.tock.nlp.core.Intent;
import ai.tock.nlp.core.IntentClassification;
import ai.tock.nlp.model.IntentContext;
import ai.tock.nlp.model.service.engine.IntentModelHolder;
import ai.tock.nlp.model.service.engine.NlpIntentClassifier;
import ai.tock.nlp.stanford.StanfordIntentModel;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J+\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000f"}, d2={"Lai/tock/nlp/stanford/StanfordIntentClassifier;", "Lai/tock/nlp/model/service/engine/NlpIntentClassifier;", "model", "Lai/tock/nlp/model/service/engine/IntentModelHolder;", "(Lai/tock/nlp/model/service/engine/IntentModelHolder;)V", "classifyIntent", "Lai/tock/nlp/core/IntentClassification;", "context", "Lai/tock/nlp/model/IntentContext;", "text", "", "tokens", "", "(Lai/tock/nlp/model/IntentContext;Ljava/lang/String;[Ljava/lang/String;)Lai/tock/nlp/core/IntentClassification;", "Companion", "tock-nlp-model-stanford"})
public final class StanfordIntentClassifier
extends NlpIntentClassifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final IntentClassification emptyClassification = new IntentClassification(){

        public double probability() {
            return 0.0;
        }

        public boolean hasNext() {
            return false;
        }

        @NotNull
        public Intent next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    };

    public StanfordIntentClassifier(@NotNull IntentModelHolder model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(model);
    }

    @NotNull
    public IntentClassification classifyIntent(@NotNull IntentContext context, @NotNull String text, @NotNull String[] tokens) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        IntentModelHolder intentModelHolder = this.getModel();
        boolean bl = false;
        boolean bl2 = false;
        IntentModelHolder $this$classifyIntent_u24lambda_u2d2 = intentModelHolder;
        boolean bl3 = false;
        if (!this.getModel().getApplication().getIntents().isEmpty()) {
            StanfordIntentModel stanfordIntentModel = (StanfordIntentModel)$this$classifyIntent_u24lambda_u2d2.getNativeModel();
            boolean bl4 = false;
            boolean bl5 = false;
            StanfordIntentModel $this$classifyIntent_u24lambda_u2d2_u24lambda_u2d1 = stanfordIntentModel;
            boolean bl6 = false;
            Datum d = $this$classifyIntent_u24lambda_u2d2_u24lambda_u2d1.getCdc().makeDatumFromLine(Intrinsics.stringPlus((String)"\t", (Object)text));
            Counter scores = $this$classifyIntent_u24lambda_u2d2_u24lambda_u2d1.getClassifier().scoresOf(d);
            double logSum = Counters.logSum((Counter)scores);
            Set set = scores.entrySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"scores.entrySet()");
            Iterable $this$sortedByDescending$iv = set;
            boolean $i$f$sortedByDescending = false;
            boolean bl7 = false;
            Iterator iterator = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Map.Entry it = (Map.Entry)b;
                    boolean bl2 = false;
                    Comparable comparable = (Double)it.getValue();
                    it = (Map.Entry)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Double d = (Double)it.getValue();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
                }
            }).iterator();
            return new IntentClassification(iterator, logSum, $this$classifyIntent_u24lambda_u2d2){
                private double probability;
                final /* synthetic */ Iterator<Map.Entry<String, Double>> $iterator;
                final /* synthetic */ double $logSum;
                final /* synthetic */ IntentModelHolder $this_with;
                {
                    this.$iterator = $iterator;
                    this.$logSum = $logSum;
                    this.$this_with = $receiver;
                }

                public final double getProbability() {
                    return this.probability;
                }

                public final void setProbability(double d) {
                    this.probability = d;
                }

                public double probability() {
                    return this.probability;
                }

                public boolean hasNext() {
                    return this.$iterator.hasNext();
                }

                @NotNull
                public Intent next() {
                    Intent intent = this.$iterator.next();
                    double d = this.$logSum;
                    IntentModelHolder intentModelHolder = this.$this_with;
                    boolean bl = false;
                    boolean bl2 = false;
                    Intent $dstr$key$proba = intent;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue($dstr$key$proba, (String)"(key, proba)");
                    Intent intent2 = $dstr$key$proba;
                    boolean bl4 = false;
                    String key = intent2.getKey();
                    Intent intent3 = $dstr$key$proba;
                    boolean bl5 = false;
                    Double proba = intent3.getValue();
                    this.setProbability(Math.exp(proba - d));
                    Application application = intentModelHolder.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    intent3 = application.getIntent(key);
                    return intent3 == null ? Intent.Companion.getUNKNOWN_INTENT() : intent3;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }
        return emptyClassification;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lai/tock/nlp/stanford/StanfordIntentClassifier$Companion;", "", "()V", "emptyClassification", "Lai/tock/nlp/core/IntentClassification;", "getEmptyClassification", "()Lai/tock/nlp/core/IntentClassification;", "tock-nlp-model-stanford"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntentClassification getEmptyClassification() {
            return emptyClassification;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

