/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.stanford;

import ai.tock.nlp.core.configuration.NlpApplicationConfiguration;
import ai.tock.nlp.core.configuration.NlpModelConfiguration;
import ai.tock.nlp.model.service.engine.NlpEngineModelIo;
import ai.tock.nlp.model.service.storage.NlpModelStream;
import ai.tock.nlp.stanford.StanfordIntentModel;
import ai.tock.nlp.stanford.StanfordModelBuilder;
import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.ColumnDataClassifier;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import java.io.Closeable;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0010"}, d2={"Lai/tock/nlp/stanford/StanfordModelIo;", "Lai/tock/nlp/model/service/engine/NlpEngineModelIo;", "()V", "copyEntityModel", "", "model", "", "output", "Ljava/io/OutputStream;", "copyIntentModel", "copyTokenizerModel", "loadEntityModel", "input", "Lai/tock/nlp/model/service/storage/NlpModelStream;", "loadIntentModel", "loadTokenizerModel", "tock-nlp-model-stanford"})
public final class StanfordModelIo
implements NlpEngineModelIo {
    @NotNull
    public static final StanfordModelIo INSTANCE = new StanfordModelIo();

    private StanfordModelIo() {
    }

    @NotNull
    public Object loadTokenizerModel(@NotNull NlpModelStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        throw new IllegalStateException("loading tokenizer model is not supported".toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Object loadIntentModel(@NotNull NlpModelStream input) {
        StanfordIntentModel stanfordIntentModel;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Closeable closeable = new ObjectInputStream(input.getInputStream());
        Throwable throwable = null;
        try {
            Properties properties;
            ObjectInputStream it = (ObjectInputStream)closeable;
            boolean bl = false;
            Object object = it.readObject();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type edu.stanford.nlp.classify.Classifier<kotlin.String, kotlin.String>");
            }
            Classifier classifier = (Classifier)object;
            NlpApplicationConfiguration nlpApplicationConfiguration = input.getConfiguration();
            if (nlpApplicationConfiguration == null) {
                properties = null;
            } else {
                NlpModelConfiguration nlpModelConfiguration = nlpApplicationConfiguration.getIntentConfiguration();
                properties = nlpModelConfiguration == null ? null : nlpModelConfiguration.getProperties();
            }
            Properties properties2 = properties;
            stanfordIntentModel = new StanfordIntentModel(new ColumnDataClassifier(properties2 == null ? StanfordModelBuilder.INSTANCE.getDefaultIntentClassifierConfiguration().getProperties() : properties2), (Classifier<String, String>)classifier);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return stanfordIntentModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Object loadEntityModel(@NotNull NlpModelStream input) {
        Properties properties;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Closeable closeable = input.getInputStream();
        Throwable throwable = null;
        try {
            Properties properties2;
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            NlpApplicationConfiguration nlpApplicationConfiguration = input.getConfiguration();
            if (nlpApplicationConfiguration == null) {
                properties2 = null;
            } else {
                NlpModelConfiguration nlpModelConfiguration = nlpApplicationConfiguration.getEntityConfiguration();
                properties2 = nlpModelConfiguration == null ? null : nlpModelConfiguration.getProperties();
            }
            Properties properties3 = properties2;
            Properties $this$loadEntityModel_u24lambda_u2d2_u24lambda_u2d1 = properties3 = new CRFClassifier(properties3 == null ? StanfordModelBuilder.INSTANCE.getDefaultEntityClassifierConfiguration().getProperties() : properties3);
            boolean bl2 = false;
            $this$loadEntityModel_u24lambda_u2d2_u24lambda_u2d1.loadClassifier(stream);
            properties = properties3;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return properties;
    }

    public void copyTokenizerModel(@NotNull Object model, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        throw new IllegalStateException("copying tokenizer model is not supported".toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyIntentModel(@NotNull Object model, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        StanfordIntentModel stanfordModel = (StanfordIntentModel)model;
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(output);
        Closeable closeable = objectOutputStream;
        Throwable throwable = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)closeable;
            boolean bl = false;
            objectOutputStream.writeObject(stanfordModel.getClassifier());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyEntityModel(@NotNull Object model, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        CRFClassifier crfClassifier = (CRFClassifier)model;
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(output);
        Closeable closeable = objectOutputStream;
        Throwable throwable = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)closeable;
            boolean bl = false;
            crfClassifier.serializeClassifier(objectOutputStream);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

