/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.stanford;

import ai.tock.nlp.core.Entity;
import ai.tock.nlp.core.EntityRecognition;
import ai.tock.nlp.core.EntityValue;
import ai.tock.nlp.core.IntOpenRange;
import ai.tock.nlp.model.EntityCallContext;
import ai.tock.nlp.model.EntityCallContextForEntity;
import ai.tock.nlp.model.EntityCallContextForIntent;
import ai.tock.nlp.model.EntityCallContextForSubEntities;
import ai.tock.nlp.model.service.engine.EntityModelHolder;
import ai.tock.nlp.model.service.engine.NlpEntityClassifier;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.ie.crf.CRFCliqueTree;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.objectbank.ObjectBank;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000  2\u00020\u0001:\u0002 !B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J1\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ1\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0011J1\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0013J?\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015H\u0002\u00a2\u0006\u0002\u0010\u0017J\u001b\u0010\u0018\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u0019J$\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0007H\u0002\u00a8\u0006\""}, d2={"Lai/tock/nlp/stanford/StanfordEntityClassifier;", "Lai/tock/nlp/model/service/engine/NlpEntityClassifier;", "model", "Lai/tock/nlp/model/service/engine/EntityModelHolder;", "<init>", "(Lai/tock/nlp/model/service/engine/EntityModelHolder;)V", "classifyEntities", "", "Lai/tock/nlp/core/EntityRecognition;", "context", "Lai/tock/nlp/model/EntityCallContext;", "text", "", "tokens", "", "(Lai/tock/nlp/model/EntityCallContext;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "Lai/tock/nlp/model/EntityCallContextForSubEntities;", "(Lai/tock/nlp/model/EntityCallContextForSubEntities;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "Lai/tock/nlp/model/EntityCallContextForIntent;", "(Lai/tock/nlp/model/EntityCallContextForIntent;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "entityFinder", "Lkotlin/Function1;", "Lai/tock/nlp/core/Entity;", "(Ljava/lang/String;[Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "getEvaluationData", "([Ljava/lang/String;)Ljava/lang/String;", "getConfidence", "", "classifier", "Ledu/stanford/nlp/ie/crf/CRFClassifier;", "Ledu/stanford/nlp/ling/CoreLabel;", "classifiedLabels", "Companion", "Token", "tock-nlp-model-stanford"})
@SourceDebugExtension(value={"SMAP\nStanfordEntityClassifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StanfordEntityClassifier.kt\nai/tock/nlp/stanford/StanfordEntityClassifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n1872#2,3:170\n1611#2,9:173\n1863#2:182\n1864#2:184\n1620#2:185\n1#3:183\n*S KotlinDebug\n*F\n+ 1 StanfordEntityClassifier.kt\nai/tock/nlp/stanford/StanfordEntityClassifier\n*L\n101#1:170,3\n131#1:173,9\n131#1:182\n131#1:184\n131#1:185\n131#1:183\n*E\n"})
public final class StanfordEntityClassifier
extends NlpEntityClassifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(StanfordEntityClassifier::logger$lambda$8);
    @NotNull
    private static final Regex adjacentMarkerRegep = new Regex("__near__");

    public StanfordEntityClassifier(@NotNull EntityModelHolder model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(model);
    }

    @NotNull
    public List<EntityRecognition> classifyEntities(@NotNull EntityCallContext context, @NotNull String text, @NotNull String[] tokens) {
        List<EntityRecognition> list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        EntityCallContext entityCallContext = context;
        if (entityCallContext instanceof EntityCallContextForIntent) {
            list = this.classifyEntities((EntityCallContextForIntent)context, text, tokens);
        } else {
            if (entityCallContext instanceof EntityCallContextForEntity) {
                throw new IllegalStateException("EntityCallContextForEntity is not supported".toString());
            }
            if (entityCallContext instanceof EntityCallContextForSubEntities) {
                list = this.classifyEntities((EntityCallContextForSubEntities)context, text, tokens);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    private final List<EntityRecognition> classifyEntities(EntityCallContextForSubEntities context, String text, String[] tokens) {
        return this.classifyEntities(text, tokens, (Function1<? super String, Entity>)((Function1)arg_0 -> StanfordEntityClassifier.classifyEntities$lambda$0(context, arg_0)));
    }

    private final List<EntityRecognition> classifyEntities(EntityCallContextForIntent context, String text, String[] tokens) {
        return this.classifyEntities(text, tokens, (Function1<? super String, Entity>)((Function1)arg_0 -> StanfordEntityClassifier.classifyEntities$lambda$1(context, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<EntityRecognition> classifyEntities(String text, String[] tokens, Function1<? super String, Entity> entityFinder) {
        List list;
        try {
            void $this$mapNotNullTo$iv$iv;
            CharSequence charSequence;
            EntityModelHolder $this$classifyEntities_u24lambda_u245 = this.getModel();
            boolean bl = false;
            Object object = $this$classifyEntities_u24lambda_u245.getNativeModel();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type edu.stanford.nlp.ie.crf.CRFClassifier<edu.stanford.nlp.ling.CoreLabel>");
            CRFClassifier classifier = (CRFClassifier)object;
            String evaluationData = this.getEvaluationData(tokens);
            ObjectBank documents = classifier.makeObjectBankFromString(evaluationData, classifier.defaultReaderAndWriter());
            Intrinsics.checkNotNull((Object)documents);
            List document = CollectionsKt.flatten((Iterable)((Iterable)documents));
            List classifiedLabels = classifier.classify(document);
            Intrinsics.checkNotNull((Object)classifiedLabels);
            double confidence = this.getConfidence((CRFClassifier<CoreLabel>)classifier, classifiedLabels);
            List coreTokens = new ArrayList();
            Token previousToken = null;
            Iterable $this$forEachIndexed$iv = document;
            boolean $i$f$forEachIndexed = false;
            int index$iv22 = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void word;
                int n;
                if ((n = index$iv22++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                CoreLabel coreLabel = (CoreLabel)item$iv;
                int index = n;
                boolean bl2 = false;
                String t = text;
                int start = 0;
                for (int i = 0; i < index; ++i) {
                    int n2 = ((CoreLabel)document.get(i)).word().length();
                    CharSequence charSequence2 = t;
                    String string = ((CoreLabel)document.get(i)).word();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"word(...)");
                    int nextTokenIndex = n2 + StringsKt.indexOf$default((CharSequence)charSequence2, (String)string, (int)0, (boolean)false, (int)6, null);
                    start += nextTokenIndex;
                    Intrinsics.checkNotNullExpressionValue((Object)t.substring(nextTokenIndex), (String)"substring(...)");
                }
                CharSequence charSequence3 = t;
                String string = ((CoreLabel)document.get(index)).word();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"word(...)");
                int end = (start += StringsKt.indexOf$default((CharSequence)charSequence3, (String)string, (int)0, (boolean)false, (int)6, null)) + ((CoreLabel)document.get(index)).word().length();
                String entityRole = (String)word.get(CoreAnnotations.AnswerAnnotation.class);
                if (!Intrinsics.areEqual((Object)entityRole, (Object)"O")) {
                    Token token = previousToken;
                    if (!Intrinsics.areEqual((Object)(token != null ? token.getType() : null), (Object)entityRole)) {
                        String string2 = word.word();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"word(...)");
                        Intrinsics.checkNotNull((Object)entityRole);
                        previousToken = new Token(start, end, string2, entityRole);
                    } else {
                        String w;
                        coreTokens.remove(CollectionsKt.getLastIndex((List)coreTokens));
                        charSequence = text;
                        Token token2 = previousToken;
                        Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type ai.tock.nlp.stanford.StanfordEntityClassifier.Token");
                        int n3 = token2.getStart();
                        Intrinsics.checkNotNullExpressionValue((Object)((String)charSequence).substring(n3, end), (String)"substring(...)");
                        int n4 = previousToken.getStart();
                        Intrinsics.checkNotNull((Object)entityRole);
                        previousToken = new Token(n4, end, w, entityRole);
                    }
                    Token tok = previousToken;
                    coreTokens.add(new Token(tok.getStart(), tok.getEnd(), tok.getText(), tok.getType()));
                    continue;
                }
                previousToken = null;
            }
            Iterable $this$mapNotNull$iv = coreTokens;
            boolean $i$f$mapNotNull = false;
            Iterable index$iv22 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                EntityRecognition entityRecognition;
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                Token it = (Token)element$iv$iv;
                boolean bl4 = false;
                Regex regex = adjacentMarkerRegep;
                charSequence = it.getType();
                Entity entity = (Entity)entityFinder.invoke((Object)regex.replaceFirst(charSequence, string = ""));
                if (entity == null) {
                    logger.warn(() -> StanfordEntityClassifier.classifyEntities$lambda$5$lambda$4$lambda$3(it));
                    entityRecognition = null;
                } else {
                    entityRecognition = new EntityRecognition(new EntityValue(it.getStart(), it.getEnd(), entity, null, null, false, 56, null), confidence);
                }
                if (entityRecognition == null) continue;
                EntityRecognition it$iv$iv = entityRecognition;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        catch (Exception e) {
            String string = Arrays.toString(tokens);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            logger.error("error with " + text + " and " + string, (Throwable)e);
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final String getEvaluationData(String[] tokens) {
        return ArraysKt.joinToString$default((Object[])tokens, (CharSequence)"", null, null, (int)0, null, StanfordEntityClassifier::getEvaluationData$lambda$6, (int)30, null);
    }

    private final double getConfidence(CRFClassifier<CoreLabel> classifier, List<? extends CoreLabel> classifiedLabels) {
        try {
            int counter = 0;
            double probSum = 0.0;
            CRFCliqueTree cliqueTree = classifier.getCliqueTree(classifiedLabels);
            int n = cliqueTree.length();
            for (int i = 0; i < n; ++i) {
                CoreLabel wi = classifiedLabels.get(i);
                int index = classifier.classIndex.indexOf(wi.get(CoreAnnotations.AnswerAnnotation.class));
                probSum = cliqueTree.prob(i, index);
                ++counter;
            }
            double prob = 1.0 - probSum / (double)counter;
            return (double)Math.round(prob * (double)1000) / 1000.0;
        }
        catch (Exception e) {
            logger.error((Throwable)e, StanfordEntityClassifier::getConfidence$lambda$7);
            return 0.1;
        }
    }

    private static final Entity classifyEntities$lambda$0(EntityCallContextForSubEntities $context, String it) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $context.getEntityType().findSubEntity(it);
    }

    private static final Entity classifyEntities$lambda$1(EntityCallContextForIntent $context, String it) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $context.getIntent().getEntity(it);
    }

    private static final Object classifyEntities$lambda$5$lambda$4$lambda$3(Token $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return "unknown entity role " + $it.getType();
    }

    private static final CharSequence getEvaluationData$lambda$6(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it + "\tO\n";
    }

    private static final Object getConfidence$lambda$7() {
        return "Exception during confidence calculation - skipped";
    }

    private static final Unit logger$lambda$8() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lai/tock/nlp/stanford/StanfordEntityClassifier$Companion;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "adjacentMarkerRegep", "Lkotlin/text/Regex;", "tock-nlp-model-stanford"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lai/tock/nlp/stanford/StanfordEntityClassifier$Token;", "Lai/tock/nlp/core/IntOpenRange;", "start", "", "end", "text", "", "type", "<init>", "(IILjava/lang/String;Ljava/lang/String;)V", "getStart", "()I", "getEnd", "getText", "()Ljava/lang/String;", "getType", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "toString", "tock-nlp-model-stanford"})
    private static final class Token
    implements IntOpenRange {
        private final int start;
        private final int end;
        @NotNull
        private final String text;
        @NotNull
        private final String type;

        public Token(int start, int end, @NotNull String text, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.start = start;
            this.end = end;
            this.text = text;
            this.type = type;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final int component1() {
            return this.start;
        }

        public final int component2() {
            return this.end;
        }

        @NotNull
        public final String component3() {
            return this.text;
        }

        @NotNull
        public final String component4() {
            return this.type;
        }

        @NotNull
        public final Token copy(int start, int end, @NotNull String text, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new Token(start, end, text, type);
        }

        public static /* synthetic */ Token copy$default(Token token, int n, int n2, String string, String string2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = token.start;
            }
            if ((n3 & 2) != 0) {
                n2 = token.end;
            }
            if ((n3 & 4) != 0) {
                string = token.text;
            }
            if ((n3 & 8) != 0) {
                string2 = token.type;
            }
            return token.copy(n, n2, string, string2);
        }

        @NotNull
        public String toString() {
            return "Token(start=" + this.start + ", end=" + this.end + ", text=" + this.text + ", type=" + this.type + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.start);
            result = result * 31 + Integer.hashCode(this.end);
            result = result * 31 + this.text.hashCode();
            result = result * 31 + this.type.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            Token token = (Token)other;
            if (this.start != token.start) {
                return false;
            }
            if (this.end != token.end) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.text, (Object)token.text)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.type, (Object)token.type);
        }

        public int compareTo(@NotNull IntOpenRange other) {
            return IntOpenRange.DefaultImpls.compareTo((IntOpenRange)this, (IntOpenRange)other);
        }

        public boolean overlap(@NotNull IntOpenRange range) {
            return IntOpenRange.DefaultImpls.overlap((IntOpenRange)this, (IntOpenRange)range);
        }

        public boolean overlap(int start, int end) {
            return IntOpenRange.DefaultImpls.overlap((IntOpenRange)this, (int)start, (int)end);
        }

        public boolean isSameRange(@NotNull IntOpenRange range) {
            return IntOpenRange.DefaultImpls.isSameRange((IntOpenRange)this, (IntOpenRange)range);
        }

        @NotNull
        public IntRange toClosedRange() {
            return IntOpenRange.DefaultImpls.toClosedRange((IntOpenRange)this);
        }

        public int size() {
            return IntOpenRange.DefaultImpls.size((IntOpenRange)this);
        }

        @NotNull
        public String textValue(@NotNull String originalText) {
            return IntOpenRange.DefaultImpls.textValue((IntOpenRange)this, (String)originalText);
        }
    }
}

