/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.stanford;

import ai.tock.nlp.core.Application;
import ai.tock.nlp.core.Intent;
import ai.tock.nlp.core.IntentClassification;
import ai.tock.nlp.model.IntentContext;
import ai.tock.nlp.model.service.engine.IntentModelHolder;
import ai.tock.nlp.model.service.engine.NlpIntentClassifier;
import ai.tock.nlp.stanford.StanfordIntentModel;
import edu.stanford.nlp.ling.Datum;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J+\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rH\u0016\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lai/tock/nlp/stanford/StanfordIntentClassifier;", "Lai/tock/nlp/model/service/engine/NlpIntentClassifier;", "model", "Lai/tock/nlp/model/service/engine/IntentModelHolder;", "<init>", "(Lai/tock/nlp/model/service/engine/IntentModelHolder;)V", "classifyIntent", "Lai/tock/nlp/core/IntentClassification;", "context", "Lai/tock/nlp/model/IntentContext;", "text", "", "tokens", "", "(Lai/tock/nlp/model/IntentContext;Ljava/lang/String;[Ljava/lang/String;)Lai/tock/nlp/core/IntentClassification;", "Companion", "tock-nlp-model-stanford"})
@SourceDebugExtension(value={"SMAP\nStanfordIntentClassifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StanfordIntentClassifier.kt\nai/tock/nlp/stanford/StanfordIntentClassifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1062#2:74\n*S KotlinDebug\n*F\n+ 1 StanfordIntentClassifier.kt\nai/tock/nlp/stanford/StanfordIntentClassifier\n*L\n50#1:74\n*E\n"})
public final class StanfordIntentClassifier
extends NlpIntentClassifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final IntentClassification emptyClassification = new IntentClassification(){

        public double probability() {
            return 0.0;
        }

        public boolean hasNext() {
            return false;
        }

        public Intent next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    };

    public StanfordIntentClassifier(@NotNull IntentModelHolder model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(model);
    }

    @NotNull
    public IntentClassification classifyIntent(@NotNull IntentContext context, @NotNull String text, @NotNull String[] tokens) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        IntentModelHolder $this$classifyIntent_u24lambda_u242 = this.getModel();
        boolean bl = false;
        if (!this.getModel().getApplication().getIntents().isEmpty()) {
            Object object = $this$classifyIntent_u24lambda_u242.getNativeModel();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type ai.tock.nlp.stanford.StanfordIntentModel");
            StanfordIntentModel $this$classifyIntent_u24lambda_u242_u24lambda_u241 = (StanfordIntentModel)object;
            boolean bl2 = false;
            Datum d = $this$classifyIntent_u24lambda_u242_u24lambda_u241.getCdc().makeDatumFromLine("\t" + text);
            Counter scores = $this$classifyIntent_u24lambda_u242_u24lambda_u241.getClassifier().scoresOf(d);
            double logSum = Counters.logSum((Counter)scores);
            Set set = scores.entrySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
            Iterable $this$sortedByDescending$iv = set;
            boolean $i$f$sortedByDescending = false;
            Iterator iterator = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)b;
                    boolean bl = false;
                    Comparable comparable = (Double)it.getValue();
                    it = (Map.Entry)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getValue()));
                }
            }).iterator();
            return new IntentClassification(iterator, logSum, $this$classifyIntent_u24lambda_u242){
                private double probability;
                final /* synthetic */ Iterator<Map.Entry<String, Double>> $iterator;
                final /* synthetic */ double $logSum;
                final /* synthetic */ IntentModelHolder $this_with;
                {
                    this.$iterator = $iterator;
                    this.$logSum = $logSum;
                    this.$this_with = $receiver;
                }

                public final double getProbability() {
                    return this.probability;
                }

                public final void setProbability(double d) {
                    this.probability = d;
                }

                public double probability() {
                    return this.probability;
                }

                public boolean hasNext() {
                    return this.$iterator.hasNext();
                }

                public Intent next() {
                    Map.Entry<String, Double> entry = this.$iterator.next();
                    double d = this.$logSum;
                    IntentModelHolder intentModelHolder = this.$this_with;
                    Map.Entry<String, Double> entry2 = entry;
                    boolean bl = false;
                    Intrinsics.checkNotNull(entry2);
                    String key = entry2.getKey();
                    Double proba = entry2.getValue();
                    this.probability = Math.exp(proba - d);
                    Application application = intentModelHolder.getApplication();
                    Intrinsics.checkNotNull((Object)key);
                    Intent intent = application.getIntent(key);
                    if (intent == null) {
                        intent = Intent.Companion.getUNKNOWN_INTENT();
                    }
                    return intent;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }
        return emptyClassification;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/tock/nlp/stanford/StanfordIntentClassifier$Companion;", "", "<init>", "()V", "emptyClassification", "Lai/tock/nlp/core/IntentClassification;", "getEmptyClassification", "()Lai/tock/nlp/core/IntentClassification;", "tock-nlp-model-stanford"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntentClassification getEmptyClassification() {
            return emptyClassification;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

