/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.stanford;

import ai.tock.nlp.core.Application;
import ai.tock.nlp.core.configuration.NlpApplicationConfiguration;
import ai.tock.nlp.core.configuration.NlpModelConfiguration;
import ai.tock.nlp.core.sample.SampleEntity;
import ai.tock.nlp.core.sample.SampleExpression;
import ai.tock.nlp.model.EntityBuildContext;
import ai.tock.nlp.model.EntityContext;
import ai.tock.nlp.model.IntentContext;
import ai.tock.nlp.model.TokenizerContext;
import ai.tock.nlp.model.service.engine.EntityModelHolder;
import ai.tock.nlp.model.service.engine.IntentModelHolder;
import ai.tock.nlp.model.service.engine.NlpEngineModelBuilder;
import ai.tock.nlp.model.service.engine.TokenizerModelHolder;
import ai.tock.nlp.stanford.StanfordEngineProvider;
import ai.tock.nlp.stanford.StanfordIntentModel;
import ai.tock.shared.PropertiesKt;
import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.ColumnDataClassifier;
import edu.stanford.nlp.classify.Dataset;
import edu.stanford.nlp.classify.GeneralDataset;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.objectbank.ObjectBank;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J&\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J&\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J+\u0010 \u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0000\u00a2\u0006\u0002\b!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015\u00a8\u0006\""}, d2={"Lai/tock/nlp/stanford/StanfordModelBuilder;", "Lai/tock/nlp/model/service/engine/NlpEngineModelBuilder;", "<init>", "()V", "logger", "Lmu/KLogger;", "TAB", "", "ADJACENT_ENTITY_MARKER", "buildTokenizerModel", "Lai/tock/nlp/model/service/engine/TokenizerModelHolder;", "context", "Lai/tock/nlp/model/TokenizerContext;", "configuration", "Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;", "expressions", "", "Lai/tock/nlp/core/sample/SampleExpression;", "defaultEntityClassifierConfiguration", "Lai/tock/nlp/core/configuration/NlpModelConfiguration;", "getDefaultEntityClassifierConfiguration", "()Lai/tock/nlp/core/configuration/NlpModelConfiguration;", "defaultIntentClassifierConfiguration", "getDefaultIntentClassifierConfiguration", "defaultTokenizerConfiguration", "getDefaultTokenizerConfiguration", "buildIntentModel", "Lai/tock/nlp/model/service/engine/IntentModelHolder;", "Lai/tock/nlp/model/IntentContext;", "buildEntityModel", "Lai/tock/nlp/model/service/engine/EntityModelHolder;", "Lai/tock/nlp/model/EntityBuildContext;", "getEntityTrainData", "getEntityTrainData$tock_nlp_model_stanford", "tock-nlp-model-stanford"})
@SourceDebugExtension(value={"SMAP\nStanfordModelBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StanfordModelBuilder.kt\nai/tock/nlp/stanford/StanfordModelBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1557#2:175\n1628#2,3:176\n1863#2:179\n1863#2,2:180\n1864#2:186\n13411#3,2:182\n13413#3:185\n1#4:184\n*S KotlinDebug\n*F\n+ 1 StanfordModelBuilder.kt\nai/tock/nlp/stanford/StanfordModelBuilder\n*L\n75#1:175\n75#1:176,3\n115#1:179\n125#1:180,2\n115#1:186\n139#1:182,2\n139#1:185\n*E\n"})
public final class StanfordModelBuilder
implements NlpEngineModelBuilder {
    @NotNull
    public static final StanfordModelBuilder INSTANCE = new StanfordModelBuilder();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(StanfordModelBuilder::logger$lambda$0);
    @NotNull
    public static final String TAB = "\t";
    @NotNull
    public static final String ADJACENT_ENTITY_MARKER = "__near__";
    @NotNull
    private static final NlpModelConfiguration defaultEntityClassifierConfiguration = new NlpModelConfiguration(PropertiesKt.loadProperties((String)"/stanford/crfclassifier.properties"), null, false, false, 14, null);
    @NotNull
    private static final NlpModelConfiguration defaultIntentClassifierConfiguration = new NlpModelConfiguration(PropertiesKt.loadProperties((String)"/stanford/intentClassifier.properties"), null, false, false, 14, null);
    @NotNull
    private static final NlpModelConfiguration defaultTokenizerConfiguration = new NlpModelConfiguration(PropertiesKt.loadProperties((String)"/stanford/tokenizer.properties"), null, false, false, 14, null);

    private StanfordModelBuilder() {
    }

    @NotNull
    public TokenizerModelHolder buildTokenizerModel(@NotNull TokenizerContext context, @NotNull NlpApplicationConfiguration configuration, @NotNull List<SampleExpression> expressions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        return new TokenizerModelHolder(context.getLanguage(), configuration);
    }

    @NotNull
    public NlpModelConfiguration getDefaultEntityClassifierConfiguration() {
        return defaultEntityClassifierConfiguration;
    }

    @NotNull
    public NlpModelConfiguration getDefaultIntentClassifierConfiguration() {
        return defaultIntentClassifierConfiguration;
    }

    @NotNull
    public NlpModelConfiguration getDefaultTokenizerConfiguration() {
        return defaultTokenizerConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IntentModelHolder buildIntentModel(@NotNull IntentContext context, @NotNull NlpApplicationConfiguration configuration, @NotNull List<SampleExpression> expressions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        ColumnDataClassifier cdc = new ColumnDataClassifier(configuration.getIntentConfiguration().getProperties());
        Dataset dataset = new Dataset();
        Iterable $this$map$iv = expressions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SampleExpression sampleExpression = (SampleExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            dataset.add(cdc.makeDatumFromLine(it.getIntent().getName() + "\t$" + it.getText()));
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        Classifier classifier = cdc.makeClassifier((GeneralDataset)dataset);
        Application application = context.getApplication();
        Intrinsics.checkNotNull((Object)classifier);
        return new IntentModelHolder(application, (Object)new StanfordIntentModel(cdc, (Classifier<String, String>)classifier), configuration, null, 8, null);
    }

    @NotNull
    public EntityModelHolder buildEntityModel(@NotNull EntityBuildContext context, @NotNull NlpApplicationConfiguration configuration, @NotNull List<SampleExpression> expressions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        CRFClassifier crfClassifier = new CRFClassifier(configuration.getEntityConfiguration().getProperties());
        String trainingData = this.getEntityTrainData$tock_nlp_model_stanford(context, configuration, expressions);
        try {
            ObjectBank objectBank = crfClassifier.makeObjectBankFromString(trainingData, crfClassifier.defaultReaderAndWriter());
            Intrinsics.checkNotNullExpressionValue((Object)objectBank, (String)"makeObjectBankFromString(...)");
            ObjectBank transformedData = objectBank;
            crfClassifier.train((Collection)transformedData);
            return new EntityModelHolder((Object)crfClassifier, configuration, null, 4, null);
        }
        catch (Exception e) {
            logger.error(() -> StanfordModelBuilder.buildEntityModel$lambda$2(trainingData));
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final String getEntityTrainData$tock_nlp_model_stanford(@NotNull EntityBuildContext context, @NotNull NlpApplicationConfiguration configuration, @NotNull List<SampleExpression> expressions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(expressions, (String)"expressions");
        tokenizer = StanfordEngineProvider.Companion.getStanfordTokenizer(new TokenizerModelHolder(context.getLanguage(), configuration));
        tokenizerContext = new TokenizerContext((EntityContext)context);
        sb = new StringBuilder();
        tokensIndexes = new HashMap<K, V>();
        entityRoleMap = new HashMap<K, V>();
        $this$forEach$iv = expressions;
        $i$f$forEach = false;
        block2: for (T element$iv : $this$forEach$iv) {
            expression = (SampleExpression)element$iv;
            $i$a$-forEach-StanfordModelBuilder$getEntityTrainData$1 = false;
            try {
                text = expression.getText();
                if (StringsKt.contains$default((CharSequence)text, (CharSequence)"\n", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)text, (CharSequence)"\t", (boolean)false, (int)2, null)) {
                    StanfordModelBuilder.logger.warn((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getEntityTrainData$lambda$10$lambda$3(java.lang.String ), ()Ljava/lang/Object;)((String)text));
                    continue;
                }
                tokensIndexes.clear();
                entityRoleMap.clear();
                tokens = tokenizer.tokenize(tokenizerContext, text);
                $this$forEach$iv = expression.getEntities();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    e = (SampleEntity)element$iv;
                    $i$a$-forEach-StanfordModelBuilder$getEntityTrainData$1$2 = false;
                    if (e.getStart() == 0) {
                        v0 = 0;
                    } else {
                        v1 = text.substring(0, e.getStart());
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"substring(...)");
                        v0 = tokenizer.tokenize(tokenizerContext, v1).length;
                    }
                    start = v0;
                    v2 = text.substring(e.getStart(), e.getEnd());
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"substring(...)");
                    end = start + tokenizer.tokenize(tokenizerContext, v2).length;
                    if (start < tokens.length && end <= tokens.length) {
                        for (i = start; i < end; ++i) {
                            var26_32 = i;
                            tokensIndexes.put(var26_32, e);
                        }
                        continue;
                    }
                    StanfordModelBuilder.logger.warn((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getEntityTrainData$lambda$10$lambda$5$lambda$4(java.lang.String ), ()Ljava/lang/Object;)((String)text));
                    continue block2;
                }
                $this$forEachIndexed$iv = tokens;
                $i$f$forEachIndexed = false;
                index$iv = 0;
                for (String item$iv : $this$forEachIndexed$iv) {
                    block13: {
                        block15: {
                            block14: {
                                block12: {
                                    v3 = index$iv++;
                                    start = item$iv;
                                    index = v3;
                                    $i$a$-forEachIndexed-StanfordModelBuilder$getEntityTrainData$1$3 = false;
                                    entity = (SampleEntity)tokensIndexes.get(index);
                                    if (entity != null) break block12;
                                    v4 = "O";
                                    break block13;
                                }
                                if (index != 0) break block14;
                                v4 = entity.getDefinition().getRole();
                                break block13;
                            }
                            alreadyKnown = (String)entityRoleMap.get(entity);
                            if (alreadyKnown == null) break block15;
                            v4 = alreadyKnown;
                            break block13;
                        }
                        var28_34 = (SampleEntity)tokensIndexes.get(index - 1);
                        if (var28_34 == null) ** GOTO lbl-1000
                        it = var29_35 /* !! */  = var28_34;
                        $i$a$-takeIf-StanfordModelBuilder$getEntityTrainData$1$3$role$r$1 = false;
                        v5 /* !! */  = var32_39 = Intrinsics.areEqual(entityRoleMap.get(it), (Object)entity.getDefinition().getRole()) != false ? var29_35 /* !! */  : null;
                        if (var32_39 == null) ** GOTO lbl-1000
                        it = var32_39;
                        $i$a$-let-StanfordModelBuilder$getEntityTrainData$1$3$role$r$2 = false;
                        var29_35 /* !! */  = "__near__" + it.getDefinition().getRole();
                        if (var29_35 /* !! */  != null) {
                            v6 = var29_35 /* !! */ ;
                        } else lbl-1000:
                        // 3 sources

                        {
                            v6 = entity.getDefinition().getRole();
                        }
                        r = v6;
                        entityRoleMap.put(entity, r);
                        v4 = r;
                    }
                    role = v4;
                    sb.append((String)token);
                    sb.append("\t");
                    v7 = sb.append(role);
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"append(...)");
                    StringsKt.appendln((StringBuilder)v7);
                }
                StringsKt.appendln((StringBuilder)sb);
                StanfordModelBuilder.logger.trace((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getEntityTrainData$lambda$10$lambda$9(java.lang.String java.lang.StringBuilder ), ()Ljava/lang/Object;)((String)text, (StringBuilder)sb));
            }
            catch (Exception e) {
                StanfordModelBuilder.logger.error("error with " + expression, (Throwable)e);
            }
        }
        v8 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"toString(...)");
        return v8;
    }

    @NotNull
    public NlpApplicationConfiguration defaultNlpApplicationConfiguration() {
        return NlpEngineModelBuilder.DefaultImpls.defaultNlpApplicationConfiguration((NlpEngineModelBuilder)this);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object buildEntityModel$lambda$2(String $trainingData) {
        Intrinsics.checkNotNullParameter((Object)$trainingData, (String)"$trainingData");
        return "error with train data: \n " + $trainingData;
    }

    private static final Object getEntityTrainData$lambda$10$lambda$3(String $text) {
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        return "expression " + $text + " contains \\n or \\t!!! - skipped";
    }

    private static final Object getEntityTrainData$lambda$10$lambda$5$lambda$4(String $text) {
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        return "entity mismatch for " + $text;
    }

    private static final Object getEntityTrainData$lambda$10$lambda$9(String $text, StringBuilder $sb) {
        Intrinsics.checkNotNullParameter((Object)$text, (String)"$text");
        Intrinsics.checkNotNullParameter((Object)$sb, (String)"$sb");
        return $text + " ->\n" + $sb;
    }
}

