/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.stanford;

import ai.tock.nlp.model.service.engine.NlpEngineModelIo;
import ai.tock.nlp.model.service.storage.NlpModelStream;
import ai.tock.nlp.stanford.StanfordIntentModel;
import ai.tock.nlp.stanford.StanfordModelBuilder;
import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.ColumnDataClassifier;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import java.io.Closeable;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lai/tock/nlp/stanford/StanfordModelIo;", "Lai/tock/nlp/model/service/engine/NlpEngineModelIo;", "<init>", "()V", "loadTokenizerModel", "", "input", "Lai/tock/nlp/model/service/storage/NlpModelStream;", "loadIntentModel", "loadEntityModel", "copyTokenizerModel", "", "model", "output", "Ljava/io/OutputStream;", "copyIntentModel", "copyEntityModel", "tock-nlp-model-stanford"})
@SourceDebugExtension(value={"SMAP\nStanfordModelIo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StanfordModelIo.kt\nai/tock/nlp/stanford/StanfordModelIo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public final class StanfordModelIo
implements NlpEngineModelIo {
    @NotNull
    public static final StanfordModelIo INSTANCE = new StanfordModelIo();

    private StanfordModelIo() {
    }

    @NotNull
    public Object loadTokenizerModel(@NotNull NlpModelStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        throw new IllegalStateException("loading tokenizer model is not supported".toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Object loadIntentModel(@NotNull NlpModelStream input) {
        StanfordIntentModel stanfordIntentModel;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Closeable closeable = new ObjectInputStream(input.getInputStream());
        Throwable throwable = null;
        try {
            ObjectInputStream it = (ObjectInputStream)closeable;
            boolean bl = false;
            Object object = it.readObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type edu.stanford.nlp.classify.Classifier<kotlin.String, kotlin.String>");
            Classifier classifier = (Classifier)object;
            Object object2 = input.getConfiguration();
            if (object2 == null || (object2 = object2.getIntentConfiguration()) == null || (object2 = object2.getProperties()) == null) {
                object2 = StanfordModelBuilder.INSTANCE.getDefaultIntentClassifierConfiguration().getProperties();
            }
            stanfordIntentModel = new StanfordIntentModel(new ColumnDataClassifier((Properties)object2), (Classifier<String, String>)classifier);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return stanfordIntentModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Object loadEntityModel(@NotNull NlpModelStream input) {
        CRFClassifier cRFClassifier;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Closeable closeable = input.getInputStream();
        Throwable throwable = null;
        try {
            CRFClassifier cRFClassifier2;
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            Object object = input.getConfiguration();
            if (object == null || (object = object.getEntityConfiguration()) == null || (object = object.getProperties()) == null) {
                object = StanfordModelBuilder.INSTANCE.getDefaultEntityClassifierConfiguration().getProperties();
            }
            CRFClassifier $this$loadEntityModel_u24lambda_u242_u24lambda_u241 = cRFClassifier2 = new CRFClassifier((Properties)object);
            boolean bl2 = false;
            $this$loadEntityModel_u24lambda_u242_u24lambda_u241.loadClassifier(stream);
            cRFClassifier = cRFClassifier2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return cRFClassifier;
    }

    public void copyTokenizerModel(@NotNull Object model, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        throw new IllegalStateException("copying tokenizer model is not supported".toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyIntentModel(@NotNull Object model, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        StanfordIntentModel stanfordModel = (StanfordIntentModel)model;
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(output);
        Closeable closeable = objectOutputStream;
        Throwable throwable = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)closeable;
            boolean bl = false;
            objectOutputStream.writeObject(stanfordModel.getClassifier());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyEntityModel(@NotNull Object model, @NotNull OutputStream output) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        CRFClassifier crfClassifier = (CRFClassifier)model;
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(output);
        Closeable closeable = objectOutputStream;
        Throwable throwable = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)closeable;
            boolean bl = false;
            crfClassifier.serializeClassifier(objectOutputStream);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

