/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.model.service.storage.mongo;

import ai.tock.nlp.core.NlpEngineType;
import ai.tock.nlp.core.configuration.NlpApplicationConfiguration;
import ai.tock.nlp.model.service.storage.NlpApplicationConfigurationDAO;
import ai.tock.nlp.model.service.storage.mongo.MongoModelConfiguration;
import ai.tock.nlp.model.service.storage.mongo.NlpApplicationConfigurationCol_;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.collections.KMongoIterableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.FindIterablesKt;
import org.litote.kmongo.MongoCollectionsKt;
import org.litote.kmongo.SortsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0007H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lai/tock/nlp/model/service/storage/mongo/NlpApplicationConfigurationMongoDAO;", "Lai/tock/nlp/model/service/storage/NlpApplicationConfigurationDAO;", "()V", "col", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/nlp/model/service/storage/mongo/NlpApplicationConfigurationMongoDAO$NlpApplicationConfigurationCol;", "loadLastConfiguration", "Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;", "applicationName", "", "engineType", "Lai/tock/nlp/core/NlpEngineType;", "updated", "Ljava/time/Instant;", "saveNewConfiguration", "", "configuration", "NlpApplicationConfigurationCol", "tock-nlp-model-storage-mongo"})
public final class NlpApplicationConfigurationMongoDAO
implements NlpApplicationConfigurationDAO {
    private static final MongoCollection<NlpApplicationConfigurationCol> col;
    public static final NlpApplicationConfigurationMongoDAO INSTANCE;

    public void saveNewConfiguration(@NotNull String applicationName, @NotNull NlpEngineType engineType, @NotNull NlpApplicationConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)applicationName, (String)"applicationName");
        Intrinsics.checkParameterIsNotNull((Object)engineType, (String)"engineType");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        col.insertOne((Object)new NlpApplicationConfigurationCol(applicationName, engineType, configuration, null, 8, null));
    }

    @Nullable
    public NlpApplicationConfiguration loadLastConfiguration(@NotNull String applicationName, @NotNull NlpEngineType engineType, @NotNull Instant updated) {
        Intrinsics.checkParameterIsNotNull((Object)applicationName, (String)"applicationName");
        Intrinsics.checkParameterIsNotNull((Object)engineType, (String)"engineType");
        Intrinsics.checkParameterIsNotNull((Object)updated, (String)"updated");
        FindIterable findIterable = FindIterablesKt.descendingSort((FindIterable)MongoCollectionsKt.find(col, (Bson[])new Bson[]{FiltersKt.eq((KProperty)((KProperty)NlpApplicationConfigurationCol_.Companion.getApplicationName()), (Object)applicationName), FiltersKt.eq((KProperty)((KProperty)NlpApplicationConfigurationCol_.Companion.getEngineType()), (Object)engineType), FiltersKt.lt((KProperty)((KProperty)NlpApplicationConfigurationCol_.Companion.getDate()), (Object)updated)}), (KProperty[])new KProperty[]{(KProperty)NlpApplicationConfigurationCol_.Companion.getDate()}).limit(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)findIterable, (String)"col\n            .find(Ap\u2026te)\n            .limit(1)");
        NlpApplicationConfigurationCol nlpApplicationConfigurationCol = (NlpApplicationConfigurationCol)KMongoIterableKt.firstOrNull((MongoIterable)((MongoIterable)findIterable));
        return nlpApplicationConfigurationCol != null ? nlpApplicationConfigurationCol.getConfiguration() : null;
    }

    private NlpApplicationConfigurationMongoDAO() {
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$getCollection$iv;
        NlpApplicationConfigurationMongoDAO nlpApplicationConfigurationMongoDAO;
        INSTANCE = nlpApplicationConfigurationMongoDAO = new NlpApplicationConfigurationMongoDAO();
        MongoDatabase mongoDatabase = MongoModelConfiguration.INSTANCE.getDatabase();
        String collectionName$iv = "nlp_application_configuration";
        boolean $i$f$getCollection = false;
        void $this$getCollectionOfName$iv$iv = $this$getCollection$iv;
        boolean $i$f$getCollectionOfName = false;
        MongoCollection mongoCollection = $this$getCollectionOfName$iv$iv.getCollection(collectionName$iv, NlpApplicationConfigurationCol.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)mongoCollection, (String)"getCollection(collectionName, T::class.java)");
        mongoDatabase = mongoCollection;
        boolean bl = false;
        boolean bl2 = false;
        MongoDatabase $this$apply = mongoDatabase;
        boolean bl3 = false;
        MongoCollectionsKt.ensureIndex$default((MongoCollection)$this$apply, (Bson)SortsKt.descending((KProperty[])new KProperty[]{(KProperty)NlpApplicationConfigurationCol_.Companion.getApplicationName(), (KProperty)NlpApplicationConfigurationCol_.Companion.getEngineType(), (KProperty)NlpApplicationConfigurationCol_.Companion.getDate()}), null, (int)2, null);
        col = mongoDatabase;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lai/tock/nlp/model/service/storage/mongo/NlpApplicationConfigurationMongoDAO$NlpApplicationConfigurationCol;", "", "applicationName", "", "engineType", "Lai/tock/nlp/core/NlpEngineType;", "configuration", "Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;", "date", "Ljava/time/Instant;", "(Ljava/lang/String;Lai/tock/nlp/core/NlpEngineType;Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;Ljava/time/Instant;)V", "getApplicationName", "()Ljava/lang/String;", "getConfiguration", "()Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;", "getDate", "()Ljava/time/Instant;", "getEngineType", "()Lai/tock/nlp/core/NlpEngineType;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "tock-nlp-model-storage-mongo"})
    public static final class NlpApplicationConfigurationCol {
        @NotNull
        private final String applicationName;
        @NotNull
        private final NlpEngineType engineType;
        @NotNull
        private final NlpApplicationConfiguration configuration;
        @NotNull
        private final Instant date;

        @NotNull
        public final String getApplicationName() {
            return this.applicationName;
        }

        @NotNull
        public final NlpEngineType getEngineType() {
            return this.engineType;
        }

        @NotNull
        public final NlpApplicationConfiguration getConfiguration() {
            return this.configuration;
        }

        @NotNull
        public final Instant getDate() {
            return this.date;
        }

        public NlpApplicationConfigurationCol(@NotNull String applicationName, @NotNull NlpEngineType engineType, @NotNull NlpApplicationConfiguration configuration, @NotNull Instant date) {
            Intrinsics.checkParameterIsNotNull((Object)applicationName, (String)"applicationName");
            Intrinsics.checkParameterIsNotNull((Object)engineType, (String)"engineType");
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            this.applicationName = applicationName;
            this.engineType = engineType;
            this.configuration = configuration;
            this.date = date;
        }

        public /* synthetic */ NlpApplicationConfigurationCol(String string, NlpEngineType nlpEngineType, NlpApplicationConfiguration nlpApplicationConfiguration, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                Instant instant2 = Instant.now();
                Intrinsics.checkExpressionValueIsNotNull((Object)instant2, (String)"now()");
                instant = instant2;
            }
            this(string, nlpEngineType, nlpApplicationConfiguration, instant);
        }

        @NotNull
        public final String component1() {
            return this.applicationName;
        }

        @NotNull
        public final NlpEngineType component2() {
            return this.engineType;
        }

        @NotNull
        public final NlpApplicationConfiguration component3() {
            return this.configuration;
        }

        @NotNull
        public final Instant component4() {
            return this.date;
        }

        @NotNull
        public final NlpApplicationConfigurationCol copy(@NotNull String applicationName, @NotNull NlpEngineType engineType, @NotNull NlpApplicationConfiguration configuration, @NotNull Instant date) {
            Intrinsics.checkParameterIsNotNull((Object)applicationName, (String)"applicationName");
            Intrinsics.checkParameterIsNotNull((Object)engineType, (String)"engineType");
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            return new NlpApplicationConfigurationCol(applicationName, engineType, configuration, date);
        }

        public static /* synthetic */ NlpApplicationConfigurationCol copy$default(NlpApplicationConfigurationCol nlpApplicationConfigurationCol, String string, NlpEngineType nlpEngineType, NlpApplicationConfiguration nlpApplicationConfiguration, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                string = nlpApplicationConfigurationCol.applicationName;
            }
            if ((n & 2) != 0) {
                nlpEngineType = nlpApplicationConfigurationCol.engineType;
            }
            if ((n & 4) != 0) {
                nlpApplicationConfiguration = nlpApplicationConfigurationCol.configuration;
            }
            if ((n & 8) != 0) {
                instant = nlpApplicationConfigurationCol.date;
            }
            return nlpApplicationConfigurationCol.copy(string, nlpEngineType, nlpApplicationConfiguration, instant);
        }

        @NotNull
        public String toString() {
            return "NlpApplicationConfigurationCol(applicationName=" + this.applicationName + ", engineType=" + this.engineType + ", configuration=" + this.configuration + ", date=" + this.date + ")";
        }

        public int hashCode() {
            String string = this.applicationName;
            NlpEngineType nlpEngineType = this.engineType;
            NlpApplicationConfiguration nlpApplicationConfiguration = this.configuration;
            Instant instant = this.date;
            return (((string != null ? string.hashCode() : 0) * 31 + (nlpEngineType != null ? nlpEngineType.hashCode() : 0)) * 31 + (nlpApplicationConfiguration != null ? nlpApplicationConfiguration.hashCode() : 0)) * 31 + (instant != null ? ((Object)instant).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof NlpApplicationConfigurationCol)) break block3;
                    NlpApplicationConfigurationCol nlpApplicationConfigurationCol = (NlpApplicationConfigurationCol)object;
                    if (!Intrinsics.areEqual((Object)this.applicationName, (Object)nlpApplicationConfigurationCol.applicationName) || !Intrinsics.areEqual((Object)this.engineType, (Object)nlpApplicationConfigurationCol.engineType) || !Intrinsics.areEqual((Object)this.configuration, (Object)nlpApplicationConfigurationCol.configuration) || !Intrinsics.areEqual((Object)this.date, (Object)nlpApplicationConfigurationCol.date)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

