/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.model.service.storage.mongo;

import ai.tock.nlp.model.ClassifierContextKey;
import ai.tock.nlp.model.EntityContextKey;
import ai.tock.nlp.model.IntentContext;
import ai.tock.nlp.model.service.storage.NlpEngineModelDAO;
import ai.tock.nlp.model.service.storage.NlpModelStream;
import ai.tock.nlp.model.service.storage.mongo.MongoModelConfiguration;
import ai.tock.nlp.model.service.storage.mongo.NlpApplicationConfigurationMongoDAO;
import ai.tock.nlp.model.service.storage.mongo.NlpEngineModelMongoDAO;
import ai.tock.nlp.model.service.storage.mongo.NlpEngineModelMongoDAO$listenEntityModelChanges$;
import ai.tock.nlp.model.service.storage.mongo.NlpEngineModelMongoDAO$listenIntentModelChanges$;
import ai.tock.nlp.model.service.storage.mongo.NlpEngineModelMongoDAO$saveModel$;
import com.mongodb.MongoGridFSException;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.MongoCollection;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.reactivestreams.MongoSharedCollectionsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0019H\u0016J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u001fH\u0002J\u001e\u0010 \u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\t2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0019H\u0002J\u001a\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u001fH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u001fH\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010$2\u0006\u0010\u0015\u001a\u00020\u001bH\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010&2\u0006\u0010\u0015\u001a\u00020\u001bH\u0016J\u001a\u0010+\u001a\u0004\u0018\u00010&2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u001fH\u0002J\u001a\u0010,\u001a\u0004\u0018\u00010$2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u001fH\u0002J\u001c\u0010-\u001a\u00020\u00142\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00140/H\u0016J\u001c\u00101\u001a\u00020\u00142\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00140/H\u0016J\u0018\u00102\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u00103\u001a\u000204H\u0016J\u0018\u00105\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001b2\u0006\u00103\u001a\u000204H\u0016J \u00106\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u001f2\u0006\u00103\u001a\u000204H\u0002J\u000e\u00107\u001a\u0004\u0018\u000100*\u00020\u001fH\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u000f\u0010\u000bR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lai/tock/nlp/model/service/storage/mongo/NlpEngineModelMongoDAO;", "Lai/tock/nlp/model/service/storage/NlpEngineModelDAO;", "()V", "asyncEntityCol", "Lcom/mongodb/reactivestreams/client/MongoCollection;", "Lorg/bson/Document;", "kotlin.jvm.PlatformType", "asyncIntentCol", "entityBucket", "Lcom/mongodb/client/gridfs/GridFSBucket;", "getEntityBucket", "()Lcom/mongodb/client/gridfs/GridFSBucket;", "entityBucket$delegate", "Lkotlin/Lazy;", "intentBucket", "getIntentBucket", "intentBucket$delegate", "logger", "Lmu/KLogger;", "deleteEntityModel", "", "key", "Lai/tock/nlp/model/EntityContextKey;", "deleteEntityModelsNotIn", "keys", "", "deleteIntentModel", "Lai/tock/nlp/model/IntentContext$IntentContextKey;", "deleteIntentModelsNotIn", "deleteModel", "bucket", "Lai/tock/nlp/model/ClassifierContextKey;", "deleteModelNotIn", "getDownloadStream", "Lcom/mongodb/client/gridfs/GridFSDownloadStream;", "getEntityModelInputStream", "Lai/tock/nlp/model/service/storage/NlpModelStream;", "getEntityModelLastUpdate", "Ljava/time/Instant;", "getGridFSFile", "Lcom/mongodb/client/gridfs/model/GridFSFile;", "getIntentModelInputStream", "getIntentModelLastUpdate", "getLastUpdate", "getModelInputStream", "listenEntityModelChanges", "listener", "Lkotlin/Function1;", "", "listenIntentModelChanges", "saveEntityModel", "stream", "Ljava/io/InputStream;", "saveIntentModel", "saveModel", "idWithoutNamespace", "tock-nlp-model-storage-mongo"})
public final class NlpEngineModelMongoDAO
implements NlpEngineModelDAO {
    private static final KLogger logger;
    private static final Lazy entityBucket$delegate;
    private static final Lazy intentBucket$delegate;
    private static final MongoCollection<Document> asyncEntityCol;
    private static final MongoCollection<Document> asyncIntentCol;
    public static final NlpEngineModelMongoDAO INSTANCE;

    private final GridFSBucket getEntityBucket() {
        Lazy lazy = entityBucket$delegate;
        NlpEngineModelMongoDAO nlpEngineModelMongoDAO = this;
        Object var3_3 = null;
        boolean bl = false;
        return (GridFSBucket)lazy.getValue();
    }

    private final GridFSBucket getIntentBucket() {
        Lazy lazy = intentBucket$delegate;
        NlpEngineModelMongoDAO nlpEngineModelMongoDAO = this;
        Object var3_3 = null;
        boolean bl = false;
        return (GridFSBucket)lazy.getValue();
    }

    private final String idWithoutNamespace(ClassifierContextKey $this$idWithoutNamespace) {
        String string;
        String string2 = $this$idWithoutNamespace.id();
        boolean bl = false;
        boolean bl2 = false;
        String $this$run = string2;
        boolean bl3 = false;
        int i = StringsKt.indexOf$default((CharSequence)$this$run, (String)":", (int)0, (boolean)false, (int)6, null);
        int i2 = StringsKt.indexOf$default((CharSequence)$this$run, (String)"-", (int)0, (boolean)false, (int)6, null);
        if (i != -1 && i2 > i) {
            String string3 = $this$run;
            int n = i + 1;
            boolean bl4 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = null;
        }
        return string;
    }

    private final GridFSFile getGridFSFile(GridFSBucket bucket, ClassifierContextKey key) {
        Object object;
        try {
            GridFSFile gridFSFile = (GridFSFile)bucket.find(Filters.eq((String)"filename", (Object)key.id())).limit(1).first();
            if (gridFSFile == null) {
                String string = this.idWithoutNamespace(key);
                if (string != null) {
                    object = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object;
                    boolean bl3 = false;
                    gridFSFile = (GridFSFile)bucket.find(Filters.eq((String)"filename", (Object)it)).limit(1).first();
                } else {
                    gridFSFile = null;
                }
            }
            object = gridFSFile;
        }
        catch (MongoGridFSException e) {
            logger.debug((Throwable)e, (Function0)new Function0<Object>(key){
                final /* synthetic */ ClassifierContextKey $key;

                @Nullable
                public final Object invoke() {
                    return "no model exists for " + this.$key;
                }
                {
                    this.$key = classifierContextKey;
                    super(0);
                }
            });
            object = null;
        }
        return object;
    }

    private final GridFSDownloadStream getDownloadStream(GridFSBucket bucket, ClassifierContextKey key) {
        GridFSDownloadStream gridFSDownloadStream;
        Object it;
        boolean bl;
        boolean bl2;
        Object object;
        GridFSFile gridFSFile = this.getGridFSFile(bucket, key);
        if (gridFSFile == null) {
            String string = this.idWithoutNamespace(key);
            if (string != null) {
                object = string;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl3 = false;
                gridFSFile = INSTANCE.getGridFSFile(bucket, key);
            } else {
                gridFSFile = null;
            }
        }
        if (gridFSFile != null) {
            object = gridFSFile;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl4 = false;
            gridFSDownloadStream = bucket.openDownloadStream(it.getId());
        } else {
            gridFSDownloadStream = null;
        }
        return gridFSDownloadStream;
    }

    private final void saveModel(GridFSBucket bucket, ClassifierContextKey key, InputStream stream) {
        String filename = key.id();
        ObjectId newId = bucket.uploadFromStream(filename, stream);
        GridFSFindIterable gridFSFindIterable = bucket.find(Filters.and((Bson[])new Bson[]{Filters.ne((String)"_id", (Object)newId), Filters.eq((String)"filename", (Object)filename)}));
        Intrinsics.checkNotNullExpressionValue((Object)gridFSFindIterable, (String)"bucket.find(and(ne(\"_id\"\u2026q(\"filename\", filename)))");
        MongoIterable $this$forEach$iv = (MongoIterable)gridFSFindIterable;
        boolean $i$f$forEach = false;
        $this$forEach$iv.forEach(new Consumer<T>(key, bucket){
            final /* synthetic */ ClassifierContextKey $key$inlined;
            final /* synthetic */ GridFSBucket $bucket$inlined;
            {
                this.$key$inlined = classifierContextKey;
                this.$bucket$inlined = gridFSBucket;
            }

            public final void accept(T it) {
                GridFSFile it2 = (GridFSFile)it;
                boolean bl = false;
                NlpEngineModelMongoDAO.access$getLogger$p(NlpEngineModelMongoDAO.INSTANCE).debug((Function0)new Function0<Object>(it2, this){
                    final /* synthetic */ GridFSFile $it;
                    final /* synthetic */ saveModel$$inlined$forEach$1 this$0;
                    {
                        this.$it = gridFSFile;
                        this.this$0 = var2_2;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        StringBuilder stringBuilder = new StringBuilder().append("Remove file ");
                        GridFSFile gridFSFile = this.$it;
                        Intrinsics.checkNotNullExpressionValue((Object)gridFSFile, (String)"it");
                        return stringBuilder.append(gridFSFile.getObjectId()).append(" for ").append(this.this$0.$key$inlined).toString();
                    }
                });
                GridFSFile gridFSFile = it2;
                Intrinsics.checkNotNullExpressionValue((Object)gridFSFile, (String)"it");
                this.$bucket$inlined.delete(gridFSFile.getObjectId());
            }
        });
    }

    private final void deleteModel(GridFSBucket bucket, ClassifierContextKey key) {
        block0: {
            GridFSFile gridFSFile = (GridFSFile)bucket.find(Filters.eq((String)"filename", (Object)key.id())).limit(1).first();
            if (gridFSFile == null) break block0;
            GridFSFile gridFSFile2 = gridFSFile;
            boolean bl = false;
            boolean bl2 = false;
            GridFSFile $this$apply = gridFSFile2;
            boolean bl3 = false;
            logger.debug((Function0)new Function0<Object>($this$apply, key, bucket){
                final /* synthetic */ GridFSFile $this_apply;
                final /* synthetic */ ClassifierContextKey $key$inlined;
                final /* synthetic */ GridFSBucket $bucket$inlined;
                {
                    this.$this_apply = gridFSFile;
                    this.$key$inlined = classifierContextKey;
                    this.$bucket$inlined = gridFSBucket;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Remove file " + this.$this_apply.getObjectId() + " for " + this.$key$inlined;
                }
            });
            bucket.delete($this$apply.getObjectId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteModelNotIn(GridFSBucket bucket, List<? extends ClassifierContextKey> keys) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = keys;
        String string = "filename";
        GridFSBucket gridFSBucket = bucket;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClassifierContextKey classifierContextKey = (ClassifierContextKey)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.id();
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        GridFSFindIterable gridFSFindIterable = gridFSBucket.find(Filters.not((Bson)Filters.in((String)string, (Iterable)collection)));
        Intrinsics.checkNotNullExpressionValue((Object)gridFSFindIterable, (String)"bucket.find(Filters.not(\u2026, keys.map { it.id() })))");
        MongoIterable $this$forEach$iv = (MongoIterable)gridFSFindIterable;
        boolean $i$f$forEach = false;
        $this$forEach$iv.forEach(new Consumer<T>(bucket){
            final /* synthetic */ GridFSBucket $bucket$inlined;
            {
                this.$bucket$inlined = gridFSBucket;
            }

            public final void accept(T it) {
                GridFSFile it2 = (GridFSFile)it;
                boolean bl = false;
                NlpEngineModelMongoDAO.access$getLogger$p(NlpEngineModelMongoDAO.INSTANCE).debug((Function0)new Function0<Object>(it2){
                    final /* synthetic */ GridFSFile $it;
                    {
                        this.$it = gridFSFile;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        StringBuilder stringBuilder = new StringBuilder().append("Remove file ");
                        GridFSFile gridFSFile = this.$it;
                        Intrinsics.checkNotNullExpressionValue((Object)gridFSFile, (String)"it");
                        StringBuilder stringBuilder2 = stringBuilder.append(gridFSFile.getObjectId()).append(" for ");
                        GridFSFile gridFSFile2 = this.$it;
                        Intrinsics.checkNotNullExpressionValue((Object)gridFSFile2, (String)"it");
                        return stringBuilder2.append(gridFSFile2.getFilename()).toString();
                    }
                });
                GridFSFile gridFSFile = it2;
                Intrinsics.checkNotNullExpressionValue((Object)gridFSFile, (String)"it");
                this.$bucket$inlined.delete(gridFSFile.getObjectId());
            }
        });
    }

    private final NlpModelStream getModelInputStream(GridFSBucket bucket, ClassifierContextKey key) {
        NlpModelStream nlpModelStream;
        GridFSDownloadStream gridFSDownloadStream = this.getDownloadStream(bucket, key);
        if (gridFSDownloadStream != null) {
            GridFSDownloadStream gridFSDownloadStream2 = gridFSDownloadStream;
            boolean bl = false;
            boolean bl2 = false;
            GridFSDownloadStream stream = gridFSDownloadStream2;
            boolean bl3 = false;
            GridFSFile gridFSFile = stream.getGridFSFile();
            Intrinsics.checkNotNullExpressionValue((Object)gridFSFile, (String)"stream.gridFSFile");
            Instant date = gridFSFile.getUploadDate().toInstant();
            InputStream inputStream = (InputStream)stream;
            Instant instant = date;
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"date");
            nlpModelStream = new NlpModelStream(inputStream, instant, NlpApplicationConfigurationMongoDAO.INSTANCE.loadLastConfiguration(key.getApplicationName(), key.getEngineType(), date));
        } else {
            nlpModelStream = null;
        }
        return nlpModelStream;
    }

    private final Instant getLastUpdate(GridFSBucket bucket, ClassifierContextKey key) {
        Object object = this.getGridFSFile(bucket, key);
        return object != null && (object = object.getUploadDate()) != null ? ((Date)object).toInstant() : null;
    }

    @Nullable
    public NlpModelStream getEntityModelInputStream(@NotNull EntityContextKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getModelInputStream(this.getEntityBucket(), (ClassifierContextKey)key);
    }

    public void saveEntityModel(@NotNull EntityContextKey key, @NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.saveModel(this.getEntityBucket(), (ClassifierContextKey)key, stream);
    }

    @Nullable
    public Instant getEntityModelLastUpdate(@NotNull EntityContextKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getLastUpdate(this.getEntityBucket(), (ClassifierContextKey)key);
    }

    public void deleteEntityModelsNotIn(@NotNull List<EntityContextKey> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        this.deleteModelNotIn(this.getEntityBucket(), keys);
    }

    public void deleteEntityModel(@NotNull EntityContextKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.deleteModel(this.getEntityBucket(), (ClassifierContextKey)key);
    }

    @Nullable
    public NlpModelStream getIntentModelInputStream(@NotNull IntentContext.IntentContextKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getModelInputStream(this.getIntentBucket(), (ClassifierContextKey)key);
    }

    public void saveIntentModel(@NotNull IntentContext.IntentContextKey key, @NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.saveModel(this.getIntentBucket(), (ClassifierContextKey)key, stream);
    }

    @Nullable
    public Instant getIntentModelLastUpdate(@NotNull IntentContext.IntentContextKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getLastUpdate(this.getIntentBucket(), (ClassifierContextKey)key);
    }

    public void deleteIntentModelsNotIn(@NotNull List<IntentContext.IntentContextKey> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        this.deleteModelNotIn(this.getIntentBucket(), keys);
    }

    public void deleteIntentModel(@NotNull IntentContext.IntentContextKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.deleteModel(this.getIntentBucket(), (ClassifierContextKey)key);
    }

    /*
     * WARNING - void declaration
     */
    public void listenEntityModelChanges(@NotNull Function1<? super String, Unit> listener) {
        void reopenListener$iv$iv;
        void errorListener$iv$iv;
        void subscribeListener$iv$iv;
        void fullDocument$iv;
        void $this$watchIndefinitely$iv$iv;
        void $this$watch$iv;
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        MongoCollection<Document> mongoCollection = asyncEntityCol;
        Intrinsics.checkNotNullExpressionValue(mongoCollection, (String)"asyncEntityCol");
        MongoCollection<Document> mongoCollection2 = mongoCollection;
        FullDocument fullDocument = FullDocument.UPDATE_LOOKUP;
        Function1 listener$iv = (Function1)new Function1<ChangeStreamDocument<Document>, Unit>(listener){
            final /* synthetic */ Function1 $listener;

            public final void invoke(@NotNull ChangeStreamDocument<Document> it) {
                String id;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Document document = (Document)it.getFullDocument();
                Object object = document != null ? document.get((Object)"filename") : null;
                if (!(object instanceof String)) {
                    object = null;
                }
                if ((id = (String)object) != null) {
                    this.$listener.invoke((Object)id);
                }
            }
            {
                this.$listener = function1;
                super(1);
            }
        };
        boolean $i$f$watch = false;
        void var6_6 = $this$watch$iv;
        Function0 function0 = listenEntityModelChanges$$inlined$watch$1.INSTANCE;
        Function1 function1 = listenEntityModelChanges$$inlined$watch$2.INSTANCE;
        Function0 function02 = listenEntityModelChanges$$inlined$watch$3.INSTANCE;
        long reopenDelayInMS$iv$iv = 5000L;
        boolean $i$f$watchIndefinitely = false;
        MongoSharedCollectionsKt.watchIndefinitely((MongoCollection)$this$watchIndefinitely$iv$iv, (Function1)((Function1)new Function1<MongoCollection<Document>, ChangeStreamPublisher<Document>>((MongoCollection)$this$watchIndefinitely$iv$iv, (FullDocument)fullDocument$iv){
            final /* synthetic */ MongoCollection $this_watchIndefinitely;
            final /* synthetic */ FullDocument $fullDocument;
            {
                this.$this_watchIndefinitely = mongoCollection;
                this.$fullDocument = fullDocument;
                super(1);
            }

            @NotNull
            public final ChangeStreamPublisher<Document> invoke(@NotNull MongoCollection<Document> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                ChangeStreamPublisher changeStreamPublisher = this.$this_watchIndefinitely.watch(Document.class).fullDocument(this.$fullDocument);
                Intrinsics.checkNotNullExpressionValue((Object)changeStreamPublisher, (String)"watch(T::class.java).fullDocument(fullDocument)");
                return changeStreamPublisher;
            }
        }), (Function0)subscribeListener$iv$iv, (Function1)errorListener$iv$iv, (Function0)reopenListener$iv$iv, (long)reopenDelayInMS$iv$iv, (Function1)listener$iv);
    }

    /*
     * WARNING - void declaration
     */
    public void listenIntentModelChanges(@NotNull Function1<? super String, Unit> listener) {
        void reopenListener$iv$iv;
        void errorListener$iv$iv;
        void subscribeListener$iv$iv;
        void fullDocument$iv;
        void $this$watchIndefinitely$iv$iv;
        void $this$watch$iv;
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        MongoCollection<Document> mongoCollection = asyncIntentCol;
        Intrinsics.checkNotNullExpressionValue(mongoCollection, (String)"asyncIntentCol");
        MongoCollection<Document> mongoCollection2 = mongoCollection;
        FullDocument fullDocument = FullDocument.UPDATE_LOOKUP;
        Function1 listener$iv = (Function1)new Function1<ChangeStreamDocument<Document>, Unit>(listener){
            final /* synthetic */ Function1 $listener;

            public final void invoke(@NotNull ChangeStreamDocument<Document> it) {
                String id;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Document document = (Document)it.getFullDocument();
                Object object = document != null ? document.get((Object)"filename") : null;
                if (!(object instanceof String)) {
                    object = null;
                }
                if ((id = (String)object) != null) {
                    this.$listener.invoke((Object)id);
                }
            }
            {
                this.$listener = function1;
                super(1);
            }
        };
        boolean $i$f$watch = false;
        void var6_6 = $this$watch$iv;
        Function0 function0 = listenIntentModelChanges$$inlined$watch$1.INSTANCE;
        Function1 function1 = listenIntentModelChanges$$inlined$watch$2.INSTANCE;
        Function0 function02 = listenIntentModelChanges$$inlined$watch$3.INSTANCE;
        long reopenDelayInMS$iv$iv = 5000L;
        boolean $i$f$watchIndefinitely = false;
        MongoSharedCollectionsKt.watchIndefinitely((MongoCollection)$this$watchIndefinitely$iv$iv, (Function1)((Function1)new Function1<MongoCollection<Document>, ChangeStreamPublisher<Document>>((MongoCollection)$this$watchIndefinitely$iv$iv, (FullDocument)fullDocument$iv){
            final /* synthetic */ MongoCollection $this_watchIndefinitely;
            final /* synthetic */ FullDocument $fullDocument;
            {
                this.$this_watchIndefinitely = mongoCollection;
                this.$fullDocument = fullDocument;
                super(1);
            }

            @NotNull
            public final ChangeStreamPublisher<Document> invoke(@NotNull MongoCollection<Document> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                ChangeStreamPublisher changeStreamPublisher = this.$this_watchIndefinitely.watch(Document.class).fullDocument(this.$fullDocument);
                Intrinsics.checkNotNullExpressionValue((Object)changeStreamPublisher, (String)"watch(T::class.java).fullDocument(fullDocument)");
                return changeStreamPublisher;
            }
        }), (Function0)subscribeListener$iv$iv, (Function1)errorListener$iv$iv, (Function0)reopenListener$iv$iv, (long)reopenDelayInMS$iv$iv, (Function1)listener$iv);
    }

    private NlpEngineModelMongoDAO() {
    }

    static {
        NlpEngineModelMongoDAO nlpEngineModelMongoDAO;
        INSTANCE = nlpEngineModelMongoDAO = new NlpEngineModelMongoDAO();
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        entityBucket$delegate = LazyKt.lazy((Function0)entityBucket.2.INSTANCE);
        intentBucket$delegate = LazyKt.lazy((Function0)intentBucket.2.INSTANCE);
        asyncEntityCol = MongoModelConfiguration.INSTANCE.getAsyncDatabase().getCollection("fs_entity.files");
        asyncIntentCol = MongoModelConfiguration.INSTANCE.getAsyncDatabase().getCollection("fs_intent.files");
    }

    public static final /* synthetic */ KLogger access$getLogger$p(NlpEngineModelMongoDAO $this) {
        NlpEngineModelMongoDAO nlpEngineModelMongoDAO = $this;
        return logger;
    }
}

