/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.model.service.storage.mongo;

import ai.tock.nlp.core.NlpEngineType;
import ai.tock.nlp.core.configuration.NlpApplicationConfiguration;
import ai.tock.nlp.model.service.storage.NlpApplicationConfigurationDAO;
import ai.tock.nlp.model.service.storage.mongo.MongoModelConfiguration;
import ai.tock.nlp.model.service.storage.mongo.NlpApplicationConfigurationCol_;
import ai.tock.shared.MongosKt;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.collections.KMongoIterableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.FiltersKt;
import org.litote.kmongo.FindIterablesKt;
import org.litote.kmongo.MongoCollectionsKt;
import org.litote.kmongo.SortsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lai/tock/nlp/model/service/storage/mongo/NlpApplicationConfigurationMongoDAO;", "Lai/tock/nlp/model/service/storage/NlpApplicationConfigurationDAO;", "<init>", "()V", "col", "Lcom/mongodb/client/MongoCollection;", "Lai/tock/nlp/model/service/storage/mongo/NlpApplicationConfigurationMongoDAO$NlpApplicationConfigurationCol;", "saveNewConfiguration", "", "applicationName", "", "engineType", "Lai/tock/nlp/core/NlpEngineType;", "configuration", "Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;", "loadLastConfiguration", "updated", "Ljava/time/Instant;", "NlpApplicationConfigurationCol", "tock-nlp-model-storage-mongo"})
@SourceDebugExtension(value={"SMAP\nNlpApplicationConfigurationMongoDAO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NlpApplicationConfigurationMongoDAO.kt\nai/tock/nlp/model/service/storage/mongo/NlpApplicationConfigurationMongoDAO\n+ 2 MongoDatabases.kt\norg/litote/kmongo/MongoDatabasesKt\n*L\n1#1,78:1\n40#2,11:79\n*S KotlinDebug\n*F\n+ 1 NlpApplicationConfigurationMongoDAO.kt\nai/tock/nlp/model/service/storage/mongo/NlpApplicationConfigurationMongoDAO\n*L\n52#1:79,11\n*E\n"})
public final class NlpApplicationConfigurationMongoDAO
implements NlpApplicationConfigurationDAO {
    @NotNull
    public static final NlpApplicationConfigurationMongoDAO INSTANCE;
    @NotNull
    private static final MongoCollection<NlpApplicationConfigurationCol> col;

    private NlpApplicationConfigurationMongoDAO() {
    }

    public void saveNewConfiguration(@NotNull String applicationName, @NotNull NlpEngineType engineType, @NotNull NlpApplicationConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        Intrinsics.checkNotNullParameter((Object)engineType, (String)"engineType");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        col.insertOne((Object)new NlpApplicationConfigurationCol(applicationName, engineType, configuration, null, 8, null));
    }

    @Nullable
    public NlpApplicationConfiguration loadLastConfiguration(@NotNull String applicationName, @NotNull NlpEngineType engineType, @NotNull Instant updated) {
        Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
        Intrinsics.checkNotNullParameter((Object)engineType, (String)"engineType");
        Intrinsics.checkNotNullParameter((Object)updated, (String)"updated");
        Bson[] bsonArray = new Bson[]{FiltersKt.eq((KProperty)((KProperty)NlpApplicationConfigurationCol_.Companion.getApplicationName()), (Object)applicationName), FiltersKt.eq((KProperty)((KProperty)NlpApplicationConfigurationCol_.Companion.getEngineType()), (Object)engineType), FiltersKt.lt((KProperty)((KProperty)NlpApplicationConfigurationCol_.Companion.getDate()), (Object)updated)};
        FindIterable findIterable = MongoCollectionsKt.find(col, (Bson[])bsonArray);
        bsonArray = new KProperty[]{NlpApplicationConfigurationCol_.Companion.getDate()};
        FindIterable findIterable2 = FindIterablesKt.descendingSort((FindIterable)findIterable, (KProperty[])bsonArray).limit(1);
        Intrinsics.checkNotNullExpressionValue((Object)findIterable2, (String)"limit(...)");
        NlpApplicationConfigurationCol nlpApplicationConfigurationCol = (NlpApplicationConfigurationCol)KMongoIterableKt.firstOrNull((MongoIterable)((MongoIterable)findIterable2));
        return nlpApplicationConfigurationCol != null ? nlpApplicationConfigurationCol.getConfiguration() : null;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$getCollection$iv;
        INSTANCE = new NlpApplicationConfigurationMongoDAO();
        MongoDatabase mongoDatabase = MongoModelConfiguration.INSTANCE.getDatabase();
        String collectionName$iv = "nlp_application_configuration";
        boolean $i$f$getCollection = false;
        void $this$getCollectionOfName$iv$iv = $this$getCollection$iv;
        boolean $i$f$getCollectionOfName = false;
        MongoCollection mongoCollection = $this$getCollectionOfName$iv$iv.getCollection(collectionName$iv, NlpApplicationConfigurationCol.class);
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        MongoDatabase $this$col_u24lambda_u240 = mongoDatabase = mongoCollection;
        boolean bl = false;
        KProperty[] kPropertyArray = new KProperty[]{NlpApplicationConfigurationCol_.Companion.getApplicationName(), NlpApplicationConfigurationCol_.Companion.getEngineType(), NlpApplicationConfigurationCol_.Companion.getDate()};
        MongosKt.ensureIndex$default((MongoCollection)$this$col_u24lambda_u240, (Bson)SortsKt.descending((KProperty[])kPropertyArray), null, (int)2, null);
        col = mongoDatabase;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lai/tock/nlp/model/service/storage/mongo/NlpApplicationConfigurationMongoDAO$NlpApplicationConfigurationCol;", "", "applicationName", "", "engineType", "Lai/tock/nlp/core/NlpEngineType;", "configuration", "Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;", "date", "Ljava/time/Instant;", "<init>", "(Ljava/lang/String;Lai/tock/nlp/core/NlpEngineType;Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;Ljava/time/Instant;)V", "getApplicationName", "()Ljava/lang/String;", "getEngineType", "()Lai/tock/nlp/core/NlpEngineType;", "getConfiguration", "()Lai/tock/nlp/core/configuration/NlpApplicationConfiguration;", "getDate", "()Ljava/time/Instant;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "tock-nlp-model-storage-mongo"})
    public static final class NlpApplicationConfigurationCol {
        @NotNull
        private final String applicationName;
        @NotNull
        private final NlpEngineType engineType;
        @NotNull
        private final NlpApplicationConfiguration configuration;
        @NotNull
        private final Instant date;

        public NlpApplicationConfigurationCol(@NotNull String applicationName, @NotNull NlpEngineType engineType, @NotNull NlpApplicationConfiguration configuration, @NotNull Instant date) {
            Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
            Intrinsics.checkNotNullParameter((Object)engineType, (String)"engineType");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            this.applicationName = applicationName;
            this.engineType = engineType;
            this.configuration = configuration;
            this.date = date;
        }

        public /* synthetic */ NlpApplicationConfigurationCol(String string, NlpEngineType nlpEngineType, NlpApplicationConfiguration nlpApplicationConfiguration, Instant instant, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                instant = Instant.now();
            }
            this(string, nlpEngineType, nlpApplicationConfiguration, instant);
        }

        @NotNull
        public final String getApplicationName() {
            return this.applicationName;
        }

        @NotNull
        public final NlpEngineType getEngineType() {
            return this.engineType;
        }

        @NotNull
        public final NlpApplicationConfiguration getConfiguration() {
            return this.configuration;
        }

        @NotNull
        public final Instant getDate() {
            return this.date;
        }

        @NotNull
        public final String component1() {
            return this.applicationName;
        }

        @NotNull
        public final NlpEngineType component2() {
            return this.engineType;
        }

        @NotNull
        public final NlpApplicationConfiguration component3() {
            return this.configuration;
        }

        @NotNull
        public final Instant component4() {
            return this.date;
        }

        @NotNull
        public final NlpApplicationConfigurationCol copy(@NotNull String applicationName, @NotNull NlpEngineType engineType, @NotNull NlpApplicationConfiguration configuration, @NotNull Instant date) {
            Intrinsics.checkNotNullParameter((Object)applicationName, (String)"applicationName");
            Intrinsics.checkNotNullParameter((Object)engineType, (String)"engineType");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            return new NlpApplicationConfigurationCol(applicationName, engineType, configuration, date);
        }

        public static /* synthetic */ NlpApplicationConfigurationCol copy$default(NlpApplicationConfigurationCol nlpApplicationConfigurationCol, String string, NlpEngineType nlpEngineType, NlpApplicationConfiguration nlpApplicationConfiguration, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                string = nlpApplicationConfigurationCol.applicationName;
            }
            if ((n & 2) != 0) {
                nlpEngineType = nlpApplicationConfigurationCol.engineType;
            }
            if ((n & 4) != 0) {
                nlpApplicationConfiguration = nlpApplicationConfigurationCol.configuration;
            }
            if ((n & 8) != 0) {
                instant = nlpApplicationConfigurationCol.date;
            }
            return nlpApplicationConfigurationCol.copy(string, nlpEngineType, nlpApplicationConfiguration, instant);
        }

        @NotNull
        public String toString() {
            return "NlpApplicationConfigurationCol(applicationName=" + this.applicationName + ", engineType=" + this.engineType + ", configuration=" + this.configuration + ", date=" + this.date + ")";
        }

        public int hashCode() {
            int result = this.applicationName.hashCode();
            result = result * 31 + this.engineType.hashCode();
            result = result * 31 + this.configuration.hashCode();
            result = result * 31 + this.date.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NlpApplicationConfigurationCol)) {
                return false;
            }
            NlpApplicationConfigurationCol nlpApplicationConfigurationCol = (NlpApplicationConfigurationCol)other;
            if (!Intrinsics.areEqual((Object)this.applicationName, (Object)nlpApplicationConfigurationCol.applicationName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.engineType, (Object)nlpApplicationConfigurationCol.engineType)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.configuration, (Object)nlpApplicationConfigurationCol.configuration)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.date, (Object)nlpApplicationConfigurationCol.date);
        }
    }
}

