/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.nlp.model.service.storage.mongo;

import ai.tock.nlp.model.ClassifierContextKey;
import ai.tock.nlp.model.EntityContextKey;
import ai.tock.nlp.model.IntentContext;
import ai.tock.nlp.model.service.storage.NlpEngineModelDAO;
import ai.tock.nlp.model.service.storage.NlpModelStream;
import ai.tock.nlp.model.service.storage.mongo.MongoModelConfiguration;
import ai.tock.nlp.model.service.storage.mongo.NlpApplicationConfigurationMongoDAO;
import ai.tock.nlp.model.service.storage.mongo.NlpEngineModelMongoDAO$listenEntityModelChanges$;
import ai.tock.nlp.model.service.storage.mongo.NlpEngineModelMongoDAO$listenIntentModelChanges$;
import ai.tock.shared.MongosKt;
import com.mongodb.MongoGridFSException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.reactivestreams.MongoSharedCollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0017H\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\u001e\u0010#\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u00072\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00170%H\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\u001a\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010'2\u0006\u0010\u001b\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020+2\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010)2\u0006\u0010\u001b\u001a\u00020+H\u0016J\u0016\u0010.\u001a\u00020\u001f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020+0%H\u0016J\u0010\u0010/\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020+H\u0016J\u0012\u00100\u001a\u0004\u0018\u00010'2\u0006\u0010\u001b\u001a\u000201H\u0016J\u0018\u00102\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u0002012\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u00103\u001a\u0004\u0018\u00010)2\u0006\u0010\u001b\u001a\u000201H\u0016J\u0016\u00104\u001a\u00020\u001f2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002010%H\u0016J\u0010\u00105\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u000201H\u0016J\u001c\u00106\u001a\u00020\u001f2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001f08H\u0016J\u001c\u00109\u001a\u00020\u001f2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001f08H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\r\u0010\tR4\u0010\u000f\u001a&\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011 \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R4\u0010\u0014\u001a&\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011 \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006:"}, d2={"Lai/tock/nlp/model/service/storage/mongo/NlpEngineModelMongoDAO;", "Lai/tock/nlp/model/service/storage/NlpEngineModelDAO;", "<init>", "()V", "logger", "Lmu/KLogger;", "entityBucket", "Lcom/mongodb/client/gridfs/GridFSBucket;", "getEntityBucket", "()Lcom/mongodb/client/gridfs/GridFSBucket;", "entityBucket$delegate", "Lkotlin/Lazy;", "intentBucket", "getIntentBucket", "intentBucket$delegate", "asyncEntityCol", "Lcom/mongodb/reactivestreams/client/MongoCollection;", "Lorg/bson/Document;", "kotlin.jvm.PlatformType", "Lcom/mongodb/reactivestreams/client/MongoCollection;", "asyncIntentCol", "idWithoutNamespace", "", "Lai/tock/nlp/model/ClassifierContextKey;", "getGridFSFile", "Lcom/mongodb/client/gridfs/model/GridFSFile;", "bucket", "key", "getDownloadStream", "Lcom/mongodb/client/gridfs/GridFSDownloadStream;", "saveModel", "", "stream", "Ljava/io/InputStream;", "deleteModel", "deleteModelNotIn", "keys", "", "getModelInputStream", "Lai/tock/nlp/model/service/storage/NlpModelStream;", "getLastUpdate", "Ljava/time/Instant;", "getEntityModelInputStream", "Lai/tock/nlp/model/EntityContextKey;", "saveEntityModel", "getEntityModelLastUpdate", "deleteEntityModelsNotIn", "deleteEntityModel", "getIntentModelInputStream", "Lai/tock/nlp/model/IntentContext$IntentContextKey;", "saveIntentModel", "getIntentModelLastUpdate", "deleteIntentModelsNotIn", "deleteIntentModel", "listenEntityModelChanges", "listener", "Lkotlin/Function1;", "listenIntentModelChanges", "tock-nlp-model-storage-mongo"})
@SourceDebugExtension(value={"SMAP\nNlpEngineModelMongoDAO.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NlpEngineModelMongoDAO.kt\nai/tock/nlp/model/service/storage/mongo/NlpEngineModelMongoDAO\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KMongoIterable.kt\nkotlin/collections/KMongoIterableKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Mongos.kt\nai/tock/shared/MongosKt\n+ 6 MongoSharedCollections.kt\norg/litote/kmongo/reactivestreams/MongoSharedCollectionsKt\n*L\n1#1,199:1\n1#2:200\n61#3:201\n61#3:206\n1557#4:202\n1628#4,3:203\n236#5:207\n243#5:227\n236#5:228\n243#5:248\n60#6,19:208\n60#6,19:229\n*S KotlinDebug\n*F\n+ 1 NlpEngineModelMongoDAO.kt\nai/tock/nlp/model/service/storage/mongo/NlpEngineModelMongoDAO\n*L\n102#1:201\n120#1:206\n119#1:202\n119#1:203,3\n182#1:207\n182#1:227\n191#1:228\n191#1:248\n182#1:208,19\n191#1:229,19\n*E\n"})
public final class NlpEngineModelMongoDAO
implements NlpEngineModelDAO {
    @NotNull
    public static final NlpEngineModelMongoDAO INSTANCE = new NlpEngineModelMongoDAO();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(NlpEngineModelMongoDAO::logger$lambda$0);
    @NotNull
    private static final Lazy entityBucket$delegate = LazyKt.lazy(NlpEngineModelMongoDAO::entityBucket_delegate$lambda$2);
    @NotNull
    private static final Lazy intentBucket$delegate = LazyKt.lazy(NlpEngineModelMongoDAO::intentBucket_delegate$lambda$4);
    private static final com.mongodb.reactivestreams.client.MongoCollection<Document> asyncEntityCol = MongoModelConfiguration.INSTANCE.getAsyncDatabase().getCollection("fs_entity.files");
    private static final com.mongodb.reactivestreams.client.MongoCollection<Document> asyncIntentCol = MongoModelConfiguration.INSTANCE.getAsyncDatabase().getCollection("fs_intent.files");

    private NlpEngineModelMongoDAO() {
    }

    private final GridFSBucket getEntityBucket() {
        Lazy lazy = entityBucket$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (GridFSBucket)object;
    }

    private final GridFSBucket getIntentBucket() {
        Lazy lazy = intentBucket$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (GridFSBucket)object;
    }

    private final String idWithoutNamespace(ClassifierContextKey $this$idWithoutNamespace) {
        String string;
        String $this$idWithoutNamespace_u24lambda_u245 = $this$idWithoutNamespace.id();
        boolean bl = false;
        int i = StringsKt.indexOf$default((CharSequence)$this$idWithoutNamespace_u24lambda_u245, (String)":", (int)0, (boolean)false, (int)6, null);
        int i2 = StringsKt.indexOf$default((CharSequence)$this$idWithoutNamespace_u24lambda_u245, (String)"-", (int)0, (boolean)false, (int)6, null);
        if (i != -1 && i2 > i) {
            String string2 = $this$idWithoutNamespace_u24lambda_u245.substring(i + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = null;
        }
        return string;
    }

    private final GridFSFile getGridFSFile(GridFSBucket bucket, ClassifierContextKey key) {
        GridFSFile gridFSFile;
        try {
            GridFSFile gridFSFile2 = (GridFSFile)bucket.find(Filters.eq((String)"filename", (Object)key.id())).limit(1).first();
            if (gridFSFile2 == null) {
                String string = this.idWithoutNamespace(key);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    gridFSFile2 = (GridFSFile)bucket.find(Filters.eq((String)"filename", (Object)it)).limit(1).first();
                } else {
                    gridFSFile2 = null;
                }
            }
            gridFSFile = gridFSFile2;
        }
        catch (MongoGridFSException e) {
            logger.debug((Throwable)e, () -> NlpEngineModelMongoDAO.getGridFSFile$lambda$7(key));
            gridFSFile = null;
        }
        return gridFSFile;
    }

    private final GridFSDownloadStream getDownloadStream(GridFSBucket bucket, ClassifierContextKey key) {
        GridFSDownloadStream gridFSDownloadStream;
        GridFSFile gridFSFile;
        GridFSFile gridFSFile2 = this.getGridFSFile(bucket, key);
        if (gridFSFile2 == null) {
            String string = this.idWithoutNamespace(key);
            if (string != null) {
                String it = string;
                boolean bl = false;
                gridFSFile2 = INSTANCE.getGridFSFile(bucket, key);
            } else {
                gridFSFile2 = null;
            }
        }
        if ((gridFSFile = gridFSFile2) != null) {
            GridFSFile it = gridFSFile;
            boolean bl = false;
            gridFSDownloadStream = bucket.openDownloadStream(it.getId());
        } else {
            gridFSDownloadStream = null;
        }
        return gridFSDownloadStream;
    }

    private final void saveModel(GridFSBucket bucket, ClassifierContextKey key, InputStream stream) {
        String filename = key.id();
        ObjectId newId = bucket.uploadFromStream(filename, stream);
        Bson[] bsonArray = new Bson[]{Filters.ne((String)"_id", (Object)newId), Filters.eq((String)"filename", (Object)filename)};
        GridFSFindIterable gridFSFindIterable = bucket.find(Filters.and((Bson[])bsonArray));
        Intrinsics.checkNotNullExpressionValue((Object)gridFSFindIterable, (String)"find(...)");
        MongoIterable $this$forEach$iv = (MongoIterable)gridFSFindIterable;
        boolean $i$f$forEach = false;
        $this$forEach$iv.forEach(new Consumer(bucket, key){
            final /* synthetic */ GridFSBucket $bucket$inlined;
            final /* synthetic */ ClassifierContextKey $key$inlined;
            {
                this.$bucket$inlined = gridFSBucket;
                this.$key$inlined = classifierContextKey;
            }

            public final void accept(T it) {
                GridFSFile it2 = (GridFSFile)it;
                boolean bl = false;
                NlpEngineModelMongoDAO.access$getLogger$p().debug((Function0)new Function0<Object>(it2, this.$key$inlined){
                    final /* synthetic */ GridFSFile $it;
                    final /* synthetic */ ClassifierContextKey $key;
                    {
                        this.$it = $it;
                        this.$key = $key;
                    }

                    public final Object invoke() {
                        return "Remove file " + this.$it.getObjectId() + " for " + this.$key;
                    }
                });
                this.$bucket$inlined.delete(it2.getObjectId());
            }
        });
    }

    private final void deleteModel(GridFSBucket bucket, ClassifierContextKey key) {
        block0: {
            GridFSFile gridFSFile;
            GridFSFile gridFSFile2 = (GridFSFile)bucket.find(Filters.eq((String)"filename", (Object)key.id())).limit(1).first();
            if (gridFSFile2 == null) break block0;
            GridFSFile $this$deleteModel_u24lambda_u2412 = gridFSFile = gridFSFile2;
            boolean bl = false;
            logger.debug(() -> NlpEngineModelMongoDAO.deleteModel$lambda$12$lambda$11($this$deleteModel_u24lambda_u2412, key));
            bucket.delete($this$deleteModel_u24lambda_u2412.getObjectId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteModelNotIn(GridFSBucket bucket, List<? extends ClassifierContextKey> keys) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = keys;
        String string = "filename";
        GridFSBucket gridFSBucket = bucket;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClassifierContextKey classifierContextKey = (ClassifierContextKey)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.id());
        }
        collection = (List)destination$iv$iv;
        GridFSFindIterable gridFSFindIterable = gridFSBucket.find(Filters.not((Bson)Filters.in((String)string, (Iterable)collection)));
        Intrinsics.checkNotNullExpressionValue((Object)gridFSFindIterable, (String)"find(...)");
        MongoIterable $this$forEach$iv = (MongoIterable)gridFSFindIterable;
        boolean $i$f$forEach = false;
        $this$forEach$iv.forEach(new Consumer(bucket){
            final /* synthetic */ GridFSBucket $bucket$inlined;
            {
                this.$bucket$inlined = gridFSBucket;
            }

            public final void accept(T it) {
                GridFSFile it2 = (GridFSFile)it;
                boolean bl = false;
                NlpEngineModelMongoDAO.access$getLogger$p().debug((Function0)new Function0<Object>(it2){
                    final /* synthetic */ GridFSFile $it;
                    {
                        this.$it = $it;
                    }

                    public final Object invoke() {
                        return "Remove file " + this.$it.getObjectId() + " for " + this.$it.getFilename();
                    }
                });
                this.$bucket$inlined.delete(it2.getObjectId());
            }
        });
    }

    private final NlpModelStream getModelInputStream(GridFSBucket bucket, ClassifierContextKey key) {
        NlpModelStream nlpModelStream;
        GridFSDownloadStream gridFSDownloadStream = this.getDownloadStream(bucket, key);
        if (gridFSDownloadStream != null) {
            GridFSDownloadStream stream = gridFSDownloadStream;
            boolean bl = false;
            Instant date = stream.getGridFSFile().getUploadDate().toInstant();
            InputStream inputStream = (InputStream)stream;
            Intrinsics.checkNotNull((Object)date);
            nlpModelStream = new NlpModelStream(inputStream, date, NlpApplicationConfigurationMongoDAO.INSTANCE.loadLastConfiguration(key.getApplicationName(), key.getEngineType(), date));
        } else {
            nlpModelStream = null;
        }
        return nlpModelStream;
    }

    private final Instant getLastUpdate(GridFSBucket bucket, ClassifierContextKey key) {
        Object object = this.getGridFSFile(bucket, key);
        return object != null && (object = object.getUploadDate()) != null ? ((Date)object).toInstant() : null;
    }

    @Nullable
    public NlpModelStream getEntityModelInputStream(@NotNull EntityContextKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getModelInputStream(this.getEntityBucket(), (ClassifierContextKey)key);
    }

    public void saveEntityModel(@NotNull EntityContextKey key, @NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.saveModel(this.getEntityBucket(), (ClassifierContextKey)key, stream);
    }

    @Nullable
    public Instant getEntityModelLastUpdate(@NotNull EntityContextKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getLastUpdate(this.getEntityBucket(), (ClassifierContextKey)key);
    }

    public void deleteEntityModelsNotIn(@NotNull List<EntityContextKey> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        this.deleteModelNotIn(this.getEntityBucket(), keys);
    }

    public void deleteEntityModel(@NotNull EntityContextKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.deleteModel(this.getEntityBucket(), (ClassifierContextKey)key);
    }

    @Nullable
    public NlpModelStream getIntentModelInputStream(@NotNull IntentContext.IntentContextKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getModelInputStream(this.getIntentBucket(), (ClassifierContextKey)key);
    }

    public void saveIntentModel(@NotNull IntentContext.IntentContextKey key, @NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.saveModel(this.getIntentBucket(), (ClassifierContextKey)key, stream);
    }

    @Nullable
    public Instant getIntentModelLastUpdate(@NotNull IntentContext.IntentContextKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getLastUpdate(this.getIntentBucket(), (ClassifierContextKey)key);
    }

    public void deleteIntentModelsNotIn(@NotNull List<IntentContext.IntentContextKey> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        this.deleteModelNotIn(this.getIntentBucket(), keys);
    }

    public void deleteIntentModel(@NotNull IntentContext.IntentContextKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.deleteModel(this.getIntentBucket(), (ClassifierContextKey)key);
    }

    /*
     * WARNING - void declaration
     */
    public void listenEntityModelChanges(@NotNull Function1<? super String, Unit> listener) {
        void errorListener$iv$iv;
        void subscribeListener$iv$iv;
        void fullDocument$iv;
        void $this$watchIndefinitely_u24default$iv$iv;
        void $this$watch$iv;
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        com.mongodb.reactivestreams.client.MongoCollection<Document> mongoCollection = asyncEntityCol;
        Intrinsics.checkNotNullExpressionValue(mongoCollection, (String)"asyncEntityCol");
        com.mongodb.reactivestreams.client.MongoCollection<Document> mongoCollection2 = mongoCollection;
        FullDocument fullDocument = FullDocument.UPDATE_LOOKUP;
        Function1 listener$iv = arg_0 -> NlpEngineModelMongoDAO.listenEntityModelChanges$lambda$16(listener, arg_0);
        boolean $i$f$watch = false;
        void var6_6 = $this$watch$iv;
        Function0 function0 = listenEntityModelChanges$$inlined$watch$1.INSTANCE;
        Function1 function1 = listenEntityModelChanges$$inlined$watch$2.INSTANCE;
        Function0 reopenListener$iv$iv = listenEntityModelChanges$$inlined$watch$3.INSTANCE;
        long reopenDelayInMS$iv$iv = 5000L;
        boolean $i$f$watchIndefinitely = false;
        MongoSharedCollectionsKt.watchIndefinitely((com.mongodb.reactivestreams.client.MongoCollection)$this$watchIndefinitely_u24default$iv$iv, (Function1)((Function1)new Function1<com.mongodb.reactivestreams.client.MongoCollection<Document>, ChangeStreamPublisher<Document>>((com.mongodb.reactivestreams.client.MongoCollection)$this$watchIndefinitely_u24default$iv$iv, (FullDocument)fullDocument$iv){
            final /* synthetic */ com.mongodb.reactivestreams.client.MongoCollection $this_watchIndefinitely;
            final /* synthetic */ FullDocument $fullDocument;
            {
                this.$this_watchIndefinitely = $receiver;
                this.$fullDocument = $fullDocument;
            }

            public final ChangeStreamPublisher<Document> invoke(com.mongodb.reactivestreams.client.MongoCollection<Document> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                ChangeStreamPublisher changeStreamPublisher = this.$this_watchIndefinitely.watch(Document.class).fullDocument(this.$fullDocument);
                Intrinsics.checkNotNullExpressionValue((Object)changeStreamPublisher, (String)"fullDocument(...)");
                return changeStreamPublisher;
            }
        }), (Function0)subscribeListener$iv$iv, (Function1)errorListener$iv$iv, (Function0)reopenListener$iv$iv, (long)reopenDelayInMS$iv$iv, (Function1)listener$iv);
    }

    /*
     * WARNING - void declaration
     */
    public void listenIntentModelChanges(@NotNull Function1<? super String, Unit> listener) {
        void errorListener$iv$iv;
        void subscribeListener$iv$iv;
        void fullDocument$iv;
        void $this$watchIndefinitely_u24default$iv$iv;
        void $this$watch$iv;
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        com.mongodb.reactivestreams.client.MongoCollection<Document> mongoCollection = asyncIntentCol;
        Intrinsics.checkNotNullExpressionValue(mongoCollection, (String)"asyncIntentCol");
        com.mongodb.reactivestreams.client.MongoCollection<Document> mongoCollection2 = mongoCollection;
        FullDocument fullDocument = FullDocument.UPDATE_LOOKUP;
        Function1 listener$iv = arg_0 -> NlpEngineModelMongoDAO.listenIntentModelChanges$lambda$17(listener, arg_0);
        boolean $i$f$watch = false;
        void var6_6 = $this$watch$iv;
        Function0 function0 = listenIntentModelChanges$$inlined$watch$1.INSTANCE;
        Function1 function1 = listenIntentModelChanges$$inlined$watch$2.INSTANCE;
        Function0 reopenListener$iv$iv = listenIntentModelChanges$$inlined$watch$3.INSTANCE;
        long reopenDelayInMS$iv$iv = 5000L;
        boolean $i$f$watchIndefinitely = false;
        MongoSharedCollectionsKt.watchIndefinitely((com.mongodb.reactivestreams.client.MongoCollection)$this$watchIndefinitely_u24default$iv$iv, (Function1)((Function1)new Function1<com.mongodb.reactivestreams.client.MongoCollection<Document>, ChangeStreamPublisher<Document>>((com.mongodb.reactivestreams.client.MongoCollection)$this$watchIndefinitely_u24default$iv$iv, (FullDocument)fullDocument$iv){
            final /* synthetic */ com.mongodb.reactivestreams.client.MongoCollection $this_watchIndefinitely;
            final /* synthetic */ FullDocument $fullDocument;
            {
                this.$this_watchIndefinitely = $receiver;
                this.$fullDocument = $fullDocument;
            }

            public final ChangeStreamPublisher<Document> invoke(com.mongodb.reactivestreams.client.MongoCollection<Document> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                ChangeStreamPublisher changeStreamPublisher = this.$this_watchIndefinitely.watch(Document.class).fullDocument(this.$fullDocument);
                Intrinsics.checkNotNullExpressionValue((Object)changeStreamPublisher, (String)"fullDocument(...)");
                return changeStreamPublisher;
            }
        }), (Function0)subscribeListener$iv$iv, (Function1)errorListener$iv$iv, (Function0)reopenListener$iv$iv, (long)reopenDelayInMS$iv$iv, (Function1)listener$iv);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final GridFSBucket entityBucket_delegate$lambda$2() {
        GridFSBucket gridFSBucket;
        GridFSBucket $this$entityBucket_delegate_u24lambda_u242_u24lambda_u241 = gridFSBucket = GridFSBuckets.create((MongoDatabase)MongoModelConfiguration.INSTANCE.getDatabase(), (String)"fs_entity");
        boolean bl = false;
        MongoCollection mongoCollection = MongoModelConfiguration.INSTANCE.getDatabase().getCollection("fs_entity.files");
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        MongosKt.ensureIndex$default((MongoCollection)mongoCollection, (String)"{filename:1}", null, (int)2, null);
        return gridFSBucket;
    }

    private static final GridFSBucket intentBucket_delegate$lambda$4() {
        GridFSBucket gridFSBucket;
        GridFSBucket $this$intentBucket_delegate_u24lambda_u244_u24lambda_u243 = gridFSBucket = GridFSBuckets.create((MongoDatabase)MongoModelConfiguration.INSTANCE.getDatabase(), (String)"fs_intent");
        boolean bl = false;
        MongoCollection mongoCollection = MongoModelConfiguration.INSTANCE.getDatabase().getCollection("fs_intent.files");
        Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
        MongosKt.ensureIndex$default((MongoCollection)mongoCollection, (String)"{filename:1}", null, (int)2, null);
        return gridFSBucket;
    }

    private static final Object getGridFSFile$lambda$7(ClassifierContextKey $key) {
        return "no model exists for " + $key;
    }

    private static final Object deleteModel$lambda$12$lambda$11(GridFSFile $this_apply, ClassifierContextKey $key) {
        return "Remove file " + $this_apply.getObjectId() + " for " + $key;
    }

    private static final Unit listenEntityModelChanges$lambda$16(Function1 $listener, ChangeStreamDocument it) {
        String id;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Document document = (Document)it.getFullDocument();
        Object object = document != null ? document.get((Object)"filename") : null;
        String string = id = object instanceof String ? (String)object : null;
        if (id != null) {
            $listener.invoke((Object)id);
        }
        return Unit.INSTANCE;
    }

    private static final Unit listenIntentModelChanges$lambda$17(Function1 $listener, ChangeStreamDocument it) {
        String id;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Document document = (Document)it.getFullDocument();
        Object object = document != null ? document.get((Object)"filename") : null;
        String string = id = object instanceof String ? (String)object : null;
        if (id != null) {
            $listener.invoke((Object)id);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }
}

