/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared.security;

import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.security.EncryptorsKt;
import ai.tock.shared.security.TockObfuscatorService;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import mu.KLogger;
import mu.KotlinLogging;
import org.jasypt.util.text.BasicTextEncryptor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r\u001a\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r\u001a\u0006\u0010\u0010\u001a\u00020\u0011\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"encryptionEnabled", "", "getEncryptionEnabled", "()Z", "logger", "Lmu/KLogger;", "textEncryptor", "Lorg/jasypt/util/text/BasicTextEncryptor;", "getTextEncryptor", "()Lorg/jasypt/util/text/BasicTextEncryptor;", "textEncryptor$delegate", "Lkotlin/Lazy;", "decrypt", "", "s", "encrypt", "initEncryptor", "", "tock-shared"})
public final class EncryptorsKt {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final KLogger logger;
    private static final Lazy textEncryptor$delegate;
    private static final boolean encryptionEnabled;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(EncryptorsKt.class, (String)"tock-shared"), "textEncryptor", "getTextEncryptor()Lorg/jasypt/util/text/BasicTextEncryptor;"))};
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        textEncryptor$delegate = LazyKt.lazy((Function0)textEncryptor.2.INSTANCE);
        encryptionEnabled = PropertiesKt.propertyExists("tock_encrypt_pass");
    }

    private static final BasicTextEncryptor getTextEncryptor() {
        Lazy lazy = textEncryptor$delegate;
        Object var1_1 = null;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (BasicTextEncryptor)lazy.getValue();
    }

    public static final boolean getEncryptionEnabled() {
        return encryptionEnabled;
    }

    @NotNull
    public static final String encrypt(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        String string = EncryptorsKt.getTextEncryptor().encrypt(s);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"textEncryptor.encrypt(s)");
        return string;
    }

    @NotNull
    public static final String decrypt(@NotNull String s) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        try {
            String string2 = EncryptorsKt.getTextEncryptor().decrypt(s);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"textEncryptor.decrypt(s)");
            string = string2;
        }
        catch (Exception e) {
            LoggersKt.error(logger, e);
            string = s;
        }
        return string;
    }

    public static final void initEncryptor() {
        if (encryptionEnabled) {
            logger.info((Function0)initEncryptor.1.INSTANCE);
            EncryptorsKt.decrypt(EncryptorsKt.encrypt("test"));
            logger.info((Function0)initEncryptor.2.INSTANCE);
        }
        TockObfuscatorService.INSTANCE.loadObfuscators$tock_shared();
    }
}

