/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared.jackson;

import ai.tock.shared.jackson.AnyValueWrapper;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=AnyValueDeserializer.class)
@JsonSerialize(using=AnyValueSerializer.class)
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0087\b\u0018\u0000 \u00182\u00020\u0001:\u0003\u0016\u0017\u0018B\u001d\b\u0016\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\u001f\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00072\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lai/tock/shared/jackson/AnyValueWrapper;", "", "klass", "Lkotlin/reflect/KClass;", "value", "(Lkotlin/reflect/KClass;Ljava/lang/Object;)V", "(Ljava/lang/Object;)V", "", "(Ljava/lang/String;Ljava/lang/Object;)V", "getKlass", "()Ljava/lang/String;", "getValue", "()Ljava/lang/Object;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "AnyValueDeserializer", "AnyValueSerializer", "Companion", "tock-shared"})
public final class AnyValueWrapper {
    @NotNull
    private final String klass;
    @Nullable
    private final Object value;
    private static final KLogger logger;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final String getKlass() {
        return this.klass;
    }

    @Nullable
    public final Object getValue() {
        return this.value;
    }

    public AnyValueWrapper(@NotNull String klass, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        this.klass = klass;
        this.value = value;
    }

    public AnyValueWrapper(@NotNull KClass<?> klass, @Nullable Object value) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        String string = JvmClassMappingKt.getJavaClass(klass).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"klass.java.name");
        this(string, value);
    }

    public AnyValueWrapper(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this(Reflection.getOrCreateKotlinClass(value.getClass()), value);
    }

    static {
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
    }

    @NotNull
    public final String component1() {
        return this.klass;
    }

    @Nullable
    public final Object component2() {
        return this.value;
    }

    @NotNull
    public final AnyValueWrapper copy(@NotNull String klass, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return new AnyValueWrapper(klass, value);
    }

    public static /* synthetic */ AnyValueWrapper copy$default(AnyValueWrapper anyValueWrapper, String string, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            string = anyValueWrapper.klass;
        }
        if ((n & 2) != 0) {
            object = anyValueWrapper.value;
        }
        return anyValueWrapper.copy(string, object);
    }

    @NotNull
    public String toString() {
        return "AnyValueWrapper(klass=" + this.klass + ", value=" + this.value + ")";
    }

    public int hashCode() {
        String string = this.klass;
        Object object = this.value;
        return (string != null ? string.hashCode() : 0) * 31 + (object != null ? object.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof AnyValueWrapper)) break block3;
                AnyValueWrapper anyValueWrapper = (AnyValueWrapper)object;
                if (!Intrinsics.areEqual((Object)this.klass, (Object)anyValueWrapper.klass) || !Intrinsics.areEqual((Object)this.value, (Object)anyValueWrapper.value)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lai/tock/shared/jackson/AnyValueWrapper$AnyValueDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lai/tock/shared/jackson/AnyValueWrapper;", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "tock-shared"})
    public static final class AnyValueDeserializer
    extends JsonDeserializer<AnyValueWrapper> {
        @Nullable
        public AnyValueWrapper deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext context) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            String fieldName = JacksonKt.fieldNameWithValueReady(jp);
            if (fieldName != null) {
                AnyValueWrapper anyValueWrapper;
                Class<?> clazz;
                try {
                    String string = jp.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jp.text");
                    clazz = Class.forName(StringsKt.replace$default((String)string, (String)"fr.vsct.tock", (String)"ai.tock", (boolean)false, (int)4, null));
                }
                catch (Exception e) {
                    logger.warn("deserialization error for class " + e.getMessage());
                    clazz = null;
                }
                Class<?> classValue = clazz;
                fieldName = JacksonKt.fieldNameWithValueReady(jp);
                if (fieldName != null) {
                    if (classValue == null) {
                        JsonToken jsonToken = jp.getCurrentToken();
                        Intrinsics.checkNotNullExpressionValue((Object)jsonToken, (String)"jp.currentToken");
                        if (jsonToken.isStructStart()) {
                            jp.skipChildren();
                        }
                        jp.nextToken();
                        JacksonKt.checkEndToken(jp);
                        return null;
                    }
                    Object value = jp.readValueAs(classValue);
                    JacksonKt.checkEndToken(jp);
                    String string = classValue.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classValue.name");
                    return new AnyValueWrapper(string, value);
                }
                JacksonKt.checkEndToken(jp);
                if (classValue == null) {
                    anyValueWrapper = null;
                } else {
                    String string = classValue.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classValue.name");
                    anyValueWrapper = new AnyValueWrapper(string, null);
                }
                return anyValueWrapper;
            }
            return null;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lai/tock/shared/jackson/AnyValueWrapper$AnyValueSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lai/tock/shared/jackson/AnyValueWrapper;", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "tock-shared"})
    public static final class AnyValueSerializer
    extends JsonSerializer<AnyValueWrapper> {
        public void serialize(@NotNull AnyValueWrapper value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
            gen.writeStartObject();
            gen.writeFieldName("klass");
            gen.writeString(value.getKlass());
            serializers.defaultSerializeField("value", value.getValue(), gen);
            gen.writeEndObject();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/tock/shared/jackson/AnyValueWrapper$Companion;", "", "()V", "logger", "Lmu/KLogger;", "tock-shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

