/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared.security.auth;

import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.security.TockUser;
import ai.tock.shared.security.TockUserListener;
import ai.tock.shared.security.TockUserRole;
import ai.tock.shared.security.auth.AWSJWTAuthHandler;
import ai.tock.shared.security.auth.AWSJWTAuthProvider;
import ai.tock.shared.security.auth.RetrofitAWSPublicKeyClient;
import ai.tock.shared.security.auth.SSOTockAuthProvider;
import ai.tock.shared.vertx.WebVerticle;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import com.google.common.io.BaseEncoding;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.auth.jwt.impl.JWTUser;
import io.vertx.ext.web.handler.AuthHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\b\u0000\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001f2\u0006\u0010 \u001a\u00020\fH\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\f2\u0006\u0010 \u001a\u00020\fH\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0#2\u0006\u0010 \u001a\u00020\fH\u0002R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lai/tock/shared/security/auth/AWSJWTAuthProvider;", "Lai/tock/shared/security/auth/SSOTockAuthProvider;", "Lio/vertx/ext/auth/jwt/JWTAuth;", "vertx", "Lio/vertx/core/Vertx;", "(Lio/vertx/core/Vertx;)V", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "jwtAuthProvider", "publicKey", "", "authenticate", "", "authInfo", "Lio/vertx/core/json/JsonObject;", "resultHandler", "Lio/vertx/core/Handler;", "Lio/vertx/core/AsyncResult;", "Lio/vertx/ext/auth/User;", "createAuthHandler", "Lio/vertx/ext/web/handler/AuthHandler;", "verticle", "Lai/tock/shared/vertx/WebVerticle;", "generateToken", "claims", "options", "Lio/vertx/ext/auth/JWTOptions;", "getJwtAuthProvider", "parseCustomRoles", "", "customRoles", "parseNamespace", "parseUserRoles", "", "Companion", "tock-shared"})
public final class AWSJWTAuthProvider
extends SSOTockAuthProvider
implements JWTAuth {
    private volatile String publicKey;
    private volatile JWTAuth jwtAuthProvider;
    private static final KLogger logger;
    private static final String jwtAlgorithm;
    private static final Map<String, String> namespaceMapping;
    private static final Map<String, String> customRolesMapping;
    @NotNull
    public static final Companion Companion;

    private final Executor getExecutor() {
        KodeinInjector $this$provide$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        TypeToken typeToken = (TypeToken)new TypeReference<Executor>(){};
        return (Executor)((Function0)kodeinInjector.Provider(typeToken, tag$iv).getValue()).invoke();
    }

    @Override
    @NotNull
    public AuthHandler createAuthHandler(@NotNull WebVerticle verticle) {
        Intrinsics.checkNotNullParameter((Object)((Object)verticle), (String)"verticle");
        return (AuthHandler)new AWSJWTAuthHandler(this, null);
    }

    public void authenticate(@NotNull JsonObject authInfo, @NotNull Handler<AsyncResult<User>> resultHandler) {
        Intrinsics.checkNotNullParameter((Object)authInfo, (String)"authInfo");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        JWTAuth jWTAuth = this.jwtAuthProvider = this.getJwtAuthProvider(authInfo);
        if (jWTAuth != null) {
            jWTAuth.authenticate(authInfo, (Handler)new Handler<AsyncResult<User>>(this, resultHandler, authInfo){
                final /* synthetic */ AWSJWTAuthProvider this$0;
                final /* synthetic */ Handler $resultHandler;
                final /* synthetic */ JsonObject $authInfo;

                public final void handle(AsyncResult<User> it) {
                    if (it.succeeded()) {
                        JWTUser user;
                        Object object = it.result();
                        if (!(object instanceof JWTUser)) {
                            object = null;
                        }
                        if ((user = (JWTUser)object) != null) {
                            String customRoles;
                            JsonObject token = user.principal();
                            String string = customRoles = token.getString("custom:roles");
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"customRoles");
                            Set roles = AWSJWTAuthProvider.access$parseUserRoles(this.this$0, string);
                            if (roles.isEmpty()) {
                                AWSJWTAuthProvider.access$getLogger$cp().warn((Function0)new Function0<Object>(customRoles){
                                    final /* synthetic */ String $customRoles;

                                    @Nullable
                                    public final Object invoke() {
                                        return "empty role for " + this.$customRoles;
                                    }
                                    {
                                        this.$customRoles = string;
                                        super(0);
                                    }
                                });
                                this.$resultHandler.handle((Object)Future.failedFuture((String)"Unauthorized"));
                            } else {
                                String namespace = AWSJWTAuthProvider.access$parseNamespace(this.this$0, customRoles);
                                if (namespace == null) {
                                    AWSJWTAuthProvider.access$getLogger$cp().warn((Function0)new Function0<Object>(customRoles){
                                        final /* synthetic */ String $customRoles;

                                        @Nullable
                                        public final Object invoke() {
                                            return "no namespace for " + this.$customRoles;
                                        }
                                        {
                                            this.$customRoles = string;
                                            super(0);
                                        }
                                    });
                                    this.$resultHandler.handle((Object)Future.failedFuture((String)"Unauthorized"));
                                } else {
                                    AWSJWTAuthProvider.access$getExecutor$p(this.this$0).executeBlocking((Function0<Unit>)((Function0)new Function0<Unit>(this, token, namespace, roles){
                                        final /* synthetic */ authenticate.1 this$0;
                                        final /* synthetic */ JsonObject $token;
                                        final /* synthetic */ String $namespace;
                                        final /* synthetic */ Set $roles;

                                        public final void invoke() {
                                            String customName = this.$token.getString("email");
                                            KodeinInjector $this$provide$iv = IOCsKt.getInjector();
                                            Object tag$iv = null;
                                            boolean $i$f$provide = false;
                                            KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide$iv.getInjector();
                                            KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
                                            TypeToken typeToken = (TypeToken)new TypeReference<TockUserListener>(){};
                                            TockUserListener tockUserListener = (TockUserListener)((Function0)kodeinInjector.Provider(typeToken, tag$iv).getValue()).invoke();
                                            String string = customName;
                                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"customName");
                                            TockUser u = tockUserListener.registerUser(new TockUser(string, this.$namespace, this.$roles, false, 8, null), true);
                                            this.this$0.$resultHandler.handle((Object)Future.succeededFuture((Object)((Object)u)));
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            this.$token = jsonObject;
                                            this.$namespace = string;
                                            this.$roles = set;
                                            super(0);
                                        }
                                    }));
                                }
                            }
                        } else {
                            this.$resultHandler.handle((Object)Future.failedFuture((String)"Unauthorized"));
                        }
                    } else {
                        if (this.$authInfo.getBoolean("retry") == null) {
                            AWSJWTAuthProvider.access$setPublicKey$p(this.this$0, null);
                            JsonObject jsonObject = this.$authInfo.put("retry", Boolean.valueOf(true));
                            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"authInfo.put(\"retry\", true)");
                            this.this$0.authenticate(jsonObject, (Handler<AsyncResult<User>>)this.$resultHandler);
                        }
                        this.$resultHandler.handle((Object)Future.failedFuture((String)"Unauthorized"));
                    }
                }
                {
                    this.this$0 = aWSJWTAuthProvider;
                    this.$resultHandler = handler;
                    this.$authInfo = jsonObject;
                }
            });
        } else {
            resultHandler.handle((Object)Future.failedFuture((String)"no jwt provider"));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> parseCustomRoles(String customRoles) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)customRoles, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)it, (CharSequence)"["), (CharSequence)"]");
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String string4 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            collection.add(string4);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final String parseNamespace(String customRoles) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.parseCustomRoles(customRoles);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            String it = (String)element$iv$iv;
            boolean bl = false;
            Object object = namespaceMapping.get(it);
            if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void n;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    void var21_21 = n;
                    boolean bl3 = false;
                    void v1 = var21_21;
                    if (v1 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    String string2 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString();
                    collection.add(string2);
                }
                list = (List)destination$iv$iv2;
            } else {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> parseUserRoles(String customRoles) {
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        String it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.parseCustomRoles(customRoles);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            it = (String)element$iv$iv;
            boolean bl = false;
            Object object = customRolesMapping.get(it);
            if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null)) != null) {
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void r;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    TockUserRole tockUserRole = TockUserRole.Companion.toRole((String)r);
                    collection.add(tockUserRole);
                }
                list = (List)destination$iv$iv2;
            } else {
                list = CollectionsKt.emptyList();
            }
            list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (TockUserRole)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = ((Enum)((Object)it)).name();
            collection.add(string);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private final JWTAuth getJwtAuthProvider(JsonObject authInfo) {
        JWTAuth jWTAuth;
        if (this.publicKey == null) {
            String string = authInfo.getString("jwt");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"authInfo.getString(\"jwt\")");
            CharSequence charSequence = string;
            String string2 = "\\.";
            int n = 0;
            string2 = new Regex(string2);
            n = 0;
            boolean bl = false;
            List segments = string2.split(charSequence, n);
            if (segments.size() == 3) {
                String kid;
                String headerSeg = (String)segments.get(0);
                byte[] byArray = BaseEncoding.base64Url().decode((CharSequence)headerSeg);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"BaseEncoding.base64Url().decode(headerSeg)");
                byte[] byArray2 = byArray;
                bl = false;
                JsonObject header = new JsonObject(new String(byArray2, Charsets.UTF_8));
                String string3 = kid = header.getString("kid");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"kid");
                String newPublicKey = RetrofitAWSPublicKeyClient.INSTANCE.getPublicKey(string3);
                if (newPublicKey != null) {
                    this.publicKey = StringsKt.replace$default((String)StringsKt.replace$default((String)newPublicKey, (String)"-----BEGIN PUBLIC KEY-----\n", (String)"", (boolean)false, (int)4, null), (String)"\n-----END PUBLIC KEY-----\n", (String)"", (boolean)false, (int)4, null);
                    jWTAuth = JWTAuth.create((Vertx)this.getVertx(), (JWTAuthOptions)new JWTAuthOptions(new JsonObject().put("pubSecKeys", new JsonArray().add(new JsonObject().put("algorithm", jwtAlgorithm).put("publicKey", this.publicKey)))));
                } else {
                    jWTAuth = null;
                }
            } else {
                jWTAuth = null;
            }
        } else {
            jWTAuth = this.jwtAuthProvider;
        }
        return jWTAuth;
    }

    @NotNull
    public String generateToken(@NotNull JsonObject claims, @NotNull JWTOptions options) {
        Intrinsics.checkNotNullParameter((Object)claims, (String)"claims");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return "";
    }

    public AWSJWTAuthProvider(@NotNull Vertx vertx2) {
        Intrinsics.checkNotNullParameter((Object)vertx2, (String)"vertx");
        super(vertx2);
    }

    static {
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
        jwtAlgorithm = PropertiesKt.property("jwt_algorithm", "ES256");
        namespaceMapping = PropertiesKt.mapProperty$default("tock_jwt_custom_namespace_mapping", MapsKt.emptyMap(), null, null, 12, null);
        customRolesMapping = PropertiesKt.mapProperty$default("tock_jwt_custom_roles_mapping", MapsKt.emptyMap(), null, null, 12, null);
    }

    public static final /* synthetic */ Set access$parseUserRoles(AWSJWTAuthProvider $this, String customRoles) {
        return $this.parseUserRoles(customRoles);
    }

    public static final /* synthetic */ KLogger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ String access$parseNamespace(AWSJWTAuthProvider $this, String customRoles) {
        return $this.parseNamespace(customRoles);
    }

    public static final /* synthetic */ Executor access$getExecutor$p(AWSJWTAuthProvider $this) {
        return $this.getExecutor();
    }

    public static final /* synthetic */ String access$getPublicKey$p(AWSJWTAuthProvider $this) {
        return $this.publicKey;
    }

    public static final /* synthetic */ void access$setPublicKey$p(AWSJWTAuthProvider $this, String string) {
        $this.publicKey = string;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lai/tock/shared/security/auth/AWSJWTAuthProvider$Companion;", "", "()V", "customRolesMapping", "", "", "jwtAlgorithm", "logger", "Lmu/KLogger;", "namespaceMapping", "tock-shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

