/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared;

import ai.tock.shared.ImageFormat;
import ai.tock.shared.ImageGenerator$WhenMappings;
import ai.tock.shared.SvgGenerator;
import ai.tock.shared.SvgToPngConverter;
import java.io.ByteArrayOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001b\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lai/tock/shared/ImageGenerator;", "T", "", "svgToPngConverter", "Lai/tock/shared/SvgToPngConverter;", "svgGenerator", "Lai/tock/shared/SvgGenerator;", "(Lai/tock/shared/SvgToPngConverter;Lai/tock/shared/SvgGenerator;)V", "documentToByteArray", "", "document", "Lorg/w3c/dom/Document;", "generate", "params", "format", "Lai/tock/shared/ImageFormat;", "(Ljava/lang/Object;Lai/tock/shared/ImageFormat;)[B", "tock-shared"})
public final class ImageGenerator<T> {
    private final SvgToPngConverter svgToPngConverter;
    private final SvgGenerator<T> svgGenerator;

    @NotNull
    public final byte[] generate(@NotNull T params, @NotNull ImageFormat format) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        Document document = this.svgGenerator.generate(params);
        switch (ImageGenerator$WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                byArray = this.svgToPngConverter.documentToPngByteArray(document);
                break;
            }
            case 2: {
                byArray = this.documentToByteArray(document);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return byArray;
    }

    private final byte[] documentToByteArray(Document document) {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        byte[] byArray = outputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"outputStream.toByteArray()");
        return byArray;
    }

    public ImageGenerator(@NotNull SvgToPngConverter svgToPngConverter, @NotNull SvgGenerator<T> svgGenerator) {
        Intrinsics.checkNotNullParameter((Object)svgToPngConverter, (String)"svgToPngConverter");
        Intrinsics.checkNotNullParameter(svgGenerator, (String)"svgGenerator");
        this.svgToPngConverter = svgToPngConverter;
        this.svgGenerator = svgGenerator;
    }
}

