/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared;

import ai.tock.shared.Loader;
import com.google.common.io.Resources;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"resource", "Ljava/net/URL;", "path", "", "resourceAsStream", "Ljava/io/InputStream;", "resourceAsString", "tock-shared"})
public final class IOsKt {
    @NotNull
    public static final URL resource(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        URL uRL = Loader.class.getResource(path);
        if (uRL == null) {
            String string = "resource " + path + " not found";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return uRL;
    }

    @NotNull
    public static final InputStream resourceAsStream(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        InputStream inputStream = Loader.class.getResourceAsStream(path);
        if (inputStream == null) {
            String string = Intrinsics.stringPlus((String)"path not found: ", (Object)path);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return inputStream;
    }

    @NotNull
    public static final String resourceAsString(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = Resources.toString((URL)IOsKt.resource(path), (Charset)StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(resource(path), StandardCharsets.UTF_8)");
        return string;
    }
}

