/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared;

import ai.tock.shared.Level;
import java.io.EOFException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0015\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lai/tock/shared/LoggingInterceptor;", "Lokhttp3/Interceptor;", "logger", "Lmu/KLogger;", "level", "Lai/tock/shared/Level;", "(Lmu/KLogger;Lai/tock/shared/Level;)V", "getLevel", "()Lai/tock/shared/Level;", "getLogger", "()Lmu/KLogger;", "bodyEncoded", "", "headers", "Lokhttp3/Headers;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "isPlaintext", "buffer", "Lokio/Buffer;", "isPlaintext$tock_shared", "tock-shared"})
final class LoggingInterceptor
implements Interceptor {
    @NotNull
    private final KLogger logger;
    @NotNull
    private final Level level;

    public LoggingInterceptor(@NotNull KLogger logger2, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.logger = logger2;
        this.level = level;
    }

    @NotNull
    public final KLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Level getLevel() {
        return this.level;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Level level = this.level;
        Request request = chain.request();
        if (level == Level.NONE) {
            return chain.proceed(request);
        }
        boolean logBody = level == Level.BODY;
        boolean logHeaders = logBody || level == Level.HEADERS;
        RequestBody requestBody = request.body();
        boolean hasRequestBody = requestBody != null;
        Connection connection = chain.connection();
        Protocol protocol = connection != null ? connection.protocol() : Protocol.HTTP_1_1;
        String requestStartMessage = "--> " + request.method() + ' ' + request.url() + ' ' + protocol;
        if (!logHeaders && hasRequestBody) {
            StringBuilder stringBuilder = new StringBuilder().append(requestStartMessage).append(" (");
            RequestBody requestBody2 = requestBody;
            Intrinsics.checkNotNull((Object)requestBody2);
            requestStartMessage = stringBuilder.append(requestBody2.contentLength()).append("-byte body)").toString();
        }
        this.logger.info(requestStartMessage);
        if (logHeaders) {
            if (hasRequestBody) {
                RequestBody requestBody3 = requestBody;
                Intrinsics.checkNotNull((Object)requestBody3);
                if (requestBody3.contentType() != null) {
                    this.logger.info(Intrinsics.stringPlus((String)"Content-Type: ", (Object)requestBody.contentType()));
                }
                if (requestBody.contentLength() != -1L) {
                    this.logger.info(Intrinsics.stringPlus((String)"Content-Length: ", (Object)requestBody.contentLength()));
                }
            }
            Headers headers = request.headers();
            int i = 0;
            int count = headers.size();
            while (i < count) {
                String name = headers.name(i);
                if (!StringsKt.equals((String)"Content-Type", (String)name, (boolean)true) && !StringsKt.equals((String)"Content-Length", (String)name, (boolean)true)) {
                    this.logger.info(name + ": " + headers.value(i));
                }
                int n = i;
                i = n + 1;
            }
            if (!logBody || !hasRequestBody) {
                this.logger.info(Intrinsics.stringPlus((String)"--> END ", (Object)request.method()));
            } else if (this.bodyEncoded(request.headers())) {
                this.logger.info("--> END " + request.method() + " (encoded body omitted)");
            } else {
                Buffer buffer = new Buffer();
                RequestBody requestBody4 = requestBody;
                Intrinsics.checkNotNull((Object)requestBody4);
                requestBody4.writeTo((BufferedSink)buffer);
                Charset charset = StandardCharsets.UTF_8;
                MediaType contentType = requestBody.contentType();
                if (contentType != null) {
                    charset = contentType.charset(StandardCharsets.UTF_8);
                }
                this.logger.info("");
                if (this.isPlaintext$tock_shared(buffer)) {
                    Charset charset2 = charset;
                    Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"charset");
                    this.logger.info(buffer.readString(charset2));
                    this.logger.info("--> END " + request.method() + " (" + requestBody.contentLength() + "-byte body)");
                } else {
                    this.logger.info("--> END " + request.method() + " (binary " + requestBody.contentLength() + "-byte body omitted)");
                }
            }
        }
        long startNs = System.nanoTime();
        Response response = null;
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            this.logger.error(Intrinsics.stringPlus((String)"<-- HTTP FAILED: ", (Object)e));
            throw e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        ResponseBody responseBody = response.body();
        Intrinsics.checkNotNull((Object)responseBody);
        ResponseBody responseBody2 = responseBody;
        long contentLength = responseBody2.contentLength();
        String bodySize = contentLength != -1L ? contentLength + "-byte" : "unknown-length";
        this.logger.info("<-- " + response.code() + ' ' + response.message() + ' ' + response.request().url() + " (" + tookMs + "ms" + (!logHeaders ? ", " + bodySize + " body" : "") + ')');
        if (logHeaders) {
            Headers headers = response.headers();
            int i = 0;
            int count = headers.size();
            while (i < count) {
                this.logger.info(headers.name(i) + ": " + headers.value(i));
                int n = i;
                i = n + 1;
            }
            if (!logBody || !HttpHeaders.promisesBody((Response)response)) {
                this.logger.info("<-- END HTTP");
            } else if (this.bodyEncoded(response.headers())) {
                this.logger.info("<-- END HTTP (encoded body omitted)");
            } else {
                BufferedSource source = responseBody2.source();
                source.request(Long.MAX_VALUE);
                Buffer buffer = source.getBuffer();
                Charset charset = StandardCharsets.UTF_8;
                MediaType contentType = responseBody2.contentType();
                if (contentType != null) {
                    charset = contentType.charset(StandardCharsets.UTF_8);
                }
                if (!this.isPlaintext$tock_shared(buffer)) {
                    this.logger.info("");
                    this.logger.info("<-- END HTTP (binary " + buffer.size() + "-byte body omitted)");
                    return response;
                }
                if (contentLength != 0L) {
                    this.logger.info("");
                    Buffer buffer2 = buffer.clone();
                    Charset charset3 = charset;
                    Intrinsics.checkNotNullExpressionValue((Object)charset3, (String)"charset");
                    this.logger.info(buffer2.readString(charset3));
                }
                this.logger.info("<-- END HTTP (" + buffer.size() + "-byte body)");
            }
        }
        return response;
    }

    public final boolean isPlaintext$tock_shared(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            int n = 0;
            do {
                int i = n++;
                if (prefix.exhausted()) break;
                if (!Character.isISOControl(prefix.readUtf8CodePoint())) continue;
                return false;
            } while (n <= 15);
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    private final boolean bodyEncoded(Headers headers) {
        String contentEncoding = headers.get("Content-Encoding");
        return contentEncoding != null && !StringsKt.equals((String)contentEncoding, (String)"identity", (boolean)true);
    }
}

