/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared.security.auth;

import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import ai.tock.shared.security.auth.RetrofitAWSPublicKeyClient;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Path;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lai/tock/shared/security/auth/RetrofitAWSPublicKeyClient;", "", "()V", "api", "Lai/tock/shared/security/auth/RetrofitAWSPublicKeyClient$AWSPublicKeyApi;", "awsRegion", "", "logger", "Lmu/KLogger;", "getPublicKey", "keyID", "AWSPublicKeyApi", "tock-shared"})
public final class RetrofitAWSPublicKeyClient {
    @NotNull
    public static final RetrofitAWSPublicKeyClient INSTANCE = new RetrofitAWSPublicKeyClient();
    @NotNull
    private static final AWSPublicKeyApi api;
    @NotNull
    private static final KLogger logger;
    @NotNull
    private static final String awsRegion;

    private RetrofitAWSPublicKeyClient() {
    }

    @Nullable
    public final String getPublicKey(@NotNull String keyID) {
        Intrinsics.checkNotNullParameter((Object)keyID, (String)"keyID");
        ResponseBody responseBody = (ResponseBody)api.getPublicKey(keyID).execute().body();
        return responseBody == null ? null : responseBody.string();
    }

    static {
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        awsRegion = PropertiesKt.property("aws_region", "eu-west-1");
        Retrofit.Builder builder = RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default(PropertiesKt.longProperty("tock_aws_public_key_request_timeout_ms", 30000L), logger, null, null, false, false, null, 124, null).baseUrl("https://public-keys.auth.elb." + awsRegion + ".amazonaws.com");
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"retrofitBuilderWithTimeoutAndLogger(\n            longProperty(\"tock_aws_public_key_request_timeout_ms\", 30000),\n            logger\n        )\n            .baseUrl(\"https://public-keys.auth.elb.$awsRegion.amazonaws.com\")");
        Retrofit retrofit = RetrofitsKt.addJacksonConverter$default(builder, null, 1, null).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"retrofitBuilderWithTimeoutAndLogger(\n            longProperty(\"tock_aws_public_key_request_timeout_ms\", 30000),\n            logger\n        )\n            .baseUrl(\"https://public-keys.auth.elb.$awsRegion.amazonaws.com\")\n            .addJacksonConverter()\n            .build()");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(AWSPublicKeyApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(T::class.java)");
        api = (AWSPublicKeyApi)object;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bb\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0001\u0010\u0005\u001a\u00020\u0006H'\u00a8\u0006\u0007"}, d2={"Lai/tock/shared/security/auth/RetrofitAWSPublicKeyClient$AWSPublicKeyApi;", "", "getPublicKey", "Lretrofit2/Call;", "Lokhttp3/ResponseBody;", "keyID", "", "tock-shared"})
    private static interface AWSPublicKeyApi {
        @GET(value="/{keyID}")
        @NotNull
        public Call<ResponseBody> getPublicKey(@Path(value="keyID") @NotNull String var1);
    }
}

