/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared;

import ai.tock.shared.FontLoader;
import ai.tock.shared.IOsKt;
import ai.tock.shared.LoggersKt;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u001e\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\b\b\u0002\u0010\u000e\u001a\u00020\bJ\u0014\u0010\u000f\u001a\u00020\u000b*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lai/tock/shared/FontLoader;", "", "()V", "logger", "Lmu/KLogger;", "createFont", "Ljava/awt/Font;", "path", "", "file", "register", "", "fontFilesNames", "", "fontFilesPath", "registerAndLogFont", "Ljava/awt/GraphicsEnvironment;", "font", "tock-shared"})
public final class FontLoader {
    @NotNull
    public static final FontLoader INSTANCE = new FontLoader();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);

    private FontLoader() {
    }

    /*
     * WARNING - void declaration
     */
    public final void register(@NotNull List<String> fontFilesNames, @NotNull String fontFilesPath) {
        Intrinsics.checkNotNullParameter(fontFilesNames, (String)"fontFilesNames");
        Intrinsics.checkNotNullParameter((Object)fontFilesPath, (String)"fontFilesPath");
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = fontFilesNames;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(INSTANCE.createFont(fontFilesPath, (String)it));
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Font it = (Font)element$iv;
                boolean bl = false;
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                Intrinsics.checkNotNullExpressionValue((Object)graphicsEnvironment, (String)"getLocalGraphicsEnvironment()");
                INSTANCE.registerAndLogFont(graphicsEnvironment, it);
            }
        }
        catch (Throwable t) {
            LoggersKt.error(logger, t);
        }
    }

    public static /* synthetic */ void register$default(FontLoader fontLoader, List list, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "/generation/fonts/";
        }
        fontLoader.register(list, string);
    }

    private final void registerAndLogFont(GraphicsEnvironment $this$registerAndLogFont, Font font) {
        if (!$this$registerAndLogFont.registerFont(font)) {
            logger.error("font " + font + " not loaded");
        } else {
            logger.info("font " + font + " loaded");
        }
    }

    private final Font createFont(String path, String file) {
        Font font = Font.createFont(0, IOsKt.resourceAsStream(path + file));
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"createFont(\n            \u2026am(path + file)\n        )");
        return font;
    }
}

