/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared.cache;

import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.cache.CachesKt;
import ai.tock.shared.cache.TockCache;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.Id;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u001a&\u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\r0\f\u0012\u0004\u0012\u00020\u00010\u000b\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a-\u0010\u0010\u001a\u0004\u0018\u0001H\r\"\b\b\u0000\u0010\r*\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0012\u001a=\u0010\u0013\u001a\u0004\u0018\u0001H\r\"\b\b\u0000\u0010\r*\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\r0\u0015\u00a2\u0006\u0002\u0010\u0016\u001a(\u0010\u0017\u001a\u00020\u0001\"\b\b\u0000\u0010\r*\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a3\u0010\u0018\u001a\u00020\u0019\"\b\b\u0000\u0010\r*\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u0002H\r\u00a2\u0006\u0002\u0010\u001b\u001a&\u0010\u001c\u001a\u00020\u0019\"\b\b\u0000\u0010\r*\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u001b\u0010\u001d\u001a\u0004\u0018\u0001H\r\"\u0004\b\u0000\u0010\r*\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u001e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"NOT_PRESENT", "", "cache", "Lai/tock/shared/cache/TockCache;", "getCache", "()Lai/tock/shared/cache/TockCache;", "inMemoryCache", "Lcom/google/common/cache/Cache;", "logger", "Lmu/KLogger;", "getCachedValuesForType", "", "Lorg/litote/kmongo/Id;", "T", "type", "", "getFromCache", "id", "(Lorg/litote/kmongo/Id;Ljava/lang/String;)Ljava/lang/Object;", "getOrCache", "valueProvider", "Lkotlin/Function0;", "(Lorg/litote/kmongo/Id;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "inMemoryKey", "putInCache", "", "value", "(Lorg/litote/kmongo/Id;Ljava/lang/String;Ljava/lang/Object;)V", "removeFromCache", "replaceNotPresent", "(Ljava/lang/Object;)Ljava/lang/Object;", "tock-shared"})
public final class CachesKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private static final Cache<Object, Object> inMemoryCache;
    @NotNull
    private static final Object NOT_PRESENT;

    private static final TockCache getCache() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (TockCache)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<TockCache>(){}, tag$iv).getValue()).invoke();
    }

    private static final <T> T replaceNotPresent(Object $this$replaceNotPresent) {
        return (T)(Intrinsics.areEqual((Object)$this$replaceNotPresent, (Object)NOT_PRESENT) ? null : $this$replaceNotPresent);
    }

    private static final <T> Object inMemoryKey(Id<T> id, String type) {
        return TuplesKt.to(id, (Object)type);
    }

    @Nullable
    public static final <T> T getOrCache(@NotNull Id<T> id, @NotNull String type, @NotNull Function0<? extends T> valueProvider) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(valueProvider, (String)"valueProvider");
        return CachesKt.replaceNotPresent(inMemoryCache.get(CachesKt.inMemoryKey(id, type), () -> CachesKt.getOrCache$lambda$1(id, type, valueProvider)));
    }

    @Nullable
    public static final <T> T getFromCache(@NotNull Id<T> id, @NotNull String type) {
        T t;
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        try {
            t = CachesKt.replaceNotPresent(inMemoryCache.get(CachesKt.inMemoryKey(id, type), () -> CachesKt.getFromCache$lambda$2(id, type)));
        }
        catch (Exception e) {
            LoggersKt.error(logger, e);
            t = null;
        }
        return t;
    }

    public static final <T> void putInCache(@NotNull Id<T> id, @NotNull String type, @NotNull T value) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        try {
            if (!(value instanceof byte[])) {
                inMemoryCache.put(CachesKt.inMemoryKey(id, type), value);
            }
            CachesKt.getCache().put(id, type, value);
        }
        catch (Exception e) {
            LoggersKt.error(logger, e);
        }
    }

    public static final <T> void removeFromCache(@NotNull Id<T> id, @NotNull String type) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        inMemoryCache.invalidate(CachesKt.inMemoryKey(id, type));
        CachesKt.getCache().remove(id, type);
    }

    @NotNull
    public static final <T> Map<Id<T>, Object> getCachedValuesForType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return CachesKt.getCache().getAll(type);
    }

    private static final Object getOrCache$lambda$1(Id $id, String $type, Function0 $valueProvider) {
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        Intrinsics.checkNotNullParameter((Object)$type, (String)"$type");
        Intrinsics.checkNotNullParameter((Object)$valueProvider, (String)"$valueProvider");
        Object object = CachesKt.getCache().get($id, $type);
        if (object == null) {
            Object object2;
            try {
                Object object3;
                Object object4 = $valueProvider.invoke();
                if (object4 != null) {
                    Object object5;
                    Object $this$getOrCache_u24lambda_u241_u24lambda_u240 = object5 = object4;
                    boolean bl = false;
                    CachesKt.putInCache($id, $type, $this$getOrCache_u24lambda_u241_u24lambda_u240);
                    object3 = object5;
                } else {
                    object3 = null;
                }
                object2 = object3;
            }
            catch (Exception e) {
                LoggersKt.error(logger, e);
                object2 = null;
            }
            if ((object = object2) == null) {
                object = NOT_PRESENT;
            }
        }
        return object;
    }

    private static final Object getFromCache$lambda$2(Id $id, String $type) {
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        Intrinsics.checkNotNullParameter((Object)$type, (String)"$type");
        Object object = CachesKt.getCache().get($id, $type);
        if (object == null) {
            object = NOT_PRESENT;
        }
        return object;
    }

    static {
        Cache cache = CacheBuilder.newBuilder().maximumSize(PropertiesKt.longProperty("tock_cache_in_memory_maximum_size", 10000L)).expireAfterAccess(PropertiesKt.longProperty("tock_cache_in_memory_expiration_in_ms", 3600000L), TimeUnit.MILLISECONDS).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"newBuilder()\n        .ma\u2026       )\n        .build()");
        inMemoryCache = cache;
        NOT_PRESENT = new Object();
    }
}

