/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared.jackson;

import ai.tock.shared.jackson.ConstrainedValueWrapper;
import ai.tock.shared.jackson.ConstrainedValueWrapperKt;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=ConstrainedValueDeserializer.class)
@JsonSerialize(using=ConstrainedValueSerializer.class)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0087\b\u0018\u0000 \u0019*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0003\u0019\u001a\u001bB\u001d\b\u0016\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\b\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000f\u001a\u00020\bH\u00c6\u0003J\u0010\u0010\u0010\u001a\u0004\u0018\u00018\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\b2\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00018\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0005\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lai/tock/shared/jackson/ConstrainedValueWrapper;", "T", "", "klass", "Lkotlin/reflect/KClass;", "value", "(Lkotlin/reflect/KClass;Ljava/lang/Object;)V", "(Ljava/lang/Object;)V", "", "(Ljava/lang/String;Ljava/lang/Object;)V", "getKlass", "()Ljava/lang/String;", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "copy", "(Ljava/lang/String;Ljava/lang/Object;)Lai/tock/shared/jackson/ConstrainedValueWrapper;", "equals", "", "other", "hashCode", "", "toString", "Companion", "ConstrainedValueDeserializer", "ConstrainedValueSerializer", "tock-shared"})
public final class ConstrainedValueWrapper<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String klass;
    @Nullable
    private final T value;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);

    public ConstrainedValueWrapper(@NotNull String klass, @Nullable T value) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        this.klass = klass;
        this.value = value;
    }

    @NotNull
    public final String getKlass() {
        return this.klass;
    }

    @Nullable
    public final T getValue() {
        return this.value;
    }

    public ConstrainedValueWrapper(@NotNull KClass<?> klass, @Nullable T value) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        String string = JvmClassMappingKt.getJavaClass(klass).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"klass.java.name");
        this(string, value);
    }

    public ConstrainedValueWrapper(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this(Reflection.getOrCreateKotlinClass(value.getClass()), value);
    }

    @NotNull
    public final String component1() {
        return this.klass;
    }

    @Nullable
    public final T component2() {
        return this.value;
    }

    @NotNull
    public final ConstrainedValueWrapper<T> copy(@NotNull String klass, @Nullable T value) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return new ConstrainedValueWrapper<T>(klass, value);
    }

    public static /* synthetic */ ConstrainedValueWrapper copy$default(ConstrainedValueWrapper constrainedValueWrapper, String string, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            string = constrainedValueWrapper.klass;
        }
        if ((n & 2) != 0) {
            object = constrainedValueWrapper.value;
        }
        return constrainedValueWrapper.copy(string, object);
    }

    @NotNull
    public String toString() {
        return "ConstrainedValueWrapper(klass=" + this.klass + ", value=" + this.value + ")";
    }

    public int hashCode() {
        int result = this.klass.hashCode();
        result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConstrainedValueWrapper)) {
            return false;
        }
        ConstrainedValueWrapper constrainedValueWrapper = (ConstrainedValueWrapper)other;
        if (!Intrinsics.areEqual((Object)this.klass, (Object)constrainedValueWrapper.klass)) {
            return false;
        }
        return Intrinsics.areEqual(this.value, constrainedValueWrapper.value);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/tock/shared/jackson/ConstrainedValueWrapper$Companion;", "", "()V", "logger", "Lmu/KLogger;", "tock-shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lai/tock/shared/jackson/ConstrainedValueWrapper$ConstrainedValueDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lai/tock/shared/jackson/ConstrainedValueWrapper;", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "tock-shared"})
    public static final class ConstrainedValueDeserializer
    extends JsonDeserializer<ConstrainedValueWrapper<?>> {
        @Nullable
        public ConstrainedValueWrapper<?> deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext context) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            String fieldName = JacksonKt.fieldNameWithValueReady(jp);
            if (fieldName != null) {
                ConstrainedValueWrapper<Object> constrainedValueWrapper;
                Object replace;
                try {
                    String string = jp.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jp.text");
                    replace = StringsKt.replace$default((String)string, (String)"fr.vsct.tock", (String)"ai.tock", (boolean)false, (int)4, null);
                    if (!ConstrainedValueWrapperKt.access$getConstrainedTypes$p().contains(replace)) {
                        throw new AssertionError((Object)("unregister class: " + (String)replace));
                    }
                    replace = Class.forName((String)replace);
                }
                catch (Exception e) {
                    logger.warn("deserialization error for class " + e.getMessage());
                    replace = null;
                }
                String classValue = replace;
                fieldName = JacksonKt.fieldNameWithValueReady(jp);
                if (fieldName != null) {
                    if (classValue == null) {
                        if (jp.getCurrentToken().isStructStart()) {
                            jp.skipChildren();
                        }
                        jp.nextToken();
                        JacksonKt.checkEndToken(jp);
                        return null;
                    }
                    Object value = jp.readValueAs((Class)((Object)classValue));
                    JacksonKt.checkEndToken(jp);
                    String string = ((Class)((Object)classValue)).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classValue.name");
                    return new ConstrainedValueWrapper<Object>(string, value);
                }
                JacksonKt.checkEndToken(jp);
                if (classValue == null) {
                    constrainedValueWrapper = null;
                } else {
                    String string = ((Class)((Object)classValue)).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classValue.name");
                    constrainedValueWrapper = new ConstrainedValueWrapper<Object>(string, null);
                }
                return constrainedValueWrapper;
            }
            return null;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lai/tock/shared/jackson/ConstrainedValueWrapper$ConstrainedValueSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lai/tock/shared/jackson/ConstrainedValueWrapper;", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "tock-shared"})
    public static final class ConstrainedValueSerializer
    extends JsonSerializer<ConstrainedValueWrapper<?>> {
        public void serialize(@NotNull ConstrainedValueWrapper<?> value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
            gen.writeStartObject();
            gen.writeFieldName("klass");
            gen.writeString(value.getKlass());
            serializers.defaultSerializeField("value", value.getValue(), gen);
            gen.writeEndObject();
        }
    }
}

