/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared.security.auth;

import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.jackson.JacksonKt;
import ai.tock.shared.security.TockUser;
import ai.tock.shared.security.TockUserListener;
import ai.tock.shared.security.auth.CASAuthProvider;
import ai.tock.shared.security.auth.SSOTockAuthProvider;
import ai.tock.shared.security.auth.WithExcludedPathHandler;
import ai.tock.shared.vertx.WebVerticle;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.LocalSessionStore;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.vertx.auth.Pac4jAuthProvider;
import org.pac4j.vertx.auth.Pac4jUser;
import org.pac4j.vertx.context.session.VertxSessionStore;
import org.pac4j.vertx.handler.impl.CallbackHandler;
import org.pac4j.vertx.handler.impl.CallbackHandlerOptions;
import org.pac4j.vertx.handler.impl.SecurityHandler;
import org.pac4j.vertx.handler.impl.SecurityHandlerOptions;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 92\u00020\u0001:\u00029:B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u0016H\u0016J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010!\u001a\u00020\"H&J\"\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J&\u0010*\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u000200H&J\"\u00101\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u001f022\u0006\u0010/\u001a\u000200H&J*\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00062\u0018\u00106\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u001f02H\u0004J$\u00107\u001a\u00020\u00122\u0006\u0010/\u001a\u0002002\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u000204080\u0016H\u0014R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006;"}, d2={"Lai/tock/shared/security/auth/CASAuthProvider;", "Lai/tock/shared/security/auth/SSOTockAuthProvider;", "vertx", "Lio/vertx/core/Vertx;", "(Lio/vertx/core/Vertx;)V", "enabledPacAuthorizers", "", "getEnabledPacAuthorizers", "()Ljava/lang/String;", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "sessionStore", "Lorg/pac4j/vertx/context/session/VertxSessionStore;", "getSessionStore", "()Lorg/pac4j/vertx/context/session/VertxSessionStore;", "authenticate", "", "authInfo", "Lio/vertx/core/json/JsonObject;", "resultHandler", "Lio/vertx/core/Handler;", "Lio/vertx/core/AsyncResult;", "Lio/vertx/ext/auth/User;", "callbackPath", "verticle", "Lai/tock/shared/vertx/WebVerticle;", "createAuthHandler", "Lio/vertx/ext/web/handler/AuthenticationHandler;", "excludedPaths", "", "Lkotlin/text/Regex;", "getConfig", "Lorg/pac4j/core/config/Config;", "handleUpgradeFailure", "rc", "Lio/vertx/ext/web/RoutingContext;", "code", "", "cause", "", "protectPaths", "pathsToProtect", "sessionHandler", "Lio/vertx/ext/web/handler/SessionHandler;", "readCasLogin", "user", "Lorg/pac4j/vertx/auth/Pac4jUser;", "readRolesByNamespace", "", "registerTockUser", "Lai/tock/shared/security/TockUser;", "username", "rolesByNamespace", "upgradeToTockUser", "Lai/tock/shared/security/auth/CASAuthProvider$HttpResult;", "Companion", "HttpResult", "tock-shared"})
@SourceDebugExtension(value={"SMAP\nCASAuthProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CASAuthProvider.kt\nai/tock/shared/security/auth/CASAuthProvider\n+ 2 IOCs.kt\nai/tock/shared/IOCsKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,212:1\n53#2,2:213\n53#2,2:217\n51#3:215\n51#3:219\n277#4:216\n277#4:220\n*S KotlinDebug\n*F\n+ 1 CASAuthProvider.kt\nai/tock/shared/security/auth/CASAuthProvider\n*L\n38#1:213,2\n128#1:217,2\n38#1:215\n128#1:219\n38#1:216\n128#1:220\n*E\n"})
public abstract class CASAuthProvider
extends SSOTockAuthProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VertxSessionStore sessionStore;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
    private static final boolean isJoinNamespace = PropertiesKt.booleanProperty("tock_cas_join_same_namespace_per_user", true);

    public CASAuthProvider(@NotNull Vertx vertx) {
        boolean isBehindProxy;
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        super(vertx);
        LocalSessionStore vertxSessionStore = LocalSessionStore.create((Vertx)vertx);
        this.sessionStore = new VertxSessionStore((io.vertx.ext.web.sstore.SessionStore)vertxSessionStore);
        boolean bl = isBehindProxy = PropertiesKt.propertyExists("tock_cas_auth_proxy_host") && PropertiesKt.propertyExists("tock_cas_auth_proxy_port");
        if (isBehindProxy) {
            logger.debug((Function0)1.INSTANCE);
            String proxyHost = PropertiesKt.property("tock_cas_auth_proxy_host", "127.0.0.1");
            int proxyPort = PropertiesKt.intProperty("tock_cas_auth_proxy_port", 3128);
            System.setProperty("https.proxyHost", proxyHost);
            String string = "%d";
            Object[] objectArray = new Object[]{proxyPort};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            System.setProperty("https.proxyPort", string2);
        }
    }

    @NotNull
    protected final VertxSessionStore getSessionStore() {
        return this.sessionStore;
    }

    private final Executor getExecutor() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (Executor)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<Executor>(){}, tag$iv).getValue()).invoke();
    }

    @NotNull
    public String getEnabledPacAuthorizers() {
        return "isAuthenticated";
    }

    public void handleUpgradeFailure(@NotNull RoutingContext rc, int code, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)rc, (String)"rc");
        if (cause == null) {
            logger.error("Caught by default CAS mapping exception handler: " + code);
            rc.fail(code);
        } else {
            logger.error("Caught by default CAS mapping exception handler", cause);
            rc.fail(code, cause);
        }
    }

    @NotNull
    public abstract Config getConfig();

    @NotNull
    public abstract String readCasLogin(@NotNull Pac4jUser var1);

    @NotNull
    public abstract Map<String, Set<String>> readRolesByNamespace(@NotNull Pac4jUser var1);

    @Override
    @NotNull
    public AuthenticationHandler createAuthHandler(@NotNull WebVerticle verticle) {
        Intrinsics.checkNotNullParameter((Object)((Object)verticle), (String)"verticle");
        SecurityHandlerOptions securityHandlerOptions = new SecurityHandlerOptions().setClients("CasClient");
        Intrinsics.checkNotNullExpressionValue((Object)securityHandlerOptions, (String)"SecurityHandlerOptions().setClients(\"CasClient\")");
        SecurityHandlerOptions options = securityHandlerOptions;
        options.setAuthorizers(this.getEnabledPacAuthorizers());
        return (AuthenticationHandler)new SecurityHandler(this.getVertx(), (SessionStore)this.sessionStore, this.getConfig(), new Pac4jAuthProvider(), options);
    }

    public void authenticate(@NotNull JsonObject authInfo, @NotNull Handler<AsyncResult<User>> resultHandler) {
        Intrinsics.checkNotNullParameter((Object)authInfo, (String)"authInfo");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        resultHandler.handle((Object)Future.failedFuture((String)"Unauthorized"));
    }

    @NotNull
    protected final TockUser registerTockUser(@NotNull String username, @NotNull Map<String, ? extends Set<String>> rolesByNamespace) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter(rolesByNamespace, (String)"rolesByNamespace");
        TockUser user = null;
        for (Map.Entry<String, ? extends Set<String>> entry : rolesByNamespace.entrySet()) {
            String namespace = entry.getKey();
            Set<String> roles = entry.getValue();
            KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
            Object tag$iv = null;
            boolean $i$f$provide = false;
            KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
            KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
            user = ((TockUserListener)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<TockUserListener>(){}, tag$iv).getValue()).invoke()).registerUser(new TockUser(username, namespace, roles, false, 8, null), isJoinNamespace);
        }
        TockUser tockUser = user;
        Intrinsics.checkNotNull(tockUser);
        return tockUser;
    }

    protected void upgradeToTockUser(@NotNull Pac4jUser user, @NotNull Handler<HttpResult<TockUser>> resultHandler) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        try {
            String username = this.readCasLogin(user);
            Map<String, Set<String>> rolesByNamespace = this.readRolesByNamespace(user);
            logger.debug((Function0)new Function0<Object>(username, rolesByNamespace){
                final /* synthetic */ String $username;
                final /* synthetic */ Map<String, Set<String>> $rolesByNamespace;
                {
                    this.$username = $username;
                    this.$rolesByNamespace = $rolesByNamespace;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "authenticate " + this.$username + "/" + this.$rolesByNamespace;
                }
            });
            if (rolesByNamespace.keySet().isEmpty()) {
                IllegalStateException error = new IllegalStateException("No namespace found in registered user profil");
                logger.trace("Unable to upgrade to tock user", (Throwable)error);
                resultHandler.handle(new HttpResult<Object>(null, error, 401));
                return;
            }
            TockUser tockUser = this.registerTockUser(username, rolesByNamespace);
            resultHandler.handle(new HttpResult<TockUser>(tockUser, null, 200));
        }
        catch (Exception exc) {
            logger.trace("Unable to upgrade to tock user", (Throwable)exc);
            resultHandler.handle(new HttpResult<Object>(null, exc, 500));
        }
    }

    @Override
    @NotNull
    public AuthenticationHandler protectPaths(@NotNull WebVerticle verticle, @NotNull Set<String> pathsToProtect, @NotNull SessionHandler sessionHandler) {
        Intrinsics.checkNotNullParameter((Object)((Object)verticle), (String)"verticle");
        Intrinsics.checkNotNullParameter(pathsToProtect, (String)"pathsToProtect");
        Intrinsics.checkNotNullParameter((Object)sessionHandler, (String)"sessionHandler");
        AuthenticationHandler authHandler = super.protectPaths(verticle, pathsToProtect, sessionHandler);
        Set<Regex> excluded = this.excludedPaths(verticle);
        verticle.getRouter().route("/*").handler((Handler)new WithExcludedPathHandler(excluded, (Handler<RoutingContext>)((Handler)sessionHandler)));
        verticle.getRouter().route("/*").handler((Handler)new WithExcludedPathHandler(excluded, (Handler<RoutingContext>)((Handler)authHandler)));
        verticle.getRouter().route("/*").handler((Handler)new WithExcludedPathHandler(excluded, (Handler<RoutingContext>)((Handler)arg_0 -> CASAuthProvider.protectPaths$lambda$0(this, arg_0))));
        WebVerticle $this$protectPaths_u24lambda_u242 = verticle;
        boolean bl = false;
        $this$protectPaths_u24lambda_u242.getRouter().get($this$protectPaths_u24lambda_u242.getBasePath() + "/user").handler(arg_0 -> CASAuthProvider.protectPaths$lambda$2$lambda$1(this, arg_0));
        CallbackHandlerOptions callbackHandlerOptions = new CallbackHandlerOptions().setMultiProfile(Boolean.valueOf(false));
        CallbackHandler callbackHandler = new CallbackHandler($this$protectPaths_u24lambda_u242.getVertx(), (SessionStore)this.sessionStore, this.getConfig(), callbackHandlerOptions);
        String callbackPath = this.callbackPath(verticle);
        $this$protectPaths_u24lambda_u242.getRouter().get(callbackPath).handler((Handler)sessionHandler);
        $this$protectPaths_u24lambda_u242.getRouter().get(callbackPath).handler((Handler)callbackHandler);
        $this$protectPaths_u24lambda_u242.getRouter().post(callbackPath).handler((Handler)sessionHandler);
        $this$protectPaths_u24lambda_u242.getRouter().post(callbackPath).handler((Handler)BodyHandler.create().setMergeFormAttributes(true));
        $this$protectPaths_u24lambda_u242.getRouter().post(callbackPath).handler((Handler)callbackHandler);
        return authHandler;
    }

    @Override
    @NotNull
    public Set<Regex> excludedPaths(@NotNull WebVerticle verticle) {
        Intrinsics.checkNotNullParameter((Object)((Object)verticle), (String)"verticle");
        return SetsKt.plus(super.excludedPaths(verticle), (Object)new Regex(this.callbackPath(verticle)));
    }

    private final String callbackPath(WebVerticle verticle) {
        return verticle.getBasePath() + "/callback";
    }

    private static final void protectPaths$lambda$0(CASAuthProvider this$0, RoutingContext rc) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        User user = rc.user();
        if (user != null && !(user instanceof TockUser)) {
            this$0.getExecutor().executeBlocking((Function0<Unit>)((Function0)new Function0<Unit>(this$0, user, rc){
                final /* synthetic */ CASAuthProvider this$0;
                final /* synthetic */ User $user;
                final /* synthetic */ RoutingContext $rc;
                {
                    this.this$0 = $receiver;
                    this.$user = $user;
                    this.$rc = $rc;
                    super(0);
                }

                public final void invoke() {
                    User user = this.$user;
                    Intrinsics.checkNotNull((Object)user, (String)"null cannot be cast to non-null type org.pac4j.vertx.auth.Pac4jUser");
                    this.this$0.upgradeToTockUser((Pac4jUser)user, (Handler<HttpResult<TockUser>>)((Handler)arg_0 -> protectPaths.1.1.invoke$lambda$0(this.$rc, this.this$0, arg_0)));
                }

                private static final void invoke$lambda$0(RoutingContext $rc, CASAuthProvider this$0, HttpResult it) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    if (it.succeeded()) {
                        $rc.setUser((User)it.getResult());
                        $rc.next();
                    } else {
                        $rc.clearUser();
                        $rc.session().destroy();
                        Intrinsics.checkNotNullExpressionValue((Object)$rc, (String)"rc");
                        this$0.handleUpgradeFailure($rc, it.getCode(), it.getCause());
                    }
                }
            }));
        } else {
            rc.next();
        }
    }

    private static final void protectPaths$lambda$2$lambda$1(CASAuthProvider this$0, RoutingContext it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        HttpServerResponse httpServerResponse = it.response();
        ObjectMapper objectMapper = JacksonKt.getMapper();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        httpServerResponse.end(objectMapper.writeValueAsString((Object)this$0.toTockUser(it)));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lai/tock/shared/security/auth/CASAuthProvider$Companion;", "", "()V", "isJoinNamespace", "", "()Z", "logger", "Lmu/KLogger;", "tock-shared"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isJoinNamespace() {
            return isJoinNamespace;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B!\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00018\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J6\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00018\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001J\u0006\u0010\u0019\u001a\u00020\u0016J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lai/tock/shared/security/auth/CASAuthProvider$HttpResult;", "T", "", "result", "cause", "", "code", "", "(Ljava/lang/Object;Ljava/lang/Throwable;I)V", "getCause", "()Ljava/lang/Throwable;", "getCode", "()I", "getResult", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "component3", "copy", "(Ljava/lang/Object;Ljava/lang/Throwable;I)Lai/tock/shared/security/auth/CASAuthProvider$HttpResult;", "equals", "", "other", "hashCode", "succeeded", "toString", "", "tock-shared"})
    protected static final class HttpResult<T> {
        @Nullable
        private final T result;
        @Nullable
        private final Throwable cause;
        private final int code;

        public HttpResult(@Nullable T result, @Nullable Throwable cause, int code) {
            this.result = result;
            this.cause = cause;
            this.code = code;
        }

        @Nullable
        public final T getResult() {
            return this.result;
        }

        @Nullable
        public final Throwable getCause() {
            return this.cause;
        }

        public final int getCode() {
            return this.code;
        }

        public final boolean succeeded() {
            return this.code / 100 == 2;
        }

        @Nullable
        public final T component1() {
            return this.result;
        }

        @Nullable
        public final Throwable component2() {
            return this.cause;
        }

        public final int component3() {
            return this.code;
        }

        @NotNull
        public final HttpResult<T> copy(@Nullable T result, @Nullable Throwable cause, int code) {
            return new HttpResult<T>(result, cause, code);
        }

        public static /* synthetic */ HttpResult copy$default(HttpResult httpResult, Object object, Throwable throwable, int n, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                object = httpResult.result;
            }
            if ((n2 & 2) != 0) {
                throwable = httpResult.cause;
            }
            if ((n2 & 4) != 0) {
                n = httpResult.code;
            }
            return httpResult.copy(object, throwable, n);
        }

        @NotNull
        public String toString() {
            return "HttpResult(result=" + this.result + ", cause=" + this.cause + ", code=" + this.code + ")";
        }

        public int hashCode() {
            int result = this.result == null ? 0 : this.result.hashCode();
            result = result * 31 + (this.cause == null ? 0 : this.cause.hashCode());
            result = result * 31 + Integer.hashCode(this.code);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HttpResult)) {
                return false;
            }
            HttpResult httpResult = (HttpResult)other;
            if (!Intrinsics.areEqual(this.result, httpResult.result)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cause, (Object)httpResult.cause)) {
                return false;
            }
            return this.code == httpResult.code;
        }
    }
}

