/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared.vertx;

import ai.tock.shared.Executor;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.vertx.VertXsKt;
import io.vertx.core.AsyncResult;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.slf4j.MDCContext;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.MDC;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0012\u001a\u00020\u0013H\u0000\u001aD\u0010\u0014\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u0016*\u00020\u00072\u0018\u0010\u0017\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u0019\u0012\u0004\u0012\u00020\u00150\u00182\u0018\u0010\u001a\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u001b\u0012\u0004\u0012\u00020\u00150\u0018\u001a\u001e\u0010\u0014\u001a\u00020\u001c*\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00150\u0018\"\u001a\u0010\u0000\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0004\b\u0004\u0010\u0005\"\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\"\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000e\u001a\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\"\u0011\u0010\u0010\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u001f"}, d2={"defaultVertxOptions", "Lio/vertx/core/VertxOptions;", "getDefaultVertxOptions", "()Lio/vertx/core/VertxOptions;", "setDefaultVertxOptions", "(Lio/vertx/core/VertxOptions;)V", "internalVertx", "Lio/vertx/core/Vertx;", "getInternalVertx", "()Lio/vertx/core/Vertx;", "internalVertx$delegate", "Lkotlin/Lazy;", "logger", "Lmu/KLogger;", "sharedVertx", "getSharedVertx", "vertx", "getVertx", "vertxExecutor", "Lai/tock/shared/Executor;", "blocking", "", "T", "blockingHandler", "Lkotlin/Function1;", "Lio/vertx/core/Promise;", "resultHandler", "Lio/vertx/core/AsyncResult;", "Lio/vertx/ext/web/Route;", "handler", "Lio/vertx/ext/web/RoutingContext;", "tock-shared"})
public final class VertXsKt {
    @NotNull
    private static final KLogger logger;
    @NotNull
    private static VertxOptions defaultVertxOptions;
    @NotNull
    private static final Lazy internalVertx$delegate;

    @NotNull
    public static final VertxOptions getDefaultVertxOptions() {
        return defaultVertxOptions;
    }

    public static final void setDefaultVertxOptions(@NotNull VertxOptions vertxOptions) {
        Intrinsics.checkNotNullParameter((Object)vertxOptions, (String)"<set-?>");
        defaultVertxOptions = vertxOptions;
    }

    private static final Vertx getInternalVertx() {
        Lazy lazy = internalVertx$delegate;
        return (Vertx)lazy.getValue();
    }

    @NotNull
    public static final Vertx getSharedVertx() {
        return VertXsKt.getVertx();
    }

    @NotNull
    public static final Vertx getVertx() {
        return VertXsKt.getInternalVertx();
    }

    public static final <T> void blocking(@NotNull Vertx $this$blocking, @NotNull Function1<? super Promise<T>, Unit> blockingHandler, @NotNull Function1<? super AsyncResult<T>, Unit> resultHandler) {
        Intrinsics.checkNotNullParameter((Object)$this$blocking, (String)"<this>");
        Intrinsics.checkNotNullParameter(blockingHandler, (String)"blockingHandler");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        $this$blocking.executeBlocking(arg_0 -> VertXsKt.blocking$lambda$1(blockingHandler, arg_0), false, arg_0 -> VertXsKt.blocking$lambda$2(resultHandler, arg_0));
    }

    @NotNull
    public static final Route blocking(@NotNull Route $this$blocking, @NotNull Function1<? super RoutingContext, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)$this$blocking, (String)"<this>");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Route route = $this$blocking.blockingHandler(arg_0 -> VertXsKt.blocking$lambda$3(handler, arg_0), false);
        Intrinsics.checkNotNullExpressionValue((Object)route, (String)"blockingHandler(\n       \u2026   },\n        false\n    )");
        return route;
    }

    @NotNull
    public static final Executor vertxExecutor() {
        return new Executor(){

            public void executeBlocking(@NotNull Duration delay, @NotNull Function0<Unit> runnable) {
                Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
                Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
                if (delay.isZero()) {
                    this.executeBlocking(runnable);
                } else {
                    Map loggingContext = new MDCContext(null, 1, null).getContextMap();
                    VertXsKt.getVertx().setTimer(delay.toMillis(), arg_0 -> vertxExecutor.1.executeBlocking$lambda$0(this, loggingContext, runnable, arg_0));
                }
            }

            public void executeBlocking(@NotNull Function0<Unit> runnable) {
                Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
                Map loggingContext = new MDCContext(null, 1, null).getContextMap();
                VertXsKt.blocking(VertXsKt.getVertx(), (Function1)new Function1<Promise<Unit>, Unit>(this, (Map<String, String>)loggingContext, runnable){
                    final /* synthetic */ vertxExecutor.1 this$0;
                    final /* synthetic */ Map<String, String> $loggingContext;
                    final /* synthetic */ Function0<Unit> $runnable;
                    {
                        this.this$0 = $receiver;
                        this.$loggingContext = $loggingContext;
                        this.$runnable = $runnable;
                        super(1);
                    }

                    public final void invoke(@NotNull Promise<Unit> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        vertxExecutor.1.access$invokeWithLoggingContext(this.this$0, this.$loggingContext, (Function0)new Function0<Unit>(this.this$0, this.$runnable, it){
                            final /* synthetic */ vertxExecutor.1 this$0;
                            final /* synthetic */ Function0<Unit> $runnable;
                            final /* synthetic */ Promise<Unit> $it;
                            {
                                this.this$0 = $receiver;
                                this.$runnable = $runnable;
                                this.$it = $it;
                                super(0);
                            }

                            public final void invoke() {
                                vertxExecutor.1.access$catchableRunnable(this.this$0, this.$runnable).invoke();
                                this.$it.tryComplete();
                            }
                        });
                    }
                }, vertxExecutor.executeBlocking.3.INSTANCE);
            }

            public <T> void executeBlocking(@NotNull Callable<T> blocking2, @NotNull Function1<? super T, Unit> result) {
                Intrinsics.checkNotNullParameter(blocking2, (String)"blocking");
                Intrinsics.checkNotNullParameter(result, (String)"result");
                Map loggingContext = new MDCContext(null, 1, null).getContextMap();
                VertXsKt.blocking(VertXsKt.getVertx(), (Function1)new Function1<Promise<T>, Unit>(this, (Map<String, String>)loggingContext, blocking2){
                    final /* synthetic */ vertxExecutor.1 this$0;
                    final /* synthetic */ Map<String, String> $loggingContext;
                    final /* synthetic */ Callable<T> $blocking;
                    {
                        this.this$0 = $receiver;
                        this.$loggingContext = $loggingContext;
                        this.$blocking = $blocking;
                        super(1);
                    }

                    public final void invoke(@NotNull Promise<T> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        vertxExecutor.1.access$invokeWithLoggingContext(this.this$0, this.$loggingContext, (Function0)new Function0<Unit>(this.$blocking, it){
                            final /* synthetic */ Callable<T> $blocking;
                            final /* synthetic */ Promise<T> $it;
                            {
                                this.$blocking = $blocking;
                                this.$it = $it;
                                super(0);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final void invoke() {
                                try {
                                    this.$blocking.call();
                                }
                                finally {
                                    this.$it.tryFail("call not completed");
                                }
                            }
                        });
                    }
                }, (Function1)new Function1<AsyncResult<T>, Unit>(result){
                    final /* synthetic */ Function1<T, Unit> $result;
                    {
                        this.$result = $result;
                        super(1);
                    }

                    public final void invoke(@NotNull AsyncResult<T> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        if (it.succeeded()) {
                            this.$result.invoke(it.result());
                        } else {
                            this.$result.invoke(null);
                        }
                    }
                });
            }

            public long setPeriodic(@NotNull Duration initialDelay, @NotNull Duration delay, @NotNull Function0<Unit> runnable) {
                Intrinsics.checkNotNullParameter((Object)initialDelay, (String)"initialDelay");
                Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
                Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
                Map loggingContext = new MDCContext(null, 1, null).getContextMap();
                return VertXsKt.getVertx().setTimer(initialDelay.toMillis(), arg_0 -> vertxExecutor.1.setPeriodic$lambda$1(this, loggingContext, runnable, delay, arg_0));
            }

            private final Function0<Unit> catchableRunnable(Function0<Unit> runnable) {
                return (Function0)new Function0<Unit>(runnable){
                    final /* synthetic */ Function0<Unit> $runnable;
                    {
                        this.$runnable = $runnable;
                        super(0);
                    }

                    public final void invoke() {
                        try {
                            this.$runnable.invoke();
                        }
                        catch (Throwable throwable) {
                            LoggersKt.error(VertXsKt.access$getLogger$p(), throwable);
                        }
                    }
                };
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            private final void invokeWithLoggingContext(Map<String, String> loggingContext, Function0<Unit> runnable) {
                Function0<Unit> r = this.catchableRunnable(runnable);
                Map<String, String> context = loggingContext;
                boolean bl = false;
                if (context == null) {
                    r.invoke();
                } else {
                    Iterator<Map.Entry<String, String>> $this$mapTo$iv$iv$iv;
                    boolean restorePrevious$iv = true;
                    boolean $i$f$withLoggingContext = false;
                    Map<String, String> $this$map$iv$iv = context;
                    boolean $i$f$map = false;
                    Map<String, String> map = $this$map$iv$iv;
                    Collection destination$iv$iv$iv = new ArrayList<E>($this$map$iv$iv.size());
                    boolean $i$f$mapTo = false;
                    Iterator<Map.Entry<K, V>> iterator = $this$mapTo$iv$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void it$iv;
                        Map.Entry<K, V> item$iv$iv$iv;
                        Map.Entry<K, V> entry = item$iv$iv$iv = iterator.next();
                        Collection collection = destination$iv$iv$iv;
                        boolean bl2 = false;
                        String mdcValue$iv = MDC.get((String)((String)it$iv.getKey()));
                        collection.add(mdcValue$iv != null ? (Function0)new Function0<Unit>((Map.Entry)it$iv, mdcValue$iv){
                            final /* synthetic */ Map.Entry $it;
                            final /* synthetic */ String $mdcValue;
                            {
                                this.$it = entry;
                                this.$mdcValue = string;
                                super(0);
                            }

                            public final void invoke() {
                                MDC.put((String)((String)this.$it.getKey()), (String)this.$mdcValue);
                            }
                        } : (Function0)new Function0<Unit>((Map.Entry)it$iv){
                            final /* synthetic */ Map.Entry $it;
                            {
                                this.$it = entry;
                                super(0);
                            }

                            public final void invoke() {
                                MDC.remove((String)((String)this.$it.getKey()));
                            }
                        });
                    }
                    List cleanupCallbacks$iv = (List)destination$iv$iv$iv;
                    try {
                        Map<String, String> $this$forEach$iv$iv = context;
                        boolean $i$f$forEach = false;
                        $this$mapTo$iv$iv$iv = $this$forEach$iv$iv.entrySet().iterator();
                        while ($this$mapTo$iv$iv$iv.hasNext()) {
                            Map.Entry<String, String> element$iv$iv;
                            Map.Entry<String, String> it$iv = element$iv$iv = $this$mapTo$iv$iv$iv.next();
                            boolean bl3 = false;
                            if (it$iv.getValue() == null) continue;
                            MDC.put((String)it$iv.getKey(), (String)it$iv.getValue());
                        }
                        Object object = r.invoke();
                    }
                    finally {
                        Iterable $this$forEach$iv$iv = cleanupCallbacks$iv;
                        boolean $i$f$forEach = false;
                        for (T element$iv$iv : $this$forEach$iv$iv) {
                            Function0 it$iv = (Function0)element$iv$iv;
                            boolean bl4 = false;
                            it$iv.invoke();
                        }
                    }
                }
            }

            public long setPeriodic(@NotNull Duration delay, @NotNull Function0<Unit> runnable) {
                return Executor.DefaultImpls.setPeriodic(this, delay, runnable);
            }

            private static final void executeBlocking$lambda$0(vertxExecutor.1 this$0, Map $loggingContext, Function0 $runnable, Long it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
                this$0.invokeWithLoggingContext($loggingContext, (Function0<Unit>)((Function0)new Function0<Unit>(this$0, (Function0<Unit>)$runnable){
                    final /* synthetic */ vertxExecutor.1 this$0;
                    final /* synthetic */ Function0<Unit> $runnable;
                    {
                        this.this$0 = $receiver;
                        this.$runnable = $runnable;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.executeBlocking(this.$runnable);
                    }
                }));
            }

            private static final void setPeriodic$lambda$1(vertxExecutor.1 this$0, Map $loggingContext, Function0 $runnable, Duration $delay, Long it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
                Intrinsics.checkNotNullParameter((Object)$delay, (String)"$delay");
                this$0.invokeWithLoggingContext($loggingContext, (Function0<Unit>)((Function0)new Function0<Unit>(this$0, (Function0<Unit>)$runnable, $delay, (Map<String, String>)$loggingContext){
                    final /* synthetic */ vertxExecutor.1 this$0;
                    final /* synthetic */ Function0<Unit> $runnable;
                    final /* synthetic */ Duration $delay;
                    final /* synthetic */ Map<String, String> $loggingContext;
                    {
                        this.this$0 = $receiver;
                        this.$runnable = $runnable;
                        this.$delay = $delay;
                        this.$loggingContext = $loggingContext;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.executeBlocking(this.$runnable);
                        VertXsKt.getVertx().setPeriodic(this.$delay.toMillis(), arg_0 -> vertxExecutor.setPeriodic.1.1.invoke$lambda$0(this.this$0, this.$loggingContext, this.$runnable, arg_0));
                    }

                    private static final void invoke$lambda$0(vertxExecutor.1 this$0, Map $loggingContext, Function0 $runnable, Long it) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
                        vertxExecutor.1.access$invokeWithLoggingContext(this$0, $loggingContext, (Function0)new Function0<Unit>(this$0, (Function0<Unit>)$runnable){
                            final /* synthetic */ vertxExecutor.1 this$0;
                            final /* synthetic */ Function0<Unit> $runnable;
                            {
                                this.this$0 = $receiver;
                                this.$runnable = $runnable;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.executeBlocking(this.$runnable);
                            }
                        });
                    }
                }));
            }

            public static final /* synthetic */ void access$invokeWithLoggingContext(vertxExecutor.1 $this, Map loggingContext, Function0 runnable) {
                $this.invokeWithLoggingContext(loggingContext, (Function0<Unit>)runnable);
            }

            public static final /* synthetic */ Function0 access$catchableRunnable(vertxExecutor.1 $this, Function0 runnable) {
                return $this.catchableRunnable((Function0<Unit>)runnable);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void blocking$lambda$1(Function1 $blockingHandler, Promise future) {
        Intrinsics.checkNotNullParameter((Object)$blockingHandler, (String)"$blockingHandler");
        Intrinsics.checkNotNullParameter((Object)future, (String)"future");
        try {
            $blockingHandler.invoke((Object)future);
        }
        catch (Throwable throwable) {
            logger.error(throwable, (Function0)new Function0<Object>(throwable){
                final /* synthetic */ Throwable $throwable;
                {
                    this.$throwable = $throwable;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$throwable.getMessage();
                }
            });
            future.fail(throwable);
        }
        finally {
            future.tryFail("call not completed");
        }
    }

    private static final void blocking$lambda$2(Function1 $resultHandler, AsyncResult it) {
        Intrinsics.checkNotNullParameter((Object)$resultHandler, (String)"$resultHandler");
        try {
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            $resultHandler.invoke((Object)it);
        }
        catch (Throwable e) {
            logger.error(e, (Function0)new Function0<Object>(e){
                final /* synthetic */ Throwable $e;
                {
                    this.$e = $e;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return this.$e.getMessage();
                }
            });
        }
    }

    private static final void blocking$lambda$3(Function1 $handler, RoutingContext it) {
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        try {
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            $handler.invoke((Object)it);
        }
        catch (Throwable t) {
            try {
                LoggersKt.error(logger, t);
                it.fail(t);
            }
            catch (Throwable e) {
                LoggersKt.debug(logger, e);
            }
        }
    }

    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }

    static {
        VertxOptions vertxOptions;
        logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        VertxOptions $this$defaultVertxOptions_u24lambda_u240 = vertxOptions = new VertxOptions();
        boolean bl = false;
        $this$defaultVertxOptions_u24lambda_u240.setMaxWorkerExecuteTime(60000000000000L);
        $this$defaultVertxOptions_u24lambda_u240.setWorkerPoolSize(PropertiesKt.intProperty("tock_vertx_worker_pool_size", 20));
        if (PropertiesKt.getDevEnvironment()) {
            $this$defaultVertxOptions_u24lambda_u240.setWarningExceptionTime(1000000000000L);
        }
        defaultVertxOptions = vertxOptions;
        internalVertx$delegate = LazyKt.lazy((Function0)internalVertx.2.INSTANCE);
    }
}

