/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared.security.auth;

import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.jackson.JacksonKt;
import ai.tock.shared.security.TockUser;
import ai.tock.shared.security.TockUserListener;
import ai.tock.shared.security.auth.SSOTockAuthProvider;
import ai.tock.shared.security.auth.WithExcludedPathHandler;
import ai.tock.shared.vertx.WebVerticle;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.LocalSessionStore;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.vertx.auth.Pac4jAuthProvider;
import org.pac4j.vertx.auth.Pac4jUser;
import org.pac4j.vertx.context.session.VertxSessionStore;
import org.pac4j.vertx.handler.impl.CallbackHandler;
import org.pac4j.vertx.handler.impl.CallbackHandlerOptions;
import org.pac4j.vertx.handler.impl.SecurityHandler;
import org.pac4j.vertx.handler.impl.SecurityHandlerOptions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 :2\u00020\u0001:\u0002:;B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH&J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH&J\"\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0!0 2\u0006\u0010\u001d\u001a\u00020\u001eH&J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J$\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(2\u0012\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0+0*H\u0016J*\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u000f2\u0018\u00100\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0!0 H\u0004J$\u00101\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020.020*H\u0014J&\u00103\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000f0!2\u0006\u00105\u001a\u000206H\u0016J\u0016\u00107\u001a\b\u0012\u0004\u0012\u0002080!2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u00109\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006<"}, d2={"Lai/tock/shared/security/auth/CASAuthProvider;", "Lai/tock/shared/security/auth/SSOTockAuthProvider;", "vertx", "Lio/vertx/core/Vertx;", "<init>", "(Lio/vertx/core/Vertx;)V", "sessionStore", "Lorg/pac4j/vertx/context/session/VertxSessionStore;", "getSessionStore", "()Lorg/pac4j/vertx/context/session/VertxSessionStore;", "executor", "Lai/tock/shared/Executor;", "getExecutor", "()Lai/tock/shared/Executor;", "enabledPacAuthorizers", "", "getEnabledPacAuthorizers", "()Ljava/lang/String;", "handleUpgradeFailure", "", "rc", "Lio/vertx/ext/web/RoutingContext;", "code", "", "cause", "", "getConfig", "Lorg/pac4j/core/config/Config;", "readCasLogin", "user", "Lorg/pac4j/vertx/auth/Pac4jUser;", "readRolesByNamespace", "", "", "createAuthHandler", "Lio/vertx/ext/web/handler/AuthenticationHandler;", "verticle", "Lai/tock/shared/vertx/WebVerticle;", "authenticate", "authInfo", "Lio/vertx/core/json/JsonObject;", "resultHandler", "Lio/vertx/core/Handler;", "Lio/vertx/core/AsyncResult;", "Lio/vertx/ext/auth/User;", "registerTockUser", "Lai/tock/shared/security/TockUser;", "username", "rolesByNamespace", "upgradeToTockUser", "Lai/tock/shared/security/auth/CASAuthProvider$HttpResult;", "protectPaths", "pathsToProtect", "sessionHandler", "Lio/vertx/ext/web/handler/SessionHandler;", "excludedPaths", "Lkotlin/text/Regex;", "callbackPath", "Companion", "HttpResult", "tock-shared"})
@SourceDebugExtension(value={"SMAP\nCASAuthProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CASAuthProvider.kt\nai/tock/shared/security/auth/CASAuthProvider\n+ 2 IOCs.kt\nai/tock/shared/IOCsKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,215:1\n53#2,2:216\n53#2,2:220\n51#3:218\n51#3:222\n277#4:219\n277#4:223\n*S KotlinDebug\n*F\n+ 1 CASAuthProvider.kt\nai/tock/shared/security/auth/CASAuthProvider\n*L\n38#1:216,2\n128#1:220,2\n38#1:218\n128#1:222\n38#1:219\n128#1:223\n*E\n"})
public abstract class CASAuthProvider
extends SSOTockAuthProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VertxSessionStore sessionStore;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(CASAuthProvider::logger$lambda$8);
    private static final boolean isJoinNamespace = PropertiesKt.booleanProperty("tock_cas_join_same_namespace_per_user", true);

    public CASAuthProvider(@NotNull Vertx vertx) {
        boolean isBehindProxy;
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        super(vertx);
        LocalSessionStore vertxSessionStore = LocalSessionStore.create((Vertx)vertx);
        this.sessionStore = new VertxSessionStore((io.vertx.ext.web.sstore.SessionStore)vertxSessionStore);
        boolean bl = isBehindProxy = PropertiesKt.propertyExists("tock_cas_auth_proxy_host") && PropertiesKt.propertyExists("tock_cas_auth_proxy_port");
        if (isBehindProxy) {
            logger.debug(CASAuthProvider::_init_$lambda$0);
            String proxyHost = PropertiesKt.property("tock_cas_auth_proxy_host", "127.0.0.1");
            int proxyPort = PropertiesKt.intProperty("tock_cas_auth_proxy_port", 3128);
            System.setProperty("https.proxyHost", proxyHost);
            String string = "%d";
            Object[] objectArray = new Object[]{proxyPort};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            System.setProperty("https.proxyPort", string2);
        }
    }

    @NotNull
    protected final VertxSessionStore getSessionStore() {
        return this.sessionStore;
    }

    private final Executor getExecutor() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        return (Executor)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<Executor>(){}, tag$iv).getValue()).invoke();
    }

    @NotNull
    public String getEnabledPacAuthorizers() {
        return "isAuthenticated";
    }

    public void handleUpgradeFailure(@NotNull RoutingContext rc, int code, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)rc, (String)"rc");
        if (cause == null) {
            logger.error("Caught by default CAS mapping exception handler: " + code);
            rc.fail(code);
        } else {
            logger.error("Caught by default CAS mapping exception handler", cause);
            rc.fail(code, cause);
        }
    }

    @NotNull
    public abstract Config getConfig();

    @NotNull
    public abstract String readCasLogin(@NotNull Pac4jUser var1);

    @NotNull
    public abstract Map<String, Set<String>> readRolesByNamespace(@NotNull Pac4jUser var1);

    @Override
    @NotNull
    public AuthenticationHandler createAuthHandler(@NotNull WebVerticle verticle) {
        Intrinsics.checkNotNullParameter((Object)((Object)verticle), (String)"verticle");
        SecurityHandlerOptions securityHandlerOptions = new SecurityHandlerOptions().setClients("CasClient");
        Intrinsics.checkNotNullExpressionValue((Object)securityHandlerOptions, (String)"setClients(...)");
        SecurityHandlerOptions options = securityHandlerOptions;
        options.setAuthorizers(this.getEnabledPacAuthorizers());
        return (AuthenticationHandler)new SecurityHandler(this.getVertx(), (SessionStore)this.sessionStore, this.getConfig(), new Pac4jAuthProvider(), options);
    }

    public void authenticate(@NotNull JsonObject authInfo, @NotNull Handler<AsyncResult<User>> resultHandler) {
        Intrinsics.checkNotNullParameter((Object)authInfo, (String)"authInfo");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        resultHandler.handle((Object)Future.failedFuture((String)"Unauthorized"));
    }

    @NotNull
    protected final TockUser registerTockUser(@NotNull String username, @NotNull Map<String, ? extends Set<String>> rolesByNamespace) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter(rolesByNamespace, (String)"rolesByNamespace");
        TockUser user = null;
        for (Map.Entry<String, ? extends Set<String>> entry : rolesByNamespace.entrySet()) {
            String namespace = entry.getKey();
            Set<String> roles = entry.getValue();
            KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
            Object tag$iv = null;
            boolean $i$f$provide = false;
            KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
            KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
            user = ((TockUserListener)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<TockUserListener>(){}, tag$iv).getValue()).invoke()).registerUser(new TockUser(username, namespace, roles, false, 8, null), isJoinNamespace);
        }
        TockUser tockUser = user;
        Intrinsics.checkNotNull(tockUser);
        return tockUser;
    }

    protected void upgradeToTockUser(@NotNull Pac4jUser user, @NotNull Handler<HttpResult<TockUser>> resultHandler) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        try {
            String username = this.readCasLogin(user);
            Map<String, Set<String>> rolesByNamespace = this.readRolesByNamespace(user);
            logger.debug(() -> CASAuthProvider.upgradeToTockUser$lambda$1(username, rolesByNamespace));
            if (rolesByNamespace.keySet().isEmpty()) {
                IllegalStateException error = new IllegalStateException("No namespace found in registered user profil");
                logger.trace("Unable to upgrade to tock user", (Throwable)error);
                resultHandler.handle(new HttpResult<Object>(null, error, 401));
                return;
            }
            TockUser tockUser = this.registerTockUser(username, rolesByNamespace);
            resultHandler.handle(new HttpResult<TockUser>(tockUser, null, 200));
        }
        catch (Exception exc) {
            logger.trace("Unable to upgrade to tock user", (Throwable)exc);
            resultHandler.handle(new HttpResult<Object>(null, exc, 500));
        }
    }

    @Override
    @NotNull
    public AuthenticationHandler protectPaths(@NotNull WebVerticle verticle, @NotNull Set<String> pathsToProtect, @NotNull SessionHandler sessionHandler) {
        Intrinsics.checkNotNullParameter((Object)((Object)verticle), (String)"verticle");
        Intrinsics.checkNotNullParameter(pathsToProtect, (String)"pathsToProtect");
        Intrinsics.checkNotNullParameter((Object)sessionHandler, (String)"sessionHandler");
        AuthenticationHandler authHandler = super.protectPaths(verticle, pathsToProtect, sessionHandler);
        Set<Regex> excluded = this.excludedPaths(verticle);
        verticle.getRouter().route("/*").handler((Handler)new WithExcludedPathHandler(excluded, (Handler<RoutingContext>)((Handler)sessionHandler)));
        verticle.getRouter().route("/*").handler((Handler)new WithExcludedPathHandler(excluded, (Handler<RoutingContext>)((Handler)authHandler)));
        verticle.getRouter().route("/*").handler((Handler)new WithExcludedPathHandler(excluded, (Handler<RoutingContext>)((Handler)arg_0 -> CASAuthProvider.protectPaths$lambda$4(this, arg_0)))).failureHandler(arg_0 -> CASAuthProvider.protectPaths$lambda$5(this, arg_0));
        WebVerticle $this$protectPaths_u24lambda_u247 = verticle;
        boolean bl = false;
        $this$protectPaths_u24lambda_u247.getRouter().get($this$protectPaths_u24lambda_u247.getBasePath() + "/user").handler(arg_0 -> CASAuthProvider.protectPaths$lambda$7$lambda$6(this, arg_0));
        CallbackHandlerOptions callbackHandlerOptions = new CallbackHandlerOptions().setMultiProfile(Boolean.valueOf(false));
        CallbackHandler callbackHandler = new CallbackHandler($this$protectPaths_u24lambda_u247.getVertx(), (SessionStore)this.sessionStore, this.getConfig(), callbackHandlerOptions);
        String callbackPath = this.callbackPath(verticle);
        $this$protectPaths_u24lambda_u247.getRouter().get(callbackPath).handler((Handler)sessionHandler);
        $this$protectPaths_u24lambda_u247.getRouter().get(callbackPath).handler((Handler)callbackHandler);
        $this$protectPaths_u24lambda_u247.getRouter().post(callbackPath).handler((Handler)sessionHandler);
        $this$protectPaths_u24lambda_u247.getRouter().post(callbackPath).handler((Handler)BodyHandler.create().setMergeFormAttributes(true));
        $this$protectPaths_u24lambda_u247.getRouter().post(callbackPath).handler((Handler)callbackHandler);
        return authHandler;
    }

    @Override
    @NotNull
    public Set<Regex> excludedPaths(@NotNull WebVerticle verticle) {
        Intrinsics.checkNotNullParameter((Object)((Object)verticle), (String)"verticle");
        return SetsKt.plus(super.excludedPaths(verticle), (Object)new Regex(this.callbackPath(verticle)));
    }

    private final String callbackPath(WebVerticle verticle) {
        return verticle.getBasePath() + "/callback";
    }

    private static final Object _init_$lambda$0() {
        return "HTTP Proxy enabled in CAS Auth module";
    }

    private static final Object upgradeToTockUser$lambda$1(String $username, Map $rolesByNamespace) {
        Intrinsics.checkNotNullParameter((Object)$username, (String)"$username");
        Intrinsics.checkNotNullParameter((Object)$rolesByNamespace, (String)"$rolesByNamespace");
        return "authenticate " + $username + "/" + $rolesByNamespace;
    }

    private static final void protectPaths$lambda$4$lambda$3$lambda$2(RoutingContext $rc, CASAuthProvider this$0, HttpResult it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (it.succeeded()) {
            $rc.setUser((User)it.getResult());
            $rc.next();
        } else {
            $rc.clearUser();
            $rc.session().destroy();
            Intrinsics.checkNotNull((Object)$rc);
            this$0.handleUpgradeFailure($rc, it.getCode(), it.getCause());
        }
    }

    private static final Unit protectPaths$lambda$4$lambda$3(CASAuthProvider this$0, User $user, RoutingContext $rc) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)$user, (String)"null cannot be cast to non-null type org.pac4j.vertx.auth.Pac4jUser");
        this$0.upgradeToTockUser((Pac4jUser)$user, (Handler<HttpResult<TockUser>>)((Handler)arg_0 -> CASAuthProvider.protectPaths$lambda$4$lambda$3$lambda$2($rc, this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final void protectPaths$lambda$4(CASAuthProvider this$0, RoutingContext rc) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        User user = rc.user();
        if (user != null && !(user instanceof TockUser)) {
            this$0.getExecutor().executeBlocking((Function0<Unit>)((Function0)() -> CASAuthProvider.protectPaths$lambda$4$lambda$3(this$0, user, rc)));
        } else {
            rc.next();
        }
    }

    private static final void protectPaths$lambda$5(CASAuthProvider this$0, RoutingContext rc) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        logger.error("Authentication failure", rc.failure());
        Intrinsics.checkNotNull((Object)rc);
        this$0.handleUpgradeFailure(rc, 500, null);
    }

    private static final void protectPaths$lambda$7$lambda$6(CASAuthProvider this$0, RoutingContext it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        HttpServerResponse httpServerResponse = it.response();
        ObjectMapper objectMapper = JacksonKt.getMapper();
        Intrinsics.checkNotNull((Object)it);
        httpServerResponse.end(objectMapper.writeValueAsString((Object)this$0.toTockUser(it)));
    }

    private static final Unit logger$lambda$8() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\b\u00a8\u0006\t"}, d2={"Lai/tock/shared/security/auth/CASAuthProvider$Companion;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "isJoinNamespace", "", "()Z", "tock-shared"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isJoinNamespace() {
            return isJoinNamespace;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B#\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00018\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J6\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00018\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0015\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lai/tock/shared/security/auth/CASAuthProvider$HttpResult;", "T", "", "result", "cause", "", "code", "", "<init>", "(Ljava/lang/Object;Ljava/lang/Throwable;I)V", "getResult", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getCause", "()Ljava/lang/Throwable;", "getCode", "()I", "succeeded", "", "component1", "component2", "component3", "copy", "(Ljava/lang/Object;Ljava/lang/Throwable;I)Lai/tock/shared/security/auth/CASAuthProvider$HttpResult;", "equals", "other", "hashCode", "toString", "", "tock-shared"})
    protected static final class HttpResult<T> {
        @Nullable
        private final T result;
        @Nullable
        private final Throwable cause;
        private final int code;

        public HttpResult(@Nullable T result, @Nullable Throwable cause, int code) {
            this.result = result;
            this.cause = cause;
            this.code = code;
        }

        @Nullable
        public final T getResult() {
            return this.result;
        }

        @Nullable
        public final Throwable getCause() {
            return this.cause;
        }

        public final int getCode() {
            return this.code;
        }

        public final boolean succeeded() {
            return this.code / 100 == 2;
        }

        @Nullable
        public final T component1() {
            return this.result;
        }

        @Nullable
        public final Throwable component2() {
            return this.cause;
        }

        public final int component3() {
            return this.code;
        }

        @NotNull
        public final HttpResult<T> copy(@Nullable T result, @Nullable Throwable cause, int code) {
            return new HttpResult<T>(result, cause, code);
        }

        public static /* synthetic */ HttpResult copy$default(HttpResult httpResult, Object object, Throwable throwable, int n, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                object = httpResult.result;
            }
            if ((n2 & 2) != 0) {
                throwable = httpResult.cause;
            }
            if ((n2 & 4) != 0) {
                n = httpResult.code;
            }
            return httpResult.copy(object, throwable, n);
        }

        @NotNull
        public String toString() {
            return "HttpResult(result=" + this.result + ", cause=" + this.cause + ", code=" + this.code + ")";
        }

        public int hashCode() {
            int result = this.result == null ? 0 : this.result.hashCode();
            result = result * 31 + (this.cause == null ? 0 : this.cause.hashCode());
            result = result * 31 + Integer.hashCode(this.code);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HttpResult)) {
                return false;
            }
            HttpResult httpResult = (HttpResult)other;
            if (!Intrinsics.areEqual(this.result, httpResult.result)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cause, (Object)httpResult.cause)) {
                return false;
            }
            return this.code == httpResult.code;
        }
    }
}

