/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared;

import ai.tock.shared.Level;
import java.io.EOFException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import okhttp3.Connection;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpHeaders;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lai/tock/shared/LoggingInterceptor;", "Lokhttp3/Interceptor;", "logger", "Lmu/KLogger;", "level", "Lai/tock/shared/Level;", "<init>", "(Lmu/KLogger;Lai/tock/shared/Level;)V", "getLogger", "()Lmu/KLogger;", "getLevel", "()Lai/tock/shared/Level;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "isPlaintext", "", "buffer", "Lokio/Buffer;", "isPlaintext$tock_shared", "bodyEncoded", "headers", "Lokhttp3/Headers;", "tock-shared"})
final class LoggingInterceptor
implements Interceptor {
    @NotNull
    private final KLogger logger;
    @NotNull
    private final Level level;

    public LoggingInterceptor(@NotNull KLogger logger, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.logger = logger;
        this.level = level;
    }

    @NotNull
    public final KLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Level getLevel() {
        return this.level;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Long contentLength;
        ResponseBody responseBody;
        Connection connection;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Level level = this.level;
        Request request = chain.request();
        if (level == Level.NONE) {
            return chain.proceed(request);
        }
        boolean logBody = level == Level.BODY;
        boolean logHeaders = logBody || level == Level.HEADERS;
        RequestBody requestBody = request.body();
        boolean hasRequestBody = requestBody != null;
        Connection connection2 = connection = chain.connection();
        Protocol protocol = connection2 != null ? connection2.protocol() : Protocol.HTTP_1_1;
        String requestStartMessage = "--> " + request.method() + " " + request.url() + " " + protocol;
        if (!logHeaders && hasRequestBody) {
            RequestBody requestBody2 = requestBody;
            Intrinsics.checkNotNull((Object)requestBody2);
            requestStartMessage = requestStartMessage + " (" + requestBody2.contentLength() + "-byte body)";
        }
        this.logger.info(requestStartMessage);
        if (logHeaders) {
            if (hasRequestBody) {
                RequestBody requestBody3 = requestBody;
                Intrinsics.checkNotNull((Object)requestBody3);
                if (requestBody3.contentType() != null) {
                    this.logger.info("Content-Type: " + requestBody.contentType());
                }
                if (requestBody.contentLength() != -1L) {
                    this.logger.info("Content-Length: " + requestBody.contentLength());
                }
            }
            Headers headers = request.headers();
            int count = headers.size();
            for (int i = 0; i < count; ++i) {
                String name = headers.name(i);
                if (StringsKt.equals((String)"Content-Type", (String)name, (boolean)true) || StringsKt.equals((String)"Content-Length", (String)name, (boolean)true)) continue;
                this.logger.info(name + ": " + headers.value(i));
            }
            if (!logBody || !hasRequestBody) {
                this.logger.info("--> END " + request.method());
            } else if (this.bodyEncoded(request.headers())) {
                this.logger.info("--> END " + request.method() + " (encoded body omitted)");
            } else {
                Buffer buffer = new Buffer();
                RequestBody requestBody4 = requestBody;
                Intrinsics.checkNotNull((Object)requestBody4);
                requestBody4.writeTo((BufferedSink)buffer);
                Charset charset = StandardCharsets.UTF_8;
                MediaType contentType = requestBody.contentType();
                if (contentType != null) {
                    charset = contentType.charset(StandardCharsets.UTF_8);
                }
                this.logger.info("");
                if (this.isPlaintext$tock_shared(buffer)) {
                    Charset charset2 = charset;
                    Intrinsics.checkNotNull((Object)charset2);
                    this.logger.info(buffer.readString(charset2));
                    this.logger.info("--> END " + request.method() + " (" + requestBody.contentLength() + "-byte body)");
                } else {
                    this.logger.info("--> END " + request.method() + " (binary " + requestBody.contentLength() + "-byte body omitted)");
                }
            }
        }
        long startNs = System.nanoTime();
        Response response = null;
        try {
            response = chain.proceed(request);
        }
        catch (Exception e) {
            this.logger.error("<-- HTTP FAILED: " + e);
            throw e;
        }
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        ResponseBody responseBody2 = responseBody = response.body();
        Long l = contentLength = responseBody2 != null ? Long.valueOf(responseBody2.contentLength()) : null;
        long l2 = -1L;
        Object bodySize = l == null || l != l2 ? contentLength + "-byte" : "unknown-length";
        this.logger.info("<-- " + response.code() + " " + response.message() + " " + response.request().url() + " (" + tookMs + "ms" + (String)(!logHeaders ? ", " + (String)bodySize + " body" : "") + ")");
        if (logHeaders) {
            Headers headers = response.headers();
            int count = headers.size();
            for (int i = 0; i < count; ++i) {
                this.logger.info(headers.name(i) + ": " + headers.value(i));
            }
            if (!logBody || !HttpHeaders.promisesBody((Response)response)) {
                this.logger.info("<-- END HTTP");
            } else if (this.bodyEncoded(response.headers())) {
                this.logger.info("<-- END HTTP (encoded body omitted)");
            } else {
                MediaType contentType;
                BufferedSource source;
                ResponseBody responseBody3 = responseBody;
                BufferedSource bufferedSource = source = responseBody3 != null ? responseBody3.source() : null;
                if (bufferedSource != null) {
                    bufferedSource.request(Long.MAX_VALUE);
                }
                BufferedSource bufferedSource2 = source;
                Buffer buffer = bufferedSource2 != null ? bufferedSource2.getBuffer() : null;
                Charset charset = StandardCharsets.UTF_8;
                ResponseBody responseBody4 = responseBody;
                Object object = contentType = responseBody4 != null ? responseBody4.contentType() : null;
                if (contentType != null) {
                    charset = contentType.charset(StandardCharsets.UTF_8);
                }
                if (buffer != null && !this.isPlaintext$tock_shared(buffer)) {
                    this.logger.info("");
                    this.logger.info("<-- END HTTP (binary " + buffer.size() + "-byte body omitted)");
                    return response;
                }
                Long l3 = contentLength;
                long l4 = 0L;
                if ((l3 == null || l3 != l4) && buffer != null) {
                    this.logger.info("");
                    Buffer buffer2 = buffer.clone();
                    Charset charset3 = charset;
                    Intrinsics.checkNotNull((Object)charset3);
                    this.logger.info(buffer2.readString(charset3));
                }
                Buffer buffer3 = buffer;
                this.logger.info("<-- END HTTP (" + (buffer3 != null ? Long.valueOf(buffer3.size()) : null) + "-byte body)");
            }
        }
        return response;
    }

    public final boolean isPlaintext$tock_shared(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                if (!Character.isISOControl(prefix.readUtf8CodePoint())) continue;
                return false;
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    private final boolean bodyEncoded(Headers headers) {
        String contentEncoding = headers.get("Content-Encoding");
        return contentEncoding != null && !StringsKt.equals((String)contentEncoding, (String)"identity", (boolean)true);
    }
}

