/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared.vertx;

import ai.tock.shared.Executor;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.vertx.TockVertxProvider;
import ai.tock.shared.vertx.VertXsKt;
import ai.tock.shared.vertx.VertxProvider;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import io.vertx.core.AsyncResult;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.slf4j.MDCContext;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.slf4j.MDC;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aD\u0010\u0012\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u0014*\u00020\t2\u0018\u0010\u0015\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00140\u0017\u0012\u0004\u0012\u00020\u00130\u00162\u0018\u0010\u0018\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00140\u0019\u0012\u0004\u0012\u00020\u00130\u0016\u001a\u001e\u0010\u0012\u001a\u00020\u001a*\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00130\u0016\u001a\b\u0010\u001d\u001a\u00020\u001eH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\"\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\"\u0014\u0010\u000e\u001a\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\"\u0011\u0010\u0010\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000b\u00a8\u0006\u001f"}, d2={"logger", "Lmu/KLogger;", "defaultVertxOptions", "Lio/vertx/core/VertxOptions;", "getDefaultVertxOptions", "()Lio/vertx/core/VertxOptions;", "setDefaultVertxOptions", "(Lio/vertx/core/VertxOptions;)V", "internalVertx", "Lio/vertx/core/Vertx;", "getInternalVertx", "()Lio/vertx/core/Vertx;", "internalVertx$delegate", "Lkotlin/Lazy;", "sharedVertx", "getSharedVertx", "vertx", "getVertx", "blocking", "", "T", "blockingHandler", "Lkotlin/Function1;", "Lio/vertx/core/Promise;", "resultHandler", "Lio/vertx/core/AsyncResult;", "Lio/vertx/ext/web/Route;", "handler", "Lio/vertx/ext/web/RoutingContext;", "vertxExecutor", "Lai/tock/shared/Executor;", "tock-shared"})
@SourceDebugExtension(value={"SMAP\nVertXs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VertXs.kt\nai/tock/shared/vertx/VertXsKt\n+ 2 IOCs.kt\nai/tock/shared/IOCsKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,210:1\n60#2,3:211\n63#2,3:216\n65#3:214\n277#4:215\n*S KotlinDebug\n*F\n+ 1 VertXs.kt\nai/tock/shared/vertx/VertXsKt\n*L\n68#1:211,3\n68#1:216,3\n68#1:214\n68#1:215\n*E\n"})
public final class VertXsKt {
    @NotNull
    private static final KLogger logger;
    @NotNull
    private static VertxOptions defaultVertxOptions;
    @NotNull
    private static final Lazy internalVertx$delegate;

    @NotNull
    public static final VertxOptions getDefaultVertxOptions() {
        return defaultVertxOptions;
    }

    public static final void setDefaultVertxOptions(@NotNull VertxOptions vertxOptions) {
        Intrinsics.checkNotNullParameter((Object)vertxOptions, (String)"<set-?>");
        defaultVertxOptions = vertxOptions;
    }

    private static final Vertx getInternalVertx() {
        Lazy lazy = internalVertx$delegate;
        return (Vertx)lazy.getValue();
    }

    @NotNull
    public static final Vertx getSharedVertx() {
        return VertXsKt.getVertx();
    }

    @NotNull
    public static final Vertx getVertx() {
        return VertXsKt.getInternalVertx();
    }

    public static final <T> void blocking(@NotNull Vertx $this$blocking, @NotNull Function1<? super Promise<T>, Unit> blockingHandler, @NotNull Function1<? super AsyncResult<T>, Unit> resultHandler) {
        Intrinsics.checkNotNullParameter((Object)$this$blocking, (String)"<this>");
        Intrinsics.checkNotNullParameter(blockingHandler, (String)"blockingHandler");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        $this$blocking.executeBlocking(arg_0 -> VertXsKt.blocking$lambda$5(blockingHandler, arg_0), false, arg_0 -> VertXsKt.blocking$lambda$7(resultHandler, arg_0));
    }

    @NotNull
    public static final Route blocking(@NotNull Route $this$blocking, @NotNull Function1<? super RoutingContext, Unit> handler) {
        Intrinsics.checkNotNullParameter((Object)$this$blocking, (String)"<this>");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Route route = $this$blocking.blockingHandler(arg_0 -> VertXsKt.blocking$lambda$8(handler, arg_0), false);
        Intrinsics.checkNotNullExpressionValue((Object)route, (String)"blockingHandler(...)");
        return route;
    }

    @NotNull
    public static final Executor vertxExecutor() {
        return new Executor(){

            public void executeBlocking(Duration delay, Function0<Unit> runnable) {
                Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
                Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
                if (delay.isZero()) {
                    this.executeBlocking(runnable);
                } else {
                    Map loggingContext = new MDCContext(null, 1, null).getContextMap();
                    VertXsKt.getVertx().setTimer(delay.toMillis(), arg_0 -> vertxExecutor.1.executeBlocking$lambda$1(this, loggingContext, runnable, arg_0));
                }
            }

            public void executeBlocking(Function0<Unit> runnable) {
                Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
                Map loggingContext = new MDCContext(null, 1, null).getContextMap();
                VertXsKt.blocking(VertXsKt.getVertx(), arg_0 -> vertxExecutor.1.executeBlocking$lambda$3(this, loggingContext, runnable, arg_0), vertxExecutor.1::executeBlocking$lambda$4);
            }

            public <T> void executeBlocking(Callable<T> blocking, Function1<? super T, Unit> result) {
                Intrinsics.checkNotNullParameter(blocking, (String)"blocking");
                Intrinsics.checkNotNullParameter(result, (String)"result");
                Map loggingContext = new MDCContext(null, 1, null).getContextMap();
                VertXsKt.blocking(VertXsKt.getVertx(), arg_0 -> vertxExecutor.1.executeBlocking$lambda$6(this, loggingContext, blocking, arg_0), arg_0 -> vertxExecutor.1.executeBlocking$lambda$7(result, arg_0));
            }

            public long setPeriodic(Duration initialDelay, Duration delay, Function0<Unit> runnable) {
                Intrinsics.checkNotNullParameter((Object)initialDelay, (String)"initialDelay");
                Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
                Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
                Map loggingContext = new MDCContext(null, 1, null).getContextMap();
                return VertXsKt.getVertx().setTimer(initialDelay.toMillis(), arg_0 -> vertxExecutor.1.setPeriodic$lambda$11(this, loggingContext, runnable, delay, arg_0));
            }

            private final Function0<Unit> catchableRunnable(Function0<Unit> runnable) {
                return () -> vertxExecutor.1.catchableRunnable$lambda$12(runnable);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            private final void invokeWithLoggingContext(Map<String, String> loggingContext, Function0<Unit> runnable) {
                Function0<Unit> r = this.catchableRunnable(runnable);
                Map<String, String> context = loggingContext;
                boolean bl = false;
                if (context == null) {
                    r.invoke();
                } else {
                    Iterator<Map.Entry<String, String>> $this$mapTo$iv$iv$iv;
                    boolean restorePrevious$iv = true;
                    boolean $i$f$withLoggingContext = false;
                    Map<String, String> $this$map$iv$iv = context;
                    boolean $i$f$map = false;
                    Map<String, String> map = $this$map$iv$iv;
                    Collection destination$iv$iv$iv = new ArrayList<E>($this$map$iv$iv.size());
                    boolean $i$f$mapTo = false;
                    Iterator<Map.Entry<K, V>> iterator = $this$mapTo$iv$iv$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void it$iv;
                        Map.Entry<K, V> item$iv$iv$iv;
                        Map.Entry<K, V> entry = item$iv$iv$iv = iterator.next();
                        Collection collection = destination$iv$iv$iv;
                        boolean bl2 = false;
                        String mdcValue$iv = MDC.get((String)((String)it$iv.getKey()));
                        collection.add(mdcValue$iv != null ? (Function0)new Function0<Unit>((Map.Entry)it$iv, mdcValue$iv){
                            final /* synthetic */ Map.Entry $it;
                            final /* synthetic */ String $mdcValue;
                            {
                                this.$it = entry;
                                this.$mdcValue = string;
                                super(0);
                            }

                            public final void invoke() {
                                MDC.put((String)((String)this.$it.getKey()), (String)this.$mdcValue);
                            }
                        } : (Function0)new Function0<Unit>((Map.Entry)it$iv){
                            final /* synthetic */ Map.Entry $it;
                            {
                                this.$it = entry;
                                super(0);
                            }

                            public final void invoke() {
                                MDC.remove((String)((String)this.$it.getKey()));
                            }
                        });
                    }
                    List cleanupCallbacks$iv = (List)destination$iv$iv$iv;
                    try {
                        Map<String, String> $this$forEach$iv$iv = context;
                        boolean $i$f$forEach = false;
                        $this$mapTo$iv$iv$iv = $this$forEach$iv$iv.entrySet().iterator();
                        while ($this$mapTo$iv$iv$iv.hasNext()) {
                            Map.Entry<String, String> element$iv$iv;
                            Map.Entry<String, String> it$iv = element$iv$iv = $this$mapTo$iv$iv$iv.next();
                            boolean bl3 = false;
                            if (it$iv.getValue() == null) continue;
                            MDC.put((String)it$iv.getKey(), (String)it$iv.getValue());
                        }
                        Object object = r.invoke();
                    }
                    finally {
                        Iterable $this$forEach$iv$iv = cleanupCallbacks$iv;
                        boolean $i$f$forEach = false;
                        for (T element$iv$iv : $this$forEach$iv$iv) {
                            Function0 it$iv = (Function0)element$iv$iv;
                            boolean bl4 = false;
                            it$iv.invoke();
                        }
                    }
                }
            }

            public long setPeriodic(Duration delay, Function0<Unit> runnable) {
                return Executor.DefaultImpls.setPeriodic(this, delay, runnable);
            }

            private static final Unit executeBlocking$lambda$1$lambda$0(vertxExecutor.1 this$0, Function0 $runnable) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
                this$0.executeBlocking((Function0<Unit>)$runnable);
                return Unit.INSTANCE;
            }

            private static final void executeBlocking$lambda$1(vertxExecutor.1 this$0, Map $loggingContext, Function0 $runnable, Long it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
                this$0.invokeWithLoggingContext($loggingContext, (Function0<Unit>)((Function0)() -> vertxExecutor.1.executeBlocking$lambda$1$lambda$0(this$0, $runnable)));
            }

            private static final Unit executeBlocking$lambda$3$lambda$2(vertxExecutor.1 this$0, Function0 $runnable, Promise $it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
                Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
                this$0.catchableRunnable((Function0<Unit>)$runnable).invoke();
                $it.tryComplete();
                return Unit.INSTANCE;
            }

            private static final Unit executeBlocking$lambda$3(vertxExecutor.1 this$0, Map $loggingContext, Function0 $runnable, Promise it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this$0.invokeWithLoggingContext($loggingContext, (Function0<Unit>)((Function0)() -> vertxExecutor.1.executeBlocking$lambda$3$lambda$2(this$0, $runnable, it)));
                return Unit.INSTANCE;
            }

            private static final Unit executeBlocking$lambda$4(AsyncResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Unit.INSTANCE;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final Unit executeBlocking$lambda$6$lambda$5(Callable $blocking, Promise $it) {
                Intrinsics.checkNotNullParameter((Object)$blocking, (String)"$blocking");
                Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
                try {
                    $blocking.call();
                }
                finally {
                    $it.tryFail("call not completed");
                }
                return Unit.INSTANCE;
            }

            private static final Unit executeBlocking$lambda$6(vertxExecutor.1 this$0, Map $loggingContext, Callable $blocking, Promise it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$blocking, (String)"$blocking");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this$0.invokeWithLoggingContext($loggingContext, (Function0<Unit>)((Function0)() -> vertxExecutor.1.executeBlocking$lambda$6$lambda$5($blocking, it)));
                return Unit.INSTANCE;
            }

            private static final Unit executeBlocking$lambda$7(Function1 $result, AsyncResult it) {
                Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.succeeded()) {
                    $result.invoke(it.result());
                } else {
                    $result.invoke(null);
                }
                return Unit.INSTANCE;
            }

            private static final Unit setPeriodic$lambda$11$lambda$10$lambda$9$lambda$8(vertxExecutor.1 this$0, Function0 $runnable) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
                this$0.executeBlocking((Function0<Unit>)$runnable);
                return Unit.INSTANCE;
            }

            private static final void setPeriodic$lambda$11$lambda$10$lambda$9(vertxExecutor.1 this$0, Map $loggingContext, Function0 $runnable, Long it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
                this$0.invokeWithLoggingContext($loggingContext, (Function0<Unit>)((Function0)() -> vertxExecutor.1.setPeriodic$lambda$11$lambda$10$lambda$9$lambda$8(this$0, $runnable)));
            }

            private static final Unit setPeriodic$lambda$11$lambda$10(vertxExecutor.1 this$0, Function0 $runnable, Duration $delay, Map $loggingContext) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
                Intrinsics.checkNotNullParameter((Object)$delay, (String)"$delay");
                this$0.executeBlocking((Function0<Unit>)$runnable);
                VertXsKt.getVertx().setPeriodic($delay.toMillis(), arg_0 -> vertxExecutor.1.setPeriodic$lambda$11$lambda$10$lambda$9(this$0, $loggingContext, $runnable, arg_0));
                return Unit.INSTANCE;
            }

            private static final void setPeriodic$lambda$11(vertxExecutor.1 this$0, Map $loggingContext, Function0 $runnable, Duration $delay, Long it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
                Intrinsics.checkNotNullParameter((Object)$delay, (String)"$delay");
                this$0.invokeWithLoggingContext($loggingContext, (Function0<Unit>)((Function0)() -> vertxExecutor.1.setPeriodic$lambda$11$lambda$10(this$0, $runnable, $delay, $loggingContext)));
            }

            private static final Unit catchableRunnable$lambda$12(Function0 $runnable) {
                Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
                try {
                    $runnable.invoke();
                }
                catch (Throwable throwable) {
                    LoggersKt.error(VertXsKt.access$getLogger$p(), throwable);
                }
                return Unit.INSTANCE;
            }
        };
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Vertx internalVertx_delegate$lambda$3() {
        VertxProvider vertxProvider;
        KodeinInjector $this$provideOrDefault_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provideOrDefault = false;
        try {
            KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provideOrDefault_u24default$iv.getInjector();
            KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
            Object object = (Function0)kodeinInjector.ProviderOrNull((TypeToken)new TypeReference<VertxProvider>(){}, tag$iv).getValue();
            if (object == null || (object = object.invoke()) == null) {
                boolean bl = false;
                object = TockVertxProvider.INSTANCE;
            }
            vertxProvider = object;
        }
        catch (KodeinInjector.UninjectedException e$iv) {
            boolean bl = false;
            vertxProvider = TockVertxProvider.INSTANCE;
        }
        return vertxProvider.vertx();
    }

    private static final Object blocking$lambda$5$lambda$4(Throwable $throwable) {
        Intrinsics.checkNotNullParameter((Object)$throwable, (String)"$throwable");
        return $throwable.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void blocking$lambda$5(Function1 $blockingHandler, Promise future) {
        Intrinsics.checkNotNullParameter((Object)$blockingHandler, (String)"$blockingHandler");
        Intrinsics.checkNotNullParameter((Object)future, (String)"future");
        try {
            $blockingHandler.invoke((Object)future);
        }
        catch (Throwable throwable) {
            logger.error(throwable, () -> VertXsKt.blocking$lambda$5$lambda$4(throwable));
            future.fail(throwable);
        }
        finally {
            future.tryFail("call not completed");
        }
    }

    private static final Object blocking$lambda$7$lambda$6(Throwable $e) {
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        return $e.getMessage();
    }

    private static final void blocking$lambda$7(Function1 $resultHandler, AsyncResult it) {
        Intrinsics.checkNotNullParameter((Object)$resultHandler, (String)"$resultHandler");
        try {
            Intrinsics.checkNotNull((Object)it);
            $resultHandler.invoke((Object)it);
        }
        catch (Throwable e) {
            logger.error(e, () -> VertXsKt.blocking$lambda$7$lambda$6(e));
        }
    }

    private static final void blocking$lambda$8(Function1 $handler, RoutingContext it) {
        Intrinsics.checkNotNullParameter((Object)$handler, (String)"$handler");
        try {
            Intrinsics.checkNotNull((Object)it);
            $handler.invoke((Object)it);
        }
        catch (Throwable t) {
            try {
                LoggersKt.error(logger, t);
                it.fail(t);
            }
            catch (Throwable e) {
                LoggersKt.debug(logger, e);
            }
        }
    }

    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }

    static {
        VertxOptions vertxOptions;
        logger = KotlinLogging.INSTANCE.logger(VertXsKt::logger$lambda$0);
        VertxOptions $this$defaultVertxOptions_u24lambda_u241 = vertxOptions = new VertxOptions();
        boolean bl = false;
        $this$defaultVertxOptions_u24lambda_u241.setMaxWorkerExecuteTime(60000000000000L);
        $this$defaultVertxOptions_u24lambda_u241.setWorkerPoolSize(PropertiesKt.intProperty("tock_vertx_worker_pool_size", 20));
        if (PropertiesKt.getDevEnvironment()) {
            $this$defaultVertxOptions_u24lambda_u241.setWarningExceptionTime(1000000000000L);
        }
        defaultVertxOptions = vertxOptions;
        internalVertx$delegate = LazyKt.lazy(VertXsKt::internalVertx_delegate$lambda$3);
    }
}

