/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lai/tock/shared/GzipRequestInterceptor;", "Lokhttp3/Interceptor;", "<init>", "()V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "gzip", "Lokhttp3/RequestBody;", "body", "tock-shared"})
final class GzipRequestInterceptor
implements Interceptor {
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request originalRequest = chain.request();
        RequestBody body = originalRequest.body();
        if (body == null || originalRequest.header("Content-Encoding") != null || body.contentLength() < 512L) {
            return chain.proceed(originalRequest);
        }
        Request compressedRequest = originalRequest.newBuilder().header("Content-Encoding", "gzip").method(originalRequest.method(), this.gzip(body)).build();
        return chain.proceed(compressedRequest);
    }

    private final RequestBody gzip(RequestBody body) {
        return new RequestBody(body){
            final /* synthetic */ RequestBody $body;
            {
                this.$body = $body;
            }

            public MediaType contentType() {
                return this.$body.contentType();
            }

            public long contentLength() {
                return -1L;
            }

            public void writeTo(BufferedSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                BufferedSink gzipSink = Okio.buffer((Sink)((Sink)new GzipSink((Sink)sink)));
                this.$body.writeTo(gzipSink);
                gzipSink.close();
            }
        };
    }
}

