/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared.security;

import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.security.NoEncryptionPassException;
import ai.tock.shared.security.TockObfuscatorService;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jasypt.contrib.org.apache.commons.codec_1_3.binary.Base64;
import org.jasypt.util.text.BasicTextEncryptor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r\u001a\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r\u001a\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r\u001a\u0006\u0010\u0011\u001a\u00020\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0002\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\u0004\u0010\u0005\"\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"logger", "Lmu/KLogger;", "textEncryptor", "Lorg/jasypt/util/text/BasicTextEncryptor;", "getTextEncryptor", "()Lorg/jasypt/util/text/BasicTextEncryptor;", "textEncryptor$delegate", "Lkotlin/Lazy;", "encryptionEnabled", "", "getEncryptionEnabled", "()Z", "shaS256", "", "s", "encrypt", "decrypt", "initEncryptor", "", "tock-shared"})
public final class EncryptorsKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(EncryptorsKt::logger$lambda$0);
    @NotNull
    private static final Lazy textEncryptor$delegate = LazyKt.lazy(EncryptorsKt::textEncryptor_delegate$lambda$3);
    private static final boolean encryptionEnabled = PropertiesKt.propertyExists("tock_encrypt_pass");

    private static final BasicTextEncryptor getTextEncryptor() {
        Lazy lazy = textEncryptor$delegate;
        return (BasicTextEncryptor)lazy.getValue();
    }

    public static final boolean getEncryptionEnabled() {
        return encryptionEnabled;
    }

    @NotNull
    public static final String shaS256(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        String string = s;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = Base64.encodeBase64Chunked((byte[])messageDigest.digest(byArray));
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"encodeBase64Chunked(...)");
        return new String(byArray2, Charsets.UTF_8);
    }

    @NotNull
    public static final String encrypt(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String string = EncryptorsKt.getTextEncryptor().encrypt(s);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encrypt(...)");
        return string;
    }

    @NotNull
    public static final String decrypt(@NotNull String s) {
        String string;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        try {
            string = EncryptorsKt.getTextEncryptor().decrypt(s);
        }
        catch (Exception e) {
            LoggersKt.error(logger, e);
            string = s;
        }
        return string;
    }

    public static final void initEncryptor() {
        if (encryptionEnabled) {
            logger.info(EncryptorsKt::initEncryptor$lambda$4);
            EncryptorsKt.decrypt(EncryptorsKt.encrypt("test"));
            logger.info(EncryptorsKt::initEncryptor$lambda$5);
        }
        TockObfuscatorService.INSTANCE.loadObfuscators$tock_shared();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final BasicTextEncryptor textEncryptor_delegate$lambda$3() {
        String string;
        BasicTextEncryptor basicTextEncryptor;
        BasicTextEncryptor $this$textEncryptor_delegate_u24lambda_u243_u24lambda_u242 = basicTextEncryptor = new BasicTextEncryptor();
        boolean bl = false;
        String $this$textEncryptor_delegate_u24lambda_u243_u24lambda_u242_u24lambda_u241 = string = PropertiesKt.property("tock_encrypt_pass", "");
        boolean bl2 = false;
        if (StringsKt.isBlank((CharSequence)$this$textEncryptor_delegate_u24lambda_u243_u24lambda_u242_u24lambda_u241)) {
            if (!PropertiesKt.getDevEnvironment()) throw new NoEncryptionPassException();
            $this$textEncryptor_delegate_u24lambda_u243_u24lambda_u242.setPassword("dev");
            return basicTextEncryptor;
        } else {
            $this$textEncryptor_delegate_u24lambda_u243_u24lambda_u242.setPassword($this$textEncryptor_delegate_u24lambda_u243_u24lambda_u242_u24lambda_u241);
        }
        return basicTextEncryptor;
    }

    private static final Object initEncryptor$lambda$4() {
        return "initialize encryptor...";
    }

    private static final Object initEncryptor$lambda$5() {
        return "encryptor initialized";
    }
}

