/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared.jackson;

import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonDeserialize(using=AnyValueDeserializer.class)
@JsonSerialize(using=AnyValueSerializer.class)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0087\b\u0018\u0000 \u00172\u00020\u0001:\u0003\u0017\u0018\u0019B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001f\b\u0016\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0005\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\tJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\u001f\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lai/tock/shared/jackson/AnyValueWrapper;", "", "klass", "", "value", "<init>", "(Ljava/lang/String;Ljava/lang/Object;)V", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;Ljava/lang/Object;)V", "(Ljava/lang/Object;)V", "getKlass", "()Ljava/lang/String;", "getValue", "()Ljava/lang/Object;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "AnyValueSerializer", "AnyValueDeserializer", "tock-shared"})
public final class AnyValueWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String klass;
    @Nullable
    private final Object value;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(AnyValueWrapper::logger$lambda$0);

    public AnyValueWrapper(@NotNull String klass, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        this.klass = klass;
        this.value = value;
    }

    @NotNull
    public final String getKlass() {
        return this.klass;
    }

    @Nullable
    public final Object getValue() {
        return this.value;
    }

    public AnyValueWrapper(@NotNull KClass<?> klass, @Nullable Object value) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        String string = JvmClassMappingKt.getJavaClass(klass).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this(string, value);
    }

    public AnyValueWrapper(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this(Reflection.getOrCreateKotlinClass(value.getClass()), value);
    }

    @NotNull
    public final String component1() {
        return this.klass;
    }

    @Nullable
    public final Object component2() {
        return this.value;
    }

    @NotNull
    public final AnyValueWrapper copy(@NotNull String klass, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        return new AnyValueWrapper(klass, value);
    }

    public static /* synthetic */ AnyValueWrapper copy$default(AnyValueWrapper anyValueWrapper, String string, Object object, int n, Object object2) {
        if ((n & 1) != 0) {
            string = anyValueWrapper.klass;
        }
        if ((n & 2) != 0) {
            object = anyValueWrapper.value;
        }
        return anyValueWrapper.copy(string, object);
    }

    @NotNull
    public String toString() {
        return "AnyValueWrapper(klass=" + this.klass + ", value=" + this.value + ")";
    }

    public int hashCode() {
        int result = this.klass.hashCode();
        result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnyValueWrapper)) {
            return false;
        }
        AnyValueWrapper anyValueWrapper = (AnyValueWrapper)other;
        if (!Intrinsics.areEqual((Object)this.klass, (Object)anyValueWrapper.klass)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.value, (Object)anyValueWrapper.value);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lai/tock/shared/jackson/AnyValueWrapper$AnyValueDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lai/tock/shared/jackson/AnyValueWrapper;", "<init>", "()V", "deserialize", "jp", "Lcom/fasterxml/jackson/core/JsonParser;", "context", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "tock-shared"})
    public static final class AnyValueDeserializer
    extends JsonDeserializer<AnyValueWrapper> {
        @Nullable
        public AnyValueWrapper deserialize(@NotNull JsonParser jp, @NotNull DeserializationContext context) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            String fieldName = JacksonKt.fieldNameWithValueReady(jp);
            if (fieldName != null) {
                AnyValueWrapper anyValueWrapper;
                Class<?> clazz;
                try {
                    String string = jp.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    clazz = Class.forName(StringsKt.replace$default((String)string, (String)"fr.vsct.tock", (String)"ai.tock", (boolean)false, (int)4, null));
                }
                catch (Exception e) {
                    logger.warn("deserialization error for class " + e.getMessage());
                    clazz = null;
                }
                Class<?> classValue = clazz;
                fieldName = JacksonKt.fieldNameWithValueReady(jp);
                if (fieldName != null) {
                    if (classValue == null) {
                        if (jp.getCurrentToken().isStructStart()) {
                            jp.skipChildren();
                        }
                        jp.nextToken();
                        JacksonKt.checkEndToken(jp);
                        return null;
                    }
                    Object value = jp.readValueAs(classValue);
                    JacksonKt.checkEndToken(jp);
                    String string = classValue.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    return new AnyValueWrapper(string, value);
                }
                JacksonKt.checkEndToken(jp);
                if (classValue == null) {
                    anyValueWrapper = null;
                } else {
                    String string = classValue.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    anyValueWrapper = new AnyValueWrapper(string, null);
                }
                return anyValueWrapper;
            }
            return null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lai/tock/shared/jackson/AnyValueWrapper$AnyValueSerializer;", "Lcom/fasterxml/jackson/databind/JsonSerializer;", "Lai/tock/shared/jackson/AnyValueWrapper;", "<init>", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "serializers", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "tock-shared"})
    public static final class AnyValueSerializer
    extends JsonSerializer<AnyValueWrapper> {
        public void serialize(@NotNull AnyValueWrapper value, @NotNull JsonGenerator gen, @NotNull SerializerProvider serializers) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
            Intrinsics.checkNotNullParameter((Object)serializers, (String)"serializers");
            gen.writeStartObject();
            gen.writeFieldName("klass");
            gen.writeString(value.getKlass());
            serializers.defaultSerializeField("value", value.getValue(), gen);
            gen.writeEndObject();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/tock/shared/jackson/AnyValueWrapper$Companion;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "tock-shared"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

