/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared;

import ai.tock.shared.GzipRequestInterceptor;
import ai.tock.shared.Level;
import ai.tock.shared.LoggingInterceptor;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import ai.tock.shared.TockProxyAuthenticator;
import ai.tock.shared.jackson.JacksonKt;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.retrofit.CircuitBreakerCallAdapter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001\u001aR\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00142\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u001a\u0010\u0010\u0018\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0001\u001a\u0006\u0010\u001c\u001a\u00020\u0001\u001a\u0014\u0010\u001d\u001a\u00020\n*\u00020\n2\b\b\u0002\u0010\u001e\u001a\u00020\u001f\u001a\u001e\u0010 \u001a\u0002H!\"\n\b\u0000\u0010!\u0018\u0001*\u00020\"*\u00020#H\u0086\b\u00a2\u0006\u0002\u0010$\"\u0013\u0010\u0000\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006%"}, d2={"retrofitDefaultLogLevel", "", "getRetrofitDefaultLogLevel", "()Ljava/lang/String;", "basicAuthInterceptor", "Lokhttp3/Interceptor;", "login", "password", "basicCredentialsHeader", "retrofitBuilderWithTimeoutAndLogger", "Lretrofit2/Retrofit$Builder;", "ms", "", "logger", "Lmu/KLogger;", "level", "Lai/tock/shared/Level;", "interceptors", "", "requestGZipEncoding", "", "circuitBreaker", "proxy", "Ljava/net/Proxy;", "retrofitLogLevel", "logLevel", "tokenAuthenticationInterceptor", "token", "tryToFindLocalIp", "addJacksonConverter", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "create", "T", "", "Lretrofit2/Retrofit;", "(Lretrofit2/Retrofit;)Ljava/lang/Object;", "tock-shared"})
@SourceDebugExtension(value={"SMAP\nRetrofits.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Retrofits.kt\nai/tock/shared/RetrofitsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,461:1\n1#2:462\n808#3,11:463\n1368#3:474\n1454#3,2:475\n808#3,11:477\n1456#3,3:488\n1863#3,2:491\n*S KotlinDebug\n*F\n+ 1 Retrofits.kt\nai/tock/shared/RetrofitsKt\n*L\n60#1:463,11\n61#1:474\n61#1:475,2\n61#1:477,11\n61#1:488,3\n112#1:491,2\n*E\n"})
public final class RetrofitsKt {
    @Nullable
    private static final String retrofitDefaultLogLevel = PropertiesKt.propertyOrNull("tock_retrofit_log_level");

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final String tryToFindLocalIp() {
        String string;
        String string2;
        block9: {
            Object v8;
            block7: {
                List $this$tryToFindLocalIp_u24lambda_u243;
                block8: {
                    void $this$filterIsInstanceTo$iv$iv;
                    Enumeration<InetAddress> enumeration;
                    Object v3;
                    Object object2;
                    Iterable iterable;
                    block6: {
                        Enumeration<NetworkInterface> enumeration2 = NetworkInterface.getNetworkInterfaces();
                        Intrinsics.checkNotNullExpressionValue(enumeration2, (String)"getNetworkInterfaces(...)");
                        ArrayList<NetworkInterface> arrayList = Collections.list(enumeration2);
                        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
                        $this$tryToFindLocalIp_u24lambda_u243 = arrayList;
                        boolean bl = false;
                        iterable = $this$tryToFindLocalIp_u24lambda_u243;
                        for (Object object2 : iterable) {
                            NetworkInterface it = (NetworkInterface)object2;
                            boolean bl2 = false;
                            String string3 = it.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                            if (!StringsKt.contains$default((CharSequence)string3, (CharSequence)"eno", (boolean)false, (int)2, null)) continue;
                            v3 = object2;
                            break block6;
                        }
                        v3 = null;
                    }
                    NetworkInterface networkInterface = v3;
                    if (networkInterface == null || (enumeration = networkInterface.getInetAddresses()) == null) break block8;
                    ArrayList<InetAddress> arrayList = Collections.list(enumeration);
                    Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
                    iterable = arrayList;
                    if (iterable == null) break block8;
                    Iterable $this$filterIsInstance$iv = iterable;
                    boolean $i$f$filterIsInstance = false;
                    Iterable bl2 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object t : $this$filterIsInstanceTo$iv$iv) {
                        if (!(t instanceof Inet4Address)) continue;
                        destination$iv$iv.add(t);
                    }
                    object2 = (Inet4Address)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                    if (object2 != null && (string2 = ((InetAddress)object2).getHostName()) != null) break block9;
                }
                Iterable $this$flatMap$iv = $this$tryToFindLocalIp_u24lambda_u243;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : iterable) {
                    void $this$filterIsInstanceTo$iv$iv;
                    void $this$filterIsInstance$iv;
                    NetworkInterface it = (NetworkInterface)element$iv$iv;
                    boolean bl = false;
                    Enumeration<InetAddress> enumeration = it.getInetAddresses();
                    Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getInetAddresses(...)");
                    ArrayList<InetAddress> arrayList = Collections.list(enumeration);
                    Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
                    Iterable iterable2 = arrayList;
                    boolean $i$f$filterIsInstance = false;
                    void var21_31 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv2 instanceof Inet4Address)) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                Iterable iterable3 = (List)destination$iv$iv;
                for (Object t : iterable3) {
                    Inet4Address it = (Inet4Address)t;
                    boolean bl = false;
                    String string4 = it.getHostName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getHostName(...)");
                    if (!StringsKt.startsWith$default((String)string4, (String)"192.168.0", (boolean)false, (int)2, null)) continue;
                    v8 = t;
                    break block7;
                }
                v8 = null;
            }
            Inet4Address inet4Address = v8;
            if (inet4Address == null) return "localhost";
            String string5 = inet4Address.getHostName();
            string = string5;
            if (string5 != null) return string;
            return "localhost";
        }
        string = string2;
        return string;
    }

    public static final /* synthetic */ <T> T create(Retrofit $this$create) {
        Intrinsics.checkNotNullParameter((Object)$this$create, (String)"<this>");
        boolean $i$f$create = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Object object = $this$create.create(Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        return (T)object;
    }

    @Nullable
    public static final String getRetrofitDefaultLogLevel() {
        return retrofitDefaultLogLevel;
    }

    @NotNull
    public static final Level retrofitLogLevel(@Nullable String logLevel) {
        Object object;
        block3: {
            block4: {
                block2: {
                    CharSequence charSequence;
                    if (!PropertiesKt.getDevEnvironment() || !((charSequence = (CharSequence)logLevel) == null || charSequence.length() == 0)) break block2;
                    object = Level.BODY;
                    break block3;
                }
                object = logLevel;
                if (object == null) break block4;
                String it = object;
                boolean bl = false;
                Level level = Level.valueOf(logLevel);
                object = level;
                if (level != null) break block3;
            }
            object = Level.NONE;
        }
        return object;
    }

    @NotNull
    public static final Retrofit.Builder retrofitBuilderWithTimeoutAndLogger(long ms, @NotNull KLogger logger2, @NotNull Level level, @NotNull List<? extends Interceptor> interceptors, boolean requestGZipEncoding, boolean circuitBreaker, @Nullable Proxy proxy) {
        Retrofit.Builder builder;
        Retrofit.Builder builder2;
        ConnectionSpec[] connectionSpecArray;
        Interceptor it;
        ConnectionSpec[] connectionSpecArray2;
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        ConnectionSpec[] $this$retrofitBuilderWithTimeoutAndLogger_u24lambda_u246 = connectionSpecArray2 = new OkHttpClient.Builder().readTimeout(ms, TimeUnit.MILLISECONDS).connectTimeout(ms, TimeUnit.MILLISECONDS).writeTimeout(ms, TimeUnit.MILLISECONDS);
        boolean bl = false;
        ConnectionSpec[] $this$forEach$iv = (ConnectionSpec[])interceptors;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            it = (Interceptor)t;
            boolean bl2 = false;
            $this$retrofitBuilderWithTimeoutAndLogger_u24lambda_u246.addInterceptor(it);
        }
        ConnectionSpec[] $this$retrofitBuilderWithTimeoutAndLogger_u24lambda_u248 = connectionSpecArray2;
        boolean bl3 = false;
        ConnectionSpec[] it2 = $this$forEach$iv = $this$retrofitBuilderWithTimeoutAndLogger_u24lambda_u248;
        boolean bl4 = false;
        Object object = connectionSpecArray = requestGZipEncoding ? $this$forEach$iv : null;
        if (connectionSpecArray != null) {
            connectionSpecArray.addInterceptor((Interceptor)new GzipRequestInterceptor());
        }
        connectionSpecArray2 = connectionSpecArray2.addInterceptor((Interceptor)new LoggingInterceptor(logger2, level));
        Object $this$retrofitBuilderWithTimeoutAndLogger_u24lambda_u2410 = connectionSpecArray2;
        boolean bl5 = false;
        $this$forEach$iv = new ConnectionSpec[]{ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS, ConnectionSpec.CLEARTEXT};
        $this$retrofitBuilderWithTimeoutAndLogger_u24lambda_u2410.connectionSpecs(CollectionsKt.listOf((Object[])$this$forEach$iv));
        ConnectionSpec[] it3 = it2 = $this$retrofitBuilderWithTimeoutAndLogger_u24lambda_u2410;
        boolean builder3 = false;
        Object object2 = $this$forEach$iv = proxy != null ? it2 : null;
        if ($this$forEach$iv != null) {
            $this$forEach$iv.proxy(proxy);
        }
        $this$retrofitBuilderWithTimeoutAndLogger_u24lambda_u2410 = TockProxyAuthenticator.Companion;
        ConnectionSpec[] p0 = connectionSpecArray2;
        boolean bl7 = false;
        ((TockProxyAuthenticator.Companion)$this$retrofitBuilderWithTimeoutAndLogger_u24lambda_u2410).install((OkHttpClient.Builder)p0);
        OkHttpClient it4 = connectionSpecArray2.build();
        boolean bl8 = false;
        Retrofit.Builder $this$retrofitBuilderWithTimeoutAndLogger_u24lambda_u2413_u24lambda_u2412 = builder2 = new Retrofit.Builder().client(it4);
        boolean bl9 = false;
        Retrofit.Builder builder4 = $this$retrofitBuilderWithTimeoutAndLogger_u24lambda_u2413_u24lambda_u2412;
        it = builder4;
        boolean bl10 = false;
        Object object3 = builder = circuitBreaker && PropertiesKt.booleanProperty("tock_circuit_breaker", false) ? builder4 : null;
        if (builder != null) {
            builder.addCallAdapterFactory((CallAdapter.Factory)CircuitBreakerCallAdapter.of((CircuitBreaker)CircuitBreaker.ofDefaults((String)logger2.getName())));
        }
        Retrofit.Builder builder5 = builder2;
        Intrinsics.checkNotNullExpressionValue((Object)builder5, (String)"let(...)");
        return builder5;
    }

    public static /* synthetic */ Retrofit.Builder retrofitBuilderWithTimeoutAndLogger$default(long l, KLogger kLogger, Level level, List list, boolean bl, boolean bl2, Proxy proxy, int n, Object object) {
        if ((n & 2) != 0) {
            kLogger = KotlinLogging.INSTANCE.logger((Function0)retrofitBuilderWithTimeoutAndLogger.1.INSTANCE);
        }
        if ((n & 4) != 0) {
            level = RetrofitsKt.retrofitLogLevel(retrofitDefaultLogLevel);
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        if ((n & 0x40) != 0) {
            proxy = null;
        }
        return RetrofitsKt.retrofitBuilderWithTimeoutAndLogger(l, kLogger, level, list, bl, bl2, proxy);
    }

    @NotNull
    public static final Interceptor basicAuthInterceptor(@NotNull String login, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)login, (String)"login");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String credential = RetrofitsKt.basicCredentialsHeader(login, password);
        return arg_0 -> RetrofitsKt.basicAuthInterceptor$lambda$14(credential, arg_0);
    }

    @NotNull
    public static final Interceptor tokenAuthenticationInterceptor(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return arg_0 -> RetrofitsKt.tokenAuthenticationInterceptor$lambda$15(token, arg_0);
    }

    @NotNull
    public static final String basicCredentialsHeader(@NotNull String login, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)login, (String)"login");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        return Credentials.basic$default((String)login, (String)password, null, (int)4, null);
    }

    @NotNull
    public static final Retrofit.Builder addJacksonConverter(@NotNull Retrofit.Builder $this$addJacksonConverter, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)$this$addJacksonConverter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Retrofit.Builder $this$addJacksonConverter_u24lambda_u2416 = $this$addJacksonConverter;
        boolean bl = false;
        Retrofit.Builder builder = $this$addJacksonConverter_u24lambda_u2416.addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"run(...)");
        return builder;
    }

    public static /* synthetic */ Retrofit.Builder addJacksonConverter$default(Retrofit.Builder builder, ObjectMapper objectMapper, int n, Object object) {
        if ((n & 1) != 0) {
            objectMapper = JacksonKt.getMapper();
        }
        return RetrofitsKt.addJacksonConverter(builder, objectMapper);
    }

    private static final Response basicAuthInterceptor$lambda$14(String $credential, Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request original = chain.request();
        Request.Builder requestBuilder = original.newBuilder().header("Authorization", $credential);
        Request request = requestBuilder.build();
        return chain.proceed(request);
    }

    private static final Response tokenAuthenticationInterceptor$lambda$15(String $token, Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request original = chain.request();
        Request.Builder requestBuilder = original.newBuilder().header("Authorization", "Bearer " + $token);
        Request request = requestBuilder.build();
        return chain.proceed(request);
    }
}

