/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared.security;

import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.security.EncryptorsKt;
import ai.tock.shared.security.TockObfuscatorService;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import mu.KLogger;
import mu.KotlinLogging;
import org.jasypt.contrib.org.apache.commons.codec_1_3.binary.Base64;
import org.jasypt.util.text.BasicTextEncryptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u000e\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u000e\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0016\u001a\u000e\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"UUID_OID_NAMESPACE", "", "encryptionEnabled", "", "getEncryptionEnabled", "()Z", "logger", "Lmu/KLogger;", "oidNamespaceBytes", "", "textEncryptor", "Lorg/jasypt/util/text/BasicTextEncryptor;", "getTextEncryptor", "()Lorg/jasypt/util/text/BasicTextEncryptor;", "textEncryptor$delegate", "Lkotlin/Lazy;", "decrypt", "s", "encrypt", "initEncryptor", "", "sha256Uuid", "Ljava/util/UUID;", "namespace", "shaS256", "uuidFromBytes", "data", "tock-shared"})
public final class EncryptorsKt {
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private static final Lazy textEncryptor$delegate = LazyKt.lazy((Function0)textEncryptor.2.INSTANCE);
    private static final boolean encryptionEnabled = PropertiesKt.propertyExists("tock_encrypt_pass");
    @NotNull
    private static final String UUID_OID_NAMESPACE = "6ba7b812-9dad-11d1-80b4-00c04fd430c8";
    @NotNull
    private static final byte[] oidNamespaceBytes;

    private static final BasicTextEncryptor getTextEncryptor() {
        Lazy lazy = textEncryptor$delegate;
        return (BasicTextEncryptor)lazy.getValue();
    }

    public static final boolean getEncryptionEnabled() {
        return encryptionEnabled;
    }

    @NotNull
    public static final String shaS256(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        String string = s;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] byArray2 = Base64.encodeBase64Chunked((byte[])messageDigest.digest(byArray));
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"encodeBase64Chunked(...)");
        return new String(byArray2, Charsets.UTF_8);
    }

    @NotNull
    public static final UUID sha256Uuid(@NotNull String s, @Nullable UUID namespace) {
        Object object;
        MessageDigest $this$sha256Uuid_u24lambda_u240;
        MessageDigest messageDigest;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                $this$sha256Uuid_u24lambda_u240 = messageDigest = MessageDigest.getInstance("SHA-256");
                boolean bl = false;
                object = namespace;
                if (object == null || (object = ((UUID)object).toString()) == null) break block2;
                byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                object = byArray;
                if (byArray != null) break block3;
            }
            object = oidNamespaceBytes;
        }
        $this$sha256Uuid_u24lambda_u240.update((byte[])object);
        byte[] byArray = s.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        $this$sha256Uuid_u24lambda_u240.update(byArray);
        byte[] digest = messageDigest.digest();
        digest[6] = (byte)(digest[6] & 0xF);
        digest[6] = (byte)(digest[6] | 0x80);
        digest[8] = (byte)(digest[8] & 0x3F);
        digest[8] = (byte)(digest[8] | 0x80);
        Intrinsics.checkNotNull((Object)digest);
        return EncryptorsKt.uuidFromBytes(digest);
    }

    public static /* synthetic */ UUID sha256Uuid$default(String string, UUID uUID, int n, Object object) {
        if ((n & 2) != 0) {
            uUID = null;
        }
        return EncryptorsKt.sha256Uuid(string, uUID);
    }

    private static final UUID uuidFromBytes(byte[] data) {
        int i;
        if (!(data.length >= 16)) {
            boolean bl = false;
            String string = "data must be at least 16 bytes in length, was " + data.length;
            throw new IllegalArgumentException(string.toString());
        }
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    @NotNull
    public static final String encrypt(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String string = EncryptorsKt.getTextEncryptor().encrypt(s);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encrypt(...)");
        return string;
    }

    @NotNull
    public static final String decrypt(@NotNull String s) {
        String string;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        try {
            string = EncryptorsKt.getTextEncryptor().decrypt(s);
            Intrinsics.checkNotNull((Object)string);
        }
        catch (Exception e) {
            LoggersKt.error(logger, e);
            string = s;
        }
        return string;
    }

    public static final void initEncryptor() {
        if (encryptionEnabled) {
            logger.info((Function0)initEncryptor.1.INSTANCE);
            EncryptorsKt.decrypt(EncryptorsKt.encrypt("test"));
            logger.info((Function0)initEncryptor.2.INSTANCE);
        }
        TockObfuscatorService.INSTANCE.loadObfuscators$tock_shared();
    }

    static {
        String string = UUID_OID_NAMESPACE;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        oidNamespaceBytes = byArray;
    }
}

