/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.shared.security;

import ai.tock.shared.CollectionsKt;
import ai.tock.shared.Loader;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.security.MapObfuscator;
import ai.tock.shared.security.ObfuscatorService;
import ai.tock.shared.security.StringObfuscator;
import ai.tock.shared.security.TockObfuscatorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\r\u0010\f\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\rJ\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J6\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00122\u001a\b\u0002\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0015J&\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00152\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0015J\u001f\u0010\u0018\u001a\u00020\u000b2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u001a\"\u00020\u0007\u00a2\u0006\u0002\u0010\u001bJ\u001f\u0010\u001c\u001a\u00020\u000b2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u001a\"\u00020\t\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lai/tock/shared/security/TockObfuscatorService;", "", "()V", "logger", "Lmu/KLogger;", "mapObfuscators", "", "Lai/tock/shared/security/MapObfuscator;", "stringObfuscators", "Lai/tock/shared/security/StringObfuscator;", "deregisterObfuscators", "", "loadObfuscators", "loadObfuscators$tock_shared", "obfuscate", "", "text", "obfuscatedRanges", "", "Lkotlin/ranges/IntRange;", "texts", "", "", "map", "registerMapObfuscator", "newObfuscators", "", "([Lai/tock/shared/security/MapObfuscator;)V", "registerStringObfuscator", "([Lai/tock/shared/security/StringObfuscator;)V", "tock-shared"})
@SourceDebugExtension(value={"SMAP\nTockObfuscatorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TockObfuscatorService.kt\nai/tock/shared/security/TockObfuscatorService\n+ 2 Loader.kt\nai/tock/shared/Loader\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,125:1\n30#2:126\n30#2:135\n1368#3:127\n1454#3,5:128\n1863#3,2:133\n1368#3:136\n1454#3,5:137\n1863#3,2:142\n1567#3:144\n1598#3,4:145\n1863#3,2:149\n1863#3,2:153\n1317#4,2:151\n*S KotlinDebug\n*F\n+ 1 TockObfuscatorService.kt\nai/tock/shared/security/TockObfuscatorService\n*L\n37#1:126\n41#1:135\n38#1:127\n38#1:128,5\n39#1:133,2\n42#1:136\n42#1:137,5\n43#1:142,2\n78#1:144\n78#1:145,4\n93#1:149,2\n115#1:153,2\n96#1:151,2\n*E\n"})
public final class TockObfuscatorService {
    @NotNull
    public static final TockObfuscatorService INSTANCE = new TockObfuscatorService();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    @NotNull
    private static final List<StringObfuscator> stringObfuscators = new CopyOnWriteArrayList();
    @NotNull
    private static final List<MapObfuscator> mapObfuscators = new CopyOnWriteArrayList();

    private TockObfuscatorService() {
    }

    public final void loadObfuscators$tock_shared() {
        try {
            Iterable list$iv$iv;
            ObfuscatorService it;
            Object element$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            Loader this_$iv = Loader.INSTANCE;
            boolean $i$f$loadServices = false;
            Iterator<ObfuscatorService> iterator = ServiceLoader.load(ObfuscatorService.class).iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterable $this$flatMap$iv = CollectionsKt.toSafeList(iterator);
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = iterator2.next();
                it = (ObfuscatorService)element$iv$iv;
                boolean bl = false;
                list$iv$iv = it.stringObfuscators();
                kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StringObfuscator it2 = (StringObfuscator)element$iv;
                boolean bl = false;
                element$iv$iv = new StringObfuscator[]{it2};
                INSTANCE.registerStringObfuscator((StringObfuscator)element$iv$iv);
            }
            this_$iv = Loader.INSTANCE;
            $i$f$loadServices = false;
            Iterator<ObfuscatorService> iterator3 = ServiceLoader.load(ObfuscatorService.class).iterator();
            Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
            $this$flatMap$iv = CollectionsKt.toSafeList(iterator3);
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            $i$f$flatMapTo = false;
            Iterator bl = $this$flatMapTo$iv$iv.iterator();
            while (bl.hasNext()) {
                element$iv$iv = bl.next();
                it = (ObfuscatorService)element$iv$iv;
                boolean bl2 = false;
                list$iv$iv = it.parameterObfuscators();
                kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$forEach$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MapObfuscator it3 = (MapObfuscator)element$iv;
                boolean bl3 = false;
                MapObfuscator[] mapObfuscatorArray = new MapObfuscator[]{it3};
                INSTANCE.registerMapObfuscator(mapObfuscatorArray);
            }
        }
        catch (Exception e) {
            LoggersKt.error(logger, e);
        }
    }

    public final void registerStringObfuscator(StringObfuscator ... newObfuscators) {
        Intrinsics.checkNotNullParameter((Object)newObfuscators, (String)"newObfuscators");
        stringObfuscators.addAll(ArraysKt.toList((Object[])newObfuscators));
    }

    public final void registerMapObfuscator(MapObfuscator ... newObfuscators) {
        Intrinsics.checkNotNullParameter((Object)newObfuscators, (String)"newObfuscators");
        mapObfuscators.addAll(ArraysKt.toList((Object[])newObfuscators));
    }

    public final void deregisterObfuscators() {
        stringObfuscators.clear();
        mapObfuscators.clear();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> obfuscate(@NotNull List<String> texts, @NotNull Map<Integer, ? extends List<IntRange>> obfuscatedRanges) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(texts, (String)"texts");
        Intrinsics.checkNotNullParameter(obfuscatedRanges, (String)"obfuscatedRanges");
        Iterable $this$mapIndexed$iv = texts;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void t;
            String string;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                kotlin.collections.CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List list = obfuscatedRanges.get((int)index);
            if (list == null) {
                list = kotlin.collections.CollectionsKt.emptyList();
            }
            if ((string = INSTANCE.obfuscate((String)t, list)) == null) {
                string = "";
            }
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List obfuscate$default(TockObfuscatorService tockObfuscatorService, List list, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        return tockObfuscatorService.obfuscate(list, map);
    }

    @Nullable
    public final String obfuscate(@Nullable String text, @NotNull List<IntRange> obfuscatedRanges) {
        String string;
        Intrinsics.checkNotNullParameter(obfuscatedRanges, (String)"obfuscatedRanges");
        try {
            String string2;
            if (text == null) {
                string2 = null;
            } else {
                StringObfuscator it;
                String t = null;
                t = text;
                Iterable $this$forEach$iv = stringObfuscators;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (StringObfuscator)element$iv;
                    boolean bl = false;
                    t = it.obfuscate(t);
                }
                $this$forEach$iv = SequencesKt.filterNot((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)obfuscatedRanges), (Function1)obfuscate.3.INSTANCE);
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (IntRange)element$iv;
                    boolean bl = false;
                    String string3 = t;
                    CharSequence charSequence = StringsKt.repeat((CharSequence)"*", (int)(1 + it.getLast() - it.getFirst()));
                    t = ((Object)StringsKt.replaceRange((CharSequence)string3, (IntRange)it, (CharSequence)charSequence)).toString();
                }
                string2 = string;
            }
            string = string2;
        }
        catch (Exception e) {
            LoggersKt.error(logger, e);
            string = text;
        }
        return string;
    }

    public static /* synthetic */ String obfuscate$default(TockObfuscatorService tockObfuscatorService, String string, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = kotlin.collections.CollectionsKt.emptyList();
        }
        return tockObfuscatorService.obfuscate(string, list);
    }

    @NotNull
    public final Map<String, String> obfuscate(@NotNull Map<String, String> map) {
        Map<String, String> map2;
        Intrinsics.checkNotNullParameter(map, (String)"map");
        try {
            Map<String, String> p = null;
            p = map;
            Iterable $this$forEach$iv = mapObfuscators;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MapObfuscator it = (MapObfuscator)element$iv;
                boolean bl = false;
                p = it.obfuscate(p);
            }
        }
        catch (Exception e) {
            LoggersKt.error(logger, e);
            map2 = map;
        }
        return map2;
    }
}

