/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.translator.google;

import ai.tock.translator.TranslatorEngine;
import com.google.cloud.translate.Translate;
import com.google.cloud.translate.TranslateOptions;
import com.google.cloud.translate.Translation;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lai/tock/translator/google/GoogleTranslatorEngine;", "Lai/tock/translator/TranslatorEngine;", "()V", "supportAdminTranslation", "", "getSupportAdminTranslation", "()Z", "translate", "Lcom/google/cloud/translate/Translate;", "kotlin.jvm.PlatformType", "", "text", "source", "Ljava/util/Locale;", "target", "tock-translator-google"})
public final class GoogleTranslatorEngine
implements TranslatorEngine {
    @NotNull
    public static final GoogleTranslatorEngine INSTANCE = new GoogleTranslatorEngine();
    private static final Translate translate = (Translate)TranslateOptions.getDefaultInstance().getService();
    private static final boolean supportAdminTranslation = true;

    private GoogleTranslatorEngine() {
    }

    @NotNull
    public String translate(@NotNull String text, @NotNull Locale source, @NotNull Locale target) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Translate.TranslateOption[] translateOptionArray = new Translate.TranslateOption[]{Translate.TranslateOption.sourceLanguage((String)source.getLanguage()), Translate.TranslateOption.targetLanguage((String)target.getLanguage())};
        Translation translation = translate.translate(text, translateOptionArray);
        String string = StringEscapeUtils.unescapeHtml4((String)translation.getTranslatedText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unescapeHtml4(translation.translatedText)");
        return string;
    }

    public boolean getSupportAdminTranslation() {
        return supportAdminTranslation;
    }
}

