/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.translator.google;

import ai.tock.translator.TranslatorEngine;
import com.google.cloud.translate.Translate;
import com.google.cloud.translate.TranslateOptions;
import com.google.cloud.translate.Translation;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.text.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lai/tock/translator/google/GoogleTranslatorEngine;", "Lai/tock/translator/TranslatorEngine;", "<init>", "()V", "translate", "Lcom/google/cloud/translate/Translate;", "kotlin.jvm.PlatformType", "Lcom/google/cloud/translate/Translate;", "", "text", "source", "Ljava/util/Locale;", "target", "supportAdminTranslation", "", "getSupportAdminTranslation", "()Z", "tock-translator-google"})
public final class GoogleTranslatorEngine
implements TranslatorEngine {
    @NotNull
    public static final GoogleTranslatorEngine INSTANCE = new GoogleTranslatorEngine();
    private static final Translate translate = (Translate)TranslateOptions.getDefaultInstance().getService();
    private static final boolean supportAdminTranslation = true;

    private GoogleTranslatorEngine() {
    }

    @NotNull
    public String translate(@NotNull String text, @NotNull Locale source, @NotNull Locale target) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Translate.TranslateOption[] translateOptionArray = new Translate.TranslateOption[]{Translate.TranslateOption.sourceLanguage((String)source.getLanguage()), Translate.TranslateOption.targetLanguage((String)target.getLanguage())};
        Translation translation = translate.translate(text, translateOptionArray);
        String string = StringEscapeUtils.unescapeHtml4((String)translation.getTranslatedText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unescapeHtml4(...)");
        return string;
    }

    public boolean getSupportAdminTranslation() {
        return supportAdminTranslation;
    }
}

