/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.xray;

import ai.tock.bot.xray.IssueRetrieved;
import ai.tock.bot.xray.NoIssueRetrieved;
import ai.tock.bot.xray.SearchIssueResult;
import ai.tock.bot.xray.TooMuchIssuesRetrieved;
import ai.tock.bot.xray.XrayApi;
import ai.tock.bot.xray.XrayClient;
import ai.tock.bot.xray.XrayConfiguration;
import ai.tock.bot.xray.model.JiraAttachment;
import ai.tock.bot.xray.model.JiraIssue;
import ai.tock.bot.xray.model.JiraIssueLink;
import ai.tock.bot.xray.model.JiraKey;
import ai.tock.bot.xray.model.JiraTest;
import ai.tock.bot.xray.model.JiraTestProject;
import ai.tock.bot.xray.model.JiraType;
import ai.tock.bot.xray.model.SearchResult;
import ai.tock.bot.xray.model.XrayAttachment;
import ai.tock.bot.xray.model.XrayBuildTestStep;
import ai.tock.bot.xray.model.XrayTest;
import ai.tock.bot.xray.model.XrayTestExecution;
import ai.tock.bot.xray.model.XrayTestExecutionCreation;
import ai.tock.bot.xray.model.XrayTestPlan;
import ai.tock.bot.xray.model.XrayTestStep;
import ai.tock.bot.xray.model.XrayUpdateTest;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import com.beust.klaxon.JsonArray;
import com.beust.klaxon.JsonObject;
import com.beust.klaxon.Klaxon;
import com.beust.klaxon.Parser;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Response;
import retrofit2.Retrofit;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nJ:\u0010\u0012\u001a&\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u000f0\u000f \u0014*\u0012\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u00130\u00132\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\rJ\u000e\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\nJ\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\nJ\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\n0)2\u0006\u0010*\u001a\u00020\nJ\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020\n0)2\u0006\u0010*\u001a\u00020\n2\u0006\u0010,\u001a\u00020\nJ\u000e\u0010-\u001a\u00020.2\u0006\u0010$\u001a\u00020\nJ\u0014\u0010/\u001a\b\u0012\u0004\u0012\u0002000)2\u0006\u00101\u001a\u00020\nJ\u0014\u00102\u001a\b\u0012\u0004\u0012\u0002030)2\u0006\u00104\u001a\u00020\nJ\u0014\u00105\u001a\b\u0012\u0004\u0012\u0002060)2\u0006\u0010\u001e\u001a\u00020\nJ\u0014\u00107\u001a\b\u0012\u0004\u0012\u0002030)2\u0006\u0010\u001e\u001a\u00020\nJ\u0016\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020\nJ\u0018\u0010<\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010=\u001a\u00020>J\u0014\u0010?\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\u0006\u0010@\u001a\u00020AJ\u0018\u0010B\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u001cJ\u001e\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\n2\u0006\u0010F\u001a\u00020\n2\u0006\u0010G\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lai/tock/bot/xray/XrayClient;", "", "()V", "logger", "Lmu/KLogger;", "xray", "Lai/tock/bot/xray/XrayApi;", "getXray", "()Lai/tock/bot/xray/XrayApi;", "xrayLogin", "", "xrayPassword", "xrayTimeoutInSeconds", "", "addPrecondition", "Lokhttp3/ResponseBody;", "preConditionKey", "jiraId", "addTestToTestPlan", "Lretrofit2/Response;", "kotlin.jvm.PlatformType", "test", "testPlan", "createNewTestExecutionIssue", "Lai/tock/bot/xray/model/JiraIssue;", "textExectuionFields", "Lai/tock/bot/xray/model/XrayTestExecutionCreation;", "createTest", "Lai/tock/bot/xray/model/JiraTest;", "deleteStep", "testKey", "stepId", "getAttachmentToString", "attachment", "Lai/tock/bot/xray/model/XrayAttachment;", "getIssue", "issueKey", "getKeyOfSearchedIssue", "Lai/tock/bot/xray/SearchIssueResult;", "jql", "getLabels", "", "key", "getLinkedIssues", "linkedField", "getProjectFromIssue", "Lai/tock/bot/xray/model/JiraTestProject;", "getProjectTestPlans", "Lai/tock/bot/xray/model/XrayTestPlan;", "project", "getTestPlanTests", "Lai/tock/bot/xray/model/XrayTest;", "testPlanKey", "getTestSteps", "Lai/tock/bot/xray/model/XrayTestStep;", "getTests", "linkTest", "", "key1", "key2", "saveStep", "step", "Lai/tock/bot/xray/model/XrayBuildTestStep;", "sendTestExecution", "execution", "Lai/tock/bot/xray/model/XrayTestExecution;", "updateTest", "uploadAttachment", "Lai/tock/bot/xray/model/JiraAttachment;", "issueId", "name", "content", "tock-xray-plugin"})
@SourceDebugExtension(value={"SMAP\nXrayClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XrayClient.kt\nai/tock/bot/xray/XrayClient\n+ 2 Retrofits.kt\nai/tock/shared/RetrofitsKt\n*L\n1#1,244:1\n71#2:245\n*S KotlinDebug\n*F\n+ 1 XrayClient.kt\nai/tock/bot/xray/XrayClient\n*L\n73#1:245\n*E\n"})
public final class XrayClient {
    @NotNull
    public static final XrayClient INSTANCE = new XrayClient();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
    private static final long xrayTimeoutInSeconds = PropertiesKt.longProperty((String)"tock_bot_test_xray_timeout_in_ms", (long)60000L);
    @NotNull
    private static final String xrayLogin = PropertiesKt.property((String)"tock_bot_test_xray_login", (String)"please set xray login");
    @NotNull
    private static final String xrayPassword = PropertiesKt.property((String)"tock_bot_test_xray_password", (String)"please set xray password");
    @NotNull
    private static final XrayApi xray;

    private XrayClient() {
    }

    @NotNull
    public final XrayApi getXray() {
        return xray;
    }

    @NotNull
    public final List<XrayTest> getTestPlanTests(@NotNull String testPlanKey) {
        Intrinsics.checkNotNullParameter((Object)testPlanKey, (String)"testPlanKey");
        List list = (List)xray.getTestsOfTestPlan(testPlanKey).execute().body();
        if (list == null) {
            throw new IllegalStateException(("no test in " + testPlanKey).toString());
        }
        List tests = list;
        List list2 = (List)xray.getTests(CollectionsKt.joinToString$default((Iterable)tests, (CharSequence)";", null, null, (int)0, null, (Function1)getTestPlanTests.1.INSTANCE, (int)30, null)).execute().body();
        if (list2 == null) {
            throw new IllegalStateException(("unable to get tests for " + tests).toString());
        }
        return list2;
    }

    @NotNull
    public final List<XrayTest> getTests(@NotNull String testKey) {
        Intrinsics.checkNotNullParameter((Object)testKey, (String)"testKey");
        List list = (List)xray.getTests(testKey).execute().body();
        if (list == null) {
            throw new IllegalStateException(("unable to get the test " + testKey).toString());
        }
        return list;
    }

    @NotNull
    public final List<XrayTestStep> getTestSteps(@NotNull String testKey) {
        Intrinsics.checkNotNullParameter((Object)testKey, (String)"testKey");
        List list = (List)xray.getTestSteps(testKey).execute().body();
        if (list == null) {
            throw new IllegalStateException(("no test steps for " + testKey).toString());
        }
        return list;
    }

    @NotNull
    public final SearchIssueResult getKeyOfSearchedIssue(@NotNull String jql) {
        SearchIssueResult searchIssueResult;
        JsonArray issuesArray;
        Intrinsics.checkNotNullParameter((Object)jql, (String)"jql");
        Klaxon klaxon = new Klaxon();
        ResponseBody responseBody = (ResponseBody)xray.searchIssue(jql).execute().body();
        String body = responseBody != null ? responseBody.string() : null;
        JsonObject parsed = klaxon.parseJsonObject((Reader)new StringReader(body));
        JsonArray jsonArray = issuesArray = parsed.array("issues");
        switch (jsonArray != null ? jsonArray.size() : 0) {
            case 0: {
                searchIssueResult = NoIssueRetrieved.INSTANCE;
                break;
            }
            case 1: {
                JsonArray jsonArray2 = issuesArray;
                searchIssueResult = new IssueRetrieved(StringsKt.replace$default((String)StringsKt.replace$default((String)String.valueOf(jsonArray2 != null && (jsonArray2 = jsonArray2.get("key")) != null ? jsonArray2.getValue() : null), (String)"[", (String)"", (boolean)false, (int)4, null), (String)"]", (String)"", (boolean)false, (int)4, null));
                break;
            }
            default: {
                searchIssueResult = TooMuchIssuesRetrieved.INSTANCE;
            }
        }
        return searchIssueResult;
    }

    @NotNull
    public final JiraTestProject getProjectFromIssue(@NotNull String issueKey) {
        JiraTestProject jiraTestProject;
        Intrinsics.checkNotNullParameter((Object)issueKey, (String)"issueKey");
        Klaxon klaxon = new Klaxon();
        Response xrayResponse = xray.getIssue(issueKey).execute();
        if (xrayResponse.isSuccessful()) {
            Object object = (ResponseBody)xrayResponse.body();
            if (object == null || (object = object.string()) == null) {
                object = "";
            }
            JsonObject parsed = klaxon.parseJsonObject((Reader)new StringReader((String)object));
            Object object2 = MapsKt.getValue((Map)((Map)parsed), (Object)"fields");
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.beust.klaxon.JsonObject");
            Object project = ((JsonObject)object2).getMap().get("project");
            Intrinsics.checkNotNull(project, (String)"null cannot be cast to non-null type com.beust.klaxon.JsonObject");
            jiraTestProject = new JiraTestProject(String.valueOf(((JsonObject)project).get((Object)"key")));
        } else {
            logger.error((Function0)new Function0<Object>((Response<ResponseBody>)xrayResponse){
                final /* synthetic */ Response<ResponseBody> $xrayResponse;
                {
                    this.$xrayResponse = $xrayResponse;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "ERROR -- Jira project not retrieved -->" + this.$xrayResponse.errorBody();
                }
            });
            jiraTestProject = new JiraTestProject("");
        }
        return jiraTestProject;
    }

    @NotNull
    public final JiraIssue createNewTestExecutionIssue(@NotNull XrayTestExecutionCreation textExectuionFields) {
        Intrinsics.checkNotNullParameter((Object)textExectuionFields, (String)"textExectuionFields");
        JiraIssue jiraIssue = (JiraIssue)xray.createTestExecution(textExectuionFields).execute().body();
        if (jiraIssue == null) {
            throw new IllegalStateException("Test execution creation has failed.".toString());
        }
        return jiraIssue;
    }

    @NotNull
    public final Response<ResponseBody> sendTestExecution(@NotNull XrayTestExecution execution) {
        Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
        Response response = xray.sendTestExecution(execution).execute();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"execute(...)");
        return response;
    }

    @NotNull
    public final String getAttachmentToString(@NotNull XrayAttachment attachment) {
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        Object object = (ResponseBody)xray.getAttachment(attachment.getId(), attachment.getFileName()).execute().body();
        if (object == null || (object = object.string()) == null) {
            object = "error : empty jira attachment";
        }
        return object;
    }

    @NotNull
    public final JiraIssue createTest(@NotNull JiraTest test) {
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        JiraIssue jiraIssue = (JiraIssue)xray.createTest(test).execute().body();
        if (jiraIssue == null) {
            throw new IllegalStateException(("error during creating test " + test).toString());
        }
        return jiraIssue;
    }

    @Nullable
    public final ResponseBody saveStep(@NotNull String testKey, @NotNull XrayBuildTestStep step) {
        Intrinsics.checkNotNullParameter((Object)testKey, (String)"testKey");
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        return (ResponseBody)xray.saveStep(testKey, step).execute().body();
    }

    @NotNull
    public final ResponseBody deleteStep(@NotNull String testKey, long stepId) {
        Intrinsics.checkNotNullParameter((Object)testKey, (String)"testKey");
        ResponseBody responseBody = (ResponseBody)xray.deleteStep(testKey, stepId).execute().body();
        if (responseBody == null) {
            throw new IllegalStateException("error during test step deletion".toString());
        }
        return responseBody;
    }

    @NotNull
    public final ResponseBody getIssue(@NotNull String issueKey) {
        Intrinsics.checkNotNullParameter((Object)issueKey, (String)"issueKey");
        ResponseBody responseBody = (ResponseBody)xray.getIssue(issueKey).execute().body();
        if (responseBody == null) {
            throw new IllegalStateException("error: issue not found".toString());
        }
        return responseBody;
    }

    @Nullable
    public final ResponseBody addPrecondition(@NotNull String preConditionKey, @NotNull String jiraId) {
        Intrinsics.checkNotNullParameter((Object)preConditionKey, (String)"preConditionKey");
        Intrinsics.checkNotNullParameter((Object)jiraId, (String)"jiraId");
        return (ResponseBody)xray.addPrecondition(preConditionKey, new XrayUpdateTest(CollectionsKt.listOf((Object)jiraId), null, 2, null)).execute().body();
    }

    @Nullable
    public final ResponseBody updateTest(@NotNull String jiraId, @NotNull JiraTest test) {
        Intrinsics.checkNotNullParameter((Object)jiraId, (String)"jiraId");
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        return (ResponseBody)xray.updateTest(jiraId, test).execute().body();
    }

    @NotNull
    public final JiraAttachment uploadAttachment(@NotNull String issueId, @NotNull String name, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Object object = (List)XrayApi.DefaultImpls.addAttachment$default(xray, issueId, MultipartBody.Part.Companion.createFormData("file", name, RequestBody.Companion.create(MediaType.Companion.get("text/plain"), content)), null, 4, null).execute().body();
        if (object == null || (object = (JiraAttachment)CollectionsKt.firstOrNull((List)object)) == null) {
            throw new IllegalStateException(("error during attachment of " + content).toString());
        }
        return object;
    }

    public final void linkTest(@NotNull String key1, @NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key1, (String)"key1");
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key2");
        xray.linkIssue(new JiraIssueLink(new JiraType("Associate"), new JiraKey(key1), new JiraKey(key2))).execute();
    }

    @NotNull
    public final List<String> getLabels(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Response response = xray.getIssue(key).execute();
        Parser parser = Parser.Companion.invoke$default((Parser.Companion)Parser.Companion, null, null, (boolean)false, (int)7, null);
        Object object = response.body();
        Intrinsics.checkNotNull((Object)object);
        Object object2 = parser.parse(new StringBuilder(((ResponseBody)object).string()));
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.beust.klaxon.JsonObject");
        JsonObject body = (JsonObject)object2;
        JsonObject jsonObject = body.obj("fields");
        return jsonObject != null && (jsonObject = jsonObject.array("labels")) != null ? (List)jsonObject : CollectionsKt.emptyList();
    }

    @NotNull
    public final List<String> getLinkedIssues(@NotNull String key, @NotNull String linkedField) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)linkedField, (String)"linkedField");
        Response response = xray.getIssue(key).execute();
        Parser parser = Parser.Companion.invoke$default((Parser.Companion)Parser.Companion, null, null, (boolean)false, (int)7, null);
        Object object = response.body();
        Intrinsics.checkNotNull((Object)object);
        Object object2 = parser.parse(new StringBuilder(((ResponseBody)object).string()));
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.beust.klaxon.JsonObject");
        JsonObject body = (JsonObject)object2;
        JsonObject jsonObject = body.obj("fields");
        return jsonObject != null && (jsonObject = jsonObject.array(linkedField)) != null ? (List)jsonObject : CollectionsKt.emptyList();
    }

    public final Response<ResponseBody> addTestToTestPlan(@NotNull String test, @NotNull String testPlan) {
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        Intrinsics.checkNotNullParameter((Object)testPlan, (String)"testPlan");
        return xray.addTestToTestPlans(testPlan, new XrayUpdateTest(CollectionsKt.listOf((Object)test), null, 2, null)).execute();
    }

    @NotNull
    public final List<XrayTestPlan> getProjectTestPlans(@NotNull String project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new String[]{"key", "summary"};
        Response response = xray.searchTestPlans("project= " + project + " AND issuetype=\"Test Plan\" order by key ASC", CollectionsKt.listOf((Object[])objectArray)).execute();
        SearchResult searchResult = (SearchResult)response.body();
        if (searchResult == null) {
            throw new IllegalStateException(("No test plans for project " + project + " !").toString());
        }
        SearchResult searchResult2 = searchResult;
        return searchResult2.getIssues();
    }

    static {
        Retrofit retrofit = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)xrayTimeoutInSeconds, null, null, (List)CollectionsKt.listOf((Object)RetrofitsKt.basicAuthInterceptor((String)xrayLogin, (String)xrayPassword)), (boolean)false, (boolean)false, null, (int)118, null), null, (int)1, null).baseUrl(XrayConfiguration.INSTANCE.getXrayUrl$tock_xray_plugin()).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"build(...)");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(XrayApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        xray = (XrayApi)object;
    }
}

