/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.xray;

import ai.tock.bot.admin.dialog.ActionReport;
import ai.tock.bot.admin.dialog.DialogReport;
import ai.tock.bot.admin.dialog.DialogReportDAO;
import ai.tock.bot.definition.BotDefinitionBase;
import ai.tock.bot.engine.BotBus;
import ai.tock.bot.engine.Bus;
import ai.tock.bot.engine.message.Message;
import ai.tock.bot.engine.message.Sentence;
import ai.tock.bot.xray.XrayKeywords;
import ai.tock.bot.xray.XrayService;
import ai.tock.bot.xray.model.XrayTest;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u001d\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0011J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lai/tock/bot/xray/XrayKeywordHandler;", "", "<init>", "()V", "logger", "Lmu/KLogger;", "dialogReportDAO", "Lai/tock/bot/admin/dialog/DialogReportDAO;", "jiraKeyProject", "", "createXray", "", "keyword", "bus", "Lai/tock/bot/engine/BotBus;", "createXray$tock_xray_plugin", "updateXray", "updateXray$tock_xray_plugin", "cleanSurrogates", "Lai/tock/bot/admin/dialog/DialogReport;", "tock-xray-plugin"})
@SourceDebugExtension(value={"SMAP\nXrayKeywordHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XrayKeywordHandler.kt\nai/tock/bot/xray/XrayKeywordHandler\n+ 2 IOCs.kt\nai/tock/shared/IOCsKt\n+ 3 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 4 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,133:1\n53#2,2:134\n51#3:136\n277#4:137\n1872#5,2:138\n1874#5:142\n774#5:143\n865#5,2:144\n1179#6,2:140\n*S KotlinDebug\n*F\n+ 1 XrayKeywordHandler.kt\nai/tock/bot/xray/XrayKeywordHandler\n*L\n35#1:134,2\n35#1:136\n35#1:137\n117#1:138,2\n117#1:142\n52#1:143\n52#1:144,2\n120#1:140,2\n*E\n"})
public final class XrayKeywordHandler {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(XrayKeywordHandler::logger$lambda$0);
    @NotNull
    private final DialogReportDAO dialogReportDAO;
    @NotNull
    private final String jiraKeyProject;

    public XrayKeywordHandler() {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        this.dialogReportDAO = (DialogReportDAO)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<DialogReportDAO>(){}, tag$iv).getValue()).invoke();
        this.jiraKeyProject = PropertiesKt.property((String)"tock_bot_test_jira_project", (String)"Set a key for the jira project.");
    }

    public final void createXray$tock_xray_plugin(@NotNull String keyword, @NotNull BotBus bus) {
        BotBus botBus;
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        String[] stringArray = new String[]{","};
        List params = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)keyword, (String)XrayKeywords.INSTANCE.getXRAY_KEYWORD(), (String)"", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (params.size() == 1 && StringsKt.isBlank((CharSequence)((CharSequence)params.get(0)))) {
            botBus = (BotBus)Bus.DefaultImpls.endRawText$default((Bus)((Bus)bus), (CharSequence)"Error : Test title is mandatory", (long)0L, (int)2, null);
        } else {
            XrayTest xrayTest;
            Map labelPlanMap = MapsKt.emptyMap();
            try {
                DialogReport dialogReport = this.dialogReportDAO.getDialog(bus.getDialog().getId());
                Intrinsics.checkNotNull((Object)dialogReport);
                DialogReport dialog = this.cleanSurrogates(dialogReport);
                String string = (String)CollectionsKt.getOrNull((List)params, (int)1);
                String linkedJira = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
                String connectorName = "";
                Function1 testTitle = arg_0 -> XrayKeywordHandler.createXray$lambda$3(linkedJira, this, connectorName, params, labelPlanMap, arg_0);
                xrayTest = new XrayService(null, null, null, null, 15, null).generateXrayTest(dialog, (Function1<? super List<String>, String>)testTitle, linkedJira, CollectionsKt.listOfNotNull((Object)""), labelPlanMap);
            }
            catch (Exception e) {
                LoggersKt.error((KLogger)this.logger, (Throwable)e);
                xrayTest = null;
            }
            XrayTest xray = xrayTest;
            BotDefinitionBase.Companion.endTestContextKeywordHandler(bus, false);
            bus.setNextUserActionState(null);
            botBus = xray != null ? (BotBus)Bus.DefaultImpls.endRawText$default((Bus)((Bus)bus), (CharSequence)("Xray issue created : " + xray.getKey()), (long)0L, (int)2, null) : (BotBus)Bus.DefaultImpls.endRawText$default((Bus)((Bus)bus), (CharSequence)"Error during issue creation", (long)0L, (int)2, null);
        }
    }

    public final void updateXray$tock_xray_plugin(@NotNull String keyword, @NotNull BotBus bus) {
        BotBus botBus;
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        String params = StringsKt.replace$default((String)keyword, (String)XrayKeywords.INSTANCE.getXRAY_UPDATE_KEYWORD(), (String)"", (boolean)false, (int)4, null);
        String testKey = ((Object)StringsKt.trim((CharSequence)params)).toString();
        if (StringsKt.isBlank((CharSequence)testKey)) {
            botBus = (BotBus)Bus.DefaultImpls.endRawText$default((Bus)((Bus)bus), (CharSequence)"Error: test key is mandatory", (long)0L, (int)2, null);
        } else if (!StringsKt.contains$default((CharSequence)testKey, (CharSequence)this.jiraKeyProject, (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{"-"};
            botBus = (BotBus)Bus.DefaultImpls.endRawText$default((Bus)((Bus)bus), (CharSequence)("Error: project key (" + ((Object)StringsKt.trim((CharSequence)((String)StringsKt.split$default((CharSequence)params, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0)))).toString() + ") does not match expected one (" + this.jiraKeyProject + ")"), (long)0L, (int)2, null);
        } else {
            XrayTest xrayTest;
            try {
                DialogReport dialogReport = this.dialogReportDAO.getDialog(bus.getDialog().getId());
                Intrinsics.checkNotNull((Object)dialogReport);
                DialogReport dialog = this.cleanSurrogates(dialogReport);
                xrayTest = new XrayService(null, null, null, null, 15, null).updateXrayTest(dialog, testKey);
            }
            catch (Exception e) {
                LoggersKt.error((KLogger)this.logger, (Throwable)e);
                xrayTest = null;
            }
            XrayTest xray = xrayTest;
            BotDefinitionBase.Companion.endTestContextKeywordHandler(bus, false);
            bus.setNextUserActionState(null);
            botBus = xray != null ? (BotBus)Bus.DefaultImpls.endRawText$default((Bus)((Bus)bus), (CharSequence)("Xray issue updated : " + testKey), (long)0L, (int)2, null) : (BotBus)Bus.DefaultImpls.endRawText$default((Bus)((Bus)bus), (CharSequence)("Error during update of issue " + testKey), (long)0L, (int)2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final DialogReport cleanSurrogates(DialogReport $this$cleanSurrogates) {
        List cleanedActions = new ArrayList();
        Iterable $this$forEachIndexed$iv = $this$cleanSurrogates.getActions();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            boolean bl;
            void currentAction;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ActionReport actionReport = (ActionReport)item$iv;
            int index = n;
            boolean bl2 = false;
            String currentActionMessage = null;
            currentActionMessage = currentAction.getMessage().toPrettyString();
            if (currentAction.getMessage().isSimpleMessage()) {
                CharSequence $this$forEach$iv = currentActionMessage;
                boolean $i$f$forEach = false;
                for (int i = 0; i < $this$forEach$iv.length(); ++i) {
                    char element$iv;
                    char c = element$iv = $this$forEach$iv.charAt(i);
                    boolean bl3 = false;
                    if (!CharsKt.isSurrogate((char)c)) continue;
                    currentActionMessage = StringsKt.replace$default((String)currentActionMessage, (String)String.valueOf(c), (String)"", (boolean)false, (int)4, null);
                }
                bl = cleanedActions.add(ActionReport.copy$default((ActionReport)currentAction, null, null, null, (Message)((Message)new Sentence(currentActionMessage, null, null, null, 14, null)), null, null, (boolean)false, null, null, null, null, (int)2039, null));
                continue;
            }
            bl = cleanedActions.add($this$cleanSurrogates.getActions().get(index));
        }
        return new DialogReport(cleanedActions, $this$cleanSurrogates.getUserInterface(), $this$cleanSurrogates.getId(), false, null, null, 56, null);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final String createXray$lambda$3(String $linkedJira, XrayKeywordHandler this$0, String $connectorName, List $params, Map $labelPlanMap, List labels) {
        String string;
        String string2;
        String string3;
        String string4;
        block5: {
            block4: {
                void $this$createXray_u24lambda_u243_u24lambda_u242;
                String linkedJiraNumber;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$connectorName, (String)"$connectorName");
                Intrinsics.checkNotNullParameter((Object)$params, (String)"$params");
                Intrinsics.checkNotNullParameter((Object)$labelPlanMap, (String)"$labelPlanMap");
                Intrinsics.checkNotNullParameter((Object)labels, (String)"labels");
                Iterable $this$filter$iv = labels;
                boolean $i$f$filter = false;
                Object object = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (!$labelPlanMap.containsKey(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List l = (List)destination$iv$iv;
                String labelLink = l.isEmpty() ? "" : "[" + CollectionsKt.first((List)l) + "]";
                object = $linkedJira;
                string4 = linkedJiraNumber = object == null || StringsKt.isBlank((CharSequence)object) ? "" : StringsKt.replace$default((String)$linkedJira, (String)(this$0.jiraKeyProject + "-"), (String)"", (boolean)false, (int)4, null) + " - ";
                string3 = $connectorName;
                string2 = labelLink;
                string = (String)CollectionsKt.getOrNull((List)$params, (int)0);
                if (string == null) break block4;
                String string5 = string;
                String string6 = string2;
                String string7 = string3;
                String string8 = string4;
                boolean bl = false;
                String string9 = StringsKt.isBlank((CharSequence)((CharSequence)$this$createXray_u24lambda_u243_u24lambda_u242)) ? null : ((Object)StringsKt.trim((CharSequence)((CharSequence)$this$createXray_u24lambda_u243_u24lambda_u242))).toString();
                string4 = string8;
                string3 = string7;
                string2 = string6;
                String string10 = string9;
                string = string10;
                if (string10 != null) break block5;
            }
            string = "Test";
        }
        return string4 + " [AUTO]" + string3 + string2 + " " + string;
    }
}

