/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.xray;

import ai.tock.bot.admin.bot.BotApplicationConfiguration;
import ai.tock.bot.admin.dialog.ActionReport;
import ai.tock.bot.admin.dialog.DialogReport;
import ai.tock.bot.admin.test.DialogExecutionReport;
import ai.tock.bot.admin.test.TestActionReport;
import ai.tock.bot.admin.test.TestClientServiceKt;
import ai.tock.bot.admin.test.TestDialogReport;
import ai.tock.bot.admin.test.TestPlan;
import ai.tock.bot.admin.test.TestPlanDAO;
import ai.tock.bot.admin.test.TestPlanExecution;
import ai.tock.bot.admin.test.TestPlanExecutionStatus;
import ai.tock.bot.connector.ConnectorType;
import ai.tock.bot.engine.message.Message;
import ai.tock.bot.engine.message.Sentence;
import ai.tock.bot.engine.message.parser.MessageParser;
import ai.tock.bot.engine.user.PlayerId;
import ai.tock.bot.engine.user.PlayerType;
import ai.tock.bot.xray.IssueRetrieved;
import ai.tock.bot.xray.NoIssueRetrieved;
import ai.tock.bot.xray.SearchIssueResult;
import ai.tock.bot.xray.TooMuchIssuesRetrieved;
import ai.tock.bot.xray.XrayClient;
import ai.tock.bot.xray.XrayConfiguration;
import ai.tock.bot.xray.XrayPlanExecutionResult;
import ai.tock.bot.xray.model.JiraIssue;
import ai.tock.bot.xray.model.JiraIssueType;
import ai.tock.bot.xray.model.JiraTest;
import ai.tock.bot.xray.model.JiraTestProject;
import ai.tock.bot.xray.model.XrayAttachment;
import ai.tock.bot.xray.model.XrayBuildStepAttachment;
import ai.tock.bot.xray.model.XrayBuildTestStep;
import ai.tock.bot.xray.model.XrayExecutionConfiguration;
import ai.tock.bot.xray.model.XrayPrecondition;
import ai.tock.bot.xray.model.XrayStatus;
import ai.tock.bot.xray.model.XrayTest;
import ai.tock.bot.xray.model.XrayTestExecution;
import ai.tock.bot.xray.model.XrayTestExecutionCreation;
import ai.tock.bot.xray.model.XrayTestExecutionInfo;
import ai.tock.bot.xray.model.XrayTestExecutionReport;
import ai.tock.bot.xray.model.XrayTestExecutionStepReport;
import ai.tock.bot.xray.model.XrayTestPlan;
import ai.tock.bot.xray.model.XrayTestStep;
import ai.tock.bot.xray.model.XrayTextExecutionFields;
import ai.tock.shared.DatesKt;
import ai.tock.shared.Dice;
import ai.tock.shared.IOCsKt;
import ai.tock.shared.LocalesKt;
import ai.tock.shared.LoggersKt;
import ai.tock.shared.PropertiesKt;
import ai.tock.translator.UserInterfaceType;
import com.github.salomonbrys.kodein.KodeinInjectedBase;
import com.github.salomonbrys.kodein.KodeinInjector;
import com.github.salomonbrys.kodein.TypeReference;
import com.github.salomonbrys.kodein.TypeToken;
import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.litote.kmongo.Id;
import org.litote.kmongo.IdsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001_BA\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0003J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004J\u000e\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004J\u000e\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004J\u0016\u0010%\u001a\u00020!2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u0003H\u0002JJ\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u00032\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\u00032\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u0003H\u0002J$\u00104\u001a\b\u0012\u0004\u0012\u00020'0\u00032\u0006\u00105\u001a\u00020/2\f\u00106\u001a\b\u0012\u0004\u0012\u00020807H\u0002J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u000208H\u0002J:\u0010<\u001a\b\u0012\u0004\u0012\u00020'0\u00032\u0006\u00105\u001a\u00020/2\u0006\u0010*\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u00106\u001a\b\u0012\u0004\u0012\u00020807H\u0002J.\u0010=\u001a\u00020'2\u0006\u00105\u001a\u00020/2\u0006\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020@2\f\u00106\u001a\b\u0012\u0004\u0012\u00020807H\u0002J\u0018\u0010A\u001a\u00020@2\u0006\u00105\u001a\u00020/2\u0006\u0010B\u001a\u00020\u0004H\u0002J&\u0010C\u001a\u00020@2\u0006\u00105\u001a\u00020/2\u0006\u0010*\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0018\u0010D\u001a\u0002012\u0006\u00105\u001a\u00020/2\u0006\u0010E\u001a\u00020FH\u0002J>\u0010G\u001a\u0004\u0018\u00010H2\u0006\u00105\u001a\u00020/2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020\u000f2\b\u0010N\u001a\u0004\u0018\u00010\u00042\b\u0010O\u001a\u0004\u0018\u00010PH\u0002J\\\u0010Q\u001a\u0004\u0018\u00010F2\u0006\u0010R\u001a\u00020S2\u001a\b\u0002\u0010T\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0004\u0012\u00020\u00040U2\n\b\u0002\u0010V\u001a\u0004\u0018\u00010\u00042\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0014\b\u0002\u0010X\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0012J\u0018\u0010Y\u001a\u0004\u0018\u00010F2\u0006\u0010R\u001a\u00020S2\u0006\u0010Z\u001a\u00020\u0004J\u0018\u0010[\u001a\n\u0012\u0004\u0012\u00020\\\u0018\u00010\u00032\u0006\u0010R\u001a\u00020SH\u0002J\f\u0010]\u001a\u00020)*\u00020^H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lai/tock/bot/xray/XrayService;", "", "configurationIds", "", "", "testPlanKeys", "testKeys", "testedBotId", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "logger", "Lmu/KLogger;", "configurationNames", "startSentence", "userId", "Lai/tock/bot/engine/user/PlayerId;", "botId", "connectorJiraMap", "", "jiraProject", "testTypeField", "manualStepsField", "linkedField", "locale", "Ljava/util/Locale;", "instant", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "Ljava/time/Instant;", "jiraRegisteredBotUrl", "getTestPlans", "Lai/tock/bot/xray/model/XrayTestPlan;", "execute", "Lai/tock/bot/xray/XrayPlanExecutionResult;", "namespace", "executeTestPlans", "executeTests", "sendToXray", "reports", "Lai/tock/bot/xray/XrayService$TestPlanExecutionReport;", "sendXrayExecution", "", "planKey", "start", "Ljava/time/OffsetDateTime;", "end", "configurations", "Lai/tock/bot/xray/model/XrayExecutionConfiguration;", "dialogs", "Lai/tock/bot/admin/test/TestDialogReport;", "executionDialogs", "Lai/tock/bot/admin/test/DialogExecutionReport;", "exec", "configuration", "executionId", "Lorg/litote/kmongo/Id;", "Lai/tock/bot/admin/test/TestPlanExecution;", "saveTestPlanExecution", "", "testPlanExecution", "execTestsOnly", "executePlan", "xrayTestPlanKey", "testPlan", "Lai/tock/bot/admin/test/TestPlan;", "getTestPlanFromXray", "xrayPlanKey", "createTestPlanWithTests", "getDialogReport", "xrayTest", "Lai/tock/bot/xray/model/XrayTest;", "parseStepData", "Lai/tock/bot/admin/test/TestActionReport;", "userInterface", "Lai/tock/translator/UserInterfaceType;", "stepId", "", "playerId", "raw", "xrayAttachment", "Lai/tock/bot/xray/model/XrayAttachment;", "generateXrayTest", "dialog", "Lai/tock/bot/admin/dialog/DialogReport;", "testName", "Lkotlin/Function1;", "linkedJira", "testsPlans", "labelTestPlansMap", "updateXrayTest", "testKey", "defineTestSteps", "Lai/tock/bot/xray/model/XrayBuildTestStep;", "isEmptyMessage", "Lai/tock/bot/engine/message/Message;", "TestPlanExecutionReport", "tock-xray-plugin"})
@SourceDebugExtension(value={"SMAP\nXrayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XrayService.kt\nai/tock/bot/xray/XrayService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 IOCs.kt\nai/tock/shared/IOCsKt\n+ 6 GInjected.kt\ncom/github/salomonbrys/kodein/GInjectedKt\n+ 7 types.kt\ncom/github/salomonbrys/kodein/TypesKt\n*L\n1#1,745:1\n774#2:746\n865#2,2:747\n774#2:749\n865#2,2:750\n1368#2:752\n1454#2,5:753\n774#2:758\n865#2,2:759\n774#2:761\n865#2,2:762\n1368#2:764\n1454#2,5:765\n1485#2:770\n1510#2,3:771\n1513#2,3:781\n774#2:785\n865#2,2:786\n1557#2:788\n1628#2,3:789\n1557#2:792\n1628#2,3:793\n1557#2:796\n1628#2,3:797\n1557#2:800\n1628#2,3:801\n1053#2:804\n1557#2:805\n1628#2,2:806\n295#2,2:808\n774#2:810\n865#2,2:811\n1557#2:813\n1628#2,3:814\n1630#2:817\n2632#2,3:818\n1734#2,3:821\n1611#2,9:824\n1863#2:833\n1864#2:835\n1620#2:836\n1611#2,9:841\n1863#2:850\n1864#2:852\n1620#2:853\n774#2:854\n865#2,2:855\n774#2:857\n865#2,2:858\n1557#2:860\n1628#2,3:861\n1863#2,2:864\n774#2:866\n865#2,2:867\n1557#2:869\n1628#2,3:870\n1368#2:873\n1454#2,2:874\n295#2,2:876\n295#2,2:878\n1456#2,3:880\n1863#2,2:883\n774#2:885\n865#2,2:886\n1863#2,2:888\n1863#2,2:890\n1863#2,2:892\n1863#2,2:894\n1863#2:896\n1755#2,3:897\n1864#2:900\n1557#2:901\n1628#2,3:902\n1557#2:905\n1628#2,3:906\n1557#2:909\n1628#2,3:910\n1557#2:913\n1628#2,3:914\n1663#2,8:917\n1368#2:925\n1454#2,5:926\n1368#2:931\n1454#2,5:932\n1734#2,3:937\n381#3,7:774\n1#4:784\n1#4:834\n1#4:851\n53#5,2:837\n51#6:839\n277#7:840\n*S KotlinDebug\n*F\n+ 1 XrayService.kt\nai/tock/bot/xray/XrayService\n*L\n146#1:746\n146#1:747,2\n147#1:749\n147#1:750,2\n152#1:752\n152#1:753,5\n181#1:758\n181#1:759,2\n182#1:761\n182#1:762,2\n187#1:764\n187#1:765,5\n213#1:770\n213#1:771,3\n213#1:781,3\n250#1:785\n250#1:786,2\n252#1:788\n252#1:789,3\n291#1:792\n291#1:793,3\n306#1:796\n306#1:797,3\n311#1:800\n311#1:801,3\n315#1:804\n316#1:805\n316#1:806,2\n317#1:808,2\n330#1:810\n330#1:811,2\n332#1:813\n332#1:814,3\n316#1:817\n363#1:818,3\n365#1:821,3\n384#1:824,9\n384#1:833\n384#1:835\n384#1:836\n427#1:841,9\n427#1:850\n427#1:852\n427#1:853\n486#1:854\n486#1:855,2\n493#1:857\n493#1:858,2\n495#1:860\n495#1:861,3\n515#1:864,2\n521#1:866\n521#1:867,2\n522#1:869\n522#1:870,3\n551#1:873\n551#1:874,2\n559#1:876,2\n567#1:878,2\n551#1:880,3\n644#1:883,2\n649#1:885\n649#1:886,2\n650#1:888,2\n656#1:890,2\n676#1:892,2\n680#1:894,2\n693#1:896\n717#1:897,3\n693#1:900\n216#1:901\n216#1:902,3\n220#1:905\n220#1:906,3\n226#1:909\n226#1:910,3\n231#1:913\n231#1:914,3\n231#1:917,8\n232#1:925\n232#1:926,5\n233#1:931\n233#1:932,5\n236#1:937,3\n213#1:774,7\n384#1:834\n427#1:851\n414#1:837,2\n414#1:839\n414#1:840\n*E\n"})
public final class XrayService {
    @NotNull
    private final List<String> configurationIds;
    @NotNull
    private final List<String> testPlanKeys;
    @NotNull
    private final List<String> testKeys;
    @NotNull
    private final String testedBotId;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final List<String> configurationNames;
    @NotNull
    private final String startSentence;
    @NotNull
    private final PlayerId userId;
    @NotNull
    private final PlayerId botId;
    @NotNull
    private final Map<String, List<String>> connectorJiraMap;
    @NotNull
    private final String jiraProject;
    @NotNull
    private final String testTypeField;
    @NotNull
    private final String manualStepsField;
    @NotNull
    private final String linkedField;
    @NotNull
    private final Locale locale;
    private final Instant instant;
    @NotNull
    private final String jiraRegisteredBotUrl;

    public XrayService(@NotNull List<String> configurationIds, @NotNull List<String> testPlanKeys, @NotNull List<String> testKeys, @NotNull String testedBotId) {
        Intrinsics.checkNotNullParameter(configurationIds, (String)"configurationIds");
        Intrinsics.checkNotNullParameter(testPlanKeys, (String)"testPlanKeys");
        Intrinsics.checkNotNullParameter(testKeys, (String)"testKeys");
        Intrinsics.checkNotNullParameter((Object)testedBotId, (String)"testedBotId");
        this.configurationIds = configurationIds;
        this.testPlanKeys = testPlanKeys;
        this.testKeys = testKeys;
        this.testedBotId = testedBotId;
        this.logger = KotlinLogging.INSTANCE.logger(XrayService::logger$lambda$0);
        this.configurationNames = PropertiesKt.listProperty$default((String)"tock_bot_test_configuration_names", (List)CollectionsKt.emptyList(), null, (int)4, null);
        this.startSentence = PropertiesKt.property((String)"tock_bot_test_start_sentence", (String)"");
        this.userId = new PlayerId("testUser", PlayerType.user, null, 4, null);
        this.botId = new PlayerId("testBot", PlayerType.bot, null, 4, null);
        this.connectorJiraMap = PropertiesKt.mapListProperty$default((String)"tock_bot_test_connector_jira_map", (Map)MapsKt.emptyMap(), null, null, null, (int)28, null);
        this.jiraProject = PropertiesKt.property((String)"tock_bot_test_jira_project", (String)"please set a jira project");
        this.testTypeField = PropertiesKt.property((String)"tock_bot_test_jira_xray_test_type_field", (String)"please set a test type field");
        this.manualStepsField = PropertiesKt.property((String)"tock_bot_test_jira_xray_manual_test_field", (String)"please set a test type field");
        this.linkedField = PropertiesKt.property((String)"tock_bot_test_jira_linked_field", (String)"");
        String string = LocalesKt.getDefaultLocale().toLanguageTag();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLanguageTag(...)");
        Locale locale = Locale.forLanguageTag(PropertiesKt.property((String)"tock_bot_test_locale", (String)string));
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"forLanguageTag(...)");
        this.locale = locale;
        this.instant = Instant.now();
        this.jiraRegisteredBotUrl = PropertiesKt.property((String)"tock_bot_test_jira_registered_bot_url", (String)"${botUrl}");
        XrayConfiguration.INSTANCE.configure();
    }

    public /* synthetic */ XrayService(List list, List list2, List list3, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = PropertiesKt.listProperty$default((String)"tock_bot_test_configuration_ids", (List)CollectionsKt.emptyList(), null, (int)4, null);
        }
        if ((n & 2) != 0) {
            list2 = PropertiesKt.listProperty$default((String)"tock_bot_test_xray_test_plan_keys", (List)CollectionsKt.emptyList(), null, (int)4, null);
        }
        if ((n & 4) != 0) {
            list3 = PropertiesKt.listProperty$default((String)"tock_bot_test_xray_test_keys", (List)CollectionsKt.emptyList(), null, (int)4, null);
        }
        if ((n & 8) != 0) {
            string = PropertiesKt.property((String)"tock_bot_test_botId", (String)"please set a bot id to test");
        }
        this(list, list2, list3, string);
    }

    @NotNull
    public final List<XrayTestPlan> getTestPlans() {
        return XrayClient.INSTANCE.getProjectTestPlans(this.jiraProject);
    }

    @NotNull
    public final XrayPlanExecutionResult execute(@NotNull String namespace) {
        XrayPlanExecutionResult xrayPlanExecutionResult;
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        if (!((Collection)this.testKeys).isEmpty() && !((Collection)this.testPlanKeys).isEmpty()) {
            throw new AssertionError((Object)"Cannot execute test plan and test at the same time.");
        }
        if (!((Collection)this.testKeys).isEmpty()) {
            xrayPlanExecutionResult = this.executeTests(namespace);
        } else if (!((Collection)this.testPlanKeys).isEmpty()) {
            xrayPlanExecutionResult = this.executeTestPlans(namespace);
        } else {
            this.logger.warn(XrayService::execute$lambda$1);
            xrayPlanExecutionResult = new XrayPlanExecutionResult(0, 0, "ERROR : Specify \"testPlanKey\" OR (xor) \"testKey\".");
        }
        return xrayPlanExecutionResult;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final XrayPlanExecutionResult executeTestPlans(@NotNull String namespace) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this.logger.info(() -> XrayService.executeTestPlans$lambda$2(namespace));
        JiraTestProject jiraProject = XrayClient.INSTANCE.getProjectFromIssue(this.testPlanKeys.get(0));
        String executionId = Dice.INSTANCE.newId();
        try {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            BotApplicationConfiguration it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            object = TestClientServiceKt.findTestClient().getBotConfigurations(namespace, this.testedBotId);
            boolean $i$f$filter = false;
            void var6_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (BotApplicationConfiguration)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getConnectorType(), (Object)ConnectorType.Companion.getRest())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (BotApplicationConfiguration)element$iv$iv;
                boolean bl = false;
                if (!(this.configurationIds.contains(it.get_id().toString()) || this.configurationIds.isEmpty() && this.configurationNames.contains(it.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (BotApplicationConfiguration)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = this.exec(new XrayExecutionConfiguration(it, this.testPlanKeys, jiraProject, null, null, 24, null), (Id<TestPlanExecution>)IdsKt.toId((String)executionId));
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List it2 = (List)destination$iv$iv;
            boolean bl = false;
            object = this.sendToXray(it2);
        }
        catch (Throwable t) {
            LoggersKt.error((KLogger)this.logger, (Throwable)t);
            object = new XrayPlanExecutionResult(0, 0, "No test run");
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final XrayPlanExecutionResult executeTests(@NotNull String namespace) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        String dummyTestPlanKey = "AUTO_" + this.testKeys.get(0);
        JiraTestProject jiraProject = XrayClient.INSTANCE.getProjectFromIssue(this.testKeys.get(0));
        String executionId = Dice.INSTANCE.newId();
        this.logger.info(() -> XrayService.executeTests$lambda$7(namespace));
        this.logger.debug(() -> XrayService.executeTests$lambda$8(executionId, dummyTestPlanKey));
        try {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            BotApplicationConfiguration it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            object = TestClientServiceKt.findTestClient().getBotConfigurations(namespace, this.testedBotId);
            boolean $i$f$filter = false;
            void var7_9 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (BotApplicationConfiguration)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getConnectorType(), (Object)ConnectorType.Companion.getRest())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (BotApplicationConfiguration)element$iv$iv;
                boolean bl = false;
                if (!(this.configurationIds.contains(it.get_id().toString()) || this.configurationIds.isEmpty() && this.configurationNames.contains(it.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (BotApplicationConfiguration)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = this.execTestsOnly(new XrayExecutionConfiguration(it, CollectionsKt.listOf((Object)dummyTestPlanKey), jiraProject, null, null, 24, null), dummyTestPlanKey, this.testKeys, (Id<TestPlanExecution>)IdsKt.toId((String)executionId));
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List it2 = (List)destination$iv$iv;
            boolean bl = false;
            this.logger.debug(() -> XrayService.executeTests$lambda$13$lambda$12(executionId, dummyTestPlanKey));
            object = this.sendToXray(it2);
        }
        catch (Throwable t) {
            this.logger.error(t.getMessage());
            object = new XrayPlanExecutionResult(0, 0, "No test run: " + t.getMessage());
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final XrayPlanExecutionResult sendToXray(List<TestPlanExecutionReport> reports) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        int n;
        int n2;
        Iterator $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = reports;
        int $i$f$groupBy = 0;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            TestPlanExecutionReport it = (TestPlanExecutionReport)element$iv$iv;
            boolean bl3 = false;
            String key$iv$iv = it.getPlanKey();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        destination$iv$iv2.forEach((arg_0, arg_1) -> XrayService.sendToXray$lambda$26((arg_0, arg_1) -> XrayService.sendToXray$lambda$25(this, arg_0, arg_1), arg_0, arg_1));
        $this$groupBy$iv = reports;
        $i$f$groupBy = 0;
        for (Object destination$iv$iv2 : $this$groupBy$iv) {
            void $this$filterTo$iv$iv;
            void it;
            TestPlanExecutionReport $i$f$groupByTo2 = (TestPlanExecutionReport)destination$iv$iv2;
            n2 = $i$f$groupBy;
            boolean bl = false;
            Iterable $this$filter$iv = it.getExecution().getDialogs();
            boolean $i$f$filter = false;
            Iterable bl3 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                DialogExecutionReport dialogExecutionReport = (DialogExecutionReport)element$iv$iv;
                boolean bl4 = false;
                if (!(!dialogExecutionReport.getError())) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            n = ((List)destination$iv$iv3).size();
            $i$f$groupBy = n2 + n;
        }
        $this$groupBy$iv = reports;
        n2 = $i$f$groupBy;
        $i$f$groupBy = 0;
        for (Object destination$iv$iv2 : $this$groupBy$iv) {
            TestPlanExecutionReport it = (TestPlanExecutionReport)destination$iv$iv2;
            n = $i$f$groupBy;
            boolean bl = false;
            int n3 = it.getExecution().getDialogs().size();
            $i$f$groupBy = n + n3;
        }
        n = $i$f$groupBy;
        $this$groupBy$iv = reports;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object v1;
            Object object;
            block8: {
                void it;
                TestPlanExecutionReport $i$f$filter = (TestPlanExecutionReport)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                Iterable iterable2 = it.getExecution().getDialogs();
                for (Object t : iterable2) {
                    DialogExecutionReport dialogExecutionReport = (DialogExecutionReport)t;
                    boolean bl5 = false;
                    if (!dialogExecutionReport.getError()) continue;
                    v1 = t;
                    break block8;
                }
                v1 = null;
            }
            DialogExecutionReport dialogExecutionReport = v1;
            object.add(dialogExecutionReport != null ? dialogExecutionReport.getErrorMessage() : null);
        }
        List list = (List)destination$iv$iv2;
        String string = list.toString();
        int n4 = n;
        int n5 = n2;
        return new XrayPlanExecutionResult(n5, n4, string);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean sendXrayExecution(String planKey, OffsetDateTime start, OffsetDateTime end, List<XrayExecutionConfiguration> configurations, List<TestDialogReport> dialogs, List<DialogExecutionReport> executionDialogs) {
        boolean bl;
        boolean bl2;
        Collection<XrayTestExecutionReport> collection;
        Iterable $this$sortedBy$iv;
        Collection<String> collection2;
        String string;
        XrayExecutionConfiguration it;
        Object object;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Iterator iterator;
        Iterable $this$map$iv;
        boolean $i$f$map;
        Object object2;
        Object object3;
        SearchIssueResult testExecutionKeyIssue = XrayClient.INSTANCE.getKeyOfSearchedIssue("project = \"" + configurations.get(0).getJiraTestProject().getKey() + "\" and issuetype = \"Test Execution\" and summary ~ \"" + planKey + " " + configurations.get(0).getBotConfiguration().getName() + "\"");
        SearchIssueResult searchIssueResult = testExecutionKeyIssue;
        if (Intrinsics.areEqual((Object)searchIssueResult, (Object)TooMuchIssuesRetrieved.INSTANCE)) {
            throw new IllegalStateException(("too many test executions have been retrieved with summary \"" + planKey + " " + configurations.get(0).getBotConfiguration().getName() + "\".").toString());
        }
        if (Intrinsics.areEqual((Object)searchIssueResult, (Object)NoIssueRetrieved.INSTANCE)) {
            Iterable iterable = configurations;
            object3 = planKey;
            object2 = configurations.get(0).getJiraTestProject();
            XrayClient xrayClient = XrayClient.INSTANCE;
            $i$f$map = false;
            iterator = $this$map$iv;
            Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                XrayExecutionConfiguration xrayExecutionConfiguration = (XrayExecutionConfiguration)item$iv$iv;
                object = collection3;
                boolean bl3 = false;
                object.add(it.getBotConfiguration().getName());
            }
            object = (List)collection3;
            JiraIssueType jiraIssueType = new JiraIssueType("Test Execution");
            String string2 = "Automatized Test Execution";
            String string3 = (String)object3 + " - " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSortedSet((Iterable)((Iterable)object)), null, null, null, (int)0, null, null, (int)63, null);
            Object object4 = object2;
            XrayTextExecutionFields xrayTextExecutionFields = new XrayTextExecutionFields((JiraTestProject)object4, string3, string2, jiraIssueType);
            string = xrayClient.createNewTestExecutionIssue(new XrayTestExecutionCreation(xrayTextExecutionFields)).getKey();
        } else {
            if (!(searchIssueResult instanceof IssueRetrieved)) throw new NoWhenBranchMatchedException();
            string = ((IssueRetrieved)testExecutionKeyIssue).getKey();
        }
        String testExecutionKey = string;
        $this$map$iv = configurations;
        object2 = planKey;
        String string4 = testExecutionKey;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        Collection collection4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (XrayExecutionConfiguration)item$iv$iv;
            object3 = collection4;
            boolean bl4 = false;
            object3.add(it.getBotConfiguration().getName());
        }
        object3 = (List)collection4;
        String string5 = (String)object2 + " - " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSortedSet((Iterable)((Iterable)object3)), null, null, null, (int)0, null, null, (int)63, null);
        $this$map$iv = configurations;
        String string6 = planKey;
        OffsetDateTime offsetDateTime = end;
        object = start;
        object3 = "Automatized Test Execution";
        object2 = string5;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        Collection collection5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (XrayExecutionConfiguration)item$iv$iv;
            collection2 = collection5;
            boolean bl5 = false;
            collection2.add(it.getEnvironment());
        }
        collection2 = (List)collection5;
        List list = CollectionsKt.toList((Iterable)CollectionsKt.toSortedSet((Iterable)collection2));
        String string7 = string6;
        OffsetDateTime offsetDateTime2 = offsetDateTime;
        Object object5 = object;
        Object object6 = object3;
        Object object7 = object2;
        $this$map$iv = executionDialogs;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                DialogExecutionReport it = (DialogExecutionReport)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getDialogReportId().toString());
                it = (DialogExecutionReport)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getDialogReportId().toString())));
            }
        });
        XrayTestExecutionInfo xrayTestExecutionInfo = new XrayTestExecutionInfo((String)object7, (String)object6, (OffsetDateTime)object5, offsetDateTime2, string7, list);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        Collection collection6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List list2;
            Object object8;
            Object v2;
            void dialogReport;
            block33: {
                it = (DialogExecutionReport)item$iv$iv;
                collection = collection6;
                boolean bl6 = false;
                Iterable $this$firstOrNull$iv = dialogs;
                boolean $i$f$firstOrNull = false;
                for (Object t : $this$firstOrNull$iv) {
                    TestDialogReport it2 = (TestDialogReport)t;
                    boolean bl7 = false;
                    if (!Intrinsics.areEqual((Object)it2.getId(), (Object)dialogReport.getDialogReportId())) continue;
                    v2 = t;
                    break block33;
                }
                v2 = null;
            }
            TestDialogReport dialog = v2;
            boolean stepViewed = false;
            String string8 = dialogReport.getDialogReportId().toString();
            OffsetDateTime offsetDateTime4 = OffsetDateTime.ofInstant(dialogReport.getDate(), DatesKt.getDefaultZoneId());
            offsetDateTime4 = offsetDateTime4;
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime3, (String)"ofInstant(...)");
            OffsetDateTime offsetDateTime6 = OffsetDateTime.ofInstant(dialogReport.getDate(), DatesKt.getDefaultZoneId()).plus(dialogReport.getDuration());
            offsetDateTime6 = offsetDateTime6;
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime5, (String)"plus(...)");
            if (dialogReport.getError()) {
                String string9 = dialogReport.getErrorMessage();
                if (string9 == null) {
                    string9 = "";
                }
                object8 = "Failed execution " + string9;
            } else {
                object8 = "Successful execution";
            }
            XrayStatus xrayStatus = dialogReport.getError() ? XrayStatus.FAIL : XrayStatus.PASS;
            Object object9 = dialog;
            if (object9 != null && (object9 = object9.getActions()) != null) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                void $this$filterTo$iv$iv;
                Iterable iterable = (Iterable)object9;
                XrayStatus xrayStatus2 = xrayStatus;
                Object object10 = object8;
                OffsetDateTime offsetDateTime7 = offsetDateTime6;
                OffsetDateTime offsetDateTime8 = offsetDateTime4;
                String string10 = string8;
                boolean $i$f$filter22 = false;
                Iterable bl7 = iterable;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    TestActionReport it3 = (TestActionReport)element$iv$iv;
                    boolean bl8 = false;
                    if (!(it3.getPlayerId().getType() == PlayerType.bot)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Collection<XrayTestExecutionStepReport> collection7 = (List)destination$iv$iv;
                Iterable $i$f$filter22 = collection7;
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    Object object11;
                    void testActionReport;
                    XrayStatus xrayStatus3;
                    TestActionReport bl8 = (TestActionReport)item$iv$iv2;
                    collection7 = destination$iv$iv2;
                    boolean bl9 = false;
                    if (!dialogReport.getError()) {
                        xrayStatus3 = XrayStatus.PASS;
                    } else if (stepViewed) {
                        xrayStatus3 = XrayStatus.TODO;
                    } else if (Intrinsics.areEqual((Object)dialogReport.getErrorActionId(), (Object)testActionReport.getId())) {
                        stepViewed = true;
                        xrayStatus3 = XrayStatus.FAIL;
                    } else {
                        xrayStatus3 = XrayStatus.PASS;
                    }
                    XrayStatus status = xrayStatus3;
                    switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
                        case 1: {
                            object11 = "Test successful";
                            break;
                        }
                        case 2: {
                            object11 = "Skipped";
                            break;
                        }
                        case 3: {
                            if (dialogReport.getReturnedMessage() != null) {
                                Message message = dialogReport.getReturnedMessage();
                                object11 = "TestFailed : " + (message != null ? message.toPrettyString() : null);
                                break;
                            }
                            if (dialogReport.getErrorMessage() != null) {
                                object11 = "TestFailed : " + dialogReport.getErrorMessage();
                                break;
                            }
                            object11 = "Test failed";
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    collection7.add(new XrayTestExecutionStepReport((String)object11, status));
                }
                collection7 = (List)destination$iv$iv2;
                string8 = string10;
                OffsetDateTime offsetDateTime6 = offsetDateTime8;
                offsetDateTime6 = offsetDateTime7;
                object8 = object10;
                xrayStatus = xrayStatus2;
                list2 = collection7;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            List list3 = list2;
            XrayStatus xrayStatus4 = xrayStatus;
            Object object12 = object8;
            OffsetDateTime offsetDateTime9 = offsetDateTime6;
            OffsetDateTime offsetDateTime10 = offsetDateTime4;
            String string11 = string8;
            collection.add(new XrayTestExecutionReport(string11, offsetDateTime10, offsetDateTime9, (String)object12, xrayStatus4, list3));
        }
        String string12 = string4;
        XrayTestExecutionInfo xrayTestExecutionInfo2 = xrayTestExecutionInfo;
        collection = (List)collection6;
        Collection collection8 = collection;
        XrayTestExecution xrayExecution = new XrayTestExecution(string12, xrayTestExecutionInfo2, (List<XrayTestExecutionReport>)collection8);
        if (!XrayClient.INSTANCE.sendTestExecution(xrayExecution).isSuccessful()) return false;
        Iterable $this$none$iv = executionDialogs;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            bl2 = true;
        } else {
            for (Object e : $this$none$iv) {
                DialogExecutionReport it4 = (DialogExecutionReport)e;
                boolean bl10 = false;
                if (!it4.getError()) continue;
                return false;
            }
            bl2 = true;
        }
        if (!bl2) return false;
        Iterable $this$all$iv = xrayExecution.getTests();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object t = iterator.next();
            XrayTestExecutionReport it5 = (XrayTestExecutionReport)t;
            boolean bl11 = false;
            if (it5.getStatus() != XrayStatus.PASS) return false;
            bl = true;
        } while (bl);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<TestPlanExecutionReport> exec(XrayExecutionConfiguration configuration, Id<TestPlanExecution> executionId) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = configuration.getXrayTestPlanKeys();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TestPlanExecutionReport it$iv$iv;
            TestPlanExecutionReport testPlanExecutionReport;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String xrayPlanKey = (String)element$iv$iv;
            boolean bl2 = false;
            this.logger.info(() -> XrayService.exec$lambda$45$lambda$42(xrayPlanKey));
            try {
                TestPlanExecutionReport testPlanExecutionReport2;
                Id id = IdsKt.toId((String)(xrayPlanKey + "_" + configuration.getBotConfiguration().getApplicationId()));
                List list = new ArrayList();
                Duration duration = Duration.between(Instant.now(), Instant.now());
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
                TestPlanExecution exec = new TestPlanExecution(id, list, 0, null, duration, executionId, TestPlanExecutionStatus.PENDING, 8, null);
                this.saveTestPlanExecution(exec);
                TestPlan xrayTestPlan = this.getTestPlanFromXray(configuration, xrayPlanKey);
                if (!((Collection)xrayTestPlan.getDialogs()).isEmpty()) {
                    testPlanExecutionReport2 = this.executePlan(configuration, xrayPlanKey, xrayTestPlan, executionId);
                } else {
                    this.logger.info(() -> XrayService.exec$lambda$45$lambda$43(configuration));
                    testPlanExecutionReport2 = null;
                }
                testPlanExecutionReport = testPlanExecutionReport2;
            }
            finally {
                this.logger.info(() -> XrayService.exec$lambda$45$lambda$44(xrayPlanKey));
            }
            if (testPlanExecutionReport == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void saveTestPlanExecution(TestPlanExecution testPlanExecution) {
        KodeinInjector $this$provide_u24default$iv = IOCsKt.getInjector();
        Object tag$iv = null;
        boolean $i$f$provide = false;
        KodeinInjectedBase $receiver$iv$iv = (KodeinInjectedBase)$this$provide_u24default$iv.getInjector();
        KodeinInjector kodeinInjector = $receiver$iv$iv.getInjector();
        TestPlanDAO testPlanDAO = (TestPlanDAO)((Function0)kodeinInjector.Provider((TypeToken)new TypeReference<TestPlanDAO>(){}, tag$iv).getValue()).invoke();
        testPlanDAO.saveTestExecution(testPlanExecution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<TestPlanExecutionReport> execTestsOnly(XrayExecutionConfiguration configuration, String planKey, List<String> testKeys, Id<TestPlanExecution> executionId) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = configuration.getXrayTestPlanKeys();
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TestPlanExecutionReport it$iv$iv;
            TestPlanExecutionReport testPlanExecutionReport;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String xrayPlanKey = (String)element$iv$iv;
            boolean bl2 = false;
            this.logger.info(() -> XrayService.execTestsOnly$lambda$50$lambda$46(xrayPlanKey, planKey));
            try {
                TestPlanExecutionReport testPlanExecutionReport2;
                TestPlan testPlan = this.createTestPlanWithTests(configuration, planKey, testKeys);
                this.logger.debug(() -> XrayService.execTestsOnly$lambda$50$lambda$47(testPlan, planKey));
                if (!((Collection)testPlan.getDialogs()).isEmpty()) {
                    testPlanExecutionReport2 = this.executePlan(configuration, testPlan.getName(), testPlan, executionId);
                } else {
                    this.logger.debug(() -> XrayService.execTestsOnly$lambda$50$lambda$48(configuration));
                    testPlanExecutionReport2 = null;
                }
                testPlanExecutionReport = testPlanExecutionReport2;
            }
            finally {
                this.logger.info(() -> XrayService.execTestsOnly$lambda$50$lambda$49(xrayPlanKey, planKey));
            }
            if (testPlanExecutionReport == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final TestPlanExecutionReport executePlan(XrayExecutionConfiguration configuration, String xrayTestPlanKey, TestPlan testPlan, Id<TestPlanExecution> executionId) {
        this.logger.debug(() -> XrayService.executePlan$lambda$51(testPlan, executionId));
        TestPlanExecution execution = TestClientServiceKt.findTestClient().saveAndExecuteTestPlan(testPlan, executionId);
        this.logger.debug(() -> XrayService.executePlan$lambda$52(execution));
        return new TestPlanExecutionReport(configuration, xrayTestPlanKey, testPlan, execution);
    }

    /*
     * WARNING - void declaration
     */
    private final TestPlan getTestPlanFromXray(XrayExecutionConfiguration configuration, String xrayPlanKey) {
        void $this$mapTo$iv$iv;
        XrayTest it;
        Iterable $this$filterTo$iv$iv;
        List<XrayTest> xrayTests = XrayClient.INSTANCE.getTestPlanTests(xrayPlanKey);
        XrayExecutionConfiguration $this$getTestPlanFromXray_u24lambda_u2456 = configuration;
        boolean bl = false;
        Iterable $this$filter$iv = xrayTests;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            List connectorJiras;
            it = (XrayTest)element$iv$iv;
            boolean bl2 = false;
            Map<String, List<String>> map = this.connectorJiraMap;
            ConnectorType connectorType = configuration.getBotConfiguration().getOwnerConnectorType();
            List list = map.get(connectorType != null ? connectorType.getId() : null);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            if (!((connectorJiras = list).isEmpty() || !((Collection)CollectionsKt.intersect((Iterable)XrayClient.INSTANCE.getLinkedIssues(it.getKey(), this.linkedField), (Iterable)connectorJiras)).isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (XrayTest)element$iv$iv;
            boolean bl3 = false;
            if (!it.supportConf(configuration.getBotConfiguration().getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (XrayTest)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(this.getDialogReport(configuration, it));
        }
        Id id = IdsKt.toId((String)(xrayPlanKey + "_" + configuration.getBotConfiguration().getApplicationId()));
        ConnectorType connectorType = $this$getTestPlanFromXray_u24lambda_u2456.getBotConfiguration().getTargetConnectorType();
        Message message = StringsKt.isBlank((CharSequence)this.startSentence) ? null : (Message)CollectionsKt.first((List)MessageParser.INSTANCE.parse(this.startSentence));
        Locale locale = this.locale;
        Id id2 = $this$getTestPlanFromXray_u24lambda_u2456.getBotConfiguration().get_id();
        String string = $this$getTestPlanFromXray_u24lambda_u2456.getBotConfiguration().getNlpModel();
        String string2 = $this$getTestPlanFromXray_u24lambda_u2456.getBotConfiguration().getNamespace();
        String string3 = $this$getTestPlanFromXray_u24lambda_u2456.getBotConfiguration().getApplicationId();
        String string4 = xrayPlanKey;
        List list = (List)destination$iv$iv;
        return new TestPlan(list, string4, string3, string2, string, id2, locale, message, connectorType, id);
    }

    /*
     * WARNING - void declaration
     */
    private final TestPlan createTestPlanWithTests(XrayExecutionConfiguration configuration, String planKey, List<String> testKeys) {
        void $this$mapTo$iv$iv;
        XrayTest it;
        Iterable $this$filterTo$iv$iv;
        List xrayTests = new ArrayList();
        Iterable $this$forEach$iv = testKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            xrayTests.addAll((Collection)XrayClient.INSTANCE.getTests(it2));
        }
        XrayExecutionConfiguration $this$createTestPlanWithTests_u24lambda_u2460 = configuration;
        boolean bl = false;
        Iterable $this$filter$iv = xrayTests;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (XrayTest)element$iv$iv;
            boolean bl2 = false;
            if (!it.supportConf(configuration.getBotConfiguration().getName())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (XrayTest)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(this.getDialogReport(configuration, it));
        }
        Id id = IdsKt.toId((String)(planKey + "_" + configuration.getBotConfiguration().getApplicationId()));
        ConnectorType connectorType = $this$createTestPlanWithTests_u24lambda_u2460.getBotConfiguration().getTargetConnectorType();
        Message message = StringsKt.isBlank((CharSequence)this.startSentence) ? null : (Message)CollectionsKt.first((List)MessageParser.INSTANCE.parse(this.startSentence));
        Locale locale = this.locale;
        Id id2 = $this$createTestPlanWithTests_u24lambda_u2460.getBotConfiguration().get_id();
        String string = $this$createTestPlanWithTests_u24lambda_u2460.getBotConfiguration().getNlpModel();
        String string2 = $this$createTestPlanWithTests_u24lambda_u2460.getBotConfiguration().getNamespace();
        String string3 = $this$createTestPlanWithTests_u24lambda_u2460.getBotConfiguration().getApplicationId();
        String string4 = planKey;
        List list = (List)destination$iv$iv;
        return new TestPlan(list, string4, string3, string2, string, id2, locale, message, connectorType, id);
    }

    /*
     * WARNING - void declaration
     */
    private final TestDialogReport getDialogReport(XrayExecutionConfiguration configuration, XrayTest xrayTest) {
        void $this$flatMapTo$iv$iv;
        UserInterfaceType userInterface = xrayTest.findUserInterface();
        List<XrayTestStep> xraySteps = XrayClient.INSTANCE.getTestSteps(xrayTest.getKey());
        Iterable $this$flatMap$iv = xraySteps;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Object v1;
            Object var30_29;
            XrayService xrayService;
            XrayExecutionConfiguration xrayExecutionConfiguration;
            UserInterfaceType userInterfaceType;
            long l;
            PlayerId playerId;
            String string;
            Object[] objectArray;
            block4: {
                Object v0;
                XrayAttachment it;
                Iterable $this$firstOrNull$iv;
                boolean $i$f$firstOrNull;
                Object[] objectArray2;
                int n;
                XrayTestStep xrayTestStep;
                block3: {
                    xrayTestStep = (XrayTestStep)element$iv$iv;
                    boolean bl = false;
                    objectArray = new TestActionReport[2];
                    Iterable iterable2 = xrayTestStep.getAttachments();
                    string = xrayTestStep.getData().getRaw();
                    playerId = this.userId;
                    l = xrayTestStep.getId();
                    userInterfaceType = userInterface;
                    xrayExecutionConfiguration = configuration;
                    xrayService = this;
                    n = 0;
                    objectArray2 = objectArray;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (XrayAttachment)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getFileName(), (Object)"user.message")) continue;
                        v0 = element$iv;
                        break block3;
                    }
                    v0 = null;
                }
                var30_29 = v0;
                objectArray2[n] = xrayService.parseStepData(xrayExecutionConfiguration, userInterfaceType, l, playerId, string, var30_29);
                $this$firstOrNull$iv = xrayTestStep.getAttachments();
                string = xrayTestStep.getResult().getRaw();
                playerId = this.botId;
                l = xrayTestStep.getId();
                userInterfaceType = userInterface;
                xrayExecutionConfiguration = configuration;
                xrayService = this;
                n = 1;
                objectArray2 = objectArray;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (XrayAttachment)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getFileName(), (Object)"bot.message")) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            var30_29 = v1;
            objectArray2[n] = xrayService.parseStepData(xrayExecutionConfiguration, userInterfaceType, l, playerId, string, var30_29);
            Iterable list$iv$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Id id = IdsKt.toId((String)xrayTest.getKey());
        UserInterfaceType userInterfaceType = userInterface;
        List list = (List)destination$iv$iv;
        return new TestDialogReport(list, userInterfaceType, id);
    }

    private final TestActionReport parseStepData(XrayExecutionConfiguration configuration, UserInterfaceType userInterface, long stepId, PlayerId playerId, String raw, XrayAttachment xrayAttachment) {
        TestActionReport testActionReport;
        String string;
        String message;
        String string2;
        String it = string2 = (message = xrayAttachment != null ? XrayClient.INSTANCE.getAttachmentToString(xrayAttachment) : raw);
        boolean bl = false;
        CharSequence charSequence = it;
        String string3 = string = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string2 : null;
        if (string != null) {
            String $this$parseStepData_u24lambda_u2465 = string;
            boolean bl2 = false;
            Instant instant = this.instant;
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant");
            testActionReport = new TestActionReport(playerId, instant, MessageParser.INSTANCE.parse(StringsKt.replace$default((String)$this$parseStepData_u24lambda_u2465, (String)this.jiraRegisteredBotUrl, (String)configuration.getBotUrl(), (boolean)false, (int)4, null)), configuration.getBotConfiguration().getTargetConnectorType(), userInterface, IdsKt.toId((String)((playerId.getType() == PlayerType.bot ? "b" : "u") + stepId)));
        } else {
            testActionReport = null;
        }
        return testActionReport;
    }

    @Nullable
    public final XrayTest generateXrayTest(@NotNull DialogReport dialog, @NotNull Function1<? super List<String>, String> testName, @Nullable String linkedJira, @NotNull List<String> testsPlans, @NotNull Map<String, String> labelTestPlansMap) {
        JiraIssue jira;
        block13: {
            String string;
            String string2;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Object object;
            List<XrayBuildTestStep> steps;
            block12: {
                block11: {
                    Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
                    Intrinsics.checkNotNullParameter(testName, (String)"testName");
                    Intrinsics.checkNotNullParameter(testsPlans, (String)"testsPlans");
                    Intrinsics.checkNotNullParameter(labelTestPlansMap, (String)"labelTestPlansMap");
                    steps = this.defineTestSteps(dialog);
                    object = linkedJira;
                    if (object == null) break block11;
                    String it = object;
                    boolean bl = false;
                    List<String> list = XrayClient.INSTANCE.getLabels(it);
                    object = list;
                    if (list != null) break block12;
                }
                object = CollectionsKt.emptyList();
            }
            List<String> labels = object;
            JiraTest test = new JiraTest(this.jiraProject, (String)testName.invoke(labels), "", CollectionsKt.listOf((Object)"automatisation"), this.testTypeField, this.manualStepsField, "cucumber-tock");
            jira = XrayClient.INSTANCE.createTest(test);
            if (linkedJira != null) {
                XrayClient.INSTANCE.linkTest(jira.getKey(), linkedJira);
                $this$forEach$iv = testsPlans;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    XrayClient.INSTANCE.addTestToTestPlan(jira.getKey(), it);
                }
                if (!labelTestPlansMap.isEmpty()) {
                    Iterator $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    $this$forEach$iv = labels;
                    boolean $i$f$filter = false;
                    Iterator iterator = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    Iterator bl = $this$filterTo$iv$iv.iterator();
                    while (bl.hasNext()) {
                        Object element$iv$iv = bl.next();
                        String it = (String)element$iv$iv;
                        boolean bl2 = false;
                        if (!labelTestPlansMap.containsKey(it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        String string3 = jira.getKey();
                        String string4 = labelTestPlansMap.get(it);
                        Intrinsics.checkNotNull((Object)string4);
                        XrayClient.INSTANCE.addTestToTestPlan(string3, string4);
                    }
                }
            }
            List<XrayBuildTestStep> list = steps;
            if (list != null) {
                $this$forEach$iv = list;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    XrayBuildTestStep it = (XrayBuildTestStep)element$iv;
                    boolean bl = false;
                    XrayClient.INSTANCE.saveStep(jira.getKey(), it);
                }
            }
            if ((string2 = XrayPrecondition.Companion.getPreconditionForUserInterface(((ActionReport)CollectionsKt.first((List)dialog.getActions())).getUserInterfaceType())) == null) break block13;
            String $this$generateXrayTest_u24lambda_u2472 = string = string2;
            boolean bl = false;
            XrayClient.INSTANCE.addPrecondition($this$generateXrayTest_u24lambda_u2472, jira.getKey());
        }
        return new XrayTest(jira.getKey(), null, 2, null);
    }

    public static /* synthetic */ XrayTest generateXrayTest$default(XrayService xrayService, DialogReport dialogReport, Function1 function1, String string, List list, Map map, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = XrayService::generateXrayTest$lambda$66;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            map = MapsKt.emptyMap();
        }
        return xrayService.generateXrayTest(dialogReport, (Function1<? super List<String>, String>)function1, string, list, map);
    }

    @Nullable
    public final XrayTest updateXrayTest(@NotNull DialogReport dialog, @NotNull String testKey) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
            Intrinsics.checkNotNullParameter((Object)testKey, (String)"testKey");
            List<XrayBuildTestStep> steps = this.defineTestSteps(dialog);
            XrayClient.INSTANCE.getIssue(testKey);
            List<XrayTestStep> stepList = XrayClient.INSTANCE.getTestSteps(testKey);
            Iterable $this$forEach$iv = stepList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XrayTestStep currentStep = (XrayTestStep)element$iv;
                boolean bl = false;
                XrayClient.INSTANCE.deleteStep(testKey, currentStep.getId());
            }
            List<XrayBuildTestStep> list = steps;
            if (list == null) break block2;
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XrayBuildTestStep it = (XrayBuildTestStep)element$iv;
                boolean bl = false;
                XrayClient.INSTANCE.saveStep(testKey, it);
            }
        }
        return new XrayTest(testKey, null, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    private final List<XrayBuildTestStep> defineTestSteps(DialogReport dialog) {
        if (dialog.getActions().isEmpty()) {
            this.logger.warn((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, defineTestSteps$lambda$75(ai.tock.bot.admin.dialog.DialogReport ), ()Ljava/lang/Object;)((DialogReport)dialog));
            return null;
        }
        steps = new ArrayList<E>();
        $this$forEach$iv = dialog.getActions();
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            block12: {
                block11: {
                    action = (ActionReport)element$iv;
                    $i$a$-forEach-XrayService$defineTestSteps$2 = false;
                    v0 = user = action.getPlayerId().getType() == PlayerType.user;
                    if (this.isEmptyMessage(action.getMessage())) {
                        throw new IllegalStateException("Cannot save empty client message.".toString());
                    }
                    m = action.getMessage();
                    v1 = mData = m.isSimpleMessage() != false ? m.toPrettyString() : "";
                    if (m.isSimpleMessage()) {
                        v2 = null;
                    } else {
                        v3 = Base64.getEncoder();
                        v4 = m.toPrettyString().getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getBytes(...)");
                        Intrinsics.checkNotNullExpressionValue((Object)v3.encode(v4), (String)"encode(...)");
                        v2 = new XrayBuildStepAttachment(new String(var12_12, Charsets.UTF_8), user != false ? "user.message" : "bot.message", null, 4, null);
                    }
                    mAttachments = CollectionsKt.listOfNotNull((Object)v2);
                    if (user) {
                        v5 = steps.add(new XrayBuildTestStep(String.valueOf(steps.size() + 1), mData, "", mAttachments));
                        continue;
                    }
                    v5 = (XrayBuildTestStep)CollectionsKt.lastOrNull((List)steps);
                    if (v5 == null) break block12;
                    $this$defineTestSteps_u24lambda_u2479_u24lambda_u2477 = var14_14 = v5;
                    $i$a$-apply-XrayService$defineTestSteps$2$1 = false;
                    if (StringsKt.isBlank((CharSequence)$this$defineTestSteps_u24lambda_u2479_u24lambda_u2477.getResult()) == false) ** GOTO lbl-1000
                    $this$any$iv = $this$defineTestSteps_u24lambda_u2479_u24lambda_u2477.getAttachments();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v6 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (XrayBuildStepAttachment)element$iv;
                            $i$a$-any-XrayService$defineTestSteps$2$1$1 = false;
                            if (!Intrinsics.areEqual((Object)it.getFilename(), (Object)"bot.message")) continue;
                            v6 = true;
                            break block11;
                        }
                        v6 = false;
                    }
                }
                if (v6) lbl-1000:
                // 2 sources

                {
                    v7 = steps.add(new XrayBuildTestStep(String.valueOf(steps.size() + 1), "", mData, mAttachments));
                } else {
                    steps.remove(steps.size() - 1);
                    v7 = steps.add(XrayBuildTestStep.copy$default($this$defineTestSteps_u24lambda_u2479_u24lambda_u2477, null, null, mData, CollectionsKt.plus((Collection)$this$defineTestSteps_u24lambda_u2479_u24lambda_u2477.getAttachments(), (Iterable)mAttachments), 3, null));
                }
                if ((v5 = var14_14) != null) continue;
            }
            this.logger.warn((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, defineTestSteps$lambda$79$lambda$78(ai.tock.bot.admin.dialog.DialogReport ), ()Ljava/lang/Object;)((DialogReport)dialog));
            v5 = Unit.INSTANCE;
        }
        return steps;
    }

    private final boolean isEmptyMessage(Message $this$isEmptyMessage) {
        return Intrinsics.areEqual((Object)$this$isEmptyMessage, (Object)new Sentence(null, (List)new ArrayList(), null, 0L, null, 16, null));
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object execute$lambda$1() {
        return "Specify \"testPlanKey\" OR (xor) \"testKey\".";
    }

    private static final Object executeTestPlans$lambda$2(String $namespace) {
        Intrinsics.checkNotNullParameter((Object)$namespace, (String)"$namespace");
        return "execute plans with namespace " + $namespace;
    }

    private static final Object executeTests$lambda$7(String $namespace) {
        Intrinsics.checkNotNullParameter((Object)$namespace, (String)"$namespace");
        return "Execute tests with namespace " + $namespace;
    }

    private static final Object executeTests$lambda$8(String $executionId, String $dummyTestPlanKey) {
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        Intrinsics.checkNotNullParameter((Object)$dummyTestPlanKey, (String)"$dummyTestPlanKey");
        return "Execution with id : " + $executionId + " started for test plan " + $dummyTestPlanKey;
    }

    private static final Object executeTests$lambda$13$lambda$12(String $executionId, String $dummyTestPlanKey) {
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        Intrinsics.checkNotNullParameter((Object)$dummyTestPlanKey, (String)"$dummyTestPlanKey");
        return "Execution with id : " + $executionId + " ended for test plan " + $dummyTestPlanKey;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit sendToXray$lambda$25(XrayService this$0, String planKey, List plans) {
        XrayExecutionConfiguration it;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)planKey, (String)"planKey");
        Intrinsics.checkNotNullParameter((Object)plans, (String)"plans");
        Iterable $this$map$iv = plans;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            TestPlanExecutionReport testPlanExecutionReport = (TestPlanExecutionReport)item$iv$iv;
            object = destination$iv$iv;
            boolean bl4 = false;
            Iterable $this$map$iv2 = ((TestPlanExecutionReport)((Object)it)).getTestPlan().getDialogs();
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void dialogExecutionReport;
                TestDialogReport testDialogReport = (TestDialogReport)item$iv$iv2;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(dialogExecutionReport.getId());
            }
            object.add((List)destination$iv$iv2);
        }
        List $this$sendToXray_u24lambda_u2425_u24lambda_u2417 = (List)destination$iv$iv;
        boolean bl = false;
        boolean bl3 = CollectionsKt.toSet((Iterable)$this$sendToXray_u24lambda_u2425_u24lambda_u2417).size() == $this$sendToXray_u24lambda_u2425_u24lambda_u2417.size();
        if (bl3) {
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Iterable $this$distinctBy$iv;
            void $this$mapTo$iv$iv3;
            Collection<XrayExecutionConfiguration> collection;
            void $this$mapTo$iv$iv4;
            void $this$map$iv3;
            void $this$mapTo$iv$iv5;
            Object $this$map$iv4 = plans;
            boolean $i$f$map22 = false;
            destination$iv$iv = $this$map$iv4;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv5) {
                void it2;
                TestPlanExecutionReport bl4 = (TestPlanExecutionReport)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl5 = false;
                object.add(it2.getExecution().getDate());
            }
            Comparable comparable = CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv3));
            Intrinsics.checkNotNull((Object)comparable);
            Instant firstExecution = (Instant)comparable;
            OffsetDateTime offsetDateTime = OffsetDateTime.ofInstant(firstExecution, DatesKt.getDefaultZoneId());
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"ofInstant(...)");
            Iterable $i$f$map22 = plans;
            Object object2 = firstExecution;
            OffsetDateTime offsetDateTime2 = offsetDateTime;
            String string = planKey;
            object = this$0;
            boolean $i$f$map32 = false;
            destination$iv$iv3 = $this$map$iv3;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv3 : $this$mapTo$iv$iv4) {
                void it3;
                TestPlanExecutionReport bl5 = (TestPlanExecutionReport)item$iv$iv3;
                collection = destination$iv$iv4;
                boolean bl6 = false;
                collection.add((XrayExecutionConfiguration)((Object)Long.valueOf(it3.getExecution().getDuration().toMillis())));
            }
            collection = (List)destination$iv$iv4;
            $this$map$iv4 = OffsetDateTime.ofInstant(((Instant)object2).plus(CollectionsKt.sumOfLong((Iterable)collection), ChronoUnit.MILLIS), DatesKt.getDefaultZoneId());
            Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv4, (String)"ofInstant(...)");
            Object object3 = $this$map$iv4;
            $this$map$iv4 = plans;
            object2 = object3;
            boolean $i$f$map4 = false;
            Object $i$f$map32 = $this$map$iv4;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it4;
                TestPlanExecutionReport item$iv$iv3 = (TestPlanExecutionReport)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl7 = false;
                collection.add(it4.getConfiguration());
            }
            collection = (List)destination$iv$iv3;
            $this$map$iv4 = collection;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                it = (XrayExecutionConfiguration)e$iv;
                boolean bl8 = false;
                String key$iv = it.getBotConfiguration().getName();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            collection = list$iv;
            $this$distinctBy$iv = plans;
            boolean $i$f$flatMap = false;
            set$iv = $this$flatMap$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                TestPlanExecutionReport it5 = (TestPlanExecutionReport)element$iv$iv;
                boolean bl9 = false;
                Iterable list$iv$iv = it5.getTestPlan().getDialogs();
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            List list = (List)destination$iv$iv3;
            $this$flatMap$iv = plans;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv3 = new ArrayList();
            $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                TestPlanExecutionReport it6 = (TestPlanExecutionReport)element$iv$iv;
                boolean bl10 = false;
                Iterable list$iv$iv = it6.getExecution().getDialogs();
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            List list2 = (List)destination$iv$iv3;
            super.sendXrayExecution(string, offsetDateTime2, (OffsetDateTime)object2, (List<XrayExecutionConfiguration>)collection, list, list2);
        } else {
            Iterable $this$all$iv = plans;
            boolean $i$f$all = false;
            if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) {
                for (Object element$iv : $this$all$iv) {
                    TestPlanExecutionReport it7 = (TestPlanExecutionReport)element$iv;
                    boolean bl11 = false;
                    OffsetDateTime offsetDateTime = OffsetDateTime.ofInstant(it7.getExecution().getDate(), DatesKt.getDefaultZoneId());
                    Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"ofInstant(...)");
                    OffsetDateTime offsetDateTime3 = OffsetDateTime.ofInstant(it7.getExecution().getDate().plus(it7.getExecution().getDuration()), DatesKt.getDefaultZoneId());
                    Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime3, (String)"ofInstant(...)");
                    if (this$0.sendXrayExecution(planKey, offsetDateTime, offsetDateTime3, CollectionsKt.listOf((Object)it7.getConfiguration()), it7.getTestPlan().getDialogs(), it7.getExecution().getDialogs())) continue;
                    break;
                }
            }
        }
        return Unit.INSTANCE;
    }

    private static final void sendToXray$lambda$26(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final Object exec$lambda$45$lambda$42(String $xrayPlanKey) {
        Intrinsics.checkNotNullParameter((Object)$xrayPlanKey, (String)"$xrayPlanKey");
        return "Start plan " + $xrayPlanKey + " execution";
    }

    private static final Object exec$lambda$45$lambda$43(XrayExecutionConfiguration $configuration) {
        Intrinsics.checkNotNullParameter((Object)$configuration, (String)"$configuration");
        return "Empty test plan for " + $configuration + " - skipped";
    }

    private static final Object exec$lambda$45$lambda$44(String $xrayPlanKey) {
        Intrinsics.checkNotNullParameter((Object)$xrayPlanKey, (String)"$xrayPlanKey");
        return "Plan " + $xrayPlanKey + " executed";
    }

    private static final Object execTestsOnly$lambda$50$lambda$46(String $xrayPlanKey, String $planKey) {
        Intrinsics.checkNotNullParameter((Object)$xrayPlanKey, (String)"$xrayPlanKey");
        Intrinsics.checkNotNullParameter((Object)$planKey, (String)"$planKey");
        return "Start plan " + $xrayPlanKey + " execution for test plan " + $planKey;
    }

    private static final Object execTestsOnly$lambda$50$lambda$47(TestPlan $testPlan, String $planKey) {
        Intrinsics.checkNotNullParameter((Object)$testPlan, (String)"$testPlan");
        Intrinsics.checkNotNullParameter((Object)$planKey, (String)"$planKey");
        return "Common Tock test plan created : " + $testPlan.hashCode() + " for test plan " + $planKey;
    }

    private static final Object execTestsOnly$lambda$50$lambda$48(XrayExecutionConfiguration $configuration) {
        Intrinsics.checkNotNullParameter((Object)$configuration, (String)"$configuration");
        return "Empty test plan for " + $configuration + " - skipped";
    }

    private static final Object execTestsOnly$lambda$50$lambda$49(String $xrayPlanKey, String $planKey) {
        Intrinsics.checkNotNullParameter((Object)$xrayPlanKey, (String)"$xrayPlanKey");
        Intrinsics.checkNotNullParameter((Object)$planKey, (String)"$planKey");
        return "Plan " + $xrayPlanKey + " executed for test plan " + $planKey;
    }

    private static final Object executePlan$lambda$51(TestPlan $testPlan, Id $executionId) {
        Intrinsics.checkNotNullParameter((Object)$testPlan, (String)"$testPlan");
        Intrinsics.checkNotNullParameter((Object)$executionId, (String)"$executionId");
        return "Execute test plan " + $testPlan.getName() + " with execution id " + $executionId;
    }

    private static final Object executePlan$lambda$52(TestPlanExecution $execution) {
        Intrinsics.checkNotNullParameter((Object)$execution, (String)"$execution");
        return "Test plan execution " + $execution.getTestPlanId();
    }

    private static final String generateXrayTest$lambda$66(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "Test";
    }

    private static final Object defineTestSteps$lambda$75(DialogReport $dialog) {
        Intrinsics.checkNotNullParameter((Object)$dialog, (String)"$dialog");
        return "no action for dialog " + $dialog;
    }

    private static final Object defineTestSteps$lambda$79$lambda$78(DialogReport $dialog) {
        Intrinsics.checkNotNullParameter((Object)$dialog, (String)"$dialog");
        return "no first step for " + $dialog;
    }

    public XrayService() {
        this(null, null, null, null, 15, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lai/tock/bot/xray/XrayService$TestPlanExecutionReport;", "", "configuration", "Lai/tock/bot/xray/model/XrayExecutionConfiguration;", "planKey", "", "testPlan", "Lai/tock/bot/admin/test/TestPlan;", "execution", "Lai/tock/bot/admin/test/TestPlanExecution;", "<init>", "(Lai/tock/bot/xray/model/XrayExecutionConfiguration;Ljava/lang/String;Lai/tock/bot/admin/test/TestPlan;Lai/tock/bot/admin/test/TestPlanExecution;)V", "getConfiguration", "()Lai/tock/bot/xray/model/XrayExecutionConfiguration;", "getPlanKey", "()Ljava/lang/String;", "getTestPlan", "()Lai/tock/bot/admin/test/TestPlan;", "getExecution", "()Lai/tock/bot/admin/test/TestPlanExecution;", "tock-xray-plugin"})
    private static final class TestPlanExecutionReport {
        @NotNull
        private final XrayExecutionConfiguration configuration;
        @NotNull
        private final String planKey;
        @NotNull
        private final TestPlan testPlan;
        @NotNull
        private final TestPlanExecution execution;

        public TestPlanExecutionReport(@NotNull XrayExecutionConfiguration configuration, @NotNull String planKey, @NotNull TestPlan testPlan, @NotNull TestPlanExecution execution) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)planKey, (String)"planKey");
            Intrinsics.checkNotNullParameter((Object)testPlan, (String)"testPlan");
            Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
            this.configuration = configuration;
            this.planKey = planKey;
            this.testPlan = testPlan;
            this.execution = execution;
        }

        @NotNull
        public final XrayExecutionConfiguration getConfiguration() {
            return this.configuration;
        }

        @NotNull
        public final String getPlanKey() {
            return this.planKey;
        }

        @NotNull
        public final TestPlan getTestPlan() {
            return this.testPlan;
        }

        @NotNull
        public final TestPlanExecution getExecution() {
            return this.execution;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[XrayStatus.values().length];
            try {
                nArray[XrayStatus.PASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XrayStatus.TODO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XrayStatus.FAIL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

