/*
 * Decompiled with CFR 0.152.
 */
package ai.tock.bot.xray;

import ai.tock.bot.admin.bot.BotApplicationConfiguration;
import ai.tock.bot.admin.test.TestClientService;
import ai.tock.bot.admin.test.TestPlan;
import ai.tock.bot.admin.test.TestPlanExecution;
import ai.tock.bot.xray.TockTestApi;
import ai.tock.shared.PropertiesKt;
import ai.tock.shared.RetrofitsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.litote.kmongo.Id;
import retrofit2.Retrofit;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lai/tock/bot/xray/TockTestClient;", "Lai/tock/bot/admin/test/TestClientService;", "()V", "tock", "Lai/tock/bot/xray/TockTestApi;", "getTock", "()Lai/tock/bot/xray/TockTestApi;", "tockLogin", "", "tockPassword", "tockTimeoutInSeconds", "", "tockUrl", "getBotConfigurations", "", "Lai/tock/bot/admin/bot/BotApplicationConfiguration;", "namespace", "botId", "priority", "", "saveAndExecuteTestPlan", "Lai/tock/bot/admin/test/TestPlanExecution;", "testPlan", "Lai/tock/bot/admin/test/TestPlan;", "executionId", "Lorg/litote/kmongo/Id;", "tock-xray-plugin"})
@SourceDebugExtension(value={"SMAP\nTockTestClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TockTestClient.kt\nai/tock/bot/xray/TockTestClient\n+ 2 Retrofits.kt\nai/tock/shared/RetrofitsKt\n*L\n1#1,66:1\n71#2:67\n*S KotlinDebug\n*F\n+ 1 TockTestClient.kt\nai/tock/bot/xray/TockTestClient\n*L\n51#1:67\n*E\n"})
public final class TockTestClient
implements TestClientService {
    @NotNull
    public static final TockTestClient INSTANCE = new TockTestClient();
    private static final long tockTimeoutInSeconds = PropertiesKt.longProperty((String)"tock_bot_test_timeout_in_ms", (long)3600000L);
    @NotNull
    private static final String tockLogin = PropertiesKt.property((String)"tock_bot_test_login", (String)"please set tock test login");
    @NotNull
    private static final String tockPassword = PropertiesKt.property((String)"tock_bot_test_password", (String)"please set tock test password");
    @NotNull
    private static final String tockUrl = PropertiesKt.property((String)"tock_bot_test_url", (String)"http://set_property_tock_bot_test_url");
    @NotNull
    private static final TockTestApi tock;

    private TockTestClient() {
    }

    @NotNull
    public final TockTestApi getTock() {
        return tock;
    }

    @NotNull
    public TestPlanExecution saveAndExecuteTestPlan(@NotNull TestPlan testPlan, @NotNull Id<TestPlanExecution> executionId) {
        Intrinsics.checkNotNullParameter((Object)testPlan, (String)"testPlan");
        Intrinsics.checkNotNullParameter(executionId, (String)"executionId");
        TestPlanExecution testPlanExecution = (TestPlanExecution)tock.executeTestPlan(testPlan).execute().body();
        if (testPlanExecution == null) {
            testPlanExecution = new TestPlanExecution(testPlan.get_id(), CollectionsKt.emptyList(), 1, null, null, null, null, 120, null);
        }
        return testPlanExecution;
    }

    @NotNull
    public List<BotApplicationConfiguration> getBotConfigurations(@NotNull String namespace, @NotNull String botId) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)botId, (String)"botId");
        List list = (List)tock.getBotConfigurations(botId).execute().body();
        if (list == null) {
            throw new IllegalStateException("not a bot configuration".toString());
        }
        return list;
    }

    public int priority() {
        return 0;
    }

    static {
        Retrofit retrofit = RetrofitsKt.addJacksonConverter$default((Retrofit.Builder)RetrofitsKt.retrofitBuilderWithTimeoutAndLogger$default((long)tockTimeoutInSeconds, null, null, (List)CollectionsKt.listOf((Object)RetrofitsKt.basicAuthInterceptor((String)tockLogin, (String)tockPassword)), (boolean)false, (boolean)false, null, (int)118, null), null, (int)1, null).baseUrl(tockUrl).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"build(...)");
        Retrofit $this$create$iv = retrofit;
        boolean $i$f$create = false;
        Object object = $this$create$iv.create(TockTestApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        tock = (TockTestApi)object;
    }
}

