/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1;

import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;

public abstract class FlexibleEnum<E extends FlexibleEnum<E>>
implements Comparable<E> {
    private final String name;

    protected FlexibleEnum(String name) {
        this.name = name;
    }

    @JsonValue
    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlexibleEnum that = (FlexibleEnum)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public int compareTo(E o) {
        return this.name.compareTo(((FlexibleEnum)o).name());
    }

    protected static <T extends FlexibleEnum<T>> T[] values(T[] knownValues, Collection<T> discoveredValues, Class<T> clazz) {
        ArrayList<FlexibleEnum> copy = new ArrayList<FlexibleEnum>(discoveredValues);
        FlexibleEnum[] out = (FlexibleEnum[])Array.newInstance(clazz, knownValues.length + copy.size());
        copy.toArray(out);
        for (int i = 0; i < knownValues.length; ++i) {
            out[i + copy.size()] = knownValues[i];
        }
        return out;
    }

    protected static <T extends FlexibleEnum<T>> T valueOf(T[] knownValues, ConcurrentMap<String, T> discoveredValues, String name, NewEnumCreator<T> enumCreator) {
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        for (T t : knownValues) {
            if (!((FlexibleEnum)t).name().equals(name)) continue;
            return t;
        }
        FlexibleEnum value = (FlexibleEnum)discoveredValues.get(name);
        if (value != null) {
            return (T)value;
        }
        T created = enumCreator.create(name);
        discoveredValues.putIfAbsent(name, created);
        return (T)((FlexibleEnum)discoveredValues.get(name));
    }

    protected static interface NewEnumCreator<T extends FlexibleEnum<T>> {
        public T create(String var1);
    }
}

