/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1;

import ai.toloka.client.v1.AbstractRequestParameters;
import ai.toloka.client.v1.FilterParam;
import ai.toloka.client.v1.RangeOperator;
import ai.toloka.client.v1.RangeParam;
import ai.toloka.client.v1.RequestParameters;
import ai.toloka.client.v1.SortDirection;
import ai.toloka.client.v1.SortParam;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class SearchRequest
extends AbstractRequestParameters
implements RequestParameters {
    private static final String SORT_PARAMETER = "sort";
    private static final String LIMIT_PARAMETER = "limit";
    private final Map<String, Object> filterParameters;
    private final Map<String, Object> rangeParameters;
    private final String sortParameter;
    private final Integer limit;

    protected SearchRequest(Map<String, Object> filterParameters, Map<String, Object> rangeParameters, String sortParameter, Integer limit) {
        this.filterParameters = filterParameters;
        this.rangeParameters = rangeParameters;
        this.sortParameter = sortParameter;
        this.limit = limit;
    }

    @Override
    public Map<String, Object> getQueryParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.putAll(this.filterParameters);
        params.putAll(this.rangeParameters);
        params.put(SORT_PARAMETER, this.sortParameter);
        params.put(LIMIT_PARAMETER, this.limit);
        return this.filterNulls(params);
    }

    public static abstract class SortBuilder<T extends SortBuilder, B extends Builder, P extends SortParam>
    extends SegmentBuilder<B> {
        private Map<String, SortItem<T>> sorts = new LinkedHashMap<String, SortItem<T>>();

        public T by(P param, SortDirection direction) {
            return this.put(param.parameter(), new SortItem(this, this)).direction(direction);
        }

        public SortItem<T> by(P param) {
            return this.put(param.parameter(), new SortItem(this, this));
        }

        public String getSortParameter() {
            if (!this.sorts.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, SortItem<T>> sort : this.sorts.entrySet()) {
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(this.getSortProperty(sort.getKey(), sort.getValue().isAscending()));
                }
                return sb.toString();
            }
            return null;
        }

        protected SortItem<T> put(String property, SortItem<T> sortItem) {
            this.sorts.put(property, sortItem);
            return sortItem;
        }

        private String getSortProperty(String property, boolean ascending) {
            return ascending ? property : "-" + property;
        }

        public static class SortItem<S extends SortBuilder> {
            private final S sortBuilder;
            private boolean ascending;
            final /* synthetic */ SortBuilder this$0;

            SortItem(S sortBuilder) {
                this.this$0 = this$0;
                this.sortBuilder = sortBuilder;
            }

            public S asc() {
                this.ascending = true;
                return this.sortBuilder;
            }

            public S desc() {
                this.ascending = false;
                return this.sortBuilder;
            }

            public boolean isAscending() {
                return this.ascending;
            }

            public S direction(SortDirection direction) {
                this.ascending = direction == SortDirection.asc;
                return this.sortBuilder;
            }
        }
    }

    public static abstract class RangeBuilder<T extends RangeBuilder, B extends Builder, P extends RangeParam>
    extends SegmentBuilder<B> {
        private Set<RangeItem> ranges = new LinkedHashSet<RangeItem>();

        public T by(P param, Object value, RangeOperator operator) {
            return (T)new RangeItemBuilder(this, param.parameter(), value, this).withOperator(operator);
        }

        protected RangeItemBuilder<T> by(P param, Object value) {
            return new RangeItemBuilder(this, param.parameter(), value, this);
        }

        public Map<String, Object> getRangeParameters() {
            LinkedHashMap<String, Object> rangeParameters = new LinkedHashMap<String, Object>();
            for (RangeItem range : this.ranges) {
                rangeParameters.put(this.getRangeKey(range), range.getValue());
            }
            return rangeParameters;
        }

        void add(RangeItemBuilder<T> rangeItemBuilder) {
            this.ranges.add(new RangeItem(rangeItemBuilder.name, rangeItemBuilder.value, rangeItemBuilder.operator));
        }

        private String getRangeKey(RangeItem rangeItem) {
            return rangeItem.name + "_" + rangeItem.operator.name();
        }

        private class RangeItem {
            private final String name;
            private final Object value;
            private final RangeOperator operator;

            RangeItem(String name, Object value, RangeOperator operator) {
                this.name = name;
                this.value = value;
                this.operator = operator;
            }

            public String getName() {
                return this.name;
            }

            public Object getValue() {
                return this.value;
            }

            public RangeOperator getOperator() {
                return this.operator;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                RangeItem rangeItem = (RangeItem)o;
                return Objects.equals(this.name, rangeItem.name) && Objects.equals(this.value, rangeItem.value) && this.operator == rangeItem.operator;
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.name, this.value, this.operator});
            }
        }

        public static class RangeItemBuilder<R extends RangeBuilder> {
            private final String name;
            private final Object value;
            private RangeOperator operator;
            private final R rangeBuilder;
            final /* synthetic */ RangeBuilder this$0;

            RangeItemBuilder(String name, Object value, R rangeBuilder) {
                this.this$0 = this$0;
                this.name = name;
                this.rangeBuilder = rangeBuilder;
                this.value = value;
            }

            public R gt() {
                this.operator = RangeOperator.gt;
                ((RangeBuilder)this.rangeBuilder).add(this);
                return this.rangeBuilder;
            }

            public R gte() {
                this.operator = RangeOperator.gte;
                ((RangeBuilder)this.rangeBuilder).add(this);
                return this.rangeBuilder;
            }

            public R lt() {
                this.operator = RangeOperator.lt;
                ((RangeBuilder)this.rangeBuilder).add(this);
                return this.rangeBuilder;
            }

            public R lte() {
                this.operator = RangeOperator.lte;
                ((RangeBuilder)this.rangeBuilder).add(this);
                return this.rangeBuilder;
            }

            public R withOperator(RangeOperator operator) {
                this.operator = operator;
                ((RangeBuilder)this.rangeBuilder).add(this);
                return this.rangeBuilder;
            }
        }
    }

    public static abstract class FilterBuilder<T extends FilterBuilder, B extends Builder, P extends FilterParam>
    extends SegmentBuilder<B> {
        private Map<String, Object> filters = new LinkedHashMap<String, Object>();

        public Map<String, Object> getFilterParameters() {
            return this.filters;
        }

        protected void put(String property, Object value) {
            this.filters.put(property, value);
        }

        public T by(P param, Object value) {
            this.put(param.parameter(), value);
            return (T)this;
        }
    }

    static abstract class SegmentBuilder<B extends Builder> {
        private B builder;

        SegmentBuilder() {
        }

        public B and() {
            return this.builder;
        }

        void setBuilder(Builder searchRequestBuilder) {
            this.builder = searchRequestBuilder;
        }
    }

    public static abstract class Builder<G extends SearchRequest, T extends Builder, F extends FilterBuilder<?, T, ?>, R extends RangeBuilder<?, T, ?>, S extends SortBuilder<?, T, ?>> {
        protected final F filterBuilder;
        protected final R rangeBuilder;
        protected final S sortBuilder;
        private Integer limit;

        protected Builder(F filterBuilder, R rangeBuilder, S sortBuilder) {
            this.filterBuilder = filterBuilder;
            ((SegmentBuilder)this.filterBuilder).setBuilder(this);
            this.rangeBuilder = rangeBuilder;
            ((SegmentBuilder)this.rangeBuilder).setBuilder(this);
            this.sortBuilder = sortBuilder;
            ((SegmentBuilder)this.sortBuilder).setBuilder(this);
        }

        public F filter() {
            return this.filterBuilder;
        }

        public R range() {
            return this.rangeBuilder;
        }

        public S sort() {
            return this.sortBuilder;
        }

        public T limit(int limit) {
            this.limit = limit;
            return (T)this;
        }

        public abstract G done();

        protected Integer getLimit() {
            return this.limit;
        }
    }
}

