/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1;

import ai.toloka.client.v1.ValidationError;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Map;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="code", defaultImpl=TlkError.class, visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=ValidationError.class, name="VALIDATION_ERROR")})
public class TlkError<P> {
    public static final String NOT_FOUND_CODE = "NOT_FOUND";
    public static final String METHOD_NOT_ALLOWED_CODE = "METHOD_NOT_ALLOWED";
    public static final String NOT_ACCEPTABLE_CODE = "NOT_ACCEPTABLE";
    public static final String UNSUPPORTED_MEDIA_TYPE_CODE = "UNSUPPORTED_MEDIA_TYPE";
    public static final String AUTHENTICATION_ERROR_CODE = "AUTHENTICATION_ERROR";
    public static final String ACCESS_DENIED_CODE = "ACCESS_DENIED";
    public static final String DOES_NOT_EXIST_CODE = "DOES_NOT_EXIST";
    public static final String CONFLICT_STATE_CODE = "CONFLICT_STATE";
    public static final String VALIDATION_ERROR_CODE = "VALIDATION_ERROR";
    public static final String TOO_MANY_REQUESTS_CODE = "TOO_MANY_REQUESTS";
    public static final String ENTITY_TOO_LARGE_CODE = "ENTITY_TOO_LARGE";
    public static final String REMOTE_SERVICE_UNAVAILABLE_CODE = "REMOTE_SERVICE_UNAVAILABLE";
    public static final String INTERNAL_ERROR_CODE = "INTERNAL_ERROR";
    public static final String NGINX_ERROR_CODE = "NGINX_ERROR";
    public static final String UNARCHIVED_POOLS_CONFLICT_CODE = "UNARCHIVED_POOLS_CONFLICT";
    public static final String PROJECT_INAPPROPRIATE_STATUS_CODE = "PROJECT_INAPPROPRIATE_STATUS";
    public static final String EMPTY_POOL_CODE = "EMPTY_POOL";
    public static final String SUBMITTED_ASSIGNMENTS_CONFLICT_CODE = "SUBMITTED_ASSIGNMENTS_CONFLICT";
    public static final String POOL_INAPPROPRIATE_STATUS_CODE = "POOL_INAPPROPRIATE_STATUS";
    public static final String MIXER_CONFIG_REQUIRED_CODE = "MIXER_CONFIG_REQUIRED";
    public static final String POOL_TASK_SUITES_COUNT_EXCEEDED_CODE = "POOL_TASK_SUITES_COUNT_EXCEEDED";
    public static final String POOL_TASKS_COUNT_EXCEEDED_CODE = "POOL_TASKS_COUNT_EXCEEDED";
    public static final String ASSIGNMENTS_COUNT_CONFLICT_CODE = "ASSIGNMENTS_COUNT_CONFLICT";
    public static final String POOL_LOCKED_BY_ANOTHER_OPERATION_CODE = "POOL_LOCKED_BY_ANOTHER_OPERATION";
    public static final String SYSTEM_SCOPE_MODIFICATION_CODE = "SYSTEM_SCOPE_MODIFICATION";
    public static final String BATCH_INITIALIZATION_ERROR_CODE = "BATCH_INITIALIZATION_ERROR";
    public static final String OPERATION_EXECUTION_ERROR_CODE = "OPERATION_EXECUTION_ERROR";
    public static final String OPERATION_ALREADY_EXISTS_CODE = "OPERATION_ALREADY_EXISTS";
    private final String code;
    private final String requestId;
    private final String message;
    private final Map<String, P> payload;

    @JsonCreator
    public TlkError(@JsonProperty(value="code") String code, @JsonProperty(value="request_id") String requestId, @JsonProperty(value="message") String message, @JsonProperty(value="property") Map<String, P> payload) {
        this.code = code;
        this.requestId = requestId;
        this.message = message;
        this.payload = payload;
    }

    public TlkError(String code, String message, Map<String, P> payload) {
        this.code = code;
        this.message = message;
        this.payload = payload;
        this.requestId = null;
    }

    public TlkError(String code, String message) {
        this.code = code;
        this.message = message;
        this.requestId = null;
        this.payload = null;
    }

    public String getCode() {
        return this.code;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, P> getPayload() {
        return this.payload;
    }

    public String toString() {
        return "TlkError{code='" + this.code + "', requestId='" + this.requestId + "', message='" + this.message + "', payload=" + this.payload + "}";
    }
}

