/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.attachment;

import ai.toloka.client.v1.SearchRequest;
import ai.toloka.client.v1.attachment.AttachmentFilterParam;
import ai.toloka.client.v1.attachment.AttachmentRangeParam;
import ai.toloka.client.v1.attachment.AttachmentSortParam;
import ai.toloka.client.v1.attachment.AttachmentType;
import java.util.Date;
import java.util.Map;

public class AttachmentSearchRequest
extends SearchRequest {
    static final String OWNER_ID_PARAMETER = "owner_id";
    static final String OWNER_COMPANY_ID_PARAMETER = "owner_company_id";
    public static final String NAME_PARAMETER = "name";
    public static final String ATTACHMENT_TYPE_PARAMETER = "type";
    public static final String USER_ID_PARAMETER = "user_id";
    public static final String ASSIGNMENT_ID_PARAMETER = "assignment_id";
    public static final String POOL_ID_PARAMETER = "pool_id";
    public static final String ID_PARAMETER = "id";
    public static final String CREATED_PARAMETER = "created";

    private AttachmentSearchRequest(Map<String, Object> filterParameters, Map<String, Object> rangeParameters, String sortParameter, Integer limit) {
        super(filterParameters, rangeParameters, sortParameter, limit);
    }

    public static AttachmentBuilder make() {
        return new AttachmentBuilder(new AttachmentFilterBuilder(), new AttachmentRangeBuilder(), new AttachmentSortBuilder());
    }

    public static class AttachmentSortBuilder
    extends SearchRequest.SortBuilder<AttachmentSortBuilder, AttachmentBuilder, AttachmentSortParam> {
        public SearchRequest.SortBuilder.SortItem<AttachmentSortBuilder> byId() {
            return this.by(AttachmentSortParam.id);
        }

        public SearchRequest.SortBuilder.SortItem<AttachmentSortBuilder> byCreated() {
            return this.by(AttachmentSortParam.created);
        }
    }

    public static class AttachmentRangeBuilder
    extends SearchRequest.RangeBuilder<AttachmentRangeBuilder, AttachmentBuilder, AttachmentRangeParam> {
        public SearchRequest.RangeBuilder.RangeItemBuilder<AttachmentRangeBuilder> byId(String id) {
            return this.by(AttachmentRangeParam.id, id);
        }

        public SearchRequest.RangeBuilder.RangeItemBuilder<AttachmentRangeBuilder> byCreated(Date created) {
            return this.by(AttachmentRangeParam.created, created);
        }
    }

    public static class AttachmentFilterBuilder
    extends SearchRequest.FilterBuilder<AttachmentFilterBuilder, AttachmentBuilder, AttachmentFilterParam> {
        public AttachmentFilterBuilder byOwnerId(String ownerId) {
            return (AttachmentFilterBuilder)this.by(AttachmentFilterParam.ownerId, ownerId);
        }

        public AttachmentFilterBuilder byOwnerCompanyId(String ownerCompanyId) {
            return (AttachmentFilterBuilder)this.by(AttachmentFilterParam.ownerCompanyId, ownerCompanyId);
        }

        public AttachmentFilterBuilder byName(String name) {
            return (AttachmentFilterBuilder)this.by(AttachmentFilterParam.name, name);
        }

        public AttachmentFilterBuilder byAttachmentType(AttachmentType attachmentType) {
            return (AttachmentFilterBuilder)this.by(AttachmentFilterParam.attachmentType, attachmentType);
        }

        public AttachmentFilterBuilder byUserId(String userId) {
            return (AttachmentFilterBuilder)this.by(AttachmentFilterParam.userId, userId);
        }

        public AttachmentFilterBuilder byAssignmentId(String assignmentId) {
            return (AttachmentFilterBuilder)this.by(AttachmentFilterParam.assignmentId, assignmentId);
        }

        public AttachmentFilterBuilder byPoolId(String poolId) {
            return (AttachmentFilterBuilder)this.by(AttachmentFilterParam.poolId, poolId);
        }
    }

    public static class AttachmentBuilder
    extends SearchRequest.Builder<AttachmentSearchRequest, AttachmentBuilder, AttachmentFilterBuilder, AttachmentRangeBuilder, AttachmentSortBuilder> {
        private AttachmentBuilder(AttachmentFilterBuilder filterBuilder, AttachmentRangeBuilder rangeBuilder, AttachmentSortBuilder sortBuilder) {
            super(filterBuilder, rangeBuilder, sortBuilder);
        }

        @Override
        public AttachmentSearchRequest done() {
            return new AttachmentSearchRequest(((AttachmentFilterBuilder)this.filterBuilder).getFilterParameters(), ((AttachmentRangeBuilder)this.rangeBuilder).getRangeParameters(), ((AttachmentSortBuilder)this.sortBuilder).getSortParameter(), this.getLimit());
        }
    }
}

