/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.impl;

import ai.toloka.client.v1.BatchCreateResult;
import ai.toloka.client.v1.ModificationResult;
import ai.toloka.client.v1.NotFoundException;
import ai.toloka.client.v1.RequestParameters;
import ai.toloka.client.v1.SearchRequest;
import ai.toloka.client.v1.SearchResult;
import ai.toloka.client.v1.ServiceUnavailableException;
import ai.toloka.client.v1.TlkError;
import ai.toloka.client.v1.TlkException;
import ai.toloka.client.v1.TolokaRequestIOException;
import ai.toloka.client.v1.ValidationError;
import ai.toloka.client.v1.ValidationException;
import ai.toloka.client.v1.impl.TolokaClientFactoryImpl;
import ai.toloka.client.v1.impl.transport.MapperUtil;
import ai.toloka.client.v1.impl.transport.TransportUtil;
import ai.toloka.client.v1.impl.validation.Assertions;
import ai.toloka.client.v1.operation.Operation;
import ai.toloka.client.v1.pool.PoolOpenOperation;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientImpl {
    private static final Logger logger = LoggerFactory.getLogger(AbstractClientImpl.class);
    private static final String ASYNC_MODE_PARAMETER = "async_mode";
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private final String prefix;
    private final TolokaClientFactoryImpl factory;
    private final ExecutorService executor;

    protected AbstractClientImpl(TolokaClientFactoryImpl factory) {
        this(factory, "v1");
    }

    protected AbstractClientImpl(TolokaClientFactoryImpl factory, String versionPrefix) {
        this.prefix = versionPrefix;
        this.factory = factory;
        this.executor = Executors.newCachedThreadPool();
    }

    public URI getTolokaApiUrl() {
        return this.factory.getTolokaApiUrl();
    }

    public HttpClient getHttpClient() {
        return this.factory.getHttpClient();
    }

    public Consumer<HttpRequestBase> getHttpConsumer() {
        return this.factory.getHeadersSupplier();
    }

    public TolokaClientFactoryImpl getFactory() {
        return this.factory;
    }

    private static URIBuilder addPaths(URIBuilder uriBuilder, String ... paths) {
        for (String path : paths) {
            if (path == null || path.isEmpty()) continue;
            uriBuilder.setPath(uriBuilder.getPath().endsWith("/") ? uriBuilder.getPath() + path : uriBuilder.getPath() + "/" + path);
        }
        return uriBuilder;
    }

    protected URIBuilder addVersionPrefix(URIBuilder uriBuilder, String ... paths) {
        String[] v1Paths = new String[paths.length + 1];
        v1Paths[0] = this.prefix;
        System.arraycopy(paths, 0, v1Paths, 1, paths.length);
        return AbstractClientImpl.addPaths(uriBuilder, v1Paths);
    }

    protected <T> SearchResult<T> find(final SearchRequest request, final String path, final TypeReference typeReference) {
        return (SearchResult)new RequestExecutorWrapper<SearchResult<T>>(){

            @Override
            SearchResult<T> execute() throws URISyntaxException, IOException {
                HttpResponse response;
                URIBuilder uriBuilder = AbstractClientImpl.this.addVersionPrefix(new URIBuilder(AbstractClientImpl.this.getTolokaApiUrl()), path);
                if (request != null) {
                    uriBuilder.addParameters(AbstractClientImpl.this.convertParameters(request.getQueryParameters()));
                }
                if ((response = TransportUtil.executeGet(AbstractClientImpl.this.getHttpClient(), uriBuilder.build(), AbstractClientImpl.this.getHttpConsumer())).getStatusLine().getStatusCode() != 200) {
                    throw AbstractClientImpl.this.parseException(response);
                }
                return (SearchResult)MapperUtil.getObjectReader(typeReference).readValue(response.getEntity().getContent());
            }
        }.wrap();
    }

    protected <T> T get(final String id, final String path, final Class<T> clazz) {
        Assertions.checkArgNotNull(id, "Id may not be null");
        return new RequestExecutorWrapper<T>(){

            @Override
            T execute() throws URISyntaxException, IOException {
                URI uri = AbstractClientImpl.this.addVersionPrefix(new URIBuilder(AbstractClientImpl.this.getTolokaApiUrl()), path, id).build();
                HttpResponse response = TransportUtil.executeGet(AbstractClientImpl.this.getHttpClient(), uri, AbstractClientImpl.this.getHttpConsumer());
                if (response.getStatusLine().getStatusCode() == 200) {
                    return MapperUtil.getObjectReader(clazz).readValue(response.getEntity().getContent());
                }
                if (response.getStatusLine().getStatusCode() == 404) {
                    return null;
                }
                throw AbstractClientImpl.this.parseException(response);
            }
        }.wrap();
    }

    protected <T, R> ModificationResult<R> create(final T form, final String path, final Class<R> responseClass, final Map<String, Object> queryParameters) {
        return (ModificationResult)new RequestExecutorWrapper<ModificationResult<R>>(){

            @Override
            ModificationResult<R> execute() throws URISyntaxException, IOException {
                HttpResponse response;
                URIBuilder uriBuilder = AbstractClientImpl.this.addVersionPrefix(new URIBuilder(AbstractClientImpl.this.getTolokaApiUrl()), path);
                if (queryParameters != null) {
                    uriBuilder.addParameters(AbstractClientImpl.this.convertParameters(queryParameters));
                }
                if ((response = TransportUtil.executePost(AbstractClientImpl.this.getHttpClient(), uriBuilder.build(), AbstractClientImpl.this.getHttpConsumer(), form)).getStatusLine().getStatusCode() == 201) {
                    ModificationResult result = new ModificationResult(MapperUtil.getObjectReader(responseClass).readValue(response.getEntity().getContent()), true);
                    return result;
                }
                throw AbstractClientImpl.this.parseException(response);
            }
        }.wrap();
    }

    protected <T, R> BatchCreateResult<R> upsertMultiple(final List<T> forms, final String path, final TypeReference<BatchCreateResult<R>> typeReference) {
        return (BatchCreateResult)new RequestExecutorWrapper<BatchCreateResult<R>>(){

            @Override
            BatchCreateResult<R> execute() throws URISyntaxException, IOException {
                URIBuilder uriBuilder = AbstractClientImpl.this.addVersionPrefix(new URIBuilder(AbstractClientImpl.this.getTolokaApiUrl()), path);
                HttpResponse response = TransportUtil.executePut(AbstractClientImpl.this.getHttpClient(), uriBuilder.build(), AbstractClientImpl.this.getHttpConsumer(), forms);
                if (response.getStatusLine().getStatusCode() == 200) {
                    return (BatchCreateResult)MapperUtil.getObjectReader(typeReference).readValue(response.getEntity().getContent());
                }
                throw AbstractClientImpl.this.parseException(response);
            }
        }.wrap();
    }

    <T> BatchCreateResult<T> createMultiple(final List<T> forms, final String path, final TypeReference<BatchCreateResult<T>> typeReference, final RequestParameters requestParameters) {
        return (BatchCreateResult)new RequestExecutorWrapper<BatchCreateResult<T>>(){

            @Override
            BatchCreateResult<T> execute() throws URISyntaxException, IOException {
                URIBuilder uriBuilder = AbstractClientImpl.this.addVersionPrefix(new URIBuilder(AbstractClientImpl.this.getTolokaApiUrl()), path);
                if (requestParameters != null) {
                    uriBuilder.addParameters(AbstractClientImpl.this.convertParameters(requestParameters.getQueryParameters()));
                }
                uriBuilder.addParameter(AbstractClientImpl.ASYNC_MODE_PARAMETER, Boolean.FALSE.toString());
                HttpResponse response = TransportUtil.executePost(AbstractClientImpl.this.getHttpClient(), uriBuilder.build(), AbstractClientImpl.this.getHttpConsumer(), forms);
                if (response.getStatusLine().getStatusCode() == 201) {
                    return (BatchCreateResult)MapperUtil.getObjectReader(typeReference).readValue(response.getEntity().getContent());
                }
                throw AbstractClientImpl.this.parseException(response);
            }
        }.wrap();
    }

    <T, O extends Operation> O createMultipleAsync(final Iterator<T> forms, final String path, final Class<O> opClass, final RequestParameters requestParameters) {
        return (O)((Operation)new RequestExecutorWrapper<O>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            O execute() throws URISyntaxException, IOException {
                URIBuilder uriBuilder = AbstractClientImpl.this.addVersionPrefix(new URIBuilder(AbstractClientImpl.this.getTolokaApiUrl()), path);
                if (requestParameters != null) {
                    uriBuilder.addParameters(AbstractClientImpl.this.convertParameters(requestParameters.getQueryParameters()));
                }
                uriBuilder.addParameter(AbstractClientImpl.ASYNC_MODE_PARAMETER, Boolean.TRUE.toString());
                try (PipedInputStream in = new PipedInputStream(16384);){
                    PipedOutputStream out = new PipedOutputStream(in);
                    AbstractClientImpl.this.executor.execute(AbstractClientImpl.this.readJsonForms(out, forms));
                    HttpResponse response = TransportUtil.executePost(AbstractClientImpl.this.getHttpClient(), uriBuilder.build(), AbstractClientImpl.this.getHttpConsumer(), in);
                    if (response.getStatusLine().getStatusCode() != 202) throw AbstractClientImpl.this.parseException(response);
                    Operation operation = (Operation)MapperUtil.getObjectReader(opClass).readValue(response.getEntity().getContent());
                    Operation.setOperationClient(operation, AbstractClientImpl.this.getFactory().getOperationClient());
                    Operation operation2 = operation;
                    return operation2;
                    finally {
                        out.close();
                    }
                }
            }
        }.wrap());
    }

    protected <T> ModificationResult<T> update(final String resourceId, final T form, final String path, final Class<T> formClass) {
        return (ModificationResult)new RequestExecutorWrapper<ModificationResult<T>>(){

            @Override
            ModificationResult<T> execute() throws URISyntaxException, IOException {
                URI uri = AbstractClientImpl.this.addVersionPrefix(new URIBuilder(AbstractClientImpl.this.getTolokaApiUrl()), path, resourceId).build();
                HttpResponse response = TransportUtil.executePut(AbstractClientImpl.this.getHttpClient(), uri, AbstractClientImpl.this.getHttpConsumer(), form);
                if (response.getStatusLine().getStatusCode() == 200) {
                    Object result = MapperUtil.getObjectReader(formClass).readValue(response.getEntity().getContent());
                    return new ModificationResult(result, false);
                }
                throw AbstractClientImpl.this.parseException(response);
            }
        }.wrap();
    }

    protected <T, R> ModificationResult<R> upsert(final String resourceId, final T form, final String path, final Class<R> formClass) {
        return (ModificationResult)new RequestExecutorWrapper<ModificationResult<R>>(){

            @Override
            ModificationResult<R> execute() throws URISyntaxException, IOException {
                URI uri = AbstractClientImpl.this.addVersionPrefix(new URIBuilder(AbstractClientImpl.this.getTolokaApiUrl()), path, resourceId).build();
                HttpResponse response = TransportUtil.executePut(AbstractClientImpl.this.getHttpClient(), uri, AbstractClientImpl.this.getHttpConsumer(), form);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200 || statusCode == 201) {
                    Object result = MapperUtil.getObjectReader(formClass).readValue(response.getEntity().getContent());
                    return new ModificationResult(result, statusCode == 201);
                }
                throw AbstractClientImpl.this.parseException(response);
            }
        }.wrap();
    }

    protected <P, T> ModificationResult<T> patch(final String resourceId, final P patch, final String path, final Class<T> resourceClass, final Map<String, Object> queryParameters) {
        return (ModificationResult)new RequestExecutorWrapper<ModificationResult<T>>(){

            @Override
            ModificationResult<T> execute() throws URISyntaxException, IOException {
                HttpResponse response;
                URIBuilder uriBuilder = AbstractClientImpl.this.addVersionPrefix(new URIBuilder(AbstractClientImpl.this.getTolokaApiUrl()), path, resourceId);
                if (queryParameters != null && !queryParameters.isEmpty()) {
                    uriBuilder.addParameters(AbstractClientImpl.this.convertParameters(queryParameters));
                }
                if ((response = TransportUtil.executePatch(AbstractClientImpl.this.getHttpClient(), uriBuilder.build(), AbstractClientImpl.this.getHttpConsumer(), patch)).getStatusLine().getStatusCode() == 200) {
                    ModificationResult result = new ModificationResult(MapperUtil.getObjectReader(resourceClass).readValue(response.getEntity().getContent()), false);
                    return result;
                }
                throw AbstractClientImpl.this.parseException(response);
            }
        }.wrap();
    }

    protected <T extends Operation<?, ?>> T executeAction(final String resourceId, final String path, final String actionPath, final Class<T> resourceClass) {
        return (T)((Operation)new RequestExecutorWrapper<T>(){

            @Override
            T execute() throws URISyntaxException, IOException {
                URI uri = AbstractClientImpl.this.addVersionPrefix(new URIBuilder(AbstractClientImpl.this.getTolokaApiUrl()), path, resourceId, actionPath).build();
                HttpResponse response = TransportUtil.executePost(AbstractClientImpl.this.getHttpClient(), uri, AbstractClientImpl.this.getHttpConsumer());
                if (response.getStatusLine().getStatusCode() == 202) {
                    Operation operation = (Operation)MapperUtil.getObjectReader(resourceClass).readValue(response.getEntity().getContent());
                    PoolOpenOperation.setOperationClient(operation, AbstractClientImpl.this.getFactory().getOperationClient());
                    return operation;
                }
                if (response.getStatusLine().getStatusCode() == 204) {
                    return null;
                }
                throw AbstractClientImpl.this.parseException(response);
            }
        }.wrap());
    }

    protected <T, R> ModificationResult<R> executeSyncAction(final T form, final String path, final String resourceId, final String actionPath, final Class<R> responseClass, final Map<String, Object> queryParameters) {
        return (ModificationResult)new RequestExecutorWrapper<ModificationResult<R>>(){

            @Override
            ModificationResult<R> execute() throws URISyntaxException, IOException {
                HttpResponse response;
                URIBuilder uriBuilder = AbstractClientImpl.this.addVersionPrefix(new URIBuilder(AbstractClientImpl.this.getTolokaApiUrl()), path, resourceId, actionPath);
                if (queryParameters != null) {
                    uriBuilder.addParameters(AbstractClientImpl.this.convertParameters(queryParameters));
                }
                if ((response = TransportUtil.executePost(AbstractClientImpl.this.getHttpClient(), uriBuilder.build(), AbstractClientImpl.this.getHttpConsumer(), form)).getStatusLine().getStatusCode() == 200) {
                    ModificationResult result = new ModificationResult(MapperUtil.getObjectReader(responseClass).readValue(response.getEntity().getContent()), false);
                    return result;
                }
                throw AbstractClientImpl.this.parseException(response);
            }
        }.wrap();
    }

    protected <T extends Operation<?, ?>, O> T executeAsync(final O form, final String path, final Class<T> opClass) {
        return (T)((Operation)new RequestExecutorWrapper<T>(){

            @Override
            T execute() throws URISyntaxException, IOException {
                URI uri = AbstractClientImpl.this.addVersionPrefix(new URIBuilder(AbstractClientImpl.this.getTolokaApiUrl()), path).build();
                HttpResponse response = TransportUtil.executePost(AbstractClientImpl.this.getHttpClient(), uri, AbstractClientImpl.this.getHttpConsumer(), form);
                if (response.getStatusLine().getStatusCode() == 202) {
                    Operation operation = (Operation)MapperUtil.getObjectReader(opClass).readValue(response.getEntity().getContent());
                    PoolOpenOperation.setOperationClient(operation, AbstractClientImpl.this.getFactory().getOperationClient());
                    return operation;
                }
                throw AbstractClientImpl.this.parseException(response);
            }
        }.wrap());
    }

    void delete(final String id, final String path) {
        Assertions.checkArgNotNull(id, "Id may not be null");
        new RequestExecutorWrapper(){

            Object execute() throws URISyntaxException, IOException {
                URI uri = AbstractClientImpl.this.addVersionPrefix(new URIBuilder(AbstractClientImpl.this.getTolokaApiUrl()), path, id).build();
                HttpResponse response = TransportUtil.executeDelete(AbstractClientImpl.this.getHttpClient(), uri, AbstractClientImpl.this.getHttpConsumer());
                if (response.getStatusLine().getStatusCode() != 204) {
                    throw AbstractClientImpl.this.parseException(response);
                }
                return null;
            }
        }.wrap();
    }

    TlkException parseException(HttpResponse response) throws IOException {
        TlkError error;
        InputStream responseContent = response.getEntity().getContent();
        try {
            error = (TlkError)MapperUtil.getObjectReader(TlkError.class).readValue(responseContent);
        }
        catch (JsonProcessingException ex) {
            Scanner s = new Scanner(responseContent).useDelimiter("\\A");
            error = new TlkError("NGINX_ERROR", s.hasNext() ? s.next() : null);
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 503 || statusCode == 502) {
            return new ServiceUnavailableException(error, statusCode);
        }
        return this.parseException(error, statusCode);
    }

    private TlkException parseException(TlkError<?> error, int statusCode) {
        if (error instanceof ValidationError) {
            return new ValidationException((ValidationError)error, statusCode);
        }
        switch (error.getCode()) {
            case "NOT_FOUND": 
            case "DOES_NOT_EXIST": {
                return new NotFoundException(error, statusCode);
            }
        }
        return new TlkException(error, statusCode);
    }

    private List<NameValuePair> convertParameters(Map<String, Object> mapParameters) {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        for (Map.Entry<String, Object> mapParam : mapParameters.entrySet()) {
            if (mapParam.getValue() == null) continue;
            parameters.add(new BasicNameValuePair(mapParam.getKey(), this.valueToString(mapParam.getValue())));
        }
        return parameters;
    }

    private String valueToString(Object value) {
        if (value instanceof Date) {
            return MapperUtil.getTolokaDateFormat().format(value);
        }
        return value.toString();
    }

    private <T> Runnable readJsonForms(final PipedOutputStream out, final Iterator<T> forms) {
        return new Runnable(){

            @Override
            public void run() {
                try (JsonGenerator generator = MapperUtil.getObjectReader().getFactory().createGenerator(out, JsonEncoding.UTF8);){
                    generator.writeStartArray();
                    while (forms.hasNext()) {
                        generator.writeObject(forms.next());
                    }
                    generator.writeEndArray();
                }
                catch (Exception ex) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.addSuppressed(ex);
                        throw new RuntimeException(e);
                    }
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    protected static abstract class RequestExecutorWrapper<T> {
        protected RequestExecutorWrapper() {
        }

        T wrap() {
            try {
                return this.execute();
            }
            catch (URISyntaxException e) {
                logger.error("Unable to initialize valid URL", e);
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                logger.error("Request error", e);
                throw new TolokaRequestIOException(e);
            }
        }

        abstract T execute() throws URISyntaxException, IOException;
    }
}

