/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.impl;

import ai.toloka.client.v1.ModificationResult;
import ai.toloka.client.v1.SearchResult;
import ai.toloka.client.v1.aggregatedsolutions.AggregatedSolution;
import ai.toloka.client.v1.aggregatedsolutions.AggregatedSolutionClient;
import ai.toloka.client.v1.aggregatedsolutions.AggregatedSolutionOperation;
import ai.toloka.client.v1.aggregatedsolutions.AggregatedSolutionSearchRequest;
import ai.toloka.client.v1.aggregatedsolutions.PoolAggregatedSolutionRequest;
import ai.toloka.client.v1.aggregatedsolutions.TaskAggregatedSolutionRequest;
import ai.toloka.client.v1.impl.AbstractClientImpl;
import ai.toloka.client.v1.impl.TolokaClientFactoryImpl;
import ai.toloka.client.v1.impl.validation.Assertions;
import ai.toloka.client.v1.operation.Operation;
import com.fasterxml.jackson.core.type.TypeReference;

public class AggregatedSolutionClientImpl
extends AbstractClientImpl
implements AggregatedSolutionClient {
    private static final String AGGREGATED_SOLUTIONS_PATH = "aggregated-solutions";

    public AggregatedSolutionClientImpl(TolokaClientFactoryImpl factory) {
        super(factory);
    }

    @Override
    public AggregatedSolutionOperation aggregateSolutionsByPool(PoolAggregatedSolutionRequest request) {
        Assertions.checkArgNotNull(request, "Request may not be null");
        return (AggregatedSolutionOperation)this.executeAsync(request, "aggregated-solutions/aggregate-by-pool", Operation.class);
    }

    @Override
    public ModificationResult<AggregatedSolution> aggregateSolutionsByTask(TaskAggregatedSolutionRequest request) {
        Assertions.checkArgNotNull(request, "Request may not be null");
        Assertions.checkArgNotNull(request.getTaskId(), "Task id may not be null");
        return this.executeSyncAction(request, AGGREGATED_SOLUTIONS_PATH, null, "aggregate-by-task", AggregatedSolution.class, null);
    }

    @Override
    public SearchResult<AggregatedSolution> findAggregatedSolutions(String operationId, AggregatedSolutionSearchRequest request) {
        return this.find(request, "aggregated-solutions/" + operationId, new TypeReference<SearchResult<AggregatedSolution>>(){});
    }
}

