/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.impl;

import ai.toloka.client.v1.ModificationResult;
import ai.toloka.client.v1.SearchResult;
import ai.toloka.client.v1.assignment.Assignment;
import ai.toloka.client.v1.assignment.AssignmentClient;
import ai.toloka.client.v1.assignment.AssignmentPatch;
import ai.toloka.client.v1.assignment.AssignmentSearchRequest;
import ai.toloka.client.v1.assignment.AssignmentStatus;
import ai.toloka.client.v1.impl.AbstractClientImpl;
import ai.toloka.client.v1.impl.TolokaClientFactoryImpl;
import ai.toloka.client.v1.impl.validation.Assertions;
import com.fasterxml.jackson.core.type.TypeReference;

public class AssignmentClientImpl
extends AbstractClientImpl
implements AssignmentClient {
    private static final String ASSIGNMENTS_PATH = "assignments";

    public AssignmentClientImpl(TolokaClientFactoryImpl factory) {
        super(factory);
    }

    @Override
    public SearchResult<Assignment> findAssignments(AssignmentSearchRequest request) {
        return this.find(request, ASSIGNMENTS_PATH, new TypeReference<SearchResult<Assignment>>(){});
    }

    @Override
    public Assignment getAssignment(String assignmentId) {
        return this.get(assignmentId, ASSIGNMENTS_PATH, Assignment.class);
    }

    @Override
    public ModificationResult<Assignment> patchAssignment(String assignmentId, AssignmentPatch patch) {
        Assertions.checkArgNotNull(assignmentId, "Id may not be null");
        Assertions.checkArgNotNull(patch, "Patch may not be null");
        return this.patch(assignmentId, patch, ASSIGNMENTS_PATH, Assignment.class, null);
    }

    @Override
    public ModificationResult<Assignment> acceptAssignment(String assignmentId, String publicComment) {
        return this.patchAssignment(assignmentId, new AssignmentPatch(AssignmentStatus.ACCEPTED, publicComment));
    }

    @Override
    public ModificationResult<Assignment> rejectAssignment(String assignmentId, String publicComment) {
        return this.patchAssignment(assignmentId, new AssignmentPatch(AssignmentStatus.REJECTED, publicComment));
    }
}

