/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.impl;

import ai.toloka.client.v1.SearchResult;
import ai.toloka.client.v1.attachment.Attachment;
import ai.toloka.client.v1.attachment.AttachmentClient;
import ai.toloka.client.v1.attachment.AttachmentDownload;
import ai.toloka.client.v1.attachment.AttachmentSearchRequest;
import ai.toloka.client.v1.impl.AbstractClientImpl;
import ai.toloka.client.v1.impl.TolokaClientFactoryImpl;
import ai.toloka.client.v1.impl.transport.TransportUtil;
import ai.toloka.client.v1.impl.validation.Assertions;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpResponse;
import org.apache.http.client.utils.URIBuilder;

public class AttachmentClientImpl
extends AbstractClientImpl
implements AttachmentClient {
    private static final String ATTACHMENTS_PATH = "attachments";
    private static final String DOWNLOAD_PATH = "download";

    AttachmentClientImpl(TolokaClientFactoryImpl factory) {
        super(factory);
    }

    @Override
    public SearchResult<Attachment<?>> findAttachments(AttachmentSearchRequest request) {
        return this.find(request, ATTACHMENTS_PATH, new TypeReference<SearchResult<Attachment>>(){});
    }

    @Override
    public Attachment<?> getAttachment(String attachmentId) {
        Assertions.checkArgNotNull(attachmentId, "Id may not be null");
        return this.get(attachmentId, ATTACHMENTS_PATH, Attachment.class);
    }

    @Override
    public AttachmentDownload downloadAttachment(final String attachmentId) {
        Assertions.checkArgNotNull(attachmentId, "Id may not be null");
        return (AttachmentDownload)new AbstractClientImpl.RequestExecutorWrapper<AttachmentDownload>(){

            @Override
            AttachmentDownload execute() throws URISyntaxException, IOException {
                URI uri = AttachmentClientImpl.this.addVersionPrefix(new URIBuilder(AttachmentClientImpl.this.getTolokaApiUrl()), AttachmentClientImpl.ATTACHMENTS_PATH, attachmentId, AttachmentClientImpl.DOWNLOAD_PATH).build();
                HttpResponse response = TransportUtil.executeGet(AttachmentClientImpl.this.getHttpClient(), uri, AttachmentClientImpl.this.getHttpConsumer());
                if (response.getStatusLine().getStatusCode() == 200) {
                    String contentType = response.getFirstHeader("Content-Type").getValue();
                    String contentLength = response.getFirstHeader("Content-Length") != null ? response.getFirstHeader("Content-Length").getValue() : null;
                    String transferEncoding = response.getFirstHeader("Transfer-Encoding") != null ? response.getFirstHeader("Transfer-Encoding").getValue() : null;
                    String contentDisposition = response.getFirstHeader("Content-Disposition") != null ? response.getFirstHeader("Content-Disposition").getValue() : null;
                    return new AttachmentDownload(response.getEntity().getContent(), contentType, contentLength, transferEncoding, contentDisposition);
                }
                if (response.getStatusLine().getStatusCode() == 404) {
                    return null;
                }
                throw AttachmentClientImpl.this.parseException(response);
            }
        }.wrap();
    }
}

