/*
 * Decompiled with CFR 0.152.
 */
package ai.toloka.client.v1.impl;

import ai.toloka.client.v1.ModificationResult;
import ai.toloka.client.v1.SearchResult;
import ai.toloka.client.v1.impl.AbstractClientImpl;
import ai.toloka.client.v1.impl.TolokaClientFactoryImpl;
import ai.toloka.client.v1.impl.validation.Assertions;
import ai.toloka.client.v1.messagethread.MessageThread;
import ai.toloka.client.v1.messagethread.MessageThreadClient;
import ai.toloka.client.v1.messagethread.MessageThreadCompose;
import ai.toloka.client.v1.messagethread.MessageThreadFolders;
import ai.toloka.client.v1.messagethread.MessageThreadReply;
import ai.toloka.client.v1.messagethread.MessageThreadSearchRequest;
import com.fasterxml.jackson.core.type.TypeReference;

public class MessageThreadClientImpl
extends AbstractClientImpl
implements MessageThreadClient {
    private static final String MESSAGE_THREADS_PATH = "message-threads";
    private static final String MESSAGE_THREADS_COMPOSE_ACTION_PATH = "compose";
    private static final String MESSAGE_THREADS_REPLY_ACTION_PATH = "reply";
    private static final String MESSAGE_THREADS_ADD_TO_FOLDERS_ACTION_PATH = "add-to-folders";
    private static final String MESSAGE_THREADS_REMOVE_FROM_FOLDERS_ACTION_PATH = "remove-from-folders";

    MessageThreadClientImpl(TolokaClientFactoryImpl factory) {
        super(factory);
    }

    @Override
    public SearchResult<MessageThread> findMessageThreads(MessageThreadSearchRequest request) {
        return this.find(request, MESSAGE_THREADS_PATH, new TypeReference<SearchResult<MessageThread>>(){});
    }

    @Override
    public ModificationResult<MessageThread> composeMessageThread(MessageThreadCompose compose) {
        Assertions.checkArgNotNull(compose, "Compose may not be null");
        String path = "message-threads/compose";
        return this.create(compose, path, MessageThread.class, null);
    }

    @Override
    public ModificationResult<MessageThread> replyMessageThread(String messageThreadId, MessageThreadReply reply) {
        Assertions.checkArgNotNull(messageThreadId, "Id may not be null");
        Assertions.checkArgNotNull(reply, "Reply may not be null");
        return this.executeSyncAction(reply, MESSAGE_THREADS_PATH, messageThreadId, MESSAGE_THREADS_REPLY_ACTION_PATH, MessageThread.class, null);
    }

    @Override
    public ModificationResult<MessageThread> addToFolders(String messageThreadId, MessageThreadFolders folders) {
        return this.changeFolders(messageThreadId, folders, MESSAGE_THREADS_ADD_TO_FOLDERS_ACTION_PATH);
    }

    private ModificationResult<MessageThread> changeFolders(String messageThreadId, MessageThreadFolders folders, String actionPath) {
        Assertions.checkArgNotNull(messageThreadId, "Id may not be null");
        Assertions.checkArgNotNull(folders, "Folders may not be null");
        Assertions.checkArgNotNull(folders.getFolders(), "Folders set may not be null");
        return this.executeSyncAction(folders, MESSAGE_THREADS_PATH, messageThreadId, actionPath, MessageThread.class, null);
    }

    @Override
    public ModificationResult<MessageThread> removeFromFolders(String messageThreadId, MessageThreadFolders folders) {
        return this.changeFolders(messageThreadId, folders, MESSAGE_THREADS_REMOVE_FROM_FOLDERS_ACTION_PATH);
    }
}

